/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LineInput;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;

public class MultiPartFilter
implements Filter {
    private static Log log = LogFactory.getLog(MultiPartFilter.class);
    private File tempdir;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        LineInput in = new LineInput(request.getInputStream());
        String content_type = srequest.getContentType();
        String boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        byte[] byteBoundary = (boundary + "--").getBytes(StringUtil.__ISO_8859_1);
        MultiMap params = new MultiMap();
        String line = in.readLine();
        if (!line.equals(boundary)) {
            log.warn(line);
            throw new IOException("Missing initial multi part boundary");
        }
        boolean lastPart = false;
        String content_disposition = null;
        while (true) {
            if (lastPart) {
                chain.doFilter(new Wrapper(srequest, params), response);
                return;
            }
            while ((line = in.readLine()) != null && line.length() != 0) {
                int c2 = line.indexOf(58, 0);
                if (c2 <= 0) continue;
                String key = line.substring(0, c2).trim().toLowerCase();
                String value = line.substring(c2 + 1, line.length()).trim();
                if (!key.equals("content-disposition")) continue;
                content_disposition = value;
            }
            boolean form_data = false;
            if (content_disposition == null) {
                throw new IOException("Missing content-disposition");
            }
            StringTokenizer tok = new StringTokenizer(content_disposition, ";");
            String name = null;
            String filename = null;
            while (tok.hasMoreTokens()) {
                String t2 = tok.nextToken().trim();
                String tl = t2.toLowerCase();
                if (t2.startsWith("form-data")) {
                    form_data = true;
                    continue;
                }
                if (tl.startsWith("name=")) {
                    name = this.value(t2);
                    continue;
                }
                if (!tl.startsWith("filename=")) continue;
                filename = this.value(t2);
            }
            if (!form_data) {
                log.warn("Non form-data part in multipart/form-data");
                continue;
            }
            if (name == null || name.length() == 0) {
                log.warn("Part with no name in multipart/form-data");
                continue;
            }
            OutputStream out = null;
            File file = null;
            try {
                if (filename != null && filename.length() > 0) {
                    file = File.createTempFile("MultiPart", "", this.tempdir);
                    out = new FileOutputStream(file);
                    request.setAttribute(name, file);
                    params.put(name, filename);
                } else {
                    out = new ByteArrayOutputStream();
                }
                int state = -2;
                boolean cr2 = false;
                boolean lf = false;
                while (true) {
                    int c3;
                    int b2 = 0;
                    while ((c3 = state != -2 ? state : in.read()) != -1) {
                        state = -2;
                        if (c3 == 13 || c3 == 10) {
                            if (c3 != 13) break;
                            state = in.read();
                            break;
                        }
                        if (b2 >= 0 && b2 < byteBoundary.length && c3 == byteBoundary[b2]) {
                            ++b2;
                            continue;
                        }
                        if (cr2) {
                            out.write(13);
                        }
                        if (lf) {
                            out.write(10);
                        }
                        lf = false;
                        cr2 = false;
                        if (b2 > 0) {
                            out.write(byteBoundary, 0, b2);
                        }
                        b2 = -1;
                        out.write(c3);
                    }
                    if (b2 > 0 && b2 < byteBoundary.length - 2 || b2 == byteBoundary.length - 1) {
                        if (cr2) {
                            out.write(13);
                        }
                        if (lf) {
                            out.write(10);
                        }
                        lf = false;
                        cr2 = false;
                        out.write(byteBoundary, 0, b2);
                        b2 = -1;
                    }
                    if (b2 > 0 || c3 == -1) {
                        if (b2 == byteBoundary.length) {
                            lastPart = true;
                        }
                        if (state == 10) {
                            state = -2;
                        }
                        break;
                    }
                    if (cr2) {
                        out.write(13);
                    }
                    if (lf) {
                        out.write(10);
                    }
                    cr2 = c3 == 13;
                    boolean bl2 = lf = c3 == 10 || state == 10;
                    if (state != 10) continue;
                    state = -2;
                }
            }
            catch (Throwable throwable) {
                IO.close(out);
                throw throwable;
            }
            IO.close(out);
            if (file != null) continue;
            byte[] bytes = ((ByteArrayOutputStream)out).toByteArray();
            params.add(name, bytes);
        }
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i2 = value.indexOf(59);
        if (i2 > 0) {
            value = value.substring(0, i2);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i2 = value.indexOf(32);
            if (i2 > 0) {
                value = value.substring(0, i2);
            }
        }
        return value;
    }

    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String encoding = "UTF-8";
        MultiMap map;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this.map = map;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String name) {
            Object o2 = this.map.get(name);
            if (o2 instanceof byte[]) {
                try {
                    String s2 = new String((byte[])o2, this.encoding);
                    return s2;
                }
                catch (Exception e2) {
                    log.warn(e2);
                }
            } else if (o2 instanceof String) {
                return (String)o2;
            }
            return null;
        }

        public Map getParameterMap() {
            return this.map;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public String[] getParameterValues(String name) {
            List l2 = this.map.getValues(name);
            if (l2 == null || l2.size() == 0) {
                return new String[0];
            }
            String[] v2 = new String[l2.size()];
            for (int i2 = 0; i2 < l2.size(); ++i2) {
                Object o2 = l2.get(i2);
                if (o2 instanceof byte[]) {
                    try {
                        v2[i2] = new String((byte[])o2, this.encoding);
                    }
                    catch (Exception e2) {
                        log.warn(e2);
                    }
                    continue;
                }
                if (!(o2 instanceof String)) continue;
                v2[i2] = (String)o2;
            }
            return v2;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.encoding = enc;
        }
    }
}

