/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.ByteArrayPool;
import org.mortbay.util.StringUtil;

public class ByteArrayISO8859Writer
extends Writer {
    private byte[] _buf;
    private int _size;
    private ByteArrayOutputStream2 _bout = null;
    private OutputStreamWriter _writer = null;
    private boolean _fixed = false;

    public ByteArrayISO8859Writer() {
        this._buf = ByteArrayPool.getByteArrayAtLeast(2048);
    }

    public ByteArrayISO8859Writer(int capacity) {
        this._buf = ByteArrayPool.getByteArray(capacity);
    }

    public ByteArrayISO8859Writer(byte[] buf) {
        this._buf = buf;
        this._fixed = true;
    }

    public Object getLock() {
        return this.lock;
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._buf.length;
    }

    public int spareCapacity() {
        return this._buf.length - this._size;
    }

    public void setLength(int l2) {
        this._size = l2;
    }

    public byte[] getBuf() {
        return this._buf;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, 0, this._size);
    }

    public void write(char c2) throws IOException {
        this.ensureSpareCapacity(1);
        if (c2 >= '\u0000' && c2 <= '\u007f') {
            this._buf[this._size++] = (byte)c2;
        } else {
            char[] ca2 = new char[]{c2};
            this.writeEncoded(ca2, 0, 1);
        }
    }

    public void write(char[] ca2) throws IOException {
        this.ensureSpareCapacity(ca2.length);
        for (int i2 = 0; i2 < ca2.length; ++i2) {
            char c2 = ca2[i2];
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(ca2, i2, ca2.length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    public void write(char[] ca2, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = ca2[offset + i2];
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(ca2, offset + i2, length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    public void write(String s2) throws IOException {
        int length = s2.length();
        this.ensureSpareCapacity(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(s2.toCharArray(), i2, length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    public void write(String s2, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(offset + i2);
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(s2.toCharArray(), offset + i2, length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    private void writeEncoded(char[] ca2, int offset, int length) throws IOException {
        if (this._bout == null) {
            this._bout = new ByteArrayOutputStream2(2 * length);
            this._writer = new OutputStreamWriter((OutputStream)this._bout, StringUtil.__ISO_8859_1);
        } else {
            this._bout.reset();
        }
        this._writer.write(ca2, offset, length);
        this._writer.flush();
        this.ensureSpareCapacity(this._bout.getCount());
        System.arraycopy(this._bout.getBuf(), 0, this._buf, this._size, this._bout.getCount());
        this._size += this._bout.getCount();
    }

    public void flush() {
    }

    public void resetWriter() {
        this._size = 0;
    }

    public void close() {
    }

    public void destroy() {
        ByteArrayPool.returnByteArray(this._buf);
        this._buf = null;
    }

    public void ensureSpareCapacity(int n2) throws IOException {
        if (this._size + n2 > this._buf.length) {
            if (this._fixed) {
                throw new IOException("Buffer overflow: " + this._buf.length);
            }
            byte[] buf = new byte[(this._buf.length + n2) * 4 / 3];
            System.arraycopy(this._buf, 0, buf, 0, this._size);
            this._buf = buf;
        }
    }

    protected void finalize() {
        ByteArrayPool.returnByteArray(this._buf);
    }

    public byte[] getByteArray() {
        byte[] data = new byte[this._size];
        System.arraycopy(this._buf, 0, data, 0, this._size);
        return data;
    }
}

