/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

public class ByteArrayPool {
    public static final int __POOL_SIZE = Integer.getInteger("org.mortbay.util.ByteArrayPool.pool_size", 8);
    public static final ThreadLocal __pools = new BAThreadLocal();
    public static int __slot;

    public static byte[] getByteArray(int size) {
        byte[][] pool = (byte[][])__pools.get();
        boolean full = true;
        int i2 = pool.length;
        while (i2-- > 0) {
            if (pool[i2] != null && pool[i2].length == size) {
                byte[] b2 = pool[i2];
                pool[i2] = null;
                return b2;
            }
            full = false;
        }
        if (full) {
            i2 = pool.length;
            while (i2-- > 0) {
                pool[i2] = null;
            }
        }
        return new byte[size];
    }

    public static byte[] getByteArrayAtLeast(int minSize) {
        byte[][] pool = (byte[][])__pools.get();
        int i2 = pool.length;
        while (i2-- > 0) {
            if (pool[i2] == null || pool[i2].length < minSize) continue;
            byte[] b2 = pool[i2];
            pool[i2] = null;
            return b2;
        }
        return new byte[minSize];
    }

    public static void returnByteArray(byte[] b2) {
        int s2;
        if (b2 == null) {
            return;
        }
        byte[][] pool = (byte[][])__pools.get();
        int i2 = pool.length;
        while (i2-- > 0) {
            if (pool[i2] != null) continue;
            pool[i2] = b2;
            return;
        }
        if ((s2 = __slot++) < 0) {
            s2 = -s2;
        }
        pool[s2 % pool.length] = b2;
    }

    private static final class BAThreadLocal
    extends ThreadLocal {
        private BAThreadLocal() {
        }

        protected Object initialValue() {
            return new byte[__POOL_SIZE][];
        }
    }
}

