/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ComponentEvent;
import org.mortbay.util.ComponentListener;
import org.mortbay.util.EventProvider;
import org.mortbay.util.LazyList;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LifeCycleEvent;
import org.mortbay.util.LifeCycleListener;

public abstract class Container
implements LifeCycle,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(Container.class);
    private Object _eventListeners;
    private Object _components;
    private transient boolean _started;
    private transient boolean _starting;
    private transient boolean _stopping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws Exception {
        EventListener listener;
        int i2;
        if (this._started || this._starting) {
            return;
        }
        this._starting = true;
        if (log.isDebugEnabled()) {
            log.debug("Starting " + this);
        }
        LifeCycleEvent event = new LifeCycleEvent(this);
        for (i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
            listener = (EventListener)LazyList.get(this._eventListeners, i2);
            if (!(listener instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)listener).lifeCycleStarting(event);
        }
        try {
            this.doStart();
            this._started = true;
            log.info("Started " + this);
            for (i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                listener = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener).lifeCycleStarted(event);
            }
        }
        catch (Throwable e2) {
            LifeCycleEvent failed = new LifeCycleEvent(this, e2);
            for (int i3 = 0; i3 < LazyList.size(this._eventListeners); ++i3) {
                EventListener listener2 = (EventListener)LazyList.get(this._eventListeners, i3);
                if (!(listener2 instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener2).lifeCycleFailure(event);
            }
            if (e2 instanceof Exception) {
                throw (Exception)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            if (e2 instanceof Error) {
                throw (Error)e2;
            }
            log.warn("EXCEPTION ", e2);
        }
        finally {
            this._starting = false;
        }
    }

    protected abstract void doStart() throws Exception;

    public synchronized boolean isStarted() {
        return this._started;
    }

    protected synchronized boolean isStarting() {
        return this._starting;
    }

    protected synchronized boolean isStopping() {
        return this._stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() throws InterruptedException {
        EventListener listener;
        int i2;
        if (!this._started || this._stopping) {
            return;
        }
        this._stopping = true;
        if (log.isDebugEnabled()) {
            log.debug("Stopping " + this);
        }
        LifeCycleEvent event = new LifeCycleEvent(this);
        for (i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
            listener = (EventListener)LazyList.get(this._eventListeners, i2);
            if (!(listener instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)listener).lifeCycleStopping(event);
        }
        try {
            this.doStop();
            this._started = false;
            log.info("Stopped " + this);
            for (i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                listener = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener).lifeCycleStopped(event);
            }
        }
        catch (Throwable e2) {
            event = new LifeCycleEvent(this, e2);
            for (int i3 = 0; i3 < LazyList.size(this._eventListeners); ++i3) {
                EventListener listener2 = (EventListener)LazyList.get(this._eventListeners, i3);
                if (!(listener2 instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener2).lifeCycleFailure(event);
            }
            if (e2 instanceof InterruptedException) {
                throw (InterruptedException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            if (e2 instanceof Error) {
                throw (Error)e2;
            }
            log.warn("EXCEPTION ", e2);
        }
        finally {
            this._stopping = false;
        }
    }

    protected abstract void doStop() throws Exception;

    protected void addComponent(Object o2) {
        if (!LazyList.contains(this._components, o2)) {
            this._components = LazyList.add(this._components, o2);
            if (log.isDebugEnabled()) {
                log.debug("add component: " + o2);
            }
            ComponentEvent event = new ComponentEvent(this, o2);
            for (int i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener instanceof ComponentListener)) continue;
                ((ComponentListener)listener).addComponent(event);
            }
        }
    }

    protected void removeComponent(Object o2) {
        if (LazyList.contains(this._components, o2)) {
            this._components = LazyList.remove(this._components, o2);
            if (log.isDebugEnabled()) {
                log.debug("remove component: " + o2);
            }
            ComponentEvent event = new ComponentEvent(this, o2);
            for (int i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener instanceof ComponentListener)) continue;
                ((ComponentListener)listener).removeComponent(event);
            }
        }
    }

    public void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (this._eventListeners == null) {
            this._eventListeners = new ArrayList();
        }
        if (listener instanceof ComponentListener || listener instanceof LifeCycleListener) {
            if (log.isDebugEnabled()) {
                log.debug("addEventListener: " + listener);
            }
            this._eventListeners = LazyList.add(this._eventListeners, listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("removeEventListener: " + listener);
        }
        this._eventListeners = LazyList.remove(this._eventListeners, listener);
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._components != null && this._eventListeners != null) {
            for (int c2 = 0; c2 < LazyList.size(this._components); ++c2) {
                Object o2 = LazyList.get(this._components, c2);
                if (o2 instanceof HttpContext) {
                    ((HttpContext)o2).destroy();
                }
                ComponentEvent event = new ComponentEvent(this, o2);
                for (int i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                    EventListener listener = (EventListener)LazyList.get(this._eventListeners, i2);
                    if (!(listener instanceof ComponentListener)) continue;
                    ((ComponentListener)listener).removeComponent(event);
                }
            }
        }
        this._components = null;
        this._eventListeners = null;
    }

    public Collection getComponents() {
        return LazyList.getList(this._eventListeners, false);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (int c2 = 0; c2 < LazyList.size(this._components); ++c2) {
            Object o2 = LazyList.get(this._components, c2);
            ComponentEvent event = new ComponentEvent(this, o2);
            for (int i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener instanceof ComponentListener)) continue;
                ((ComponentListener)listener).addComponent(event);
            }
        }
    }
}

