/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class UrlEncoded
extends MultiMap {
    private static Log log = LogFactory.getLog(UrlEncoded.class);

    public UrlEncoded(UrlEncoded url) {
        super((Map)url);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String s2) {
        super(6);
        this.decode(s2, StringUtil.__ISO_8859_1);
    }

    public UrlEncoded(String s2, String charset) {
        super(6);
        this.decode(s2, charset);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, this, StringUtil.__ISO_8859_1);
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo(query, this, charset);
    }

    public String encode() {
        return this.encode(StringUtil.__ISO_8859_1, false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String encode(String charset, boolean equalsForNullValue) {
        StringBuffer result;
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        StringBuffer stringBuffer = result = new StringBuffer(128);
        synchronized (stringBuffer) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = entry.getKey().toString();
                Object list = entry.getValue();
                int s2 = LazyList.size(list);
                if (s2 == 0) {
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (equalsForNullValue) {
                        result.append('=');
                    }
                } else {
                    for (int i2 = 0; i2 < s2; ++i2) {
                        if (i2 > 0) {
                            result.append('&');
                        }
                        Object val = LazyList.get(list, i2);
                        result.append(UrlEncoded.encodeString(key, charset));
                        if (val != null) {
                            String str = val.toString();
                            if (str.length() > 0) {
                                result.append('=');
                                result.append(UrlEncoded.encodeString(str, charset));
                                continue;
                            }
                            if (!equalsForNullValue) continue;
                            result.append('=');
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                    }
                }
                if (!iter.hasNext()) continue;
                result.append('&');
            }
            return result.toString();
        }
    }

    public static void decodeTo(String content, MultiMap map) {
        UrlEncoded.decodeTo(content, map, StringUtil.__ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap map, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i2 = 0; i2 < content.length(); ++i2) {
                char c2 = content.charAt(i2);
                switch (c2) {
                    case '&': {
                        value = encoded ? UrlEncoded.decodeString(content, mark + 1, i2 - mark - 1, charset) : content.substring(mark + 1, i2);
                        mark = i2;
                        encoded = false;
                        if (key == null) continue block9;
                        map.add(key, value);
                        key = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i2 - mark - 1, charset) : content.substring(mark + 1, i2);
                        mark = i2;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                value = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, value);
            } else if (mark < content.length()) {
                key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(byte[] data, int offset, int length, MultiMap map, String charset) {
        if (data == null || length == 0) {
            return;
        }
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            try {
                int ix = offset;
                int end = offset + length;
                int ox = offset;
                String key = null;
                String value = null;
                while (ix < end) {
                    byte c2 = data[ix++];
                    switch ((char)c2) {
                        case '&': {
                            value = new String(data, offset, ox, charset);
                            if (key != null) {
                                map.add(key, value);
                                key = null;
                            }
                            ox = offset;
                            break;
                        }
                        case '=': {
                            if (key != null) break;
                            key = new String(data, offset, ox, charset);
                            ox = offset;
                            break;
                        }
                        case '+': {
                            data[ox++] = 32;
                            break;
                        }
                        case '%': {
                            int i0 = 225;
                            byte b0 = (byte)i0;
                            data[ox++] = (byte)((TypeUtil.convertHexDigit(data[ix++]) << 4) + TypeUtil.convertHexDigit(data[ix++]));
                            break;
                        }
                        default: {
                            data[ox++] = c2;
                        }
                    }
                }
                if (key != null) {
                    value = new String(data, offset, ox, charset);
                    map.add(key, value);
                }
            }
            catch (UnsupportedEncodingException e2) {
                log.warn("EXCEPTION ", e2);
            }
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), StringUtil.__ISO_8859_1);
    }

    public static String decodeString(String encoded, String charset) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), charset);
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        byte[] bytes = null;
        int n2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = encoded.charAt(offset + i2);
            if (c2 < '\u0000' || c2 > '\u00ff') {
                throw new IllegalArgumentException("Not encoded");
            }
            if (c2 == '+') {
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i2, bytes, 0);
                    n2 = i2;
                }
                bytes[n2++] = 32;
                continue;
            }
            if (c2 == '%' && i2 + 2 < length) {
                char cn2 = encoded.charAt(offset + i2 + 1);
                byte b2 = cn2 >= 'a' && cn2 <= 'z' ? (byte)(10 + cn2 - 97) : (cn2 >= 'A' && cn2 <= 'Z' ? (byte)(10 + cn2 - 65) : (byte)(cn2 - 48));
                cn2 = encoded.charAt(offset + i2 + 2);
                b2 = cn2 >= 'a' && cn2 <= 'z' ? (byte)(b2 * 16 + 10 + cn2 - 97) : (cn2 >= 'A' && cn2 <= 'Z' ? (byte)(b2 * 16 + 10 + cn2 - 65) : (byte)(b2 * 16 + cn2 - 48));
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i2, bytes, 0);
                    n2 = i2;
                }
                i2 += 2;
                bytes[n2++] = b2;
                continue;
            }
            if (n2 <= 0) continue;
            bytes[n2++] = (byte)c2;
        }
        if (bytes == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        try {
            return new String(bytes, 0, n2, charset);
        }
        catch (UnsupportedEncodingException e2) {
            return new String(bytes, 0, n2);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, StringUtil.__ISO_8859_1);
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e2) {
            log.warn("EXCEPTION ", e2);
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n2 = 0;
        boolean noEncode = true;
        for (int i2 = 0; i2 < len; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == 32) {
                noEncode = false;
                encoded[n2++] = 43;
                continue;
            }
            if (b2 >= 97 && b2 <= 122 || b2 >= 65 && b2 <= 90 || b2 >= 48 && b2 <= 57) {
                encoded[n2++] = b2;
                continue;
            }
            noEncode = false;
            encoded[n2++] = 37;
            byte nibble = (byte)((b2 & 0xF0) >> 4);
            encoded[n2++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b2 & 0xF);
            encoded[n2++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n2, charset);
        }
        catch (UnsupportedEncodingException e3) {
            log.warn("EXCEPTION ", e3);
            return new String(encoded, 0, n2);
        }
    }

    public Object clone() {
        return super.clone();
    }
}

