/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class BasicIo {
    static final byte M_APP0 = -32;
    static final byte M_APP12 = -20;
    static final byte M_COM = -2;
    public final byte M_DHP = -34;
    public final byte M_DHT = (byte)-60;
    public final byte M_DNL = -36;
    public final byte M_DQT = (byte)-37;
    public final byte M_DRI = -35;
    static final byte M_EOI = -39;
    public final byte M_EXP = -33;
    static final byte M_JPG = -56;
    static final byte M_PRX = -1;
    static final byte M_RST0 = -48;
    static final byte M_RST1 = -47;
    static final byte M_RST2 = -46;
    static final byte M_RST3 = -45;
    static final byte M_RST4 = -44;
    static final byte M_RST5 = -43;
    static final byte M_RST6 = -42;
    static final byte M_RST7 = -41;
    static final byte M_SOF0 = -64;
    static final byte M_SOF1 = -63;
    static final byte M_SOF10 = -54;
    static final byte M_SOF11 = -53;
    static final byte M_SOF13 = -51;
    static final byte M_SOF14 = -50;
    static final byte M_SOF15 = -49;
    static final byte M_SOF2 = -62;
    static final byte M_SOF3 = -61;
    static final byte M_SOF5 = -59;
    static final byte M_SOF6 = -58;
    static final byte M_SOF7 = -57;
    static final byte M_SOF9 = -55;
    static final byte M_SOI = -40;
    static final byte M_SOS = -38;
    byte[] data;
    boolean intel;
    boolean motorola;

    public BasicIo() {
        this.M_DNL = (byte)-36;
        this.M_DRI = (byte)-35;
        this.M_DHP = (byte)-34;
        this.M_EXP = (byte)-33;
    }

    byte[] bn2s(int value, int length) {
        byte[] result = new byte[length];
        this.bn2s(result, 0, value, length);
        return result;
    }

    void bn2s(byte[] result, int offset, int value, int length) {
        int i2 = 0;
        while (i2 < length) {
            result[offset + length - i2 - 1] = (byte)(value & 0xFF);
            value >>= 8;
            ++i2;
        }
    }

    int bs2i(int offset, int length) {
        int val = 0;
        int i2 = 0;
        while (i2 < length) {
            val = (val << 8) + (this.data[offset + i2] & 0xFF);
            ++i2;
        }
        return val;
    }

    public static String convertLength(long l2) {
        if (l2 / 1024L / 1024L > 0L) {
            return "" + l2 / 1024L / 1024L + "MB";
        }
        if (l2 / 1024L > 0L) {
            return "" + l2 / 1024L + "KB";
        }
        return "" + l2;
    }

    int i2bsI(int offset, int value, int length) {
        int i2 = 0;
        int s2 = 0;
        while (i2 < length) {
            this.data[offset + i2] = (byte)(value >> s2);
            ++i2;
            s2 += 8;
        }
        return offset + length;
    }

    boolean isSignature(int offset, String signature) {
        int i2 = 0;
        while (i2 < signature.length()) {
            if (signature.charAt(i2) != (this.data[offset + i2] & 0xFF)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    byte[] n2s(int value, int length) {
        byte[] result = new byte[length];
        this.n2s(result, 0, value, length);
        return result;
    }

    void n2s(byte[] result, int offset, int value, int length) {
        if (this.motorola) {
            int i2 = 0;
            while (i2 < length) {
                result[offset + length - i2 - 1] = (byte)(value & 0xFF);
                value >>= 8;
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < length) {
                result[offset + i3] = (byte)(value & 0xFF);
                value >>= 8;
                ++i3;
            }
        }
    }

    public static int read(InputStream is, byte[] data) throws IOException {
        int lefttoread = data.length;
        while (lefttoread > 0 && lefttoread <= data.length) {
            int rl = is.read(data, data.length - lefttoread, lefttoread);
            if (rl < 0) {
                return data.length - lefttoread;
            }
            lefttoread -= rl;
        }
        return data.length;
    }

    String s2a(int offset, int length) {
        String result = null;
        try {
            result = new String(this.data, offset, length, "Default");
        }
        catch (UnsupportedEncodingException e2) {}
        return result;
    }

    /*
     * Unable to fully structure code
     */
    int s2n(int offset, int length, boolean signed) {
        block4: {
            block5: {
                val = 0;
                if (!this.intel) break block5;
                shift = 0;
                i = offset;
                if (true) ** GOTO lbl11
                do {
                    val += (this.data[i] & 255) << shift;
                    shift += 8;
                    ++i;
lbl11:
                    // 2 sources

                    if (i >= length + offset) break block4;
                } while (i < this.data.length);
                break block4;
            }
            if (this.motorola) {
                i = 0;
                while (i < length) {
                    val = (val << 8) + (this.data[offset + i] & 255);
                    ++i;
                }
            }
        }
        if (signed && (val & (msb = 1 << 8 * length - 1)) > 0) {
            val -= msb << 1;
        }
        return val;
    }

    int s2n(int offset, int length) {
        return this.s2n(offset, length, false);
    }

    public static void skip(InputStream is, long n2) throws IOException {
        if (n2 == 0L) {
            return;
        }
        long lefttoskip = n2;
        do {
            lefttoskip -= is.skip(lefttoskip);
        } while (lefttoskip > 0L);
    }
}

