/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Naming;
import photoorganizer.formats.Rational;
import photoorganizer.formats.Record;
import photoorganizer.formats.StrippedJpeg;

public class CIFF
extends AbstractImageInfo {
    static final String FORMAT = "HEAP";
    static final String II = "II";
    static final String JPGM = "JPGM";
    public static final int KSTG_FORMATMASK = 49152;
    public static final int KSTG_INHEAPSPACE = 49152;
    public static final int KSTG_INRECORDENTRY = 16384;
    public static final int K_DATATYPEMASK = 14336;
    public static final int K_DT_ASCII = 2048;
    public static final int K_DT_BYTE = 0;
    public static final int K_DT_BYTE2 = 8192;
    public static final int K_DT_DWORD = 6144;
    public static final int K_DT_HEAPTYPEPROPERTY1 = 10240;
    public static final int K_DT_HEAPTYPEPROPERTY2 = 12288;
    public static final int K_DT_WORD = 4096;
    public static final int K_IDCODEMASK = 2047;
    public static final int K_TC_BODYID = 6155;
    public static final int K_TC_BODYSENSITIVITY = 4124;
    public static final int K_TC_CAMERAOBJECT = 10247;
    public static final int K_TC_CAMERASPECIFICATION = 12292;
    public static final int K_TC_CAPTURETIME = 6158;
    public static final int K_TC_COMPONENTVESRION = 2060;
    public static final int K_TC_DESCRIPTION = 2053;
    public static final int K_TC_EXUSED = 2;
    public static final int K_TC_FIRMWAREVERSION = 2059;
    public static final int K_TC_FREE = 1;
    public static final int K_TC_IMAGEFILENAME = 2070;
    public static final int K_TC_IMAGEFORMAT = 6147;
    public static final int K_TC_IMAGESPEC = 6160;
    public static final int K_TC_MEASUREDINFO = 12291;
    public static final int K_TC_MI_EV = 6164;
    public static final int K_TC_MODELNAME = 2058;
    public static final int K_TC_NULL = 0;
    public static final int K_TC_OWNERNAME = 2064;
    public static final int K_TC_RECORDID = 6148;
    public static final int K_TC_RELEASESETTING = 4118;
    public static final int K_TC_ROMOPERATIONMODE = 2061;
    public static final int K_TC_SELFTIMERTIME = 6150;
    public static final int K_TC_SERIALNUMBER = 6167;
    public static final int K_TC_SHOOTINGRECORD = 12290;
    public static final int K_TC_SR_EF = 6163;
    public static final int K_TC_SR_EXPOSURE = 6168;
    public static final int K_TC_SR_RELEASEMETHOD = 4112;
    public static final int K_TC_SR_RELEASETIMING = 4113;
    public static final int K_TC_SR_TARGETDISTANCESETTING = 6151;
    public static final int K_TC_TARGETIMAGETYPE = 4106;
    public static final int K_TC_THUMBNAILFILENAME = 2071;
    public static final int K_TC_WILDCARD = 65535;
    public static final int K_TYPEIDCODEMASK = 16383;
    static final String MM = "MM";
    Hashtable heapcontent;

    public CIFF(InputStream is, byte[] data, int offset, String name, String comments) throws FileFormatException {
        super(is, data, offset, name, comments);
    }

    public String getDataTimeOriginalString() {
        return this.heapcontent.get(new Integer(6158)).toString();
    }

    public int getExpoProgram() {
        return 0;
    }

    public float getFNumber() {
        try {
            return this.apertureToFnumber(((Record)this.heapcontent.get(new Integer(6168))).getFloatValue(2));
        }
        catch (NullPointerException e2) {
            return -1.0f;
        }
    }

    public float getFocalLength() {
        return 0.0f;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getMake() {
        return this.heapcontent.get(new Integer(2058)).toString();
    }

    public int getMetering() {
        return 0;
    }

    public String getModel() {
        return this.heapcontent.get(new Integer(2058)).toString();
    }

    public Hashtable getProperties() {
        return this.heapcontent;
    }

    public String getQuality() {
        return "BEST";
    }

    public String getReport() {
        return this.heapcontent.get(new Integer(6168)).toString();
    }

    public int getResolutionX() {
        Record r2 = (Record)this.heapcontent.get(new Integer(6160));
        if (r2 != null) {
            return r2.getWidth();
        }
        return -1;
    }

    public int getResolutionY() {
        Record r2 = (Record)this.heapcontent.get(new Integer(6160));
        if (r2 != null) {
            return r2.getHeight();
        }
        return -1;
    }

    public Rational getShutter() {
        try {
            int si = (int)((Record)this.heapcontent.get(new Integer(6168))).getFloatValue(1);
            return AbstractImageInfo.TV_TO_SEC[si];
        }
        catch (NullPointerException e2) {
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    public Icon getThumbnailIcon(StrippedJpeg im, Dimension size) {
        try {
            File tnf = new File(new File(im.getLocationName()).getParent(), this.heapcontent.get(new Integer(2071)).toString());
            if (tnf.exists()) {
                return new ImageIcon(tnf.getAbsolutePath());
            }
        }
        catch (NullPointerException e2) {}
        return null;
    }

    public boolean isFlash() {
        try {
            return ((Record)this.heapcontent.get(new Integer(6163))).getFloatValue() > 0.0f;
        }
        catch (NullPointerException e2) {
            return false;
        }
    }

    void processHeap(int start, int length) {
        int offsettbloffset = this.s2n(start + length - 4, 4) + start;
        int numrecords = this.s2n(offsettbloffset, 2);
        int next = offsettbloffset + 2;
        int i2 = 0;
        while (i2 < numrecords) {
            next = this.processRecord(next, start);
            ++i2;
        }
    }

    int processRecord(int offset, int start) {
        int type = this.s2n(offset, 2);
        int datatypeidcode = type & 0x3FFF;
        if ((type & 0xC000) == 0) {
            int length = this.s2n(offset + 2, 4);
            int recoffext = this.s2n(offset + 6, 4) + start;
            if (datatypeidcode == 6160) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2n(recoffext, 4), this.s2n(recoffext + 4, 4), Float.intBitsToFloat(this.s2n(recoffext + 8, 4)), this.s2n(recoffext + 12, 4), this.s2n(recoffext + 16, 4), this.s2n(recoffext + 20, 4), this.s2n(recoffext + 24, 4)));
            } else if (datatypeidcode == 2058) {
                String manufacturer = this.s2a(recoffext, length);
                manufacturer.replace('\u0000', ' ');
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, manufacturer));
            } else if (datatypeidcode == 2070 || datatypeidcode == 2071 || datatypeidcode == 2053 || datatypeidcode == 2064 || datatypeidcode == 2059) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2a(recoffext, length)));
            } else if (datatypeidcode == 6168) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, Float.intBitsToFloat(this.s2n(recoffext, 4)), Float.intBitsToFloat(this.s2n(recoffext + 4, 4)), Float.intBitsToFloat(this.s2n(recoffext + 8, 4))));
            } else if (datatypeidcode == 6158) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2n(recoffext, 4), this.s2n(recoffext + 4, 4), this.s2n(recoffext + 8, 4)));
            } else if (datatypeidcode == 12292) {
                this.processHeap(recoffext, length);
            } else if (datatypeidcode == 10247) {
                this.processHeap(recoffext, length);
            } else if (datatypeidcode == 12291) {
                this.processHeap(recoffext, length);
            } else if (datatypeidcode == 12290) {
                this.processHeap(recoffext, length);
            } else if ((datatypeidcode & 0x3800) == 10240 || (datatypeidcode & 0x3800) == 12288) {
                this.processHeap(recoffext, length);
            } else {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, (datatypeidcode & 0x3800) == 2048 ? this.s2a(recoffext, length) : "Unknown " + Naming.getCIFFTypeName(datatypeidcode) + " in-heap property"));
            }
        } else if ((type & 0x4000) != 0) {
            if (datatypeidcode == 6147) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2n(offset + 2, 4), Float.intBitsToFloat(this.s2n(offset + 6, 4))));
            } else if (datatypeidcode == 4106) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2n(offset + 2, 2)));
            } else if (datatypeidcode == 6148 || datatypeidcode == 6167 || datatypeidcode == 6150 || datatypeidcode == 6155) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2n(offset + 2, 4)));
            } else if (datatypeidcode == 4112 || datatypeidcode == 4113 || datatypeidcode == 4124) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2n(offset + 2, 2)));
            } else if (datatypeidcode == 6163) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, Float.intBitsToFloat(this.s2n(offset + 2, 4)), Float.intBitsToFloat(this.s2n(offset + 6, 4))));
            } else if (datatypeidcode == 6151 || datatypeidcode == 6164) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, Float.intBitsToFloat(this.s2n(offset + 2, 4))));
            } else if (datatypeidcode == 2061) {
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, this.s2a(offset + 2, 8)));
            } else {
                String content;
                if ((datatypeidcode & 0x3800) == 2048) {
                    content = this.s2a(offset + 2, 8);
                } else {
                    content = "Unknown " + Naming.getCIFFTypeName(datatypeidcode) + " in-record property";
                    if ((datatypeidcode & 0x3800) == 4096) {
                        content = content + "(" + this.s2n(offset + 2, 2) + ")";
                    } else if ((datatypeidcode & 0x3800) == 6144) {
                        content = content + "(" + this.s2n(offset + 2, 4) + ")";
                    } else if ((datatypeidcode & 0x3800) == 0) {
                        content = content + "(" + this.s2n(offset + 2, 1) + ")";
                    }
                }
                this.heapcontent.put(new Integer(datatypeidcode), new Record(datatypeidcode, content));
            }
        }
        return offset + 2 + 4 + 4;
    }

    void readHeapFileHeader() {
        this.motorola = this.data[0] == 77;
        boolean bl2 = this.intel = this.data[0] == 73;
        if (!this.isSignature(10, JPGM)) {
            return;
        }
        this.heapcontent = new Hashtable();
        int heapheaderlength = this.s2n(2, 4);
        this.processHeap(heapheaderlength, this.data.length - heapheaderlength);
    }

    public void readInfo() {
        this.readHeapFileHeader();
        this.data = null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean saveThumbnailImage(StrippedJpeg im, OutputStream os) throws IOException {
        try {
            String tnfn = this.heapcontent.get(new Integer(2071)).toString();
            if (tnfn != null) {
                int len;
                FileInputStream is = new FileInputStream(new File(new File(im.getLocationName()).getParent(), tnfn));
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)is).read(buffer)) > 0) {
                    void var6_7;
                    os.write(buffer, 0, (int)var6_7);
                }
                return true;
            }
        }
        catch (NullPointerException e2) {}
        return super.saveThumbnailImage(im, os);
    }
}

