/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import photoorganizer.formats.BasicIo;
import photoorganizer.formats.CLSID;

class DirectoryEntry
extends BasicIo {
    static final int AB_SIZE = 32;
    static final int CB_OFF = 64;
    static final int CHILD_OFF = 76;
    static final int CLSID_OFF = 80;
    static final int DE_BLACK = 1;
    static final int DE_RED = 0;
    static final int ENTRY_SIZE = 128;
    static final int FLAGS_OFF = 67;
    static final int LEFTSIB_OFF = 68;
    static final int MSE_OFF = 66;
    static final int RIGHTSIB_OFF = 72;
    static final int SECTSTART_OFF = 116;
    static final int SIZE_OFF = 120;
    static final int STGTY_INVALID = 0;
    static final int STGTY_LOCKBYTES = 3;
    static final int STGTY_PROPERTY = 4;
    static final int STGTY_ROOT = 5;
    static final int STGTY_STORAGE = 1;
    static final int STGTY_STREAM = 2;
    static final int TIMECREATE_OFF = 100;
    static final int TIMEMODIFY_OFF = 107;
    static final int USERFLAGS_OFF = 96;
    char[] _ab;
    int _cb;
    int _child;
    byte _flags;
    CLSID _id;
    int _leftSib;
    byte _mse;
    int _rightSib;
    int _sectStart;
    int _size;
    long _timeCreate;
    long _timeModify;
    int _userFlags;
    static final String[] types = new String[]{"INVALID", "STORAGE", "STREAM", "LOCKBYTES", "PROPERTY", "ROOT"};

    DirectoryEntry() {
    }

    void fill(byte[] data, int offset) {
        this.data = data;
        this.intel = true;
        this._mse = (byte)(this.s2n(66 + offset, 1) & 0xFF);
        if (this._mse >= types.length || this._mse < 0) {
            this._mse = 0;
        }
        this._cb = this.s2n(64 + offset, 2) / 2;
        this._ab = new char[this._cb];
        int i2 = 0;
        while (i2 < this._cb && i2 < 32) {
            this._ab[i2] = (char)this.bs2i(offset + 2 * i2 + (this._mse == 5 ? 0 : 1), 2);
            ++i2;
        }
        this._flags = (byte)(this.s2n(67 + offset, 1) & 0xFF);
        this._leftSib = this.s2n(68 + offset, 4);
        this._rightSib = this.s2n(72 + offset, 4);
        this._child = this.s2n(76 + offset, 4);
        this._id = new CLSID();
        this._id.fill(data, 80 + offset);
        this._userFlags = this.s2n(96 + offset, 4);
        this._timeCreate = this.s2n(100 + offset, 8);
        this._timeModify = this.s2n(107 + offset, 8);
        this._sectStart = this.s2n(116 + offset, 4);
        this._size = this.s2n(120 + offset, 4);
    }

    public String toString() {
        return "Directory " + types[this._mse] + " entry " + new String(this._ab, 0, this._cb) + ", mse " + this._mse + ", child " + this._child + ", left sib " + this._leftSib + ", right sib " + this._rightSib;
    }
}

