/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.Serializable;

public class Entry
implements Serializable {
    private String str;
    private int type;
    private Object[] value;

    public Entry(int type, Object[] value) {
        this.type = type;
        this.value = value;
    }

    public Entry(int type, String value) {
        this.type = type;
        this.str = value;
    }

    public Entry(String value) {
        this(2, value);
    }

    public Entry(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue(int index) {
        if (this.value != null) {
            return this.value[index];
        }
        if (this.str != null) {
            return this.str;
        }
        return null;
    }

    public Object[] getValues() {
        return this.value;
    }

    public void setValue(int index, Object newValue) {
        if (newValue instanceof String) {
            this.str = (String)newValue;
        } else if (this.value != null && index <= this.value.length) {
            this.value[index] = newValue;
        } else {
            Object[] tempHolder = new Object[index + 1];
            if (this.value != null) {
                System.arraycopy(this.value, 0, tempHolder, 0, this.value.length);
            }
            tempHolder[index] = newValue;
            this.value = tempHolder;
        }
    }

    public String toString() {
        if (this.str != null) {
            return this.str;
        }
        StringBuffer buff = new StringBuffer();
        int i2 = 0;
        while (i2 < this.value.length) {
            buff.append(this.type != 7 ? this.value[i2] : Integer.toHexString((Integer)this.value[i2]));
            ++i2;
        }
        return buff.toString();
    }
}

