/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import photoorganizer.formats.BasicIo;

class Header
extends BasicIo {
    static final int FATOFF = 76;
    static final int FIRST_FAT_SIZE = 109;
    static final int MINISECTORCUTOFFOFF = 56;
    static final int MINISECTORSIZEOFF = 32;
    static final int SECTDIFSTARTOFF = 68;
    static final int SECTDIRSTARTOFF = 48;
    static final int SECTMINIFATSTARTOFF = 60;
    static final int SECTORSIZEOFF = 30;
    static final int SECTSDIFOFF = 72;
    static final int SECTSFATOFF = 44;
    static final int SECTSMINIFATOFF = 64;
    int dllVersion;
    int[] fat;
    boolean intelByteOrder;
    int miniSectorCutoff;
    int miniSectorSize;
    int minorVersion;
    int sectDifStart;
    int sectDirStart;
    int sectMiniFatStart;
    int sectorSize;
    int sectsDif;
    int sectsFat;
    int sectsMiniFat;

    Header() {
    }

    void fill(byte[] data, int offset) {
        this.data = data;
        this.intel = true;
        this.intelByteOrder = true;
        this.sectorSize = 1 << this.s2n(30 + offset, 2);
        this.miniSectorSize = 1 << this.s2n(32 + offset, 2);
        this.sectsFat = this.s2n(44 + offset, 4);
        this.sectDirStart = this.s2n(48 + offset, 4);
        this.miniSectorCutoff = this.s2n(56 + offset, 4);
        this.sectMiniFatStart = this.s2n(60 + offset, 4);
        this.sectsMiniFat = this.s2n(64 + offset, 4);
        this.sectDifStart = this.s2n(68 + offset, 4);
        this.sectsDif = this.s2n(72 + offset, 4);
        this.fat = new int[109];
        int i2 = 0;
        while (i2 < 109) {
            this.fat[i2] = this.s2n(76 + offset + 4 * i2, 4);
            ++i2;
        }
    }

    public String toString() {
        String result = "Sector size " + this.sectorSize + ", mini sector size " + this.miniSectorSize + ", sectors in FAT " + this.sectsFat + ", directory sector " + this.sectDirStart + ", max size of mini stream " + this.miniSectorCutoff + ", mini FAT starts " + this.sectMiniFatStart + ", sectors in mini FAT " + this.sectsMiniFat + ", first DIF and numbers " + this.sectDifStart + ':' + this.sectsDif;
        return result;
    }
}

