/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Rational;
import photoorganizer.formats.StrippedJpeg;

public class JFXX
extends AbstractImageInfo {
    static final String CAMERA_INFO = "camera info";
    static final String CFNUMBER = "FNumber";
    static final String DIAG_INFO = "diag info";
    static final String END = "end";
    static final String FILE_INFO = "file info";
    static final String FLASH = "Flash";
    static final String FNUMBER = "Fnumber";
    static final String FORMAT = "JFXX";
    static final String ID = "ID";
    static final String IMAGESIZE = "ImageSize";
    static final String PICTURE_INFO = "picture info";
    static final String RESOLUTION = "Resolution";
    static final String SHUTTER = "Shutter";
    static final String TIMEDATE = "TimeDate";
    static final String TYPE = "Type";
    static final String USER = "user";
    static final String ZOOM = "Zoom";
    private Hashtable camerainfo;
    private Hashtable diaginfo;
    private Hashtable fileinfo;
    final DecimalFormat fnumberformat = new DecimalFormat("F##.##");
    private byte[] image;
    private String make;
    private Hashtable pictureinfo;
    final DecimalFormat zoomformat = new DecimalFormat("x##.##");

    public JFXX(InputStream is, byte[] data, int offset, String name, String comments) throws FileFormatException {
        super(is, data, offset, name, comments);
    }

    public Hashtable getCameraInfo() {
        return this.camerainfo;
    }

    public String getDataTimeOriginalString() {
        String date = (String)this.pictureinfo.get(TIMEDATE);
        if (date != null) {
            return AbstractImageInfo.dateformat.format(new Date((long)Integer.parseInt(date) * 1000L));
        }
        return null;
    }

    public Hashtable getDiagInfo() {
        return this.diaginfo;
    }

    public int getExpoProgram() {
        return 0;
    }

    public float getFNumber() {
        try {
            String a2 = (String)this.pictureinfo.get(FNUMBER);
            if (a2 == null) {
                a2 = (String)this.pictureinfo.get(CFNUMBER);
            }
            return this.fnumberformat.parse(a2).floatValue();
        }
        catch (NumberFormatException e2) {
        }
        catch (Exception e3) {
        }
        return -1.0f;
    }

    public Hashtable getFileInfo() {
        return this.fileinfo;
    }

    public float getFocalLength() {
        try {
            return this.zoomformat.parse((String)this.pictureinfo.get(ZOOM)).floatValue();
        }
        catch (NumberFormatException e2) {
        }
        catch (Exception e3) {
        }
        return 0.0f;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getMake() {
        if (this.make != null) {
            return this.make;
        }
        return FORMAT;
    }

    public static byte[] getMarkerData() {
        return new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
    }

    public int getMetering() {
        return 0;
    }

    public String getModel() {
        return "" + (String)this.camerainfo.get(ID) + " " + (String)this.camerainfo.get(TYPE);
    }

    public Hashtable getPictureInfo() {
        return this.pictureinfo;
    }

    public String getQuality() {
        return (String)this.pictureinfo.get(RESOLUTION);
    }

    public String getReport() {
        StringBuffer report = new StringBuffer();
        report.append("Shutter: ");
        report.append((String)this.pictureinfo.get(SHUTTER));
        report.append(", Aperture: ");
        String a2 = (String)this.pictureinfo.get(FNUMBER);
        if (a2 == null) {
            a2 = (String)this.pictureinfo.get(CFNUMBER);
        }
        report.append(a2).append(", Flash: ");
        report.append("0".equals((String)this.pictureinfo.get(FLASH)) ? "YES" : "NO");
        return report.toString();
    }

    public int getResolutionX() {
        int dp2;
        String s2 = (String)this.pictureinfo.get(IMAGESIZE);
        if (s2 != null && (dp2 = s2.indexOf(45)) > 0) {
            try {
                return Integer.parseInt(s2.substring(0, dp2));
            }
            catch (NumberFormatException e2) {
            }
        }
        return -1;
    }

    public int getResolutionY() {
        int dp2;
        String s2 = (String)this.pictureinfo.get(IMAGESIZE);
        if (s2 != null && (dp2 = s2.indexOf(45)) > 0) {
            try {
                return Integer.parseInt(s2.substring(dp2 + 1));
            }
            catch (NumberFormatException e2) {
            }
        }
        return -1;
    }

    public Rational getShutter() {
        try {
            return new Rational(Integer.parseInt((String)this.pictureinfo.get(SHUTTER)), 1);
        }
        catch (NumberFormatException e2) {
        }
        catch (Exception e3) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    public Icon getThumbnailIcon(StrippedJpeg im, Dimension size) {
        if (this.image != null) {
            return new ImageIcon(this.image);
        }
        return null;
    }

    public boolean isFlash() {
        if (this.pictureinfo == null) {
            return false;
        }
        String flash = (String)this.pictureinfo.get(FLASH);
        if (flash != null) {
            return !"0".equals(flash);
        }
        return false;
    }

    void readAPP0X() {
        switch (this.data[5]) {
            case 16: {
                this.image = new byte[this.data.length - 6];
                System.arraycopy(this.data, 6, this.image, 0, this.image.length);
            }
        }
    }

    void readAPP12() throws IOException {
        this.data = new byte[4];
        this.is.read(this.data);
        if (this.data[0] == -1 && this.data[1] == -20) {
            int len = this.bs2i(2, 2) - 2;
            this.data = new byte[len];
            StrippedJpeg.read(this.is, this.data);
            ParserAPP12 parser = new ParserAPP12(0);
            this.make = parser.next();
            parser.next();
            this.pictureinfo = new Hashtable();
            this.camerainfo = new Hashtable();
            this.diaginfo = new Hashtable();
            this.fileinfo = new Hashtable();
            Hashtable currentinfo = null;
            while (parser.hasMore()) {
                StringTokenizer st;
                String el = parser.next();
                if (el.startsWith("[")) {
                    if (el.indexOf(PICTURE_INFO) == 1) {
                        currentinfo = this.pictureinfo;
                        continue;
                    }
                    if (el.indexOf(CAMERA_INFO) == 1) {
                        currentinfo = this.camerainfo;
                        continue;
                    }
                    if (el.indexOf(DIAG_INFO) == 1) {
                        currentinfo = this.diaginfo;
                        continue;
                    }
                    if (el.indexOf(FILE_INFO) == 1) {
                        currentinfo = this.fileinfo;
                        continue;
                    }
                    currentinfo = null;
                    continue;
                }
                if (currentinfo == null || !(st = new StringTokenizer(el, "=")).hasMoreTokens()) continue;
                String key = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                currentinfo.put(key, st.nextToken());
            }
        }
    }

    public void readInfo() {
        try {
            this.readAPP0X();
            this.readAPP12();
        }
        catch (NullPointerException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        this.data = null;
    }

    public boolean saveThumbnailImage(StrippedJpeg im, OutputStream os) throws IOException {
        if (this.image != null && os != null) {
            os.write(this.image);
            return true;
        }
        return super.saveThumbnailImage(im, os);
    }

    class ParserAPP12 {
        int curpos;

        ParserAPP12(int offset) {
            this.curpos = offset;
        }

        boolean hasMore() {
            return this.curpos < JFXX.this.data.length - 1;
        }

        String next() {
            int startpos = this.curpos;
            while (this.curpos < JFXX.this.data.length && JFXX.this.data[this.curpos] != 0 && JFXX.this.data[this.curpos] != 10 && JFXX.this.data[this.curpos] != 13) {
                ++this.curpos;
            }
            String result = null;
            try {
                result = new String(JFXX.this.data, startpos, this.curpos - startpos, "Default");
            }
            catch (UnsupportedEncodingException e2) {}
            while (this.curpos < JFXX.this.data.length && (JFXX.this.data[this.curpos] == 0 || JFXX.this.data[this.curpos] == 10 || JFXX.this.data[this.curpos] == 13)) {
                ++this.curpos;
            }
            return result;
        }
    }
}

