/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Rational;
import photoorganizer.formats.StrippedJpeg;

class JPEG
extends AbstractImageInfo {
    byte[] header = new byte[2];
    int height;
    int precision;
    int width;

    public JPEG(InputStream is, byte[] data, int offset, String name, String comments, int width, int height) throws FileFormatException {
        super(is, data, offset, name, comments);
        if (this.width <= 0 && width > 0) {
            this.width = width;
            this.height = height;
        } else {
            int len;
            if (data.length == 2) {
                len = this.readMarker(is, true);
                if (len <= 0) {
                    return;
                }
                if (data[1] >= -64 && data[1] <= -49 && data[1] != -60 && data[1] != -56) {
                    this.precision = (this.data[0] & 0xFF) * (this.data[5] & 0xFF);
                    this.width = this.bs2i(3, 2);
                    this.height = this.bs2i(1, 2);
                    return;
                }
            }
            while ((len = this.readMarker(is, false)) > 0) {
                if (this.header[1] < -64 || this.header[1] > -49 || this.header[1] == -60 || this.header[1] == -56) continue;
                this.precision = (this.data[0] & 0xFF) * (this.data[5] & 0xFF);
                this.width = this.bs2i(3, 2);
                this.height = this.bs2i(1, 2);
                break;
            }
        }
    }

    public String getDataTimeOriginalString() {
        return AbstractImageInfo.dateformat.format(new Date());
    }

    public int getExpoProgram() {
        return 0;
    }

    public float getFNumber() {
        return 0.0f;
    }

    public float getFocalLength() {
        return 0.0f;
    }

    public String getFormat() {
        return "n/a";
    }

    public String getMake() {
        return "n/a";
    }

    public int getMetering() {
        return 0;
    }

    public String getModel() {
        return "n/a";
    }

    public String getQuality() {
        return "n/a";
    }

    public String getReport() {
        return "n/a";
    }

    public int getResolutionX() {
        return this.width;
    }

    public int getResolutionY() {
        return this.height;
    }

    public Rational getShutter() {
        return new Rational(0, 1);
    }

    public Icon getThumbnailIcon(StrippedJpeg im, Dimension size) {
        int w2 = 100;
        int h2 = 100;
        int[] pix = new int[w2 * h2];
        int index = 0;
        int y2 = 0;
        while (y2 < h2) {
            int red = y2 * 255 / (h2 - 1);
            int x2 = 0;
            while (x2 < w2) {
                int blue = x2 * 255 / (w2 - 1);
                pix[index++] = 0xFF000000 | red << 16 | blue;
                ++x2;
            }
            ++y2;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w2, h2, pix, 0, w2)));
    }

    public boolean isFlash() {
        return false;
    }

    public void readInfo() {
        this.data = null;
    }

    int readMarker(InputStream is, boolean bodyOnly) {
        try {
            if (!bodyOnly && is.read(this.header) < this.header.length) {
                return -1;
            }
            this.data = new byte[2];
            if (is.read(this.data) < this.data.length) {
                return -1;
            }
            int len = this.bs2i(0, 2) - 2;
            this.data = new byte[len];
            return BasicIo.read(is, this.data) + this.header.length + 2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return -1;
        }
    }

    public boolean saveThumbnailImage(StrippedJpeg im, OutputStream os) throws IOException {
        return false;
    }
}

