/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.Serializable;

public class Rational
implements Serializable {
    int den;
    int num;

    public Rational(float value) {
        this.den = 1000;
        this.num = (int)(value * new Integer(this.den).floatValue());
    }

    public Rational(int num, int den) {
        this.num = num;
        this.den = den;
    }

    public float floatValue() {
        return (float)this.num / (float)this.den;
    }

    public int getDen() {
        return this.den;
    }

    public int getNum() {
        return this.num;
    }

    public int intValue() {
        return this.num / this.den;
    }

    public void normalize() {
    }

    public static String toExposureString(Object o2) {
        if (o2 instanceof Rational) {
            return ((Rational)o2).toExposureString();
        }
        return o2.toString();
    }

    public String toExposureString() {
        if (this.num > 0) {
            return "1/" + Math.round(1.0 * (double)this.den / (double)this.num);
        }
        return "";
    }

    public String toString() {
        return "" + this.num + "/" + this.den;
    }
}

