/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.CIFF;
import photoorganizer.formats.Exif;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Flashpix;
import photoorganizer.formats.JFXX;
import photoorganizer.formats.JPEG;
import photoorganizer.formats.TiffExif;
import se.datadosen.util.StringCodec;

public class StrippedJpeg
extends BasicIo {
    public static final int BYTE_SIZE = 8;
    public static final int COMMENT = 8;
    public static final int DCTSIZE = 8;
    public static final int DCTSIZE2 = 64;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final String FPXR = "FPXR";
    private int[] H;
    public static final int HUFF_LOOKAHEAD = 8;
    private int[] ID;
    public static final String JFIF = "JFIF";
    public static final String JPEG = "JPEG";
    public static final int NONE = 0;
    private int[] QT;
    public static final int ROT_180 = 6;
    public static final int ROT_270 = 7;
    public static final int ROT_90 = 5;
    public static final int TRANSPOSE = 3;
    public static final int TRANSVERSE = 4;
    private int[] V;
    private int _Ah;
    private int _Al;
    private int _Se;
    private int _Ss;
    private int[][] ac_huffbits;
    private int[][] ac_huffval;
    private int[] ac_ix;
    private int[][] ac_maxcode;
    private int[] ac_table;
    private int[][] ac_valoffset;
    private int[][] app_store;
    protected byte[][] appxs;
    protected String artist;
    protected boolean canBeProcessed;
    static /* synthetic */ Class class$photoorganizer$formats$AbstractImageInfo;
    static /* synthetic */ Class class$photoorganizer$formats$Exif;
    static /* synthetic */ Class class$photoorganizer$formats$JFXX;
    StringCodec codec;
    private int[] comp_ids;
    private int components_in_frame;
    private int components_in_scan;
    private int[][] dc_huffbits;
    private int[][] dc_huffval;
    private int[] dc_ix;
    private int[][] dc_maxcode;
    private int[] dc_table;
    private int[][] dc_valoffset;
    private int[][][][][] dct_coefs;
    private static String enc;
    private int[][][] enc_ac_matrix;
    private int[][][] enc_dc_matrix;
    protected int exifIndex;
    protected File file;
    private int frm_precision;
    private int frm_x;
    private int frm_y;
    HashMap hm = new HashMap();
    protected AbstractImageInfo imageinfo;
    protected InputStream inStream;
    String in_comment;
    static final int[] jpegnaturalorder;
    static final int[] jpegzigzagorder;
    protected byte[] markerid;
    protected byte[] markers;
    private int maxHi;
    private int maxVi;
    private int mcusize;
    String out_comment;
    private int[] q_ix;
    private int[] q_prec;
    private int[][] q_table;
    protected byte[] rawDct;
    private int readcounter;
    private int restart_interval;
    int restarts_to_go;
    protected Map tables;
    protected boolean valid;

    static {
        jpegzigzagorder = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
        jpegnaturalorder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    }

    public StrippedJpeg(InputStream inStream) {
        this.codec = new StringCodec();
        this.markerid = new byte[2];
        this.inStream = inStream;
    }

    public StrippedJpeg(File file) {
        this.codec = new StringCodec();
        this.file = file;
        this.markerid = new byte[2];
        this.read();
    }

    private void addAppx(int len, byte markercode) {
        if (this.appxs == null) {
            this.appxs = new byte[0][];
        }
        byte[][] ta = new byte[this.appxs.length + 1][];
        System.arraycopy(this.appxs, 0, ta, 0, this.appxs.length);
        this.appxs = ta;
        this.appxs[this.appxs.length - 1] = new byte[len + 4];
        this.appxs[this.appxs.length - 1][0] = -1;
        this.appxs[this.appxs.length - 1][1] = markercode;
        System.arraycopy(this.markerid, 0, this.appxs[this.appxs.length - 1], 2, 2);
        System.arraycopy(this.data, 0, this.appxs[this.appxs.length - 1], 4, len);
    }

    private void addMarker(int len, byte markercode) {
        if (this.tables == null) {
            this.tables = new Hashtable();
        }
        if (this.markers == null) {
            this.markers = new byte[1];
        } else {
            byte[] ta = new byte[this.markers.length + 1];
            System.arraycopy(this.markers, 0, ta, 0, this.markers.length);
            this.markers = ta;
        }
        this.markers[this.markers.length - 1] = markercode;
        byte[] marker = new byte[len + 4];
        marker[0] = -1;
        marker[1] = markercode;
        System.arraycopy(this.markerid, 0, marker, 2, 2);
        System.arraycopy(this.data, 0, marker, 4, len);
        this.tables.put("" + markercode, marker);
    }

    void allocateTables() {
        this.dc_valoffset = new int[0][0];
        this.dc_maxcode = new int[0][0];
        this.dc_huffval = new int[0][0];
        this.enc_dc_matrix = new int[0][][];
        this.dc_huffbits = new int[0][0];
        this.dc_ix = new int[0];
        this.ac_valoffset = new int[0][0];
        this.ac_maxcode = new int[0][0];
        this.ac_huffval = new int[0][0];
        this.enc_ac_matrix = new int[0][][];
        this.ac_huffbits = new int[0][0];
        this.ac_ix = new int[0];
        this.q_table = new int[0][0];
        this.q_ix = new int[0];
        this.q_prec = new int[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public InputStream createInputStream() {
        block4: {
            try {
                if (!this.valid) break block4;
                this.readcounter = 0;
                if (this.file == null) {
                    if (this.inStream != null) {
                        return this.inStream;
                    }
                    this.valid = false;
                    break block4;
                }
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e2) {
                this.valid = false;
            }
        }
        return null;
    }

    int[][] flipHDct(int[][] dct) {
        int k2 = 0;
        while (k2 < dct[0].length) {
            if ((jpegnaturalorder[dct[1][k2]] & 1) != 0) {
                dct[0][k2] = -dct[0][k2];
            }
            ++k2;
        }
        return dct;
    }

    int[][] flipVDct(int[][] dct) {
        int k2 = 0;
        while (k2 < dct[0].length) {
            if ((jpegnaturalorder[dct[1][k2]] & 8) == 8) {
                dct[0][k2] = -dct[0][k2];
            }
            ++k2;
        }
        return dct;
    }

    private void freeMemory() {
        this.dct_coefs = null;
        this.dc_valoffset = null;
        this.dc_maxcode = null;
        this.dc_huffval = null;
        this.enc_dc_matrix = null;
        this.dc_huffbits = null;
        this.dc_ix = null;
        this.ac_valoffset = null;
        this.ac_maxcode = null;
        this.ac_huffval = null;
        this.enc_ac_matrix = null;
        this.ac_huffbits = null;
        this.ac_ix = null;
        this.q_table = null;
        this.q_ix = null;
        this.q_prec = null;
        this.appxs = null;
        this.tables = null;
        this.markers = null;
        this.rawDct = null;
    }

    public InputStream getAsStream() {
        return this.createInputStream();
    }

    public String getComment() {
        return this.out_comment;
    }

    public Date getDateTimeOriginal() {
        return this.file == null ? new Date() : new Date(this.file.lastModified());
    }

    public static String getEncoding() {
        return enc;
    }

    public File getFile() {
        return this.file;
    }

    public long getFileSize() {
        return this.length();
    }

    public Image getImage() {
        if (this.valid) {
            return Toolkit.getDefaultToolkit().getImage(this.getLocationName());
        }
        return null;
    }

    public AbstractImageInfo getImageInfo() {
        return this.imageinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(Image image, final boolean sizeOnly) {
        Dimension imageSize;
        Dimension dimension = imageSize = new Dimension();
        synchronized (dimension) {
            imageSize.width = image.getWidth(new ImageObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean imageUpdate(Image img, int infoflags, int x2, int y2, int width, int height) {
                    if (sizeOnly && (infoflags & 3) == 3 || (infoflags & 0x10) == 32 || (infoflags & 0x80) == 128 || (infoflags & 0x40) == 64) {
                        Dimension dimension = imageSize;
                        synchronized (dimension) {
                            imageSize.width = width;
                            imageSize.height = height;
                            imageSize.notify();
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (imageSize.width < 0) {
                try {
                    imageSize.wait(3600000L);
                }
                catch (Exception ie) {
                }
            } else {
                imageSize.height = image.getHeight(null);
            }
        }
        return imageSize;
    }

    public AbstractInfo getInfo() {
        return this.getImageInfo();
    }

    public String getLocationName() {
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public String getName() {
        if (this.file == null) {
            return "Unknown/Stream";
        }
        return this.file.getName();
    }

    public String getParentPath() {
        return this.file == null ? null : this.file.getParent();
    }

    public String getThumbnailType() {
        return this.getImageInfo().getThumbnailExtension();
    }

    public String getType() {
        return JPEG;
    }

    public URL getUrl() {
        if (this.file == null) {
            return null;
        }
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException me) {
            return null;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public long length() {
        return this.file == null ? -1L : this.file.length();
    }

    public static void main(String[] args) {
        System.out.println("Lossless image transformer");
        try {
            System.setErr(new PrintStream(new FileOutputStream("rotate.log"), true));
        }
        catch (IOException e2) {
            System.err.println("Can't redirect error stream.");
        }
        if (args.length == 1) {
            System.out.println("Testing order tables.");
            int i2 = 0;
            while (i2 < jpegnaturalorder.length) {
                if (jpegzigzagorder[jpegnaturalorder[i2]] != i2) {
                    System.out.println("Invalid table entry " + i2);
                }
                ++i2;
            }
            System.exit(0);
        }
        if (args.length < 3) {
            System.out.println("Usage StrippedJpeg source_name dest_name op [[comment] [encoding]]\n   where op:  FLIP_H = 1\n              FLIP_V = 2\n              TRANSPOSE = 3\n              TRANSVERSE = 4\n              ROT_90 = 5\n              ROT_180 = 6\n              ROT_270 = 7\n              COMMENT = 8");
            System.exit(255);
        } else if (Integer.parseInt(args[2]) != 8) {
            new StrippedJpeg(new File(args[0])).transform(args[1], Integer.parseInt(args[2]));
        } else {
            StrippedJpeg j2 = new StrippedJpeg(new File(args[0]));
            if (args.length > 3) {
                if (args.length > 4) {
                    StrippedJpeg.setEncoding(args[4]);
                }
                j2.setComment(args[3]);
            }
            j2.transform(args[1], 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void read(boolean info_only, boolean keep_appxs) {
        this.out_comment = "";
        this.valid = this.file != null ? this.file.isFile() : this.inStream != null;
        if (!this.valid) {
            return;
        }
        is = null;
        try {
            block73: {
                is = this.createInputStream();
                if (this.valid) break block73;
                var15_4 = null;
                if (is == null) return;
                ** GOTO lbl330
            }
            this.valid = false;
            this.canBeProcessed = true;
            block28: while (is.read(this.markerid) == this.markerid.length) {
                this.readcounter += this.markerid.length;
                if (this.markerid[0] != -1) {
                    if (this.readcounter == this.markerid.length) {
                        this.intel = this.markerid[0] == 73 && this.markerid[1] == 73;
                        v0 = this.motorola = this.markerid[0] == 77 && this.markerid[1] == 77;
                        if (this.intel || this.motorola) {
                            this.data = new byte[6];
                            if (is.read(this.data) == this.data.length && (this.intel && this.data[0] == 42 && this.data[1] == 0 || this.motorola && this.data[1] == 42 && this.data[0] == 0)) {
                                this.readcounter += this.data.length;
                                this.imageinfo = new TiffExif(is, this.data, this.readcounter, this.getName(), this.intel);
                            }
                        } else if (this.markerid[0] == Flashpix.SIGNATURE[0] && this.markerid[1] == Flashpix.SIGNATURE[1]) {
                            this.data = new byte[6];
                            if (is.read(this.data) == this.data.length && this.data[0] == Flashpix.SIGNATURE[2] && this.data[1] == Flashpix.SIGNATURE[3] && this.data[2] == Flashpix.SIGNATURE[4] && this.data[3] == Flashpix.SIGNATURE[5] && this.data[4] == Flashpix.SIGNATURE[6] && this.data[5] == Flashpix.SIGNATURE[7]) {
                                this.readcounter += this.data.length;
                            }
                        }
                    }
                    this.valid = this.imageinfo != null;
                    break;
                }
                markercode = this.markerid[1];
                System.err.println("Doing marker " + Integer.toHexString(markercode));
                block4 : switch (markercode) {
                    case -40: {
                        if (info_only) continue block28;
                        this.allocateTables();
                        break;
                    }
                    case -32: 
                    case -31: 
                    case -30: 
                    case -29: 
                    case -28: 
                    case -27: 
                    case -26: 
                    case -25: 
                    case -24: 
                    case -23: 
                    case -22: 
                    case -21: 
                    case -20: 
                    case -19: 
                    case -18: 
                    case -17: {
                        if (!info_only) {
                            if (keep_appxs) {
                                len = this.readMarker(is);
                                this.addAppx(len, markercode);
                                break;
                            }
                            if (is.read(this.markerid) != this.markerid.length) break block28;
                            this.readcounter += this.markerid.length;
                            this.data = this.markerid;
                            len = this.bs2i(0, 2) - 2;
                            BasicIo.skip(is, len);
                            this.readcounter += len;
                            System.err.println("Marker APP" + ((markercode & 255) - 224) + " is found, skipped " + len + 2 + " (" + this.getLocationName() + ")");
                            break;
                        }
                        len = this.readMarker(is);
                        if (keep_appxs) {
                            this.addAppx(len, markercode);
                        }
                        this.valid = true;
                        System.err.println("Signature " + new String(this.data, 0, 4));
                        if (this.isSignature(0, "JFIF")) {
                            version = this.bs2i(5, 2);
                            units = this.bs2i(7, 1);
                            xden = this.bs2i(8, 2);
                            yden = this.bs2i(10, 2);
                            x = this.bs2i(12, 1);
                            y = this.bs2i(13, 1);
                            thumbnailsize = 3 * x * y;
                            if (x > 0 && y > 0) {
                                System.err.println("Thumbnail " + x + "x" + y + " in APP0");
                            }
                        } else if (this.isSignature(0, "JFXX")) {
                            this.imageinfo = new JFXX(is, this.data, this.readcounter, this.getName(), this.out_comment);
                        } else if (this.isSignature(0, "Exif")) {
                            this.imageinfo = new Exif(is, this.data, this.readcounter, this.getName(), this.out_comment);
                            if (keep_appxs) {
                                this.exifIndex = this.appxs.length - 1;
                            }
                        } else if ((this.isSignature(0, "II") || this.isSignature(0, "MM")) && this.isSignature(6, "HEAP")) {
                            this.imageinfo = new CIFF(is, this.data, this.readcounter, this.getName(), this.out_comment);
                        } else if (this.isSignature(0, "FPXR")) {
                        } else if (this.imageinfo == null) {
                            System.err.println("unhandled APP marker " + Integer.toHexString(markercode) + " length " + len + " data " + new String(this.data, 0, len));
                        }
                        System.err.println("Image info " + this.imageinfo);
                        break;
                    }
                    case -37: {
                        if (info_only) {
                            this.valid = true;
                            this.data = this.markerid;
                            break block28;
                        }
                        len = this.readMarker(is);
                        pos = 0;
                        block29: while (pos < len) {
                            tabnum = this.q_prec.length;
                            wt1d = new int[tabnum + 1];
                            System.arraycopy(this.q_ix, 0, wt1d, 0, tabnum);
                            this.q_ix = wt1d;
                            this.q_ix[tabnum] = this.data[pos] & 15;
                            wt1d = new int[tabnum + 1];
                            System.arraycopy(this.q_prec, 0, wt1d, 0, tabnum);
                            this.q_prec = wt1d;
                            this.q_prec[tabnum] = (this.data[pos++] >> 4 & 15) == 0 ? 8 : 16;
                            wt2d = new int[tabnum + 1][64];
                            System.arraycopy(this.q_table, 0, wt2d, 0, tabnum);
                            this.q_table = wt2d;
                            lim = pos + 64;
                            if (lim > len) {
                                lim = len;
                            }
                            i = 0;
                            while (true) {
                                if (pos >= lim) {
                                    continue block29;
                                }
                                this.q_table[tabnum][i] = this.data[pos++] & 255;
                                ++i;
                            }
                        }
                        break;
                    }
                    case -60: {
                        if (info_only) {
                            this.valid = true;
                            this.data = this.markerid;
                            break block28;
                        }
                        len = this.readDHT(is);
                        break;
                    }
                    case -64: 
                    case -63: {
                        if (info_only) {
                            this.valid = true;
                            this.data = this.markerid;
                            System.err.println("Abandoned M_SOF0 -64   " + this.markerid[1]);
                            break block28;
                        }
                        len = this.readMarker(is);
                        this.frm_precision = this.data[0] & 255;
                        this.frm_x = this.bs2i(3, 2);
                        this.frm_y = this.bs2i(1, 2);
                        this.components_in_frame = this.data[5] & 255;
                        System.err.println("Frame, precision " + this.frm_precision);
                        System.err.println("X= " + this.frm_x + ", Y= " + this.frm_y);
                        System.err.println("Components " + this.components_in_frame + " (" + this.getLocationName() + ")");
                        this.V = new int[this.components_in_frame];
                        this.H = new int[this.components_in_frame];
                        this.QT = new int[this.components_in_frame];
                        this.ID = new int[this.components_in_frame];
                        pos = 6;
                        this.maxVi = 0;
                        this.maxHi = 0;
                        sampling = 0;
                        this.mcusize = 0;
                        i = 0;
                        while (i < this.components_in_frame) {
                            this.ID[i] = this.data[pos++] & 255;
                            sampling = (sampling << 8) + (this.data[pos] & 255);
                            this.H[i] = this.data[pos] >> 4 & 15;
                            if (this.H[i] > this.maxHi) {
                                this.maxHi = this.H[i];
                            }
                            this.V[i] = this.data[pos++] & 15;
                            if (this.V[i] > this.maxVi) {
                                this.maxVi = this.V[i];
                            }
                            this.mcusize += this.H[i] * this.V[i];
                            this.QT[i] = this.data[pos++] & 255;
                            ++i;
                        }
                        break;
                    }
                    case -62: {
                        len = this.readMarker(is);
                        System.err.println("Progressive, Huffman not supported in  (" + this.getLocationName() + ")");
                        this.canBeProcessed = false;
                        if (info_only) continue block28;
                        this.addMarker(len, markercode);
                        break;
                    }
                    case -55: {
                        len = this.readMarker(is);
                        System.err.println("Extended sequential, arithmetic not supported (" + this.getLocationName() + ")");
                        this.canBeProcessed = false;
                        if (info_only) continue block28;
                        this.addMarker(len, markercode);
                        break;
                    }
                    case -54: {
                        len = this.readMarker(is);
                        System.err.println("Progressive, arithmetic not supported (" + this.getLocationName() + ")");
                        this.canBeProcessed = false;
                        if (info_only) continue block28;
                        this.addMarker(len, markercode);
                        break;
                    }
                    case -61: 
                    case -59: 
                    case -58: 
                    case -57: 
                    case -56: 
                    case -53: 
                    case -51: 
                    case -50: 
                    case -49: {
                        len = this.readMarker(is);
                        System.err.println("One of the unsupported SOF markers:\nLossless, Huffman\nDifferential sequential, Huffman\nDifferential progressive, Huffman\nDifferential lossless, Huffman\nReserved for JPEG extensions\nLossless, arithmetic\nDifferential sequential, arithmetic\nDifferential progressive, arithmetic\nDifferential lossless, arithmetic (" + this.getLocationName() + ")");
                        this.canBeProcessed = false;
                        if (info_only) continue block28;
                        this.addMarker(len, markercode);
                        break;
                    }
                    case -38: {
                        len = this.readMarker(is);
                        if (this.canBeProcessed) {
                            this.components_in_scan = this.data[0] & 255;
                            pos = 1;
                            this.comp_ids = new int[this.components_in_scan];
                            this.dc_table = new int[this.components_in_scan];
                            this.ac_table = new int[this.components_in_scan];
                            i = 0;
                            while (true) {
                                if (i >= this.components_in_scan) {
                                    this._Ss = this.data[pos++] & 255;
                                    this._Se = this.data[pos++] & 255;
                                    this._Ah = this.data[pos] >> 4 & 15;
                                    this._Al = this.data[pos] & 15;
                                    this.readDCT(is);
                                    break block4;
                                }
                                this.comp_ids[i] = this.data[pos++] & 255;
                                this.dc_table[i] = this.data[pos] >> 4 & 15;
                                this.ac_table[i] = this.data[pos++] & 15;
                                ++i;
                            }
                        }
                        this.addMarker(len, markercode);
                        System.err.println("Read raw dct");
                        this.readRawDCT(is);
                        this.valid = true;
                        break block28;
                    }
                    case -2: {
                        len = this.readMarker(is);
                        if (this.out_comment.length() > 0) {
                            this.out_comment = this.out_comment + '\n';
                        }
                        try {
                            this.out_comment = this.out_comment + this.codec.decode(this.data, 0, len, StrippedJpeg.enc);
                        }
                        catch (UnsupportedEncodingException uee) {
                            this.out_comment = this.out_comment + this.codec.decode(this.data, 0, len);
                        }
                        catch (NullPointerException npe) {
                            this.out_comment = this.out_comment + this.codec.decode(this.data, 0, len);
                        }
                        continue block28;
                    }
                    case -39: {
                        this.valid = true;
                        break block28;
                    }
                    case -35: {
                        if (info_only) {
                            this.valid = true;
                            this.data = this.markerid;
                            break block28;
                        }
                        len = this.readMarker(is);
                        if (len != 2) {
                            throw new IOException("Wrong length of DRI marker " + len + " (" + this.getLocationName() + ")");
                        }
                        this.restart_interval = this.bs2i(0, 2);
                        System.err.println("Restart interval " + this.restart_interval);
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        len = this.readMarker(is);
                        if ((-16 & markercode) == -16) break block28;
                        System.err.println("Unsupported marker " + Integer.toHexString(markercode) + " length " + len + " (" + this.getLocationName() + ")");
                    }
                }
            }
            if (!this.valid) ** GOTO lbl338
            if (info_only) {
                if (this.imageinfo == null) {
                    this.imageinfo = new JPEG(is, this.data, this.readcounter, this.getName(), this.out_comment, this.frm_x, this.frm_y);
                }
            } else {
                System.err.println("0x" + Integer.toHexString(this.readcounter) + "(" + this.readcounter + ") byte(s) read in " + this.getName());
            }
            ** GOTO lbl338
        }
        catch (Exception e) {
            this.valid = false;
            e.printStackTrace();
            var15_6 = null;
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException ioe) {
                return;
            }
        }
        {
            catch (Throwable var14_27) {
                var15_7 = null;
                if (is == null) throw var14_27;
                ** try [egrp 3[TRYBLOCK] [8 : 3256->3265)] { 
lbl323:
                // 1 sources

                is.close();
                throw var14_27;
lbl326:
                // 1 sources

                catch (IOException ioe) {
                }
                throw var14_27;
            }
lbl330:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [8 : 3256->3265)] { 
lbl331:
            // 1 sources

            is.close();
            return;
lbl334:
            // 1 sources

            catch (IOException ioe) {
            }
            return;
lbl338:
            // 3 sources

            var15_5 = null;
            if (is == null) return;
            try {}
            catch (IOException ioe) {}
            return;
            is.close();
            return;
        }
    }

    void read() {
        this.read(true, false);
    }

    void readDCT(InputStream is) throws IOException {
        int[] last_dc = new int[this.components_in_scan];
        int[][] DCT = new int[2][64];
        this.restarts_to_go = this.restart_interval;
        if (this._Ss != 0 || this._Se != 63 || this._Ah != 0 || this._Al != 0) {
            System.err.println("Not sequential image, Ss=" + this._Ss + " Se=" + this._Se + " Ah=" + this._Ah + " Al=" + this._Al);
        }
        int widthMCU = (this.frm_x + 8 * this.maxHi - 1) / (8 * this.maxHi);
        int heightMCU = (this.frm_y + 8 * this.maxVi - 1) / (8 * this.maxVi);
        System.err.println("Size in MCU " + widthMCU + "x" + heightMCU);
        HuffDecoder decoder = new HuffDecoder(is);
        this.dct_coefs = new int[heightMCU][widthMCU][this.mcusize][2][];
        int iy = 0;
        while (iy < heightMCU) {
            int ix = 0;
            while (ix < widthMCU) {
                int mcuc = 0;
                if (this.restart_interval != 0 && this.restarts_to_go == 0) {
                    this.restarts_to_go = this.restart_interval;
                    int k2 = 0;
                    while (k2 < last_dc.length) {
                        last_dc[k2] = 0;
                        ++k2;
                    }
                    decoder.restart();
                }
                try {
                    int c2 = 0;
                    while (c2 < this.components_in_scan) {
                        int b2 = 0;
                        while (b2 < this.V[c2] * this.H[c2]) {
                            decoder.setTables(false, this.dc_table[c2]);
                            last_dc[c2] = decoder.extend(decoder.decode(1)) + last_dc[c2];
                            int curcoef = 0;
                            DCT[0][curcoef] = last_dc[c2];
                            DCT[1][curcoef++] = 0;
                            decoder.setTables(true, this.ac_table[c2]);
                            int ci2 = 1;
                            while (ci2 < 64) {
                                int ac = decoder.decode(1);
                                int v2 = ac >> 4;
                                if ((ac &= 0xF) != 0) {
                                    if ((ci2 += v2) > 63) {
                                        System.err.println("Invalid AC index " + ci2);
                                        ci2 = 63;
                                    }
                                    DCT[0][curcoef] = ac = decoder.extend(ac);
                                    DCT[1][curcoef++] = ci2;
                                } else {
                                    if (v2 != 15) break;
                                    ci2 += v2;
                                }
                                ++ci2;
                            }
                            this.dct_coefs[iy][ix][mcuc] = new int[2][curcoef];
                            System.arraycopy(DCT[0], 0, this.dct_coefs[iy][ix][mcuc][0], 0, curcoef);
                            System.arraycopy(DCT[1], 0, this.dct_coefs[iy][ix][mcuc][1], 0, curcoef);
                            ++mcuc;
                            ++b2;
                        }
                        ++c2;
                    }
                    --this.restarts_to_go;
                }
                catch (RestartException re) {
                    this.restarts_to_go = 0;
                    System.err.println("Restart exception ");
                }
                ++ix;
            }
            ++iy;
        }
    }

    /*
     * Unable to fully structure code
     */
    int readDHT(InputStream is) throws IOException {
        result = this.readMarker(is);
        base = 0;
        do {
            v0 = is_ac = (this.data[base] & 255) > 15;
            tbl_ix = is_ac ? (this.data[base] & 255) - 16 : this.data[base] & 255;
            tabnum = 0;
            if (!is_ac) {
                enc_matrix = new int[12][2];
                tabnum = this.dc_valoffset.length;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_valoffset, 0, wt2d, 0, tabnum);
                this.dc_valoffset = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_maxcode, 0, wt2d, 0, tabnum);
                this.dc_maxcode = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_huffval, 0, wt2d, 0, tabnum);
                this.dc_huffval = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_huffbits, 0, wt2d, 0, tabnum);
                this.dc_huffbits = wt2d;
                wt3d = new int[tabnum + 1][][];
                System.arraycopy(this.enc_dc_matrix, 0, wt3d, 0, tabnum);
                this.enc_dc_matrix = wt3d;
                wt1d = new int[tabnum + 1];
                System.arraycopy(this.dc_ix, 0, wt1d, 0, tabnum);
                this.dc_ix = wt1d;
                this.dc_ix[tabnum] = tbl_ix;
            } else {
                enc_matrix = new int[255][2];
                tabnum = this.ac_valoffset.length;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_valoffset, 0, wt2d, 0, tabnum);
                this.ac_valoffset = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_maxcode, 0, wt2d, 0, tabnum);
                this.ac_maxcode = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_huffval, 0, wt2d, 0, tabnum);
                this.ac_huffval = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_huffbits, 0, wt2d, 0, tabnum);
                this.ac_huffbits = wt2d;
                wt3d = new int[tabnum + 1][][];
                System.arraycopy(this.enc_ac_matrix, 0, wt3d, 0, tabnum);
                this.enc_ac_matrix = wt3d;
                wt1d = new int[tabnum + 1];
                System.arraycopy(this.ac_ix, 0, wt1d, 0, tabnum);
                this.ac_ix = wt1d;
                this.ac_ix[tabnum] = tbl_ix;
            }
            huffsize = new int[257];
            huffcode = new int[257];
            huffbits = new int[16];
            p = 0;
            l = 1;
            while (l <= 16) {
                huffbits[l - 1] = ii = this.data[base + l] & 255;
                while (ii-- > 0) {
                    huffsize[p++] = l;
                }
                ++l;
            }
            huffsize[p] = 0;
            numsymbols = p;
            code = 0;
            si = huffsize[0];
            p = 0;
            ** GOTO lbl81
            {
                huffcode[p++] = code++;
                do {
                    if (huffsize[p] == si) continue block3;
                    if (code >= 1 << si) {
                        throw new IOException("Bad huffman code table (" + this.getLocationName() + ")");
                    }
                    code <<= 1;
                    ++si;
lbl81:
                    // 2 sources

                } while (huffsize[p] != 0);
            }
            valoffset = new int[17];
            maxcode = new int[18];
            p = 0;
            l = 1;
            while (l <= 16) {
                if (this.data[base + l] != 0) {
                    valoffset[l] = p - huffcode[p];
                    maxcode[l] = huffcode[(p += this.data[base + l] & 255) - 1];
                } else {
                    maxcode[l] = -1;
                }
                ++l;
            }
            maxcode[17] = -1;
            huffval = new int[numsymbols];
            l = 0;
            while (l < numsymbols) {
                huffval[l] = this.data[base + l + 17] & 255;
                enc_matrix[huffval[l]][0] = huffcode[l];
                enc_matrix[huffval[l]][1] = huffsize[l];
                ++l;
            }
            if (!is_ac) {
                this.dc_valoffset[tabnum] = valoffset;
                this.dc_maxcode[tabnum] = maxcode;
                this.dc_huffval[tabnum] = huffval;
                this.enc_dc_matrix[tabnum] = enc_matrix;
                this.dc_huffbits[tabnum] = huffbits;
                continue;
            }
            this.ac_valoffset[tabnum] = valoffset;
            this.ac_maxcode[tabnum] = maxcode;
            this.ac_huffval[tabnum] = huffval;
            this.enc_ac_matrix[tabnum] = enc_matrix;
            this.ac_huffbits[tabnum] = huffbits;
        } while ((base += numsymbols + 17) < result);
        return result;
    }

    int readMarker(InputStream is) throws IOException, FileFormatException {
        if (is.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        this.readcounter += this.markerid.length;
        this.data = this.markerid;
        int len = this.bs2i(0, 2) - 2;
        this.data = new byte[len];
        BasicIo.read(is, this.data);
        this.readcounter += len;
        return len;
    }

    /*
     * WARNING - void declaration
     */
    void readRawDCT(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) > 0) {
            void var4_4;
            this.readcounter += var4_4;
            os.write(buffer, 0, (int)var4_4);
        }
        this.rawDct = os.toByteArray();
    }

    public boolean renameTo(File dest) {
        if (this.file == null) {
            return false;
        }
        if (this.file.renameTo(dest)) {
            this.file = dest;
            try {
                this.imageinfo.setName(this.file.getName());
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    int[][] rotate180Dct(int[][] dct) {
        int k2 = 0;
        while (k2 < dct[0].length) {
            if ((jpegnaturalorder[dct[1][k2]] & 9) == 1 || (jpegnaturalorder[dct[1][k2]] & 9) == 8) {
                dct[0][k2] = -dct[0][k2];
            }
            ++k2;
        }
        return dct;
    }

    int[][] rotate270DCT(int[][] dct) {
        int k2;
        int[] tmp_dct = new int[64];
        int i2 = 0;
        while (i2 < dct[0].length) {
            k2 = jpegnaturalorder[dct[1][i2]];
            k2 = ((k2 & 7) << 3) + (k2 >> 3);
            tmp_dct[StrippedJpeg.jpegzigzagorder[k2]] = (k2 & 8) == 8 ? -dct[0][i2] : dct[0][i2];
            ++i2;
        }
        k2 = 1;
        i2 = 1;
        while (i2 < tmp_dct.length && i2 < dct[0].length) {
            dct[1][i2] = i2;
            dct[0][i2] = tmp_dct[i2];
            ++i2;
        }
        return dct;
    }

    int[][] rotate90DCT(int[][] dct) {
        int k2;
        this.hm.clear();
        int i2 = 1;
        while (i2 < dct[0].length) {
            this.hm.put("" + dct[0][i2], dct);
            ++i2;
        }
        int[] tmp_dct = new int[64];
        i2 = 0;
        while (i2 < dct[0].length) {
            k2 = jpegnaturalorder[dct[1][i2]];
            k2 = ((k2 & 7) << 3) + (k2 >> 3);
            tmp_dct[StrippedJpeg.jpegzigzagorder[k2]] = (k2 & 1) == 1 ? -dct[0][i2] : dct[0][i2];
            ++i2;
        }
        k2 = 1;
        i2 = 1;
        while (i2 < tmp_dct.length) {
            if (tmp_dct[i2] != 0) {
                dct[1][k2] = i2;
                dct[0][k2] = tmp_dct[i2];
                ++k2;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < dct[0].length) {
            this.hm.remove("" + dct[0][i2]);
            ++i2;
        }
        if (this.hm.size() != 0) {
            System.err.println("Left " + this.hm.size() + " coeff(s)");
            Iterator it = this.hm.keySet().iterator();
            while (it.hasNext()) {
                System.err.println("Coeff " + it.next());
            }
        }
        return dct;
    }

    void save(OutputStream os, int op, Class custom_appx) throws IOException {
        this.writeMarkerSOI(os);
        this.writeNewMarker(os, custom_appx);
        this.writeMarkerAppXs(os);
        if (op == 8) {
            this.writeMarkerComment(os, this.in_comment, enc);
        } else {
            this.writeMarkerComment(os, this.out_comment, enc);
        }
        this.writeMarkerDQT(os);
        this.writeMarkerDHT(os);
        this.writeMarkerDRI(os);
        if (this.canBeProcessed) {
            this.writeMarkerSOF0(os);
            this.writeMarkerSOS(os);
            this.writeDCT(os, op);
            this.writeMarkerEOI(os);
        } else {
            this.writeUnprocessedMarkers(os);
            this.writeRawDCT(os);
        }
        os.flush();
        os.close();
        os = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMarkers(OutputStream os) throws IOException {
        try {
            this.read(true, true);
            if (os != null) {
                this.writeMarkerAppXs(os);
                os.close();
            }
            Object var3_2 = null;
            this.appxs = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.appxs = null;
            throw throwable;
        }
    }

    public void setArtist(String val) {
        this.artist = val;
    }

    public void setComment(String comment) {
        this.in_comment = comment;
        if (this.imageinfo != null) {
            this.imageinfo.setAttribute("Comments", this.in_comment);
        }
    }

    public static void setEncoding(String enc) {
        StrippedJpeg.enc = enc;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(OutputStream outStream, int op, boolean preserve_appxs, Class custom_appx) {
        this.read(false, preserve_appxs);
        try {
            try {
                switch (op) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        this.transposeImageParameters();
                        break;
                    }
                }
                this.save(outStream, op, custom_appx);
            }
            catch (IOException e2) {
                System.err.println(e2 + " in saving of " + this.getName());
                e2.printStackTrace();
                boolean bl2 = false;
                Object var8_6 = null;
                this.freeMemory();
                return bl2;
            }
            Object var8_5 = null;
            this.freeMemory();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.freeMemory();
            throw throwable;
        }
        return true;
    }

    public boolean transform(String destname, int op, boolean preserve_appxs, Class custom_appx) {
        try {
            return this.transform(new BufferedOutputStream(new FileOutputStream(destname), 4096), op, preserve_appxs, custom_appx);
        }
        catch (FileNotFoundException fne) {
            System.err.println(fne + " in saving of " + this.getName());
            return false;
        }
    }

    public boolean transform(String destname, int op, boolean preserve_appxs) {
        try {
            return this.transform(new BufferedOutputStream(new FileOutputStream(destname), 4096), op, preserve_appxs, null);
        }
        catch (FileNotFoundException fne) {
            System.err.println(fne + " in saving of " + this.getName());
            return false;
        }
    }

    public boolean transform(String destname, int op) {
        return this.transform(destname, op, true);
    }

    int[][] transposeDCT(int[][] dct) {
        int k2;
        int[] tmp_dct = new int[64];
        int i2 = 0;
        while (i2 < dct[0].length) {
            k2 = jpegnaturalorder[dct[1][i2]];
            k2 = ((k2 & 7) << 3) + (k2 >> 3);
            tmp_dct[StrippedJpeg.jpegzigzagorder[k2]] = dct[0][i2];
            ++i2;
        }
        k2 = 1;
        i2 = 1;
        while (i2 < tmp_dct.length && i2 < dct[0].length) {
            dct[1][i2] = i2;
            dct[0][i2] = tmp_dct[i2];
            ++i2;
        }
        return dct;
    }

    void transposeImageParameters() {
        int t2 = this.frm_x;
        this.frm_x = this.frm_y;
        this.frm_y = t2;
        int c2 = 0;
        while (c2 < this.components_in_scan) {
            t2 = this.V[c2];
            this.V[c2] = this.H[c2];
            this.H[c2] = t2;
            ++c2;
        }
    }

    void transposeQTable() {
        int k2 = 0;
        while (k2 < this.q_table.length) {
            int i2 = 0;
            while (i2 < 8) {
                int j2 = 0;
                while (j2 < i2) {
                    int t2 = this.q_table[k2][i2 * 8 + j2];
                    this.q_table[k2][i2 * 8 + j2] = this.q_table[k2][j2 * 8 + i2];
                    this.q_table[k2][j2 * 8 + i2] = t2;
                    ++j2;
                }
                ++i2;
            }
            ++k2;
        }
    }

    int[][] transverseDCT(int[][] dct) {
        int k2;
        int[] tmp_dct = new int[64];
        int i2 = 0;
        while (i2 < dct[0].length) {
            k2 = jpegnaturalorder[dct[1][i2]];
            boolean neg = (k2 & 1) != 0;
            k2 = ((k2 & 7) << 3) + (k2 >> 3);
            tmp_dct[StrippedJpeg.jpegzigzagorder[k2]] = (neg ^= (k2 & 1) != 0) ? -dct[0][i2] : dct[0][i2];
            ++i2;
        }
        k2 = 1;
        i2 = 1;
        while (i2 < tmp_dct.length && i2 < dct[0].length) {
            dct[1][i2] = i2;
            dct[0][i2] = tmp_dct[i2];
            ++i2;
        }
        return dct;
    }

    void writeDCT(OutputStream os, int op) throws IOException {
        if (!this.valid) {
            throw new IOException("Can't write DCT, because an error happened at reading (" + this.getLocationName() + ")");
        }
        int[] last_dc = new int[this.components_in_scan];
        HuffEncoder encoder = new HuffEncoder(os);
        int restarts_to_go = this.restart_interval;
        switch (op) {
            case 3: {
                int ix = 0;
                while (ix < this.dct_coefs[0].length) {
                    int iy = 0;
                    while (iy < this.dct_coefs.length) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k2 = 0;
                                while (k2 < last_dc.length) {
                                    last_dc[k2] = 0;
                                    ++k2;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c2 = 0;
                            while (c2 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c2], this.dc_table[c2]);
                                int mx = 0;
                                while (mx < this.V[c2]) {
                                    int my = 0;
                                    while (my < this.H[c2]) {
                                        last_dc[c2] = encoder.encode(this.transposeDCT(this.dct_coefs[iy][ix][off + my * this.V[c2] + mx]), last_dc[c2]);
                                        ++my;
                                    }
                                    ++mx;
                                }
                                off += this.V[c2] * this.H[c2];
                                ++c2;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        ++iy;
                    }
                    ++ix;
                }
                break;
            }
            case 5: {
                int ix = 0;
                while (ix < this.dct_coefs[0].length) {
                    int iy = this.dct_coefs.length - 1;
                    while (iy >= 0) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k3 = 0;
                                while (k3 < last_dc.length) {
                                    last_dc[k3] = 0;
                                    ++k3;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c3 = 0;
                            while (c3 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c3], this.dc_table[c3]);
                                int mx = 0;
                                while (mx < this.V[c3]) {
                                    int my = this.H[c3] - 1;
                                    while (my >= 0) {
                                        last_dc[c3] = encoder.encode(this.rotate90DCT(this.dct_coefs[iy][ix][off + my * this.V[c3] + mx]), last_dc[c3]);
                                        --my;
                                    }
                                    ++mx;
                                }
                                off += this.V[c3] * this.H[c3];
                                ++c3;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        catch (NullPointerException npe) {
                        }
                        --iy;
                    }
                    ++ix;
                }
                break;
            }
            case 7: {
                int ix = this.dct_coefs[0].length - 1;
                while (ix >= 0) {
                    int iy = 0;
                    while (iy < this.dct_coefs.length) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k4 = 0;
                                while (k4 < last_dc.length) {
                                    last_dc[k4] = 0;
                                    ++k4;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c4 = 0;
                            while (c4 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c4], this.dc_table[c4]);
                                int mx = this.V[c4] - 1;
                                while (mx >= 0) {
                                    int my = 0;
                                    while (my < this.H[c4]) {
                                        last_dc[c4] = encoder.encode(this.rotate270DCT(this.dct_coefs[iy][ix][off + my * this.V[c4] + mx]), last_dc[c4]);
                                        ++my;
                                    }
                                    --mx;
                                }
                                off += this.V[c4] * this.H[c4];
                                ++c4;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        ++iy;
                    }
                    --ix;
                }
                break;
            }
            case 4: {
                int ix = this.dct_coefs[0].length - 1;
                while (ix >= 0) {
                    int iy = this.dct_coefs.length - 1;
                    while (iy >= 0) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k5 = 0;
                                while (k5 < last_dc.length) {
                                    last_dc[k5] = 0;
                                    ++k5;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c5 = 0;
                            while (c5 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c5], this.dc_table[c5]);
                                int mx = this.V[c5] - 1;
                                while (mx >= 0) {
                                    int my = this.H[c5] - 1;
                                    while (my >= 0) {
                                        last_dc[c5] = encoder.encode(this.transverseDCT(this.dct_coefs[iy][ix][off + my * this.V[c5] + mx]), last_dc[c5]);
                                        --my;
                                    }
                                    --mx;
                                }
                                off += this.V[c5] * this.H[c5];
                                ++c5;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        --iy;
                    }
                    --ix;
                }
                break;
            }
            case 1: {
                int iy = 0;
                while (iy < this.dct_coefs.length) {
                    int ix = this.dct_coefs[iy].length - 1;
                    while (ix >= 0) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k6 = 0;
                                while (k6 < last_dc.length) {
                                    last_dc[k6] = 0;
                                    ++k6;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c6 = 0;
                            while (c6 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c6], this.dc_table[c6]);
                                int my = 0;
                                while (my < this.V[c6]) {
                                    int mx = this.H[c6] - 1;
                                    while (mx >= 0) {
                                        last_dc[c6] = encoder.encode(this.flipHDct(this.dct_coefs[iy][ix][off + my * this.H[c6] + mx]), last_dc[c6]);
                                        --mx;
                                    }
                                    ++my;
                                }
                                off += this.V[c6] * this.H[c6];
                                ++c6;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        --ix;
                    }
                    ++iy;
                }
                break;
            }
            case 2: {
                int iy = this.dct_coefs.length - 1;
                while (iy >= 0) {
                    int ix = 0;
                    while (ix < this.dct_coefs[iy].length) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k7 = 0;
                                while (k7 < last_dc.length) {
                                    last_dc[k7] = 0;
                                    ++k7;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c7 = 0;
                            while (c7 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c7], this.dc_table[c7]);
                                int my = this.V[c7] - 1;
                                while (my >= 0) {
                                    int mx = 0;
                                    while (mx < this.H[c7]) {
                                        last_dc[c7] = encoder.encode(this.flipVDct(this.dct_coefs[iy][ix][off + my * this.H[c7] + mx]), last_dc[c7]);
                                        ++mx;
                                    }
                                    --my;
                                }
                                off += this.V[c7] * this.H[c7];
                                ++c7;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        ++ix;
                    }
                    --iy;
                }
                break;
            }
            case 6: {
                int iy = this.dct_coefs.length - 1;
                while (iy >= 0) {
                    int ix = this.dct_coefs[iy].length - 1;
                    while (ix >= 0) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k8 = 0;
                                while (k8 < last_dc.length) {
                                    last_dc[k8] = 0;
                                    ++k8;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c8 = 0;
                            while (c8 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c8], this.dc_table[c8]);
                                int my = this.V[c8] - 1;
                                while (my >= 0) {
                                    int mx = this.H[c8] - 1;
                                    while (mx >= 0) {
                                        last_dc[c8] = encoder.encode(this.rotate180Dct(this.dct_coefs[iy][ix][off + my * this.H[c8] + mx]), last_dc[c8]);
                                        --mx;
                                    }
                                    --my;
                                }
                                off += this.V[c8] * this.H[c8];
                                ++c8;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        --ix;
                    }
                    --iy;
                }
                break;
            }
            default: {
                int iy = 0;
                while (iy < this.dct_coefs.length) {
                    int ix = 0;
                    while (ix < this.dct_coefs[iy].length) {
                        int off = 0;
                        if (this.restart_interval != 0 && restarts_to_go == 0) {
                            restarts_to_go = this.restart_interval;
                            if (this._Ss == 0) {
                                int k9 = 0;
                                while (k9 < last_dc.length) {
                                    last_dc[k9] = 0;
                                    ++k9;
                                }
                            }
                            encoder.restart();
                        }
                        try {
                            int c9 = 0;
                            while (c9 < this.components_in_scan) {
                                encoder.setTables(this.ac_table[c9], this.dc_table[c9]);
                                int b2 = 0;
                                while (b2 < this.V[c9] * this.H[c9]) {
                                    last_dc[c9] = encoder.encode(this.dct_coefs[iy][ix][off], last_dc[c9]);
                                    ++off;
                                    ++b2;
                                }
                                ++c9;
                            }
                            --restarts_to_go;
                        }
                        catch (RestartException re) {
                            restarts_to_go = 0;
                        }
                        ++ix;
                    }
                    ++iy;
                }
                break block8;
            }
        }
        encoder.flush();
    }

    void writeMarkerAppXs(OutputStream os) throws IOException {
        if (this.appxs == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.appxs.length) {
            os.write(this.appxs[i2]);
            ++i2;
        }
    }

    void writeMarkerComment(OutputStream os, String comment, String enc) throws IOException {
        os.write(-1);
        os.write(-2);
        int size = 2;
        try {
            this.data = this.codec.encode(comment, enc);
        }
        catch (UnsupportedEncodingException uee) {
            this.data = this.codec.encode(comment);
        }
        catch (NullPointerException npe) {
            this.data = this.codec.encode(comment);
        }
        os.write((size += this.data.length) >> 8);
        os.write(size & 0xFF);
        os.write(this.data);
    }

    void writeMarkerDHT(OutputStream os) throws IOException {
        int k2;
        os.write(-1);
        os.write(-60);
        int size = 2;
        int i2 = 0;
        while (i2 < this.ac_ix.length) {
            size += 17 + this.ac_huffval[i2].length;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.dc_ix.length) {
            size += 17 + this.dc_huffval[i3].length;
            ++i3;
        }
        os.write(size >> 8);
        os.write(size & 0xFF);
        int i4 = 0;
        while (i4 < this.dc_ix.length) {
            os.write(this.dc_ix[i4]);
            int k3 = 0;
            while (k3 < this.dc_huffbits[i4].length) {
                os.write(this.dc_huffbits[i4][k3]);
                ++k3;
            }
            k2 = 0;
            while (k2 < this.dc_huffval[i4].length) {
                os.write(this.dc_huffval[i4][k2]);
                ++k2;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < this.ac_ix.length) {
            os.write(this.ac_ix[i5] + 16);
            k2 = 0;
            while (k2 < this.ac_huffbits[i5].length) {
                os.write(this.ac_huffbits[i5][k2]);
                ++k2;
            }
            int k4 = 0;
            while (k4 < this.ac_huffval[i5].length) {
                os.write(this.ac_huffval[i5][k4]);
                ++k4;
            }
            ++i5;
        }
    }

    void writeMarkerDQT(OutputStream os) throws IOException {
        if (!this.valid) {
            throw new IOException("Can't write marker DQT, because an error happened at reading (" + this.getLocationName() + ")");
        }
        os.write(-1);
        os.write(-37);
        int size = 2 + this.q_ix.length * 65;
        os.write(size >> 8);
        os.write(size & 0xFF);
        int i2 = 0;
        while (i2 < this.q_ix.length) {
            os.write(this.q_ix[i2] + (this.q_prec[i2] == 8 ? 0 : 16));
            int k2 = 0;
            while (k2 < 64) {
                os.write(this.q_table[i2][k2]);
                ++k2;
            }
            ++i2;
        }
    }

    void writeMarkerDRI(OutputStream os) throws IOException {
        if (this.restart_interval != 0) {
            os.write(-1);
            os.write(-35);
            os.write(0);
            os.write(4);
            os.write(this.restart_interval >> 8);
            os.write(this.restart_interval & 0xFF);
        }
    }

    void writeMarkerEOI(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-39);
    }

    void writeMarkerSOF0(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-64);
        int size = 8 + this.components_in_frame * 3;
        os.write(size >> 8 & 0xFF);
        os.write(size & 0xFF);
        os.write(this.frm_precision);
        os.write(this.frm_y >> 8);
        os.write(this.frm_y & 0xFF);
        os.write(this.frm_x >> 8);
        os.write(this.frm_x & 0xFF);
        os.write(this.components_in_frame);
        int i2 = 0;
        while (i2 < this.components_in_frame) {
            os.write(this.ID[i2]);
            os.write((this.H[i2] << 4) + this.V[i2]);
            os.write(this.QT[i2]);
            ++i2;
        }
    }

    void writeMarkerSOI(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-40);
    }

    void writeMarkerSOS(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-38);
        int size = 3 + this.components_in_scan * 2 + 1 + 1 + 1;
        os.write(size >> 8);
        os.write(size & 0xFF);
        os.write(this.components_in_scan);
        int i2 = 0;
        while (i2 < this.components_in_scan) {
            os.write(this.comp_ids[i2]);
            os.write((this.dc_table[i2] << 4) + this.ac_table[i2]);
            ++i2;
        }
        os.write(this._Ss);
        os.write(this._Se);
        os.write((this._Ah << 4) + this._Al);
    }

    void writeNewMarker(OutputStream os, Class custom_appx) throws IOException {
        if (custom_appx == null) {
            return;
        }
        if (custom_appx == (class$photoorganizer$formats$JFXX == null ? (class$photoorganizer$formats$JFXX = StrippedJpeg.class$("photoorganizer.formats.JFXX")) : class$photoorganizer$formats$JFXX)) {
            os.write(JFXX.getMarkerData());
        } else if (custom_appx == (class$photoorganizer$formats$Exif == null ? (class$photoorganizer$formats$Exif = StrippedJpeg.class$("photoorganizer.formats.Exif")) : class$photoorganizer$formats$Exif)) {
            os.write(Exif.getMarkerData());
        } else if (custom_appx == (class$photoorganizer$formats$AbstractImageInfo == null ? (class$photoorganizer$formats$AbstractImageInfo = StrippedJpeg.class$("photoorganizer.formats.AbstractImageInfo")) : class$photoorganizer$formats$AbstractImageInfo)) {
            File ff;
            String name = this.getName();
            int dp2 = name.lastIndexOf(46);
            name = dp2 > 0 ? name.substring(0, dp2 + 1) : name + '.';
            if (this.file != null && (ff = new File(this.file.getParent(), name + "Exif")).exists()) {
                try {
                    byte[] buf = new byte[(int)ff.length()];
                    FileInputStream fis = new FileInputStream(ff);
                    BasicIo.read(fis, buf);
                    os.write(buf);
                    fis.close();
                }
                catch (IOException e2) {
                    System.err.println("Exception in reading exif marker " + e2);
                }
            }
        }
    }

    void writeRawDCT(OutputStream os) throws IOException {
        if (this.rawDct != null) {
            os.write(this.rawDct);
        }
    }

    void writeUnprocessedMarkers(OutputStream os) throws IOException {
        if (this.tables != null && this.markers != null) {
            int i2 = 0;
            while (i2 < this.markers.length) {
                byte[] marker = (byte[])this.tables.get("" + this.markers[i2]);
                if (marker != null) {
                    os.write(marker);
                }
                ++i2;
            }
        }
    }

    class RestartException
    extends Exception {
        int scan;

        RestartException(int scan) {
            this.scan = scan;
        }
    }

    class HuffEncoder {
        private int[][] ac_ecodetable;
        private int bufferputbits;
        private int bufferputbuffer;
        private int[][] dc_ecodetable;
        int next_restart_num;
        private OutputStream outputstream;

        public HuffEncoder(OutputStream os) {
            this.outputstream = os;
        }

        int encode(int[][] coef, int last_dc) throws IOException, RestartException {
            if (coef == null || coef[0] == null) {
                throw new RestartException(0);
            }
            int temp2 = coef[0][0] - last_dc;
            int temp = temp2;
            if (temp < 0) {
                temp = -temp;
                --temp2;
            }
            int nbits = 0;
            while (temp != 0) {
                ++nbits;
                temp >>= 1;
            }
            this.writeCode(this.dc_ecodetable[nbits][0], this.dc_ecodetable[nbits][1]);
            if (nbits != 0) {
                this.writeCode(temp2, nbits);
            }
            int k2 = 1;
            while (k2 < coef[0].length) {
                int r2 = coef[1][k2] - coef[1][k2 - 1] - 1;
                while (r2 > 15) {
                    this.writeCode(this.ac_ecodetable[240][0], this.ac_ecodetable[240][1]);
                    r2 -= 16;
                }
                temp2 = coef[0][k2];
                temp = temp2;
                if (temp < 0) {
                    temp = -temp;
                    --temp2;
                }
                nbits = 1;
                while ((temp >>= 1) != 0) {
                    ++nbits;
                }
                int i2 = (r2 << 4) + nbits;
                this.writeCode(this.ac_ecodetable[i2][0], this.ac_ecodetable[i2][1]);
                this.writeCode(temp2, nbits);
                ++k2;
            }
            if (63 - coef[1][coef[1].length - 1] > 0) {
                this.writeCode(this.ac_ecodetable[0][0], this.ac_ecodetable[0][1]);
            }
            return coef[0][0];
        }

        void flush() throws IOException {
            int c2;
            int putbuffer = this.bufferputbuffer;
            int putbits = this.bufferputbits;
            while (putbits >= 8) {
                c2 = putbuffer >> 16 & 0xFF;
                this.outputstream.write(c2);
                if (c2 == 255) {
                    this.outputstream.write(0);
                }
                putbuffer <<= 8;
                putbits -= 8;
            }
            if (putbits > 0) {
                c2 = putbuffer >> 16 | 255 >> putbits;
                this.outputstream.write(c2);
            }
            this.bufferputbuffer = putbuffer;
            this.bufferputbits = putbits;
        }

        void restart() throws IOException {
            this.flush();
            this.outputstream.write(-1);
            this.outputstream.write(208 + this.next_restart_num);
            this.next_restart_num = this.next_restart_num + 1 & 7;
            this.bufferputbuffer = 0;
            this.bufferputbits = 0;
        }

        void setTables(int iac, int idc) {
            boolean dt_found = false;
            boolean at_found = false;
            int i2 = 0;
            while (i2 < StrippedJpeg.this.ac_ix.length) {
                if (StrippedJpeg.this.ac_ix[i2] == iac) {
                    this.ac_ecodetable = StrippedJpeg.this.enc_ac_matrix[i2];
                    at_found = true;
                    break;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < StrippedJpeg.this.dc_ix.length) {
                if (StrippedJpeg.this.dc_ix[i3] == idc) {
                    this.dc_ecodetable = StrippedJpeg.this.enc_dc_matrix[i3];
                    dt_found = true;
                    break;
                }
                ++i3;
            }
            if (!at_found || !dt_found) {
                System.err.println("One of tables not found for a " + iac + " " + at_found + " d " + idc + " " + dt_found);
            }
        }

        void writeCode(int putbuffer, int size) throws IOException {
            int putbits = this.bufferputbits;
            putbuffer &= (1 << size) - 1;
            putbuffer <<= 24 - (putbits += size);
            putbuffer |= this.bufferputbuffer;
            while (putbits >= 8) {
                int c2 = putbuffer >> 16 & 0xFF;
                this.outputstream.write(c2);
                if (c2 == 255) {
                    this.outputstream.write(0);
                }
                putbuffer <<= 8;
                putbits -= 8;
            }
            this.bufferputbuffer = putbuffer;
            this.bufferputbits = putbits;
        }
    }

    class HuffDecoder {
        int bit_buff;
        int bit_buff_len;
        int[] cur_huffval;
        int[] cur_maxcode;
        int[] cur_valoffset;
        private InputStream is;
        int marker;
        int next_restart_num;

        HuffDecoder(InputStream is) {
            this.is = is;
        }

        void checkBitBuffer(int len) throws IOException, RestartException {
            if (this.bit_buff_len < len) {
                if (len > 16) {
                    throw new IOException("An attempt to read more than 16 bit (inbuff=" + this.bit_buff_len + ", len=" + len + ") (" + StrippedJpeg.this.getLocationName() + ")");
                }
                do {
                    this.bit_buff <<= 8;
                    this.bit_buff |= this.read();
                    this.bit_buff_len += 8;
                } while (this.bit_buff_len < len);
            }
        }

        int decode(int min_bits) throws IOException, RestartException {
            int code;
            int l2 = min_bits;
            for (code = this.getBits(l2); code > this.cur_maxcode[l2]; code |= this.getBits(1)) {
                if (code < 0) {
                    System.err.println("Negative code 0x" + Integer.toHexString(code) + " max 0x" + Integer.toHexString(this.cur_maxcode[l2]));
                }
                code <<= 1;
                if (++l2 <= 16) continue;
                throw new IOException("Corrupted JPEG data: bad Huffman code, 0x" + Integer.toHexString(code) + " max 0x" + Integer.toHexString(this.cur_maxcode[l2]) + " at 0x" + Integer.toHexString(StrippedJpeg.this.readcounter) + " (" + StrippedJpeg.this.getLocationName() + ")");
            }
            return this.cur_huffval[code + this.cur_valoffset[l2]];
        }

        int extend(int n_bits) throws IOException, RestartException {
            if (n_bits == 0) {
                return 0;
            }
            int result = this.getBits(n_bits);
            return result < 1 << n_bits - 1 ? result + ((-1 << n_bits) + 1) : result;
        }

        int getBits(int len) throws IOException, RestartException {
            this.checkBitBuffer(len);
            this.bit_buff_len -= len;
            return this.bit_buff >> this.bit_buff_len & 65535 >> 16 - len;
        }

        int read() throws IOException, RestartException {
            int result = this.is.read();
            StrippedJpeg.this.readcounter++;
            if (result == -1) {
                throw new IOException("End of file reached at " + StrippedJpeg.this.readcounter + " (" + StrippedJpeg.this.getLocationName() + ")");
            }
            if (result == 255) {
                do {
                    result = this.is.read();
                    StrippedJpeg.this.readcounter++;
                } while (result == 255);
                if (result == 0) {
                    result = 255;
                } else {
                    this.marker = result;
                    System.err.println("Marker found 0x" + Integer.toHexString(this.marker) + " offset 0x" + Long.toHexString(StrippedJpeg.this.readcounter));
                    if (this.marker != 208 + this.next_restart_num) {
                        throw new IOException("Restart markers are messed up at 0x" + Integer.toHexString(StrippedJpeg.this.readcounter) + " (" + StrippedJpeg.this.getLocationName() + ")");
                    }
                    this.next_restart_num = this.next_restart_num + 1 & 7;
                    if (StrippedJpeg.this.restarts_to_go == StrippedJpeg.this.restart_interval) {
                        result = this.is.read();
                        StrippedJpeg.this.readcounter++;
                    } else {
                        throw new RestartException(this.next_restart_num);
                    }
                }
            }
            return result;
        }

        void restart() {
            this.bit_buff_len = 0;
            this.bit_buff = 0;
            System.err.println("Restart at offset 0x" + Long.toHexString(StrippedJpeg.this.readcounter));
        }

        void setTables(boolean ac, int index) {
            if (ac) {
                int i2 = 0;
                while (i2 < StrippedJpeg.this.ac_ix.length) {
                    if (StrippedJpeg.this.ac_ix[i2] == index) {
                        this.cur_maxcode = StrippedJpeg.this.ac_maxcode[i2];
                        this.cur_huffval = StrippedJpeg.this.ac_huffval[i2];
                        this.cur_valoffset = StrippedJpeg.this.ac_valoffset[i2];
                        break;
                    }
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < StrippedJpeg.this.dc_ix.length) {
                    if (StrippedJpeg.this.dc_ix[i3] == index) {
                        this.cur_maxcode = StrippedJpeg.this.dc_maxcode[i3];
                        this.cur_huffval = StrippedJpeg.this.dc_huffval[i3];
                        this.cur_valoffset = StrippedJpeg.this.dc_valoffset[i3];
                        break;
                    }
                    ++i3;
                }
            }
        }
    }
}

