/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.Entry;
import photoorganizer.formats.Exif;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.IFD;
import photoorganizer.formats.Rational;
import photoorganizer.formats.StrippedJpeg;

public class TiffExif
extends Exif {
    static final int FAKE_JPEG_OFFSET = 7;

    public TiffExif(InputStream is, byte[] data, int offset, String name, boolean intel) throws FileFormatException {
        this.intel = intel;
        this.motorola = !intel;
        this.is = is;
        this.data = data;
        this.offset = offset;
        this.name = name;
        this.readInfo();
    }

    protected int firstIFD() {
        return this.s2n(2, 4) - this.offset + 7;
    }

    protected int getExifSize(int e_o, int entries) {
        int data_off = 0;
        int count = 0;
        int i2 = 0;
        while (i2 < entries) {
            int entry = 12 * i2 + e_o;
            if (Exif.TYPELENGTH[this.s2n(entry + 2, 2) - 1] * this.s2n(entry + 4, 4) > 4 && data_off < this.s2n(entry + 8, 4)) {
                data_off = this.s2n(entry + 8, 4);
                count = Exif.TYPELENGTH[this.s2n(entry + 2, 2) - 1] * this.s2n(entry + 4, 4);
            }
            ++i2;
        }
        return data_off + count;
    }

    protected int nextIFD(int ifd) {
        return this.s2n(this.data.length - 4, 4) - this.offset + 7;
    }

    public void readInfo() {
        Entry e2;
        this.ifds = new IFD[2];
        this.processAllIFDs();
        if (this.getTagValue(new Integer(514), 0, false) == null && (e2 = this.getTagValue(273, true)) != null) {
            this.setTagValue(514, 0, new Entry(4, new Object[]{new Integer((Integer)e2.getValue(0) - this.getThumbnailOffset() + 12)}), false);
        }
        if (this.getTagValue(new Integer(513), 0, false) == null) {
            this.setTagValue(513, 0, new Entry(4, new Object[]{new Integer(this.offset - 6)}), false);
        }
        this.offset = 0;
    }

    protected void storeIFD(int ifdoffset, IFD ifd_p) {
        int entries = 0;
        try {
            BasicIo.skip(this.is, ifdoffset - 7);
            this.offset += ifdoffset - 7;
            this.data = new byte[2];
            this.offset += this.is.read(this.data);
            entries = this.s2n(0, 2);
            byte[] ifd = new byte[12 * entries + 4];
            BasicIo.read(this.is, ifd);
            this.offset += ifd.length;
            this.data = ifd;
            byte[] value_data = new byte[this.getExifSize(0, entries) - this.offset];
            BasicIo.read(this.is, value_data);
            this.offset += value_data.length;
            this.data = ifd;
            int i2 = 0;
            while (i2 < entries) {
                int entry = 12 * i2;
                int tag = this.s2n(entry, 2);
                int type = this.s2n(entry + 2, 2);
                if (type >= 1 && type <= 10) {
                    int typelen = Exif.TYPELENGTH[type - 1];
                    int count = this.s2n(entry + 4, 4);
                    int data_off = entry + 8;
                    if (count * typelen > 4) {
                        data_off = this.s2n(data_off, 4) - (this.offset - value_data.length);
                        this.data = value_data;
                    }
                    if (type == 2) {
                        try {
                            ifd_p.addEntry(tag, new Entry(type, new String(this.data, data_off, count - 1, "Default")));
                        }
                        catch (UnsupportedEncodingException e2) {
                        }
                    } else {
                        Object[] values = new Object[count];
                        boolean signed = true;
                        int j2 = 0;
                        while (j2 < count) {
                            values[j2] = type % 5 != 0 ? new Integer(this.s2n(data_off, typelen, signed)) : new Rational(this.s2n(data_off, 4, signed), this.s2n(data_off + 4, 4, signed));
                            data_off += typelen;
                            if (tag == 34665 && j2 == 0 && (Integer)values[0] > 0) {
                                IFD iifd = new IFD(tag, type);
                                this.storeIFD((Integer)values[0] - this.offset + 7, iifd);
                                ifd_p.addIFD(iifd);
                            } else {
                                ifd_p.addEntry(tag, new Entry(type, values));
                            }
                            ++j2;
                        }
                    }
                    this.data = ifd;
                }
                ++i2;
            }
        }
        catch (IOException e3) {
        }
    }

    public void writeInfo(StrippedJpeg im, OutputStream out, int op, String encoding) throws IOException {
        throw new RuntimeException("writeInfo not supported for TIFF EXIF");
    }
}

