/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.datadosen.util.Colors;

public class JColorSelector
extends JPanel {
    protected Color color = Color.black;
    Vector listeners;
    protected String title;

    public JColorSelector(String title) {
        this.title = title;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public JColorSelector() {
        this("");
    }

    public synchronized void addActionListener(ActionListener l2) {
        Vector v2;
        Vector vector = v2 = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.listeners = v2;
        }
    }

    protected void fireActionOccured(ActionEvent e2) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((ActionListener)this.listeners.elementAt(i2)).actionPerformed(e2);
                ++i2;
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String getHTMLColor() {
        return "#" + Integer.toHexString(this.color.getRGB()).substring(2);
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(18, 18));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (!JColorSelector.this.isEnabled()) {
                    return;
                }
                Color newColor = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(JColorSelector.this), JColorSelector.this.title, JColorSelector.this.color);
                if (newColor != null) {
                    JColorSelector.this.setColor(newColor);
                }
            }
        });
        this.setColor(this.color);
    }

    public synchronized void removeActionListener(ActionListener l2) {
        if (this.listeners != null && this.listeners.contains(l2)) {
            Vector v2 = (Vector)this.listeners.clone();
            v2.removeElement(l2);
            this.listeners = v2;
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.setBackground(color);
        this.fireActionOccured(new ActionEvent(this, 0, this.getHTMLColor()));
    }

    public void setColor(String htmlColor) {
        this.setColor(Colors.getHTMLColor(htmlColor));
    }

    public String toString() {
        return this.getHTMLColor();
    }
}

