/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import se.datadosen.component.FileListMenuListener;

public class JFileListMenu
extends JMenu
implements ActionListener {
    private final String CLEAR_LIST = "<< Clear list >>";
    private transient Vector fileListMenuListeners;
    private String label;
    private int loadedHashCode;
    private int maxFiles = 8;
    private Vector names;
    private File storeFile;

    public JFileListMenu(File storeFile) {
        this.storeFile = storeFile;
        this.init();
    }

    public JFileListMenu() {
        this.storeFile = new File(System.getProperty("java.home"), "RecentFileList.cfg");
        this.init();
    }

    public void actionPerformed(ActionEvent e2) {
        this.fireFileSelected(e2);
    }

    public synchronized void addFileListMenuListener(FileListMenuListener l2) {
        Vector v2;
        Vector vector = v2 = this.fileListMenuListeners == null ? new Vector(2) : (Vector)this.fileListMenuListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.fileListMenuListeners = v2;
        }
    }

    public void addFileName(String fileName) {
        this.names.remove(fileName);
        this.names.add(0, fileName);
        if (this.names.size() > this.maxFiles) {
            this.names.removeElementAt(this.maxFiles);
        }
        this.rebuildMenu();
    }

    protected void fireFileSelected(ActionEvent e2) {
        if (this.fileListMenuListeners != null) {
            Vector listeners = this.fileListMenuListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((FileListMenuListener)listeners.elementAt(i2)).fileSelected(e2);
                ++i2;
            }
        }
    }

    private void init() {
        this.names = new Vector();
        Properties props = new Properties();
        try {
            String name;
            FileInputStream fis = new FileInputStream(this.storeFile);
            props.load(fis);
            fis.close();
            int i2 = 1;
            while ((name = props.getProperty("File" + i2)) != null) {
                this.names.add(name);
                ++i2;
            }
            this.loadedHashCode = this.names.hashCode();
            this.rebuildMenu();
        }
        catch (IOException e2) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JFileListMenu.this.save();
            }
        });
    }

    protected void rebuildMenu() {
        JMenuItem item;
        this.removeAll();
        int i2 = 0;
        while (i2 < this.names.size()) {
            item = new JMenuItem((String)this.names.get(i2));
            item.addActionListener(this);
            this.add(item);
            ++i2;
        }
        if (this.names.size() > 0) {
            item = new JMenuItem("<< Clear list >>");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JFileListMenu.this.names.removeAllElements();
                    JFileListMenu.this.rebuildMenu();
                }
            });
            this.add(item);
        }
    }

    public synchronized void removeFileListMenuListener(FileListMenuListener l2) {
        if (this.fileListMenuListeners != null && this.fileListMenuListeners.contains(l2)) {
            Vector v2 = (Vector)this.fileListMenuListeners.clone();
            v2.removeElement(l2);
            this.fileListMenuListeners = v2;
        }
    }

    public boolean save() {
        if (this.names.hashCode() == this.loadedHashCode) {
            return false;
        }
        Properties props = new Properties();
        try {
            FileOutputStream fos = new FileOutputStream(this.storeFile);
            int i2 = 0;
            while (i2 < this.names.size()) {
                props.setProperty("File" + (i2 + 1), (String)this.names.get(i2));
                ++i2;
            }
            props.store(fos, "Recent file list");
            fos.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return true;
    }
}

