/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;

public class JLinkLabel
extends JLabel {
    private String URL;
    private IOException exception;

    public JLinkLabel(String url, String text) {
        this(text);
        this.setURL(url);
    }

    public JLinkLabel(String text) {
        super(text);
        this.setForeground(Color.blue);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                try {
                    BrowserLauncher.openURL(JLinkLabel.this.URL);
                }
                catch (IOException ex) {
                    JLinkLabel.this.exception = ex;
                }
            }

            public void mouseEntered(MouseEvent e2) {
                JLinkLabel.this.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent e2) {
                JLinkLabel.this.setCursor(new Cursor(0));
            }
        });
    }

    public JLinkLabel() {
        this("");
    }

    public void clearIOException() {
        this.exception = null;
    }

    public Exception getIOException() {
        return this.exception;
    }

    public String getURL() {
        return this.URL;
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        Rectangle r2 = g2.getClipBounds();
        g2.drawLine(0, r2.height - this.getFontMetrics(this.getFont()).getDescent(), this.getFontMetrics(this.getFont()).stringWidth(this.getText()), r2.height - this.getFontMetrics(this.getFont()).getDescent());
    }

    public void setURL(String newURL) {
        this.URL = newURL;
    }
}

