/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import se.datadosen.jalbum.Msg;

public class JSmartTextComponentSupport
implements UndoableEditListener {
    public static final int ALL_SELECTED = 2;
    public static final int NO_SELECTION = 0;
    public static final int SOME_SELECTED = 1;
    public static final int UNDO_LIMIT = 1500;
    static /* synthetic */ Class class$se$datadosen$component$JSmartTextComponentSupport;
    JTextComponent comp;
    static ImageIcon copyIcon;
    static ImageIcon cutIcon;
    static ImageIcon pasteIcon;
    static ImageIcon redoIcon;
    static ImageIcon removeSelectionIcon;
    static ImageIcon selectAllIcon;
    static int shortcutMask;
    static ImageIcon undoIcon;
    private UndoManager undoManager;

    static {
        undoIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/undo.png"));
        redoIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/redo.png"));
        cutIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/cut.png"));
        copyIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/copy.png"));
        pasteIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/paste.png"));
        removeSelectionIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/selection_delete.png"));
        selectAllIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JSmartTextComponentSupport.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/selection.png"));
        shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public JSmartTextComponentSupport(JTextComponent comp) {
        this.comp = comp;
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1500);
        comp.getDocument().addUndoableEditListener(this);
        comp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    JSmartTextComponentSupport.this.doPopup(e2);
                }
            }

            public void mouseReleased(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    JSmartTextComponentSupport.this.doPopup(e2);
                }
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 90 && (e2.getModifiers() & shortcutMask) != 0) {
                    try {
                        JSmartTextComponentSupport.this.undoManager.undo();
                    }
                    catch (CannotUndoException cue) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (e2.getKeyCode() == 89 && (e2.getModifiers() & shortcutMask) != 0) {
                    try {
                        JSmartTextComponentSupport.this.undoManager.redo();
                    }
                    catch (CannotRedoException cue) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private String cutSelection() {
        int start = this.comp.getSelectionStart();
        int end = this.comp.getSelectionEnd();
        String selection = this.comp.getSelectedText();
        StringBuffer buf = new StringBuffer(this.comp.getText());
        buf.delete(start, end);
        this.comp.setText(buf.toString());
        this.comp.setCaretPosition(start);
        return selection;
    }

    void doPopup(MouseEvent e2) {
        AbstractAction undoAction = new AbstractAction(Msg.getString("edit.undo"), undoIcon){

            public void actionPerformed(ActionEvent e2) {
                JSmartTextComponentSupport.this.undoManager.undo();
            }
        };
        AbstractAction redoAction = new AbstractAction(Msg.getString("edit.redo"), redoIcon){

            public void actionPerformed(ActionEvent e2) {
                JSmartTextComponentSupport.this.undoManager.redo();
            }
        };
        AbstractAction cutAction = new AbstractAction(Msg.getString("edit.cut"), cutIcon){

            public void actionPerformed(ActionEvent e2) {
                String selection = JSmartTextComponentSupport.this.cutSelection();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(selection), null);
            }
        };
        AbstractAction copyAction = new AbstractAction(Msg.getString("edit.copy"), copyIcon){

            public void actionPerformed(ActionEvent e2) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(JSmartTextComponentSupport.this.comp.getSelectedText()), null);
            }
        };
        AbstractAction pasteAction = new AbstractAction(Msg.getString("edit.paste"), pasteIcon){

            public void actionPerformed(ActionEvent e2) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t2 = clipboard.getContents(JSmartTextComponentSupport.this.comp);
                try {
                    String content = (String)t2.getTransferData(DataFlavor.stringFlavor);
                    int start = JSmartTextComponentSupport.this.comp.getSelectionStart();
                    int end = JSmartTextComponentSupport.this.comp.getSelectionEnd();
                    StringBuffer buf = new StringBuffer(JSmartTextComponentSupport.this.comp.getText());
                    buf.delete(start, end);
                    buf.insert(start, content);
                    JSmartTextComponentSupport.this.comp.setText(buf.toString());
                    JSmartTextComponentSupport.this.comp.setCaretPosition(start + content.length());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (UnsupportedFlavorException ex) {
                    ex.printStackTrace();
                }
            }
        };
        AbstractAction deleteAction = new AbstractAction(Msg.getString("edit.delete"), removeSelectionIcon){

            public void actionPerformed(ActionEvent e2) {
                JSmartTextComponentSupport.this.cutSelection();
            }
        };
        AbstractAction selectAllAction = new AbstractAction(Msg.getString("edit.selectAll"), selectAllIcon){

            public void actionPerformed(ActionEvent e2) {
                JSmartTextComponentSupport.this.comp.requestFocus();
                JSmartTextComponentSupport.this.comp.selectAll();
            }
        };
        JPopupMenu popup = new JPopupMenu();
        popup.add(undoAction);
        popup.add(redoAction);
        popup.addSeparator();
        popup.add(cutAction);
        popup.add(copyAction);
        popup.add(pasteAction);
        popup.add(deleteAction);
        popup.addSeparator();
        popup.add(selectAllAction);
        popup.show((Component)e2.getSource(), e2.getX(), e2.getY());
        undoAction.setEnabled(this.undoManager.canUndo());
        redoAction.setEnabled(this.undoManager.canRedo());
        int status = this.getSelectionStatus();
        cutAction.setEnabled(status != 0);
        copyAction.setEnabled(status != 0);
        pasteAction.setEnabled(this.isStringInClipboard());
        deleteAction.setEnabled(status != 0);
        selectAllAction.setEnabled(status != 2);
        if (!this.comp.isEditable()) {
            cutAction.setEnabled(false);
            pasteAction.setEnabled(false);
            deleteAction.setEnabled(false);
        }
        popup.getComponent();
    }

    private int getSelectionStatus() {
        int start = this.comp.getSelectionStart();
        int end = this.comp.getSelectionEnd();
        int length = this.comp.getText().length();
        if (end - start == 0) {
            return 0;
        }
        if (end - start == length) {
            return 2;
        }
        if (end > start) {
            return 1;
        }
        return 0;
    }

    private boolean isStringInClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t2 = clipboard.getContents(this.comp);
        return t2.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public void undoableEditHappened(UndoableEditEvent e2) {
        this.undoManager.addEdit(e2.getEdit());
    }
}

