/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JWizardStep;
import se.datadosen.component.NorthEtchedBorder;

public class JWizard
extends JFrame {
    protected JButton backButton;
    Border border1;
    Border border2;
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    protected JPanel buttonPanel;
    protected JButton cancelButton;
    CardLayout cardLayout;
    JPanel content;
    protected JButton finishButton;
    FlowLayout flowLayout1;
    JLabel imageLabel;
    protected JButton nextButton;
    protected JButton okButton;
    protected Window parent;
    protected int stepIndex = 0;
    JBackgroundPanel stepPanel;
    protected LinkedList steps = new LinkedList();
    protected String title = "";

    public JWizard(String title) {
        this.content = new JPanel();
        this.borderLayout1 = new BorderLayout();
        this.borderLayout2 = new BorderLayout();
        this.imageLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.finishButton = new JButton();
        this.nextButton = new JButton();
        this.backButton = new JButton();
        this.stepPanel = new JBackgroundPanel();
        this.cardLayout = new CardLayout();
        this.title = title;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JWizard(String title, ImageIcon image) {
        this.content = new JPanel();
        this.borderLayout1 = new BorderLayout();
        this.borderLayout2 = new BorderLayout();
        this.imageLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.finishButton = new JButton();
        this.nextButton = new JButton();
        this.backButton = new JButton();
        this.stepPanel = new JBackgroundPanel();
        this.cardLayout = new CardLayout();
        this.title = title;
        this.imageLabel.setIcon(image);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JWizard() {
        this("");
    }

    public void addStep(JWizardStep step) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JLabel headerLabel = new JLabel(step.getHeader());
        Font existingFont = headerLabel.getFont();
        Font boldFont = existingFont.deriveFont(1);
        int problemIndex = boldFont.canDisplayUpTo(step.getHeader());
        if (problemIndex == -1 || problemIndex == step.getHeader().length()) {
            headerLabel.setFont(boldFont);
        }
        panel.add((Component)headerLabel, "North");
        panel.add((Component)step, "Center");
        this.stepPanel.add("", panel);
        this.steps.add(step);
        this.update();
    }

    public void allowFinish(boolean allow) {
        this.finishButton.setEnabled(allow);
        this.okButton.setEnabled(allow);
    }

    public void backButton_actionPerformed(ActionEvent e2) {
        this.cardLayout.previous(this.stepPanel);
        --this.stepIndex;
        this.update();
        this.currentStep().onShow();
    }

    public void cancelButton_actionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    public JWizardStep currentStep() {
        return (JWizardStep)this.steps.get(this.stepIndex);
    }

    public void finishButton_actionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    public Container getParent() {
        return this.parent;
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(12, 12, 0, 12);
        this.border2 = BorderFactory.createEmptyBorder(0, 0, 10, 10);
        this.getContentPane().setLayout(this.borderLayout1);
        this.content.setLayout(this.borderLayout2);
        this.content.setOpaque(false);
        this.content.setBorder(this.border1);
        this.stepPanel.setLayout(this.cardLayout);
        this.stepPanel.setOpaque(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JWizard.this.backButton_actionPerformed(e2);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JWizard.this.nextButton_actionPerformed(e2);
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JWizard.this.finishButton_actionPerformed(e2);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JWizard.this.finishButton_actionPerformed(e2);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JWizard.this.cancelButton_actionPerformed(e2);
            }
        });
        this.backButton.setEnabled(false);
        this.imageLabel.setBorder(this.border2);
        this.getContentPane().add((Component)this.content, "Center");
        this.buttonPanel.setLayout(this.flowLayout1);
        this.buttonPanel.setOpaque(false);
        this.flowLayout1.setAlignment(2);
        this.cancelButton.setText("Cancel");
        this.okButton.setText("Ok");
        this.finishButton.setText("Finish");
        this.nextButton.setText("Next");
        this.backButton.setText("Back");
        this.buttonPanel.setBorder(new NorthEtchedBorder());
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setOpaque(false);
        imagePanel.add((Component)this.imageLabel, "North");
        this.content.add((Component)imagePanel, "West");
        this.content.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.backButton, null);
        this.buttonPanel.add((Component)this.nextButton, null);
        this.buttonPanel.add((Component)this.finishButton, null);
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.content.add((Component)this.stepPanel, "Center");
    }

    public void nextButton_actionPerformed(ActionEvent e2) {
        this.cardLayout.next(this.stepPanel);
        ++this.stepIndex;
        this.update();
        this.currentStep().onShow();
    }

    public void setBackgroundImage(Image bg2) {
        this.stepPanel.setBackgroundImage(bg2);
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        this.currentStep().onShow();
    }

    protected void update() {
        this.backButton.setEnabled(this.stepIndex > 0);
        this.nextButton.setEnabled(this.stepIndex < this.steps.size() - 1 && this.currentStep().allowNext());
        this.allowFinish(this.stepIndex == this.steps.size() - 1 && this.currentStep().allowNext());
        this.finishButton.setVisible(this.steps.size() > 1);
        this.okButton.setVisible(this.steps.size() == 1);
        this.backButton.setVisible(this.steps.size() > 1);
        this.nextButton.setVisible(this.steps.size() > 1);
        this.updateTitle();
    }

    protected void updateTitle() {
        if (this.steps.size() > 1) {
            this.setTitle(this.title + " - Step " + (this.stepIndex + 1) + " of " + this.steps.size());
        } else {
            this.setTitle(this.title);
        }
    }
}

