/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import se.datadosen.component.Ruler;

public class RiverLayout
extends FlowLayout
implements LayoutManager,
Serializable {
    public static final String CENTER = "center";
    public static final String HFILL = "hfill";
    public static final String LEFT = "left";
    public static final String LINE_BREAK = "br";
    public static final String PARAGRAPH_BREAK = "p";
    public static final String RIGHT = "right";
    public static final String TAB_STOP = "tab";
    public static final String VCENTER = "vcenter";
    public static final String VFILL = "vfill";
    public static final String VTOP = "vtop";
    Map constraints = new HashMap();
    Insets extraInsets;
    int hgap;
    Insets totalInsets = new Insets(0, 0, 0, 0);
    String valign = "vcenter";
    int vgap;

    public RiverLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setExtraInsets(new Insets(0, hgap, hgap, hgap));
    }

    public RiverLayout() {
        this(10, 5);
    }

    public void addLayoutComponent(String name, Component comp) {
        this.constraints.put(comp, name);
    }

    protected void adjustAlignment(Component m2) {
        if (this.hasConstraint(m2, LEFT)) {
            this.setAlignment(0);
        } else if (this.hasConstraint(m2, RIGHT)) {
            this.setAlignment(2);
        } else if (this.hasConstraint(m2, CENTER)) {
            this.setAlignment(1);
        }
        if (this.hasConstraint(m2, VTOP)) {
            this.valign = VTOP;
        } else if (this.hasConstraint(m2, VCENTER)) {
            this.valign = VCENTER;
        }
    }

    protected Ruler calcTabs(Container target) {
        Ruler ruler = new Ruler();
        int nmembers = target.getComponentCount();
        int x2 = 0;
        int tabIndex = 0;
        int i2 = 0;
        while (i2 < nmembers) {
            Component m2 = target.getComponent(i2);
            if (this.isFirstInRow(m2) || i2 == 0) {
                x2 = 0;
                tabIndex = 0;
            } else {
                x2 += this.hgap;
            }
            if (this.hasConstraint(m2, TAB_STOP)) {
                ruler.setTab(tabIndex, x2);
                x2 = ruler.getTab(tabIndex++);
            }
            Dimension d2 = m2.getPreferredSize();
            x2 += d2.width;
            ++i2;
        }
        return ruler;
    }

    public Insets getExtraInsets() {
        return this.extraInsets;
    }

    public int getHgap() {
        return this.hgap;
    }

    protected Insets getInsets(Container target) {
        Insets insets = target.getInsets();
        this.totalInsets.top = insets.top + this.extraInsets.top;
        this.totalInsets.left = insets.left + this.extraInsets.left;
        this.totalInsets.bottom = insets.bottom + this.extraInsets.bottom;
        this.totalInsets.right = insets.right + this.extraInsets.right;
        return this.totalInsets;
    }

    public int getVgap() {
        return this.vgap;
    }

    boolean hasConstraint(Component comp, String test) {
        String cons = (String)this.constraints.get(comp);
        if (cons == null) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(cons);
        while (tokens.hasMoreTokens()) {
            if (!tokens.nextToken().equals(test)) continue;
            return true;
        }
        return false;
    }

    boolean hasHfill(Component comp) {
        return this.hasConstraint(comp, HFILL);
    }

    boolean hasVfill(Component comp) {
        return this.hasConstraint(comp, VFILL);
    }

    boolean isFirstInRow(Component comp) {
        String cons = (String)this.constraints.get(comp);
        return cons != null && (cons.indexOf(LINE_BREAK) != -1 || cons.indexOf(PARAGRAPH_BREAK) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        this.setAlignment(0);
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = this.getInsets(target);
            int maxwidth = target.getWidth() - (insets.left + insets.right);
            int maxheight = target.getHeight() - (insets.top + insets.bottom);
            int nmembers = target.getComponentCount();
            int x2 = 0;
            int y2 = insets.top + this.vgap;
            int rowh = 0;
            int start = 0;
            int moveDownStart = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component toHfill = null;
            Component toVfill = null;
            Ruler ruler = this.calcTabs(target);
            int tabIndex = 0;
            int i2 = 0;
            while (i2 < nmembers) {
                Component m2 = target.getComponent(i2);
                Dimension d2 = m2.getPreferredSize();
                m2.setSize(d2.width, d2.height);
                if (this.isFirstInRow(m2)) {
                    tabIndex = 0;
                }
                if (this.hasConstraint(m2, TAB_STOP)) {
                    x2 = ruler.getTab(tabIndex++);
                }
                if (!this.isFirstInRow(m2)) {
                    if (i2 > 0 && !this.hasConstraint(m2, TAB_STOP)) {
                        x2 += this.hgap;
                    }
                    x2 += d2.width;
                    rowh = Math.max(rowh, d2.height);
                } else {
                    if (toVfill != null && moveDownStart == 0) {
                        moveDownStart = i2;
                    }
                    if (toHfill != null) {
                        toHfill.setSize(toHfill.getWidth() + maxwidth - x2, toHfill.getHeight());
                        x2 = maxwidth;
                    }
                    this.moveComponents(target, insets.left, y2, maxwidth - x2, rowh, start, i2, ltr, ruler);
                    x2 = d2.width;
                    y2 += this.vgap + rowh;
                    if (this.hasConstraint(m2, PARAGRAPH_BREAK)) {
                        y2 += 2 * this.vgap;
                    }
                    rowh = d2.height;
                    start = i2;
                    toHfill = null;
                }
                if (this.hasHfill(m2)) {
                    toHfill = m2;
                }
                if (this.hasVfill(m2)) {
                    toVfill = m2;
                }
                this.adjustAlignment(m2);
                ++i2;
            }
            if (toVfill != null && moveDownStart == 0) {
                moveDownStart = nmembers;
            }
            if (toHfill != null) {
                toHfill.setSize(toHfill.getWidth() + maxwidth - x2, toHfill.getHeight());
                x2 = maxwidth;
            }
            this.moveComponents(target, insets.left, y2, maxwidth - x2, rowh, start, nmembers, ltr, ruler);
            int yslack = maxheight - (y2 + rowh);
            if (yslack != 0 && toVfill != null) {
                toVfill.setSize(toVfill.getWidth(), yslack + toVfill.getHeight());
                this.relMove(target, 0, yslack, moveDownStart, nmembers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            Dimension rowDim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int tabIndex = 0;
            Ruler ruler = this.calcTabs(target);
            int i2 = 0;
            while (i2 < nmembers) {
                Component m2 = target.getComponent(i2);
                if (this.isFirstInRow(m2)) {
                    tabIndex = 0;
                    dim.width = Math.max(dim.width, rowDim.width);
                    dim.height += rowDim.height + this.vgap;
                    if (this.hasConstraint(m2, PARAGRAPH_BREAK)) {
                        dim.height += 2 * this.vgap;
                    }
                    rowDim = new Dimension(0, 0);
                }
                if (this.hasConstraint(m2, TAB_STOP)) {
                    rowDim.width = ruler.getTab(tabIndex++);
                }
                Dimension d2 = m2.getMinimumSize();
                rowDim.height = Math.max(rowDim.height, d2.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    rowDim.width += this.hgap;
                }
                rowDim.width += d2.width;
                ++i2;
            }
            dim.width = Math.max(dim.width, rowDim.width);
            dim.height += rowDim.height;
            Insets insets = this.getInsets(target);
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveComponents(Container target, int x2, int y2, int width, int height, int rowStart, int rowEnd, boolean ltr, Ruler ruler) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    x2 += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x2 += width / 2;
                    break;
                }
                case 2: {
                    x2 += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x2 += width;
                }
            }
            int tabIndex = 0;
            int i2 = rowStart;
            while (i2 < rowEnd) {
                int dy2;
                Component m2 = target.getComponent(i2);
                if (this.hasConstraint(m2, TAB_STOP)) {
                    x2 = this.getInsets((Container)target).left + ruler.getTab(tabIndex++);
                }
                int n2 = dy2 = this.valign == VTOP ? 0 : (height - m2.getHeight()) / 2;
                if (ltr) {
                    m2.setLocation(x2, y2 + dy2);
                } else {
                    m2.setLocation(target.getWidth() - x2 - m2.getWidth(), y2 + dy2);
                }
                x2 += m2.getWidth() + this.hgap;
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            Dimension rowDim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int tabIndex = 0;
            Ruler ruler = this.calcTabs(target);
            int i2 = 0;
            while (i2 < nmembers) {
                Component m2 = target.getComponent(i2);
                if (this.isFirstInRow(m2)) {
                    tabIndex = 0;
                    dim.width = Math.max(dim.width, rowDim.width);
                    dim.height += rowDim.height + this.vgap;
                    if (this.hasConstraint(m2, PARAGRAPH_BREAK)) {
                        dim.height += 2 * this.vgap;
                    }
                    rowDim = new Dimension(0, 0);
                }
                if (this.hasConstraint(m2, TAB_STOP)) {
                    rowDim.width = ruler.getTab(tabIndex++);
                }
                Dimension d2 = m2.getPreferredSize();
                rowDim.height = Math.max(rowDim.height, d2.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    rowDim.width += this.hgap;
                }
                rowDim.width += d2.width;
                ++i2;
            }
            dim.width = Math.max(dim.width, rowDim.width);
            dim.height += rowDim.height;
            Insets insets = this.getInsets(target);
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void relMove(Container target, int dx2, int dy2, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i2 = rowStart;
            while (i2 < rowEnd) {
                Component m2 = target.getComponent(i2);
                m2.setLocation(m2.getX() + dx2, m2.getY() + dy2);
                ++i2;
            }
        }
    }

    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    public void setExtraInsets(Insets newExtraInsets) {
        this.extraInsets = newExtraInsets;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }
}

