/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JExplorerPanel;

class ExplorerSelectionModel {
    static final int EAST = 4;
    static final int NORTH = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    private JExplorerPanel explorer;
    private JAlbumObject focusedObject;
    int lastClickedIndex = 0;
    boolean wasAlreadySelected = false;

    public ExplorerSelectionModel(JExplorerPanel explorer) {
        this.explorer = explorer;
    }

    void deselectAll() {
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            ((JAlbumObject)comps[i2]).setSelected(false);
            ++i2;
        }
    }

    JAlbumObject getFocusedObject() {
        return this.focusedObject;
    }

    JAlbumObject getNeighbourObject(JAlbumObject jao, int direction) {
        Point p2 = jao.getLocation();
        Dimension dim = this.explorer.objectSize;
        p2.x += dim.width / 2;
        p2.y += dim.height / 2;
        switch (direction) {
            case 1: {
                p2.y -= dim.height + this.explorer.ourLayout.getVgap();
                break;
            }
            case 2: {
                p2.y += dim.height + this.explorer.ourLayout.getVgap();
                break;
            }
            case 3: {
                p2.x -= dim.width + this.explorer.ourLayout.getHgap();
                break;
            }
            case 4: {
                p2.x += dim.width + this.explorer.ourLayout.getHgap();
            }
        }
        return (JAlbumObject)this.explorer.getNearestComponent(p2);
    }

    LinkedList getSelectedObjects() {
        LinkedList<JAlbumObject> list = new LinkedList<JAlbumObject>();
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (jao.isSelected()) {
                list.add(jao);
            }
            ++i2;
        }
        return list;
    }

    JAlbumObject getSingleSelected() {
        JAlbumObject selected = null;
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (jao.isSelected()) {
                if (selected != null) {
                    return null;
                }
                selected = jao;
            }
            ++i2;
        }
        return selected;
    }

    int indexOf(Component comp) {
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            if (comps[i2] == comp) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    void invertSelection() {
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            JAlbumObject jao;
            jao.setSelected(!(jao = (JAlbumObject)comps[i2]).isSelected());
            ++i2;
        }
    }

    void selectAll() {
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            ((JAlbumObject)comps[i2]).setSelected(true);
            ++i2;
        }
    }

    void selectRange(int startIndex, int endIndex) {
        Component[] comps = this.explorer.getComponents();
        if (startIndex > endIndex) {
            int tmp = startIndex;
            startIndex = endIndex;
            endIndex = tmp;
        }
        int i2 = startIndex;
        while (i2 <= endIndex) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            jao.setSelected(true);
            ++i2;
        }
    }

    void setFocusedObject(JAlbumObject jao) {
        this.focusedObject = jao;
    }
}

