/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import se.datadosen.explorer.Cache;
import se.datadosen.jalbum.AlbumObject;

public class ImageCache {
    private Cache cache;
    private boolean debug = false;
    Dimension imageDim;
    private Object preloadMonitor = new Object();
    private Thread preloaderThread;
    private AlbumObject toLoad;

    public ImageCache(int nImages, Dimension imageDim) {
        this.cache = new Cache(nImages);
        this.imageDim = imageDim;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean contains(AlbumObject ao) {
        return this.cache.get(ao.getName()) != null;
    }

    public void dispose() {
        if (this.preloaderThread != null) {
            this.preloaderThread.interrupt();
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(AlbumObject ao) throws IOException {
        LoadingImageIndicator loading;
        String key = ao.getName();
        Object value = this.cache.get(key);
        if (value != null) {
            if (!(value instanceof LoadingImageIndicator)) {
                return (Image)value;
            }
            Object object = value;
            synchronized (object) {
                return (Image)this.cache.get(key);
            }
        }
        LoadingImageIndicator loadingImageIndicator = loading = new LoadingImageIndicator();
        synchronized (loadingImageIndicator) {
            this.cache.put(key, loading);
            Image im = this.load(ao);
            this.cache.put(key, im);
            return im;
        }
    }

    private Image load(AlbumObject ao) throws IOException {
        Image im = ao.loadImage();
        if (im != null) {
            this.log("Scaling to " + this.imageDim);
            Image scaled = ImageCache.scaleToFit(im, this.imageDim, false, false);
            im.flush();
            return scaled;
        }
        return ao.getRepresentingIcon(this.imageDim, false).getImage();
    }

    private void log(String s2) {
        if (this.debug) {
            System.out.println(s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(AlbumObject ao) {
        if (ao == null || this.contains(ao)) {
            return;
        }
        Object object = this.preloadMonitor;
        synchronized (object) {
            this.toLoad = ao;
            this.preloadMonitor.notify();
        }
        if (this.preloaderThread == null) {
            this.preloaderThread = new Thread("PreloaderThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ImageCache.this.log("Launching preloader thread");
                    while (true) {
                        ImageCache.this.log("preloading " + ImageCache.this.toLoad.getName());
                        try {
                            AlbumObject ao = ImageCache.this.toLoad;
                            ImageCache.this.toLoad = null;
                            ImageCache.this.getImage(ao);
                        }
                        catch (IOException ex1) {
                            ex1.printStackTrace(System.err);
                        }
                        Object object = ImageCache.this.preloadMonitor;
                        synchronized (object) {
                            try {
                                ImageCache.this.log("Waiting...");
                                ImageCache.this.preloadMonitor.wait();
                            }
                            catch (InterruptedException ex) {
                                ImageCache.this.log("Preloader thread quitting");
                                ImageCache.this.preloaderThread = null;
                                return;
                            }
                        }
                    }
                }
            };
            this.preloaderThread.setDaemon(true);
            this.preloaderThread.setPriority(1);
            this.preloaderThread.start();
        }
    }

    static Image scaleToFit(Image image, Dimension boundingBox, boolean highQualityScaling, boolean enlarge) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (!enlarge && width <= boundingBox.width && height <= boundingBox.height) {
            return image;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int scaleType = highQualityScaling ? 4 : 2;
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        BufferedImage bi2 = new BufferedImage(newWidth, newHeight, 1);
        Graphics g2 = bi2.getGraphics();
        g2.drawImage(image, 0, 0, newWidth, newHeight, null);
        return bi2;
    }

    public void setImageDimension(Dimension imageDim) {
        this.imageDim = imageDim;
    }

    class LoadingImageIndicator {
        LoadingImageIndicator() {
        }
    }
}

