/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.JSlideShow;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JAlbumExplorer
extends JPanel {
    public static final int IMAGE_CACHE_SIZE = 10;
    BorderLayout borderLayout1;
    static /* synthetic */ Class class$se$datadosen$explorer$JAlbumExplorer;
    JPopupMenu componentPopup;
    JPanel contentPane;
    AlbumObject currentFolder;
    Action deleteAction;
    Action excludeSelectedAction;
    public JExplorerPanel explorer;
    JPopupMenu explorerPopup;
    JScrollPane explorerScrollPane;
    Action hideExcludedAction;
    JCheckBoxMenuItem hideExcludedMenuItem;
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    ImageCache imageCache;
    Action includeSelectedAction;
    Action invertSelectionAction;
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JButton jButton3 = new JButton();
    Action largeThumbnailsAction;
    JCheckBoxMenuItem largeThumbnailsMenuItem;
    MouseAdapter mouseOnComponentAdapter;
    MouseAdapter mouseOnTreeAdapter;
    Action openAction;
    Action orderByCameraDateAction;
    Action orderByDateAction;
    Action orderByNameAction;
    Action orderByReverseDateAction;
    Action orderByReverseNameAction;
    JMenu orderingSubMenu;
    Action parentFolderAction;
    Action propertiesAction;
    Action renameAction;
    AlbumObject rootFolder;
    Action rotateLeftAction;
    Action rotateRightAction;
    Action selectAllAction;
    Action slideShowAction;
    JSplitPane splitPane;
    Point startingPoint;
    JTree tree;
    JScrollPane treeScrollPane;
    Action updateAction;
    Action useAsFolderThumbnailAction;
    JCheckBoxMenuItem useAsFolderThumbnailMenuItem;
    Action useJAlbumOrderingAction;

    public JAlbumExplorer() {
        this.borderLayout1 = new BorderLayout();
        this.splitPane = new JSplitPane();
        this.treeScrollPane = new JScrollPane();
        this.explorerScrollPane = new JScrollPane();
        this.tree = new JTree((TreeModel)null);
        this.explorer = new JExplorerPanel(this);
        this.explorerPopup = new JPopupMenu();
        this.componentPopup = new JPopupMenu();
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void adjustOrientation(boolean right) {
        LinkedList list = this.explorer.selectionModel.getSelectedObjects();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            JAlbumObject jao = (JAlbumObject)it.next();
            try {
                if (right) {
                    jao.ao.rotateRight();
                } else {
                    jao.ao.rotateLeft();
                }
                jao.renderIcon();
                jao.validate();
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
        this.imageCache.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    void doSort(Comparator comparator) {
        Component[] comps = this.explorer.getComponents();
        Arrays.sort(comps, comparator);
        this.explorer.removeAll();
        int i2 = 0;
        while (i2 < comps.length) {
            this.explorer.add(comps[i2]);
            ++i2;
        }
        this.explorer.validate();
        this.explorer.repaint();
        this.syncModel();
    }

    static boolean isPortableControlDown(MouseEvent e2) {
        boolean ret = (e2.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
        return ret;
    }

    private void jbInit() throws Exception {
        this.image1 = new ImageIcon((class$se$datadosen$explorer$JAlbumExplorer == null ? (class$se$datadosen$explorer$JAlbumExplorer = JAlbumExplorer.class$("se.datadosen.explorer.JAlbumExplorer")) : class$se$datadosen$explorer$JAlbumExplorer).getResource("openFile.png"));
        this.image2 = new ImageIcon((class$se$datadosen$explorer$JAlbumExplorer == null ? (class$se$datadosen$explorer$JAlbumExplorer = JAlbumExplorer.class$("se.datadosen.explorer.JAlbumExplorer")) : class$se$datadosen$explorer$JAlbumExplorer).getResource("closeFile.png"));
        this.image3 = new ImageIcon((class$se$datadosen$explorer$JAlbumExplorer == null ? (class$se$datadosen$explorer$JAlbumExplorer = JAlbumExplorer.class$("se.datadosen.explorer.JAlbumExplorer")) : class$se$datadosen$explorer$JAlbumExplorer).getResource("help.png"));
        this.contentPane = this;
        this.contentPane.setLayout(this.borderLayout1);
        this.jButton1.setIcon(this.image1);
        this.jButton1.setToolTipText("Open File");
        this.jButton2.setIcon(this.image2);
        this.jButton2.setToolTipText("Close File");
        this.jButton3.setIcon(this.image3);
        this.jButton3.setToolTipText("Help");
        this.splitPane.setOrientation(1);
        this.splitPane.setOpaque(true);
        this.explorer.setBackground(SystemColor.window);
        this.explorerScrollPane.setPreferredSize(new Dimension(420, 80));
        this.explorerScrollPane.getVerticalScrollBar().setUnitIncrement(70);
        this.explorer.addStructureListener(new StructureListener(){

            public void structureChanged(StructureEvent e2) {
                JAlbumExplorer.this.syncModel();
            }
        });
        this.explorer.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                int code = e2.getKeyCode();
                if (code == 38 || code == 40 || code == 37 || code == 39) {
                    this.processArrowKeys(e2);
                    e2.consume();
                }
            }

            void processArrowKeys(KeyEvent ke) {
                JAlbumObject focused = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (focused != null) {
                    int dir2 = 0;
                    switch (ke.getKeyCode()) {
                        case 38: {
                            dir2 = 1;
                            break;
                        }
                        case 40: {
                            dir2 = 2;
                            break;
                        }
                        case 37: {
                            dir2 = 3;
                            break;
                        }
                        case 39: {
                            dir2 = 4;
                        }
                    }
                    JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getNeighbourObject(focused, dir2);
                    MouseEvent me = new MouseEvent(jao, 0, ke.getWhen(), ke.getModifiers(), 0, 0, 1, false);
                    JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(jao.getLocation(), jao.getSize()));
                    JAlbumExplorer.this.mouseOnComponentAdapter.mousePressed(me);
                }
            }
        });
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.contentPane.add((Component)this.splitPane, "Center");
        this.treeScrollPane.setMinimumSize(new Dimension(50, 10));
        this.splitPane.add((Component)this.treeScrollPane, "left");
        this.treeScrollPane.getViewport().add((Component)this.tree, null);
        this.splitPane.add((Component)this.explorerScrollPane, "right");
        this.explorerScrollPane.getViewport().add((Component)this.explorer, null);
        this.explorer.setAutoscrolls(true);
        KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
        KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
        KeyStroke f5 = KeyStroke.getKeyStroke(116, 0);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        KeyStroke ctrlA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke altEnter = KeyStroke.getKeyStroke(10, 8);
        KeyStroke altGrEnter = KeyStroke.getKeyStroke(10, 2);
        KeyStroke plus = KeyStroke.getKeyStroke('+');
        KeyStroke minus = KeyStroke.getKeyStroke('-');
        this.parentFolderAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                if (JAlbumExplorer.this.currentFolder.getParent() != null) {
                    JAlbumExplorer.this.selectNode(JAlbumExplorer.this.currentFolder.getParent());
                }
            }
        };
        this.parentFolderAction.putValue("AcceleratorKey", backspace);
        this.renameAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    selected.setEditing(true);
                }
            }
        };
        this.renameAction.putValue("AcceleratorKey", f2);
        this.updateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.rootFolder.invalidate();
                JAlbumExplorer.this.setRootFolder(JAlbumExplorer.this.rootFolder);
                JAlbumExplorer.this.selectNode(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.updateAction.putValue("AcceleratorKey", f5);
        this.openAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    JAlbumExplorer.this.open(jao);
                }
            }
        };
        this.openAction.putValue("AcceleratorKey", enter);
        this.propertiesAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (list.size() == 0) {
                    JAlbumObject jao = new JAlbumObject(JAlbumExplorer.this.currentFolder, JAlbumExplorer.this.explorer);
                    jao.openPropertyEditor(JAlbumExplorer.this.explorer);
                }
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    jao.openPropertyEditor();
                }
            }
        };
        this.propertiesAction.putValue("AcceleratorKey", altEnter);
        this.hideExcludedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.largeThumbnailsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                if (JAlbumExplorer.this.largeThumbnailsMenuItem.isSelected()) {
                    JAlbumExplorer.this.explorer.setIconBounds(new Dimension(160, 160));
                } else {
                    JAlbumExplorer.this.explorer.setIconBounds(new Dimension(96, 96));
                }
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.useAsFolderThumbnailAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (JAlbumExplorer.this.useAsFolderThumbnailMenuItem.isSelected()) {
                    JAlbumExplorer.this.currentFolder.setRepresentingIconFile(jao.ao.getFile());
                } else {
                    JAlbumExplorer.this.currentFolder.setRepresentingIconFile(null);
                }
                JAlbumExplorer.this.explorer.repaint();
            }
        };
        this.deleteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (list.size() == 0) {
                    return;
                }
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    if (!jao.ao.isFolder()) continue;
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, Msg.getString("edit.cannotDeleteFoldersInfo"), Msg.getString("edit.deleteFilesTitle"), 1);
                    return;
                }
                int answer = JOptionPane.showConfirmDialog(JAlbumExplorer.this, MessageFormat.format(Msg.getString("edit.deletePermanentlyInfo"), new Integer(list.size())), Msg.getString("edit.deleteFilesTitle"), 0, 2);
                if (answer != 0) {
                    return;
                }
                it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    File f2 = jao.ao.getFile();
                    if (f2 == null || !f2.delete()) continue;
                    JAlbumExplorer.this.explorer.remove(jao);
                }
                JAlbumExplorer.this.syncModel();
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
            }
        };
        this.deleteAction.putValue("AcceleratorKey", delete);
        this.includeSelectedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    jao.setIncluded(true);
                    jao.setVisible(true);
                }
                JAlbumExplorer.this.syncModel();
            }
        };
        this.includeSelectedAction.putValue("AcceleratorKey", plus);
        this.excludeSelectedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                boolean hideExcluded = JAlbumExplorer.this.hideExcludedMenuItem.isSelected();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    jao.setIncluded(false);
                    if (!hideExcluded) continue;
                    jao.setVisible(false);
                }
                JAlbumExplorer.this.syncModel();
            }
        };
        this.excludeSelectedAction.putValue("AcceleratorKey", minus);
        this.rotateLeftAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.adjustOrientation(false);
            }
        };
        this.rotateRightAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.adjustOrientation(true);
            }
        };
        this.selectAllAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.explorer.selectionModel.selectAll();
            }
        };
        this.selectAllAction.putValue("AcceleratorKey", ctrlA);
        this.invertSelectionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.explorer.selectionModel.invertSelection();
            }
        };
        this.slideShowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                Iterator it;
                LinkedList<AlbumObject> slides = new LinkedList<AlbumObject>();
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                AlbumObject start = null;
                if (list.size() <= 1) {
                    if (list.size() == 1) {
                        start = ((JAlbumObject)list.getFirst()).ao;
                    }
                    it = JAlbumExplorer.this.currentFolder.getChildren().iterator();
                    while (it.hasNext()) {
                        AlbumObject ao = (AlbumObject)it.next();
                        if (!ao.isIncluded() || ao.isFolder()) continue;
                        slides.addLast(ao);
                    }
                } else {
                    it = list.iterator();
                    while (it.hasNext()) {
                        AlbumObject ao = ((JAlbumObject)it.next()).ao;
                        if (!ao.isIncluded() || ao.isFolder()) continue;
                        slides.addLast(ao);
                    }
                }
                JSlideShow slideShow = new JSlideShow(slides, start);
                slideShow.show();
            }
        };
        this.orderByNameAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.doSort(new Comparator(this){
                    private final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        JAlbumObject jao1 = (JAlbumObject)o1;
                        JAlbumObject jao2 = (JAlbumObject)o2;
                        return jao1.ao.getName().compareTo(jao2.ao.getName());
                    }
                });
            }
        };
        this.orderByReverseNameAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.doSort(new Comparator(this){
                    private final /* synthetic */ 21 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        JAlbumObject jao1 = (JAlbumObject)o1;
                        JAlbumObject jao2 = (JAlbumObject)o2;
                        return jao2.ao.getName().compareTo(jao1.ao.getName());
                    }
                });
            }
        };
        this.orderByDateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.doSort(new Comparator(this){
                    private final /* synthetic */ 23 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        JAlbumObject jao1 = (JAlbumObject)o1;
                        JAlbumObject jao2 = (JAlbumObject)o2;
                        long diff = jao1.ao.getFile().lastModified() - jao2.ao.getFile().lastModified();
                        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
                    }
                });
            }
        };
        this.orderByReverseDateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.doSort(new Comparator(this){
                    private final /* synthetic */ 25 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        JAlbumObject jao1 = (JAlbumObject)o1;
                        JAlbumObject jao2 = (JAlbumObject)o2;
                        long diff = jao1.ao.getFile().lastModified() - jao2.ao.getFile().lastModified();
                        return diff < 0L ? 1 : (diff > 0L ? -1 : 0);
                    }
                });
            }
        };
        this.orderByCameraDateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.doSort(new Comparator(this){
                    private final /* synthetic */ 27 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        long diff;
                        JAlbumObject jao1 = (JAlbumObject)o1;
                        JAlbumObject jao2 = (JAlbumObject)o2;
                        long d1 = jao1.ao.getMetadata().getCameraDate();
                        long d2 = jao2.ao.getMetadata().getCameraDate();
                        if (d1 == 0L) {
                            d1 = jao1.ao.getFile().lastModified();
                        }
                        if (d2 == 0L) {
                            d2 = jao2.ao.getFile().lastModified();
                        }
                        return (diff = d1 - d2) < 0L ? -1 : (diff > 0L ? 1 : 0);
                    }
                });
            }
        };
        this.useJAlbumOrderingAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                File file = new File(JAlbumExplorer.this.currentFolder.getFile(), "albumfiles.txt");
                if (file.exists()) {
                    file.delete();
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.explorer.registerKeyboardAction(this.selectAllAction, "selectAllAction", ctrlA, 2);
        this.explorer.registerKeyboardAction(this.parentFolderAction, "parentFolder", backspace, 0);
        this.tree.registerKeyboardAction(this.parentFolderAction, "parentFolder", backspace, 0);
        this.explorer.registerKeyboardAction(this.renameAction, "editNameAction", f2, 2);
        this.explorer.registerKeyboardAction(this.openAction, "openAction", enter, 2);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altEnter, 2);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altGrEnter, 2);
        this.explorer.registerKeyboardAction(this.deleteAction, "deleteAction", delete, 0);
        this.explorer.registerKeyboardAction(this.includeSelectedAction, "includeSelectedAction", plus, 2);
        this.explorer.registerKeyboardAction(this.excludeSelectedAction, "excludeSelectedAction", minus, 2);
        this.contentPane.registerKeyboardAction(this.updateAction, "update", f5, 2);
        this.componentPopup.add(this.openAction);
        this.componentPopup.add(this.invertSelectionAction);
        this.componentPopup.add(this.slideShowAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.rotateLeftAction);
        this.componentPopup.add(this.rotateRightAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.excludeSelectedAction);
        this.componentPopup.add(this.includeSelectedAction);
        this.componentPopup.addSeparator();
        this.useAsFolderThumbnailMenuItem = new JCheckBoxMenuItem(this.useAsFolderThumbnailAction);
        this.componentPopup.add(this.useAsFolderThumbnailMenuItem);
        this.componentPopup.add(this.deleteAction);
        this.componentPopup.add(this.renameAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.propertiesAction);
        this.explorerPopup.add(this.selectAllAction);
        this.explorerPopup.add(this.slideShowAction);
        this.orderingSubMenu = new JMenu();
        this.orderingSubMenu.add(this.orderByNameAction);
        this.orderingSubMenu.add(this.orderByReverseNameAction);
        this.orderingSubMenu.add(this.orderByDateAction);
        this.orderingSubMenu.add(this.orderByReverseDateAction);
        this.orderingSubMenu.add(this.orderByCameraDateAction);
        this.orderingSubMenu.add(this.useJAlbumOrderingAction);
        this.explorerPopup.addSeparator();
        this.largeThumbnailsMenuItem = new JCheckBoxMenuItem(this.largeThumbnailsAction);
        this.explorerPopup.add(this.largeThumbnailsMenuItem);
        this.hideExcludedMenuItem = new JCheckBoxMenuItem(this.hideExcludedAction);
        this.explorerPopup.add(this.hideExcludedMenuItem);
        this.explorerPopup.add(this.orderingSubMenu);
        this.explorerPopup.add(this.updateAction);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.propertiesAction);
        this.setTexts();
        MouseAdapter mouseOnExplorerAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                JAlbumExplorer.this.explorer.requestFocus();
                JAlbumExplorer.this.startingPoint = e2.getPoint();
                JAlbumExplorer.this.explorer.rubberband = new Rectangle(JAlbumExplorer.this.startingPoint);
                if (!JAlbumExplorer.isPortableControlDown(e2) && !e2.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                }
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.explorerPopup);
            }

            public void mouseReleased(MouseEvent e2) {
                JAlbumExplorer.this.explorer.rubberband = null;
                JAlbumExplorer.this.explorer.repaint();
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                int i2 = 0;
                while (i2 < comps.length) {
                    JAlbumObject jao = (JAlbumObject)comps[i2];
                    jao.resetRubberbanded();
                    ++i2;
                }
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.explorerPopup);
            }
        };
        this.explorer.addMouseListener(mouseOnExplorerAdapter);
        MouseMotionAdapter mouseMotionOnExplorerAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e2) {
                JAlbumExplorer.points2rect(JAlbumExplorer.this.startingPoint, e2.getPoint(), JAlbumExplorer.this.explorer.rubberband);
                JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(e2.getPoint()));
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                Rectangle cr2 = new Rectangle();
                int i2 = 0;
                while (i2 < comps.length) {
                    JAlbumObject jao = (JAlbumObject)comps[i2];
                    cr2.x = jao.getX();
                    cr2.y = jao.getY();
                    cr2.width = jao.getWidth();
                    cr2.height = jao.getHeight();
                    Rectangle intersection = JAlbumExplorer.this.explorer.rubberband.intersection(cr2);
                    jao.setRubberbanded(intersection.width > cr2.width / 4 && intersection.height > cr2.height / 4);
                    ++i2;
                }
                JAlbumExplorer.this.explorer.repaint();
            }
        };
        this.explorer.addMouseMotionListener(mouseMotionOnExplorerAdapter);
        this.mouseOnComponentAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    JAlbumExplorer.this.open((JAlbumObject)e2.getComponent());
                }
            }

            public void mousePressed(MouseEvent e2) {
                JAlbumExplorer.this.explorer.requestFocus();
                JAlbumObject jao = (JAlbumObject)e2.getComponent();
                JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected = jao.isSelected();
                JAlbumExplorer.this.explorer.selectionModel.setFocusedObject(jao);
                if (JAlbumExplorer.isPortableControlDown(e2)) {
                    jao.setSelected(!jao.isSelected());
                } else if (e2.isShiftDown()) {
                    int clickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    JAlbumExplorer.this.explorer.selectionModel.selectRange(JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex, clickedIndex);
                } else {
                    if (!jao.isSelected()) {
                        JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    }
                    jao.setSelected(true);
                }
                if (!e2.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                }
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.componentPopup);
            }

            public void mouseReleased(MouseEvent e2) {
                JAlbumObject jao = (JAlbumObject)e2.getComponent();
                if (!(JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.componentPopup) || JAlbumExplorer.isPortableControlDown(e2) || e2.isShiftDown())) {
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    jao.setSelected(true);
                    Point p2 = e2.getPoint();
                    if (jao.labelPanel.getBounds().contains(p2) && JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected && e2.getClickCount() == 1) {
                        jao.setEditing(true);
                    }
                }
            }
        };
        this.mouseOnTreeAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                TreePath path = JAlbumExplorer.this.tree.getPathForLocation(e2.getX(), e2.getY());
                if (e2.getButton() != 1) {
                    JAlbumExplorer.this.tree.getSelectionModel().setSelectionPath(path);
                }
            }

            public void mouseReleased(MouseEvent e2) {
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.explorerPopup);
            }
        };
        DefaultTreeCellRenderer folderRenderer = new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                FolderTreeNode node;
                Component ret = null;
                ret = selected ? super.getTreeCellRendererComponent(tree, value, selected, expanded, true, row, hasFocus) : super.getTreeCellRendererComponent(tree, value, selected, expanded, false, row, hasFocus);
                if (value instanceof FolderTreeNode && (node = (FolderTreeNode)value).getUserObject() instanceof AlbumObject) {
                    AlbumObject ao = (AlbumObject)node.getUserObject();
                    ret.setEnabled(ao.isIncluded());
                }
                return ret;
            }
        };
        folderRenderer.setLeafIcon(folderRenderer.getOpenIcon());
        this.tree.setCellRenderer(folderRenderer);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e2) {
                AlbumObject ao;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e2.getPath().getLastPathComponent();
                if (node.getUserObject() instanceof AlbumObject && (ao = (AlbumObject)node.getUserObject()) != JAlbumExplorer.this.currentFolder) {
                    JAlbumExplorer.this.viewFolder(ao);
                }
            }
        });
        this.tree.addMouseListener(this.mouseOnTreeAdapter);
        RenderThread rt = new RenderThread();
        rt.start();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.imageCache = new ImageCache(10, new Dimension(screenSize.width / 2, screenSize.width / 2));
    }

    private boolean maybeShowPopup(MouseEvent e2, JPopupMenu popup) {
        if (popup == this.componentPopup) {
            JAlbumObject jao = (JAlbumObject)e2.getComponent();
            AlbumBean engine = ((JAlbumFrame)JAlbum.comp).getEngine();
            this.useAsFolderThumbnailAction.setEnabled(!jao.ao.isFolder() || engine.getSkin().indexOf("ExhibitPlus") < 0);
            this.rotateLeftAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
            this.rotateRightAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
            this.useAsFolderThumbnailMenuItem.setSelected(false);
            File rep = this.currentFolder.getRepresentingIconFile();
            if (rep != null && rep.equals(jao.ao.getFile())) {
                this.useAsFolderThumbnailMenuItem.setSelected(true);
            }
        }
        if (e2.isPopupTrigger()) {
            popup.show(e2.getComponent(), e2.getX(), e2.getY());
            return true;
        }
        return false;
    }

    void open(JAlbumObject jao) {
        if (jao.ao.isFolder()) {
            this.selectNode(jao.ao);
        } else if (jao.ao.isDisplayableImage()) {
            jao.openPropertyEditor();
        } else {
            try {
                BrowserLauncher.openLocal(jao.ao.getFile());
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    private static void points2rect(Point p1, Point p2, Rectangle r2) {
        r2.x = Math.min(p1.x, p2.x);
        r2.y = Math.min(p1.y, p2.y);
        r2.width = p2.x - p1.x;
        if (r2.width < 0) {
            r2.width = -r2.width;
        }
        r2.height = p2.y - p1.y;
        if (r2.height < 0) {
            r2.height = -r2.height;
        }
    }

    private void selectNode(AlbumObject current) {
        FolderTreeNode rootNode = (FolderTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> allChildren = rootNode.breadthFirstEnumeration();
        while (allChildren.hasMoreElements()) {
            FolderTreeNode child = (FolderTreeNode)allChildren.nextElement();
            AlbumObject ao = (AlbumObject)child.getUserObject();
            if (!ao.equals(current)) continue;
            TreeSelectionModel sm = this.tree.getSelectionModel();
            sm.setSelectionPath(new TreePath(child.getPath()));
            break;
        }
    }

    public void setRootFolder(AlbumObject root) {
        this.rootFolder = root;
        FolderTreeNode rootNode = new FolderTreeNode(root);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        int divLocation = (int)this.tree.getPreferredSize().getWidth() + 4;
        if (divLocation < 120) {
            divLocation = 120;
        }
        if (divLocation > 200) {
            divLocation = 200;
        }
        this.splitPane.setDividerLocation(divLocation);
        treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e2) {
                Object[] path = e2.getPath();
                Object[] children = e2.getChildren();
                FolderTreeNode node = (FolderTreeNode)path[0];
                if (children != null) {
                    node = (FolderTreeNode)children[0];
                }
                AlbumObject ao = (AlbumObject)node.getUserObject();
                ao.setName(node.toString());
            }

            public void treeNodesInserted(TreeModelEvent e2) {
            }

            public void treeNodesRemoved(TreeModelEvent e2) {
            }

            public void treeStructureChanged(TreeModelEvent e2) {
            }
        });
        if (this.currentFolder == null) {
            TreeModel tm = this.tree.getModel();
            this.tree.getSelectionModel().setSelectionPath(new TreePath(tm.getRoot()));
        }
    }

    public void setTexts() {
        this.useAsFolderThumbnailAction.putValue("Name", Msg.getString("edit.folderThumbnail"));
        this.useAsFolderThumbnailAction.putValue("ShortDescription", Msg.getString("edit.folderThumbnailToolTip"));
        this.renameAction.putValue("Name", Msg.getString("edit.renameFile"));
        this.updateAction.putValue("Name", Msg.getString("edit.update"));
        this.openAction.putValue("Name", Msg.getString("edit.open"));
        this.propertiesAction.putValue("Name", Msg.getString("edit.properties"));
        this.hideExcludedAction.putValue("Name", Msg.getString("edit.hideExcluded"));
        this.largeThumbnailsAction.putValue("Name", Msg.getString("edit.largeThumbnails"));
        this.deleteAction.putValue("Name", Msg.getString("edit.delete"));
        this.includeSelectedAction.putValue("Name", Msg.getString("edit.include"));
        this.excludeSelectedAction.putValue("Name", Msg.getString("edit.exclude"));
        this.rotateLeftAction.putValue("Name", Msg.getString("edit.rotateLeftToolTip"));
        this.rotateRightAction.putValue("Name", Msg.getString("edit.rotateRightToolTip"));
        this.selectAllAction.putValue("Name", Msg.getString("edit.selectAll"));
        this.invertSelectionAction.putValue("Name", Msg.getString("edit.invertSelection"));
        this.slideShowAction.putValue("Name", Msg.getString("edit.runSlideshow"));
        this.orderByNameAction.putValue("Name", Msg.getString("ui.nameOrdering"));
        this.orderByReverseNameAction.putValue("Name", Msg.getString("edit.reverseNameOrdering"));
        this.orderByDateAction.putValue("Name", Msg.getString("ui.dateOrdering"));
        this.orderByReverseDateAction.putValue("Name", Msg.getString("edit.reverseDateOrdering"));
        this.orderByCameraDateAction.putValue("Name", Msg.getString("edit.cameraDateOrdering"));
        this.useJAlbumOrderingAction.putValue("Name", Msg.getString("edit.jalbumOrdering"));
        this.orderingSubMenu.setText(Msg.getString("edit.orderBy"));
    }

    public void syncModel() {
        LinkedList<AlbumObject> children = new LinkedList<AlbumObject>();
        Component[] comps = this.explorer.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            children.add(jao.ao);
            ++i2;
        }
        try {
            if (this.currentFolder != null) {
                this.currentFolder.setChildren(children);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void viewFolder(AlbumObject folder) {
        if (folder == null) {
            return;
        }
        this.explorer.removeAll();
        List content = folder.getChildren();
        if (content == null) {
            return;
        }
        Iterator it = content.iterator();
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        while (it.hasNext()) {
            AlbumObject ao = (AlbumObject)it.next();
            JAlbumObject jao = new JAlbumObject(ao, this.explorer);
            if (hideExcluded && !jao.ao.isIncluded()) {
                jao.setVisible(false);
            }
            DragSource ds2 = DragSource.getDefaultDragSource();
            DragGestureRecognizer dgr = ds2.createDefaultDragGestureRecognizer(jao, 3, this.explorer);
            jao.addMouseListener(this.mouseOnComponentAdapter);
            jao.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("label")) {
                        JAlbumExplorer.this.syncModel();
                    }
                }
            });
            this.explorer.add(jao);
        }
        this.validate();
        this.repaint();
        this.currentFolder = folder;
    }

    class RenderThread
    extends Thread {
        private int nErrors = 0;

        public RenderThread() {
            this.setDaemon(true);
        }

        public void run() {
            {
                block4: while (true) {
                    Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                    Rectangle view = JAlbumExplorer.this.explorerScrollPane.getViewport().getViewRect();
                    int i2 = 0;
                    while (i2 < comps.length) {
                        JAlbumObject jao = (JAlbumObject)comps[i2];
                        if (!jao.renderingDone && view.intersects(jao.getBounds())) {
                            jao.renderIcon();
                            continue block4;
                        }
                        ++i2;
                    }
                    comps = null;
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    class FolderTreeNode
    extends DefaultMutableTreeNode {
        boolean initialized;

        public FolderTreeNode(Object o2) {
            super(o2);
        }

        public int getChildCount() {
            if (!this.initialized) {
                this.initialized = true;
                this.initialize();
            }
            return super.getChildCount();
        }

        void initialize() {
            AlbumObject thisAO = (AlbumObject)super.getUserObject();
            List children = thisAO.getChildren();
            if (children == null) {
                return;
            }
            Iterator it = children.iterator();
            while (it.hasNext()) {
                AlbumObject ao = (AlbumObject)it.next();
                if (!ao.isFolder()) continue;
                this.add(new FolderTreeNode(ao));
            }
            this.initialized = true;
        }

        public boolean isLeaf() {
            return super.isLeaf();
        }
    }
}

