/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.JPropertyEditor;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;

public class JAlbumObject
extends JComponent
implements Transferable,
PropertyChangeListener {
    static final int MINI_IMAGE_WIDTH = 16;
    final AlbumObject ao;
    static final TexturePaint checkeredPaint;
    static /* synthetic */ Class class$se$datadosen$explorer$JAlbumObject;
    static Image crossImage;
    static ImageIcon defaultImageIcon;
    private boolean editing;
    final JExplorerPanel explorer;
    static final Color faintColor;
    static Image filmImage;
    boolean firstPaint = true;
    JLabel image;
    static Image infoImage;
    private boolean isMediaFile;
    public static DataFlavor jAlbumObjectFlavor;
    JLabel label;
    public static final Font labelFont;
    JPanel labelPanel;
    static Image miniFolderImage;
    JTextField nameField;
    private static int number;
    JPropertyEditor propertyEditor;
    boolean renderingDone = false;
    private boolean rubberbanded;
    private boolean selected;
    static final Color veryLightGray;

    static {
        jAlbumObjectFlavor = new DataFlavor(class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject, "JAlbum object");
        faintColor = new Color(SystemColor.window.getRed(), SystemColor.window.getGreen(), SystemColor.window.getBlue(), 150);
        infoImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/message.png")).getImage();
        miniFolderImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/minifolder_closed.png")).getImage();
        filmImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/film.png")).getImage();
        crossImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/delete2.png")).getImage();
        try {
            defaultImageIcon = new ImageIcon(new File(Config.getConfig().progDir, "res/img.gif").toURL());
        }
        catch (Exception ex) {
        }
        labelFont = new Font("sansserif", 0, 11);
        number = 1;
        veryLightGray = new Color(15526360);
        checkeredPaint = JAlbumObject.getCheckeredPaint();
    }

    public JAlbumObject(AlbumObject ao, JExplorerPanel context) {
        this.ao = ao;
        this.explorer = context;
        ao.addPropertyChangeListener("comment", this);
        this.setPreferredSize(context.objectSize);
        this.setLayout(new BorderLayout());
        try {
            if (ao.isDisplayableImage()) {
                this.image = new JLabel(defaultImageIcon);
            } else {
                this.image = new JLabel(ao.getRepresentingIcon(context.iconBounds, false));
                this.renderingDone = true;
            }
        }
        catch (IOException ex) {
            this.image = new JLabel("No image");
            this.renderingDone = true;
        }
        this.image.setPreferredSize(context.iconBounds);
        this.add((Component)this.image, "North");
        this.label = new JLabel(ao.getName());
        this.label.setFont(labelFont);
        this.label.setOpaque(true);
        this.labelPanel = new JPanel();
        FlowLayout fl = new FlowLayout(1, 0, 1);
        this.labelPanel.setLayout(fl);
        this.labelPanel.setOpaque(false);
        this.labelPanel.add(this.label);
        this.add((Component)this.labelPanel, "Center");
        this.setSelected(this.selected);
        File rep = ao.getRepresentingIconFile();
        if (rep != null && rep.getName().endsWith(".THM")) {
            this.isMediaFile = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static TexturePaint getCheckeredPaint() {
        BufferedImage bi2 = new BufferedImage(2, 2, 2);
        Graphics2D g2 = bi2.createGraphics();
        g2.setBackground(new Color(0, 0, 0, 0));
        g2.clearRect(0, 0, 2, 2);
        g2.setColor(SystemColor.window);
        g2.drawLine(0, 0, 1, 1);
        return new TexturePaint(bi2, new Rectangle(0, 0, 2, 2));
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(jAlbumObjectFlavor)) {
            return this;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{jAlbumObjectFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return true;
    }

    boolean isEditing() {
        return this.editing;
    }

    public boolean isIncluded() {
        return this.ao.isIncluded();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void openPropertyEditor(Component relativeTo) {
        if (this.propertyEditor == null) {
            this.explorer.setCursor(new Cursor(3));
            this.propertyEditor = new JPropertyEditor(this, relativeTo);
            this.propertyEditor.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e2) {
                    JAlbumObject.this.propertyEditor = null;
                }
            });
            this.explorer.setCursor(new Cursor(0));
        }
        this.propertyEditor.setVisible(true);
    }

    public void openPropertyEditor() {
        this.openPropertyEditor(this);
    }

    public void paint(Graphics g2) {
        File rep;
        int xpos = 1;
        if (this.firstPaint) {
            this.updateToolTip();
            this.firstPaint = false;
        }
        Graphics2D g2d = (Graphics2D)g2;
        super.paint(g2);
        if (this.ao.getComment().length() > 0) {
            g2d.drawImage(infoImage, 1, 2, null);
            xpos += 16;
        }
        if (this.explorer.context.currentFolder != null && (rep = this.explorer.context.currentFolder.getRepresentingIconFile()) != null && rep.equals(this.ao.getFile())) {
            g2d.drawImage(miniFolderImage, xpos, 2, null);
            xpos += 16;
        }
        if (this.isMediaFile) {
            g2d.drawImage(filmImage, xpos, 2, null);
        }
        if (!this.ao.isIncluded()) {
            g2.drawImage(crossImage, (this.image.getWidth() - crossImage.getWidth(null)) / 2, (this.image.getHeight() - crossImage.getHeight(null)) / 2, null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("comment".equals(evt.getPropertyName())) {
            this.updateToolTip();
        }
    }

    void renderIcon() {
        try {
            this.image.setIcon(this.ao.getRepresentingIcon(this.explorer.iconBounds, false));
            this.renderingDone = true;
        }
        catch (IOException ex) {
            this.image.setText("Broken");
            this.renderingDone = true;
        }
    }

    public void resetRubberbanded() {
        this.rubberbanded = false;
    }

    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (editing) {
            this.labelPanel.removeAll();
            this.nameField = new JTextField();
            this.nameField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JAlbumObject.this.setEditing(false);
                }
            });
            this.nameField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        JAlbumObject.this.nameField.setText(JAlbumObject.this.ao.getName());
                        JAlbumObject.this.setEditing(false);
                    }
                }
            });
            this.labelPanel.add(this.nameField);
            this.nameField.setText(this.ao.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.ao.getName().length());
            this.nameField.setPreferredSize(this.labelPanel.getSize());
            this.labelPanel.validate();
            this.nameField.requestFocus();
        } else {
            String newName = this.nameField.getText();
            boolean success = false;
            if (!newName.equals(this.ao.getName())) {
                this.setLabel(newName);
            }
            this.label.setText(this.ao.getName());
            this.labelPanel.removeAll();
            this.labelPanel.add(this.label);
            this.updateToolTip();
            this.labelPanel.validate();
            this.repaint();
        }
    }

    public void setIncluded(boolean included) {
        this.ao.setIncluded(included);
        this.repaint();
    }

    public void setLabel(String name) {
        String oldName = this.ao.getName();
        if (!this.ao.setName(name)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.firePropertyChange("label", oldName, name);
        }
    }

    public void setRubberbanded(boolean rubberbanded) {
        if (this.rubberbanded != rubberbanded) {
            this.setSelected(!this.selected);
        }
        this.rubberbanded = rubberbanded;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.image.setBorder(new LineBorder(SystemColor.textHighlight, 3));
            this.label.setForeground(SystemColor.textHighlightText);
            this.label.setBackground(SystemColor.textHighlight);
        } else {
            this.setEditing(false);
            this.image.setBorder(new LineBorder(veryLightGray, 1));
            this.label.setForeground(SystemColor.textText);
            this.label.setBackground(SystemColor.text);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [name=" + this.ao.getName() + "]";
    }

    private void updateToolTip() {
        String comment = this.ao.getComment();
        if (comment != null && comment.length() > 0) {
            this.setToolTipText("<html><body>" + this.ao.getComment() + "</body></html>");
        } else if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
    }
}

