/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.SmartFlowLayout;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;

public class JExplorerPanel
extends JPanel
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    public static final int LABEL_HEIGHT = 20;
    public static final int LARGE_OBJECT_SIZE = 160;
    public static final int SMALL_OBJECT_SIZE = 96;
    Point caretLocation;
    JAlbumObject closestComp;
    final JAlbumExplorer context;
    Dimension iconBounds;
    boolean insertBefore;
    Dimension objectSize;
    SmartFlowLayout ourLayout = new SmartFlowLayout();
    static final Color rubberBandColor = new Color(SystemColor.textHighlight.getRed(), SystemColor.textHighlight.getGreen(), SystemColor.textHighlight.getBlue(), 70);
    Rectangle rubberband;
    ExplorerSelectionModel selectionModel = new ExplorerSelectionModel(this);
    private transient Vector structureListeners;

    public JExplorerPanel(JAlbumExplorer context) {
        this.context = context;
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
        this.setIconBounds(new Dimension(96, 96));
        this.ourLayout.setAlignment(0);
        this.ourLayout.setHgap(32);
        this.ourLayout.setVgap(26);
        this.setLayout(this.ourLayout);
        this.setDropTarget(new DropTarget(this, this));
    }

    public synchronized void addStructureListener(StructureListener l2) {
        Vector v2;
        Vector vector = v2 = this.structureListeners == null ? new Vector(2) : (Vector)this.structureListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.structureListeners = v2;
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragExit(DropTargetEvent dte) {
        this.caretLocation = null;
        this.repaint();
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        event.startDrag(null, (JAlbumObject)event.getComponent(), this);
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getSourceActions());
        Rectangle r2 = new Rectangle(dtde.getLocation(), new Dimension(60, 60));
        r2.translate(-30, -30);
        this.scrollRectToVisible(r2);
        Point dragLocation = dtde.getLocation();
        int xpos = this.getInsets().left;
        int ypos = this.getInsets().top;
        JAlbumObject jao = this.closestComp = (JAlbumObject)this.getNearestComponent(dragLocation);
        if (jao != null) {
            ypos = jao.getY() - 2;
            int center = jao.getX() + jao.getWidth() / 2;
            boolean bl2 = this.insertBefore = dragLocation.x < center;
            xpos = this.insertBefore ? jao.getX() - this.ourLayout.hgap / 2 : jao.getX() + jao.getWidth() + this.ourLayout.hgap / 2;
        }
        this.caretLocation = new Point(xpos, ypos);
        if (jao != null && jao.isSelected()) {
            this.caretLocation = null;
            this.closestComp = null;
        }
        this.repaint();
    }

    public void drop(DropTargetDropEvent dtde) {
        this.caretLocation = null;
        if (this.getComponentCount() > 0 && this.closestComp == null) {
            dtde.rejectDrop();
            return;
        }
        LinkedList<JAlbumObject> tmpList = new LinkedList<JAlbumObject>();
        Component[] comps = this.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (jao.isSelected()) {
                this.remove(jao);
                tmpList.add(jao);
            }
            ++i2;
        }
        if (tmpList.size() > 0) {
            comps = this.getComponents();
            int insertIndex = 0;
            int i3 = 0;
            while (i3 < comps.length) {
                if (comps[i3] == this.closestComp) {
                    insertIndex = i3;
                    if (this.insertBefore) break;
                    ++insertIndex;
                    break;
                }
                ++i3;
            }
            Iterator it = tmpList.iterator();
            while (it.hasNext()) {
                this.add((Component)((JAlbumObject)it.next()), insertIndex++);
            }
            this.fireStructureChanged(new StructureEvent(this));
        }
        this.validate();
        this.repaint();
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                dtde.dropComplete(true);
            }
            catch (Exception exc) {
                System.err.println(exc);
                exc.printStackTrace();
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    protected void fireStructureChanged(StructureEvent e2) {
        if (this.structureListeners != null) {
            Vector listeners = this.structureListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((StructureListener)listeners.elementAt(i2)).structureChanged(e2);
                ++i2;
            }
        }
    }

    Component getNearestComponent(Point p2) {
        Component nearestComp = null;
        Rectangle smallest = null;
        Component[] comps = this.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            Rectangle bounds = comps[i2].getBounds();
            if (bounds.contains(p2)) {
                return comps[i2];
            }
            bounds.add(p2);
            if (smallest == null || bounds.width * bounds.height < smallest.width * smallest.height) {
                smallest = bounds;
                nearestComp = comps[i2];
            }
            ++i2;
        }
        return nearestComp;
    }

    JAlbumObject getNextComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        int i2 = 0;
        while (i2 < comps.length - 1) {
            if (comps[i2] == rel) {
                return (JAlbumObject)comps[i2 + 1];
            }
            ++i2;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension p2 = super.getPreferredSize();
        int preferredWidth = this.getParent().getWidth();
        return new Dimension(preferredWidth, p2.height);
    }

    JAlbumObject getPreviousComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        int i2 = 1;
        while (i2 < comps.length) {
            if (comps[i2] == rel) {
                return (JAlbumObject)comps[i2 - 1];
            }
            ++i2;
        }
        return null;
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        return (dropAction & 2) != 0;
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.rubberband != null) {
            g2.setColor(rubberBandColor);
            g2.fillRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
            g2.setColor(SystemColor.textHighlight);
            g2.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        }
        if (this.caretLocation != null) {
            g2.setColor(Color.black);
            Point cl2 = this.caretLocation;
            int h2 = this.objectSize.height + 4;
            g2.fillRect(cl2.x, cl2.y, 2, h2);
            g2.drawLine(cl2.x - 2, cl2.y, cl2.x + 3, cl2.y);
            g2.drawLine(cl2.x - 1, cl2.y + 1, cl2.x + 2, cl2.y + 1);
            g2.drawLine(cl2.x - 2, cl2.y + h2, cl2.x + 3, cl2.y + h2);
            g2.drawLine(cl2.x - 1, cl2.y + h2 - 1, cl2.x + 2, cl2.y + h2 - 1);
        }
    }

    public synchronized void removeStructureListener(StructureListener l2) {
        if (this.structureListeners != null && this.structureListeners.contains(l2)) {
            Vector v2 = (Vector)this.structureListeners.clone();
            v2.removeElement(l2);
            this.structureListeners = v2;
        }
    }

    public void setIconBounds(Dimension bounds) {
        this.iconBounds = bounds;
        this.objectSize = new Dimension(this.iconBounds.width, this.iconBounds.height + 20);
    }
}

