/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JPropertyEditor
extends JDialog {
    AlbumObject ao;
    JButton cancelButton;
    JTextArea commentArea;
    JLabel commentLabel;
    final ImageCache imageCache;
    JBackgroundPanel imagePanel;
    boolean isLastFolder = false;
    JAlbumObject jao;
    ControlPanel mainPanel;
    ControlPanel metaPanel;
    JButton nextButton;
    Action nextImageAction;
    JButton okButton;
    JButton previousButton;
    Action previousImageAction;
    final Component relativeTo;
    RiverLayout riverLayout1 = new RiverLayout(8, 6);
    JTabbedPane tabs = new JTabbedPane();
    JTextField title;
    JLabel titleLabel;

    public JPropertyEditor(JAlbumObject jao, Component relativeTo) {
        super((JFrame)jao.getTopLevelAncestor());
        this.mainPanel = new ControlPanel();
        this.metaPanel = new ControlPanel();
        this.imagePanel = new JBackgroundPanel();
        this.titleLabel = new JLabel(Msg.getString("edit.titleLabel"));
        this.commentLabel = new JLabel(Msg.getString("edit.commentLabel"));
        this.okButton = new JButton(Msg.getString("ok"));
        this.cancelButton = new JButton(Msg.getString("cancel"));
        this.commentArea = new JSmartTextArea(4, 32);
        this.title = new JTextField();
        this.imageCache = jao.explorer.context.imageCache;
        this.ao = jao.ao;
        this.jao = jao;
        this.relativeTo = relativeTo;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getRootPane().setDefaultButton(this.okButton);
        this.setDefaultCloseOperation(2);
        this.commentArea.setLineWrap(true);
        this.commentArea.setWrapStyleWord(true);
        this.commentLabel.setLabelFor(this.commentArea);
        this.commentLabel.setDisplayedMnemonic('C');
        KeyStroke pgUp = KeyStroke.getKeyStroke(33, 0);
        KeyStroke pgDown = KeyStroke.getKeyStroke(34, 0);
        this.previousImageAction = new AbstractAction(Msg.getString("wiz.back")){

            public void actionPerformed(ActionEvent evt) {
                JAlbumObject dest = JPropertyEditor.this.jao.explorer.getPreviousComponent(JPropertyEditor.this.jao);
                JPropertyEditor.this.moveTo(dest);
                if (dest != null) {
                    JAlbumObject previous = dest.explorer.getPreviousComponent(dest);
                    JPropertyEditor.this.imageCache.preload(previous != null ? previous.ao : null);
                }
            }
        };
        this.previousImageAction.putValue("AcceleratorKey", pgUp);
        this.nextImageAction = new AbstractAction(Msg.getString("wiz.next")){

            public void actionPerformed(ActionEvent evt) {
                JAlbumObject dest = JPropertyEditor.this.jao.explorer.getNextComponent(JPropertyEditor.this.jao);
                JPropertyEditor.this.moveTo(dest);
                if (dest != null) {
                    JAlbumObject next = JPropertyEditor.this.jao.explorer.getNextComponent(dest);
                    JPropertyEditor.this.imageCache.preload(next != null ? next.ao : null);
                }
            }
        };
        this.nextImageAction.putValue("AcceleratorKey", pgDown);
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JPropertyEditor.this.storeChanges();
                JPropertyEditor.this.dispose();
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JPropertyEditor.this.dispose();
            }
        };
        JLayeredPane pane = this.getLayeredPane();
        String name = "cancel-dialog";
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        pane.registerKeyboardAction(cancelAction, name, ks, 2);
        this.previousButton = new JButton(this.previousImageAction);
        this.nextButton = new JButton(this.nextImageAction);
        this.cancelButton.addActionListener(cancelAction);
        this.okButton.addActionListener(okAction);
        AbstractAction prevComponent = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                ((Component)e2.getSource()).transferFocusBackward();
            }
        };
        AbstractAction nextComponent = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                ((Component)e2.getSource()).transferFocus();
            }
        };
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        this.commentArea.registerKeyboardAction(prevComponent, "prevComponent", shiftTab, 0);
        this.commentArea.registerKeyboardAction(nextComponent, "nextComponent", tab, 0);
        JComponent c2 = (JComponent)this.getContentPane();
        c2.registerKeyboardAction(this.previousImageAction, "pgUpAction", pgUp, 2);
        c2.registerKeyboardAction(this.nextImageAction, "pgDownAction", pgDown, 2);
        this.commentArea.registerKeyboardAction(this.previousImageAction, "pgUpAction", pgUp, 0);
        this.commentArea.registerKeyboardAction(this.nextImageAction, "pgDownAction", pgDown, 0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                try {
                    JPropertyEditor.this.updateIcon();
                }
                catch (IOException ex) {
                }
            }
        });
        c2.setLayout(this.riverLayout1);
        this.tabs.add(Msg.getString("ui.mainPanel"), this.mainPanel);
        c2.add("hfill vfill", this.tabs);
        c2.add("br right", this.previousButton);
        c2.add(this.nextButton);
        c2.add(this.okButton);
        c2.add(this.cancelButton);
        RiverLayout rl = (RiverLayout)this.mainPanel.getLayout();
        rl.setExtraInsets(new Insets(4, 4, 4, 4));
        this.imagePanel.setPreferredSize(new Dimension(350, 300));
        this.imagePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.layoutMainPanel();
        Point p2 = this.relativeTo.getLocationOnScreen();
        this.updateUI();
        JAlbumObject next = this.jao.explorer.getNextComponent(this.jao);
        this.imageCache.preload(next != null ? next.ao : null);
        this.setLocationRelativeTo(this.relativeTo);
        this.commentArea.requestFocus();
    }

    private void layoutMainPanel() {
        this.mainPanel.add("hfill vfill", this.imagePanel);
        if (this.ao.isFolder()) {
            this.isLastFolder = true;
            this.mainPanel.add("p", this.titleLabel);
            this.mainPanel.add("br hfill", this.title);
            this.mainPanel.add("br", this.commentLabel);
        } else {
            this.isLastFolder = false;
            this.mainPanel.add("p", this.commentLabel);
        }
        this.mainPanel.add("br hfill", new JScrollPane(this.commentArea));
        this.pack();
    }

    void moveTo(JAlbumObject dest) {
        if (dest == null) {
            return;
        }
        this.storeChanges();
        this.jao.propertyEditor = null;
        this.jao = dest;
        this.jao.propertyEditor = this;
        this.ao = this.jao.ao;
        try {
            this.updateUI();
        }
        catch (IOException ex) {
        }
    }

    private Image scaleToFit(Image image, Dimension boundingBox, boolean highQualityScaling) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int scaleType = highQualityScaling ? 4 : 2;
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        return image.getScaledInstance(newWidth, newHeight, scaleType);
    }

    private void storeChanges() {
        try {
            if (!this.commentArea.getText().equals(this.ao.getComment())) {
                this.ao.setComment(this.commentArea.getText());
                this.jao.explorer.repaint();
            }
            if (this.ao.isFolder()) {
                AlbumObjectMetadata meta = this.ao.getMetadata();
                if (!this.title.getText().equals(meta.getTitle())) {
                    meta.setTitle(this.title.getText());
                    this.ao.setMetadata(meta);
                }
            }
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void updateIcon() throws IOException {
        if (this.ao.isDisplayableImage()) {
            Image closeup = this.imageCache.getImage(this.ao);
            closeup = this.scaleToFit(closeup, this.imagePanel.getSize(), false);
            this.imagePanel.setBackgroundImage(closeup);
        } else {
            Image closeup = this.ao.getRepresentingIcon(this.imagePanel.getSize(), false).getImage();
            this.imagePanel.setBackgroundImage(closeup);
        }
        this.imagePanel.repaint();
    }

    private void updateUI() throws IOException {
        this.setTitle(Msg.getString("edit.propertyEditorTitle") + " " + this.ao.getName());
        this.imagePanel.setBackgroundImage(null);
        this.titleLabel.setVisible(this.ao.isFolder());
        this.title.setVisible(this.ao.isFolder());
        this.updateIcon();
        if (this.ao.isFolder()) {
            this.title.setText(this.ao.getMetadata().getTitle());
        }
        this.commentArea.setText(this.ao.getComment());
        if (this.ao.isFolder() != this.isLastFolder) {
            this.mainPanel.removeAll();
            this.layoutMainPanel();
        }
    }
}

