/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import se.datadosen.explorer.ImageCache;
import se.datadosen.jalbum.AlbumObject;

public class JSlideShow
extends JFrame {
    List albumObjects;
    BorderLayout borderLayout1 = new BorderLayout();
    Image currentImage;
    int currentIndex;
    JLabel imageLabel = new JLabel();
    Image nextImage;
    Image previousImage;
    Dimension screenSize = this.getGraphicsConfiguration().getBounds().getSize();
    ImageCache slideCache = new ImageCache(4, this.screenSize);

    public JSlideShow(List albumObjects, AlbumObject start) {
        try {
            this.albumObjects = albumObjects;
            this.jbInit();
            int i2 = 0;
            while (i2 < albumObjects.size()) {
                AlbumObject ao = (AlbumObject)albumObjects.get(i2);
                if (ao == start) {
                    this.currentIndex = i2;
                    this.showImage(i2);
                    return;
                }
                ++i2;
            }
            this.showImage(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void backward() {
        if (this.currentIndex > 0) {
            this.showImage(--this.currentIndex);
        }
    }

    void first() {
        this.currentIndex = 0;
        this.showImage(this.currentIndex);
    }

    void forward() {
        if (this.currentIndex < this.albumObjects.size() - 1) {
            this.showImage(++this.currentIndex);
        } else {
            this.imageLabel.setIcon(null);
        }
    }

    void jbInit() throws Exception {
        this.setUndecorated(true);
        Container c2 = this.getContentPane();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                switch (e2.getKeyCode()) {
                    case 27: {
                        JSlideShow.this.setVisible(false);
                        JSlideShow.this.slideCache.dispose();
                        JSlideShow.this.dispose();
                        break;
                    }
                    case 10: 
                    case 32: 
                    case 34: 
                    case 39: 
                    case 40: {
                        JSlideShow.this.forward();
                        break;
                    }
                    case 8: 
                    case 33: 
                    case 37: 
                    case 38: {
                        JSlideShow.this.backward();
                        break;
                    }
                    case 36: {
                        JSlideShow.this.first();
                        break;
                    }
                    case 35: {
                        JSlideShow.this.last();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (e2.getButton() == 1) {
                    JSlideShow.this.forward();
                } else if (e2.getButton() == 3) {
                    JSlideShow.this.backward();
                }
            }
        });
        this.imageLabel.setHorizontalAlignment(0);
        c2.setBackground(Color.black);
        c2.setLayout(this.borderLayout1);
        c2.add((Component)this.imageLabel, "Center");
        this.setSize(this.screenSize);
    }

    void last() {
        this.currentIndex = this.albumObjects.size() - 1;
        this.showImage(this.currentIndex);
    }

    void showImage(int index) {
        try {
            ImageIcon icon = new ImageIcon(this.slideCache.getImage((AlbumObject)this.albumObjects.get(index)));
            this.currentImage = icon.getImage();
            this.imageLabel.setIcon(icon);
            if (index < this.albumObjects.size() - 1) {
                this.slideCache.preload((AlbumObject)this.albumObjects.get(index + 1));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

