/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.metadata.Directory;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.netbeans.editor.WeakPropertyChangeSupport;
import photoorganizer.formats.StrippedJpeg;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.DateResetter;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.StringCodec;

public class AlbumObjectImpl
implements AlbumObject {
    private WeakPropertyChangeSupport changeSupport;
    LinkedList children;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$se$datadosen$explorer$JAlbumObject;
    String comment;
    private static DateResetter dateResetter = new DateResetter();
    AlbumObjectFactory factory;
    private static ImageIcon faintFolderImage;
    File file;
    private static ImageIcon folderImage;
    boolean included = true;
    AlbumObjectMetadata meta;
    private AlbumObject parent;
    private AlbumObject representingAlbumObject;

    static {
        folderImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = AlbumObjectImpl.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/folder_closed.png"));
        faintFolderImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = AlbumObjectImpl.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/folder_closed_faint.png"));
    }

    AlbumObjectImpl(File file, AlbumObject parent, AlbumObjectFactory factory) {
        this.file = file;
        this.parent = parent;
        this.factory = factory;
        if (this.isFolder()) {
            File f2 = this.getFolderThumbnailFile();
            if (f2 != null) {
                this.representingAlbumObject = factory.createInstance(f2);
            }
        } else {
            File thumbFile = new File(file.getParentFile(), IO.baseName(file.getName()) + ".THM");
            if (!file.equals(thumbFile) && thumbFile.exists()) {
                this.representingAlbumObject = factory.createInstance(thumbFile);
            }
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void doWriteJPEGComment(String comment) throws IOException {
        long lastModified = this.file.lastModified();
        JAlbumFrame parent = (JAlbumFrame)JAlbum.comp;
        StrippedJpeg jpeg = new StrippedJpeg(this.file);
        String encoding = parent.textEncoding.getSelectedItem().toString();
        StrippedJpeg.setEncoding(encoding);
        if (parent.writeUTF8.isSelected()) {
            encoding = "UTF-8";
        }
        if (!StringCodec.isEncodable(comment, encoding)) {
            encoding = "UTF-8";
        }
        jpeg.setComment(comment);
        StrippedJpeg.setEncoding(encoding);
        File tmpFile = File.createTempFile("JAlbum", "JPG");
        jpeg.transform(tmpFile.getAbsolutePath(), 8);
        if (tmpFile.length() < this.file.length() / 2L) {
            throw new IOException(Msg.getString("edit.commentWritingError"));
        }
        IO.copyFile(tmpFile, this.file);
        if (!this.file.setLastModified(lastModified)) {
            dateResetter.addFile(this.file, lastModified);
        }
        tmpFile.delete();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof AlbumObject)) {
            return false;
        }
        AlbumObjectImpl otherAO = (AlbumObjectImpl)o2;
        return this.file.equals(otherAO.file);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        WeakPropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    public List getChildren() {
        if (this.isFolder() && this.children == null) {
            this.children = new LinkedList();
            FileCollection fc = new FileCollection(this.factory.engine, this.file);
            fc.useJAlbumOrdering(true);
            File[] files = fc.listFiles(this.factory.filter, true);
            int i2 = 0;
            while (i2 < files.length) {
                AlbumObjectImpl ao = new AlbumObjectImpl(files[i2], this, this.factory);
                if (fc.isExcluded(files[i2])) {
                    ao.setIncluded(false);
                }
                this.children.addLast(ao);
                ++i2;
            }
        }
        return this.children;
    }

    public String getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        if (this.isFolder()) {
            try {
                Map props = this.getFolderProperties();
                this.comment = (String)props.get("descript");
                return this.comment != null ? this.comment : "";
            }
            catch (IOException ex) {
                return "";
            }
        }
        this.getMetadata();
        this.comment = this.factory.engine.readComment(this.file, this.parent.getFile(), this.meta.imageInfo);
        return this.comment;
    }

    public File getFile() {
        return this.file;
    }

    private Map getFolderProperties() throws IOException {
        return AlbumBean.getFolderProperties(this.file);
    }

    private File getFolderThumbnailFile() {
        return this.factory.engine.getFolderThumbnailFile(this.file);
    }

    public AlbumObjectMetadata getMetadata() {
        if (this.meta == null) {
            try {
                this.meta = new AlbumObjectMetadata(this.file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.meta;
    }

    public String getName() {
        return this.file.getName();
    }

    public AlbumObject getParent() {
        return this.parent;
    }

    public ImageIcon getRepresentingIcon(Dimension bounds, boolean enlarge) throws IOException {
        if (!this.isDisplayableImage()) {
            ImageIcon repIcon = null;
            if (this.representingAlbumObject != null) {
                repIcon = this.representingAlbumObject.getRepresentingIcon(bounds, enlarge);
                if (this.isFolder() && !this.representingAlbumObject.isFolder()) {
                    Image ri = repIcon.getImage();
                    ri = this.factory.engine.createBufferedImage(ri);
                    Graphics g2 = ri.getGraphics();
                    Image fi = faintFolderImage.getImage();
                    g2.drawImage(fi, (ri.getWidth(null) - fi.getWidth(null)) / 2, (ri.getHeight(null) - fi.getHeight(null)) / 2, null);
                    repIcon = new ImageIcon(ri);
                }
                return repIcon;
            }
            repIcon = this.isFolder() ? folderImage : new ImageIcon(FileFilters.getIconFor(this.file, this.factory.engine).toURL());
            return repIcon;
        }
        try {
            this.getMetadata();
            if (this.meta.imageInfo != null && this.meta.imageInfo.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumObjectImpl.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
                Directory dir2 = this.meta.imageInfo.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumObjectImpl.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                byte[] rawImage = (byte[])dir2.getObject(61441);
                ImageIcon ii = new ImageIcon(rawImage);
                return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, false, enlarge), this.file);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(FileFilters.getExtensionOf(this.file));
            if (it.hasNext()) {
                ImageReader ir = it.next();
                ImageInputStream iis = ImageIO.createImageInputStream(this.file);
                ir.setInput(iis);
                int minIndex = ir.getMinIndex();
                if (ir.hasThumbnails(minIndex)) {
                    BufferedImage bi2 = ir.readThumbnail(minIndex, minIndex);
                    iis.close();
                    if (bi2 != null) {
                        return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(new ImageIcon(bi2), bounds, false, enlarge), this.file);
                    }
                } else {
                    iis.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        ImageIcon ii = new ImageIcon(FileFilters.loadImage(this.file, this.factory.engine));
        return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, false, enlarge), this.file);
    }

    public File getRepresentingIconFile() {
        if (this.representingAlbumObject != null) {
            return this.representingAlbumObject.getRepresentingIconFile();
        }
        if (this.isFolder()) {
            return null;
        }
        return this.file;
    }

    public void invalidate() {
        this.children = null;
    }

    public boolean isDisplayableImage() {
        return !FileFilters.hasIcon(this.file);
    }

    public boolean isFolder() {
        return this.file.isDirectory();
    }

    public boolean isIncluded() {
        return this.included;
    }

    public Image loadImage() throws IOException {
        if (!this.isDisplayableImage()) {
            return null;
        }
        BufferedImage im = FileFilters.loadImage(this.file, this.factory.engine);
        this.getMetadata();
        if (im.getWidth() > im.getHeight()) {
            return RotationSupport.adjustOrientation(im, this.file);
        }
        return im;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void rotateLeft() throws IOException {
        int r2 = RotationSupport.getOrientation(this.meta.imageInfo);
        switch (r2) {
            case 1: {
                RotationSupport.setOrientation(8, this.file);
                break;
            }
            case 6: {
                RotationSupport.setOrientation(1, this.file);
            }
        }
        this.meta = null;
    }

    public void rotateRight() throws IOException {
        int r2 = RotationSupport.getOrientation(this.meta.imageInfo);
        switch (r2) {
            case 1: {
                RotationSupport.setOrientation(6, this.file);
                break;
            }
            case 8: {
                RotationSupport.setOrientation(1, this.file);
            }
        }
        this.meta = null;
    }

    static ImageIcon scaleToFit(ImageIcon image, Dimension boundingBox, boolean highQualityScaling, boolean enlarge) {
        int width = image.getIconWidth();
        int height = image.getIconHeight();
        if (!enlarge && width <= boundingBox.width && height <= boundingBox.height) {
            return image;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int scaleType = highQualityScaling ? 4 : 2;
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        return new ImageIcon(image.getImage().getScaledInstance(newWidth, newHeight, scaleType));
    }

    public void setChildren(List children) throws IOException {
        this.children = (LinkedList)children;
        StringBuffer content = new StringBuffer();
        content.append("# This file is created by JAlbum. It sets custom file filtering and ordering for this image directory.\r\n# Each row indicate a file and it's order. Files not listed here are added to the end of the album\r\n# Rows beginning with \"-\" indicate excluded files.\r\n# To revert to filename or date ordering, remove or rename this file\r\n# Note: This file allows absolute paths to files and directories in other locations and thereby\r\n# allows you to compile albums consisting of files from several different locations.\r\n\r\n");
        Iterator it = children.iterator();
        while (it.hasNext()) {
            AlbumObjectImpl ao = (AlbumObjectImpl)it.next();
            if (!ao.isIncluded()) {
                content.append('-');
            }
            if (ao.file.getParentFile().equals(this.file)) {
                content.append(ao.getName());
            } else {
                content.append(ao.file.getAbsolutePath());
            }
            content.append("\r\n");
        }
        File orderingFile = new File(this.file, "albumfiles.txt");
        String textEncoding = this.factory.engine.isWriteUTF8() ? "UTF-8" : this.factory.engine.getTextEncoding();
        String s2 = content.toString();
        if (!textEncoding.equals("UTF-8") && !StringCodec.isEncodable(s2, textEncoding)) {
            textEncoding = "UTF-8";
        }
        IO.writeTextFile(s2, orderingFile, textEncoding);
    }

    static void setComment(String comment, File file, File oldFile) {
        try {
            File mapFile = new File(file.getParentFile(), "comments.properties");
            if (mapFile.exists()) {
                Map map = IO.readMapFile(mapFile);
                String oldComment = (String)map.get(file.getName());
                if (!comment.equals(oldComment)) {
                    if (oldFile != null) {
                        map.remove(oldFile.getName());
                    }
                    map.put(file.getName(), comment);
                    IO.writeMapFile(map, mapFile);
                }
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(file.getName(), comment);
                IO.writeMapFile(map, mapFile);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void setComment(String newComment) throws IOException {
        String oldComment = this.comment;
        if (newComment.equals(oldComment)) {
            return;
        }
        if (this.isFolder()) {
            Map props = this.getFolderProperties();
            props.put("descript", newComment);
            this.setFolderProperties(props);
            this.comment = newComment;
        } else {
            String ext;
            AlbumObjectImpl.setComment(newComment, this.file, null);
            this.comment = newComment;
            if (((JAlbumFrame)JAlbum.comp).prefsPanel.autoWriteCommentsToFile.isSelected() && ((ext = FileFilters.getExtensionOf(this.file)).equals("jpeg") || ext.equals("jpg"))) {
                new Thread("CommentWritingThread"){

                    public void run() {
                        try {
                            AlbumObjectImpl.this.doWriteJPEGComment(AlbumObjectImpl.this.comment);
                        }
                        catch (IOException ex) {
                            Debug.showErrorDialog(null, ex);
                        }
                    }
                }.start();
            }
        }
        this.firePropertyChange("comment", oldComment, newComment);
    }

    private void setFolderProperties(Map properties) throws IOException {
        IO.writeMapFile(properties, new File(this.file, "meta.properties"));
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public void setMetadata(AlbumObjectMetadata metadata) throws IOException {
        if (this.isFolder()) {
            Map props = this.getFolderProperties();
            if (metadata.getTitle() != null) {
                props.put("title", metadata.getTitle());
            } else {
                props.remove("title");
            }
            this.setFolderProperties(props);
        }
    }

    public boolean setName(String newName) {
        File renamedFile = new File(this.file.getParentFile(), newName);
        if (!IO.extensionOf(newName).equals(IO.extensionOf(this.file))) {
            renamedFile = new File(renamedFile.getParentFile(), IO.baseName(renamedFile) + "." + IO.extensionOf(this.file));
        }
        if (this.file.renameTo(renamedFile)) {
            AlbumObjectImpl.setComment(this.getComment(), renamedFile, this.file);
            this.file = renamedFile;
            return true;
        }
        return false;
    }

    public void setRepresentingIconFile(File f2) {
        try {
            Map props = this.getFolderProperties();
            props.remove("folderIconDirectory");
            if (f2 == null) {
                props.remove("folderIcon");
                this.representingAlbumObject = null;
            } else {
                props.put("folderIcon", IO.relativePath(f2, this.file));
                this.representingAlbumObject = this.factory.createInstance(f2);
            }
            this.setFolderProperties(props);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public String toString() {
        return this.getName();
    }
}

