/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.net.URL;
import java.util.Locale;
import javax.swing.UIManager;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.SmartResourceBundle;

public class Config {
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbum;
    public String language = "default";
    private String lookAndFeel;
    public File pluginsDir;
    public File progDir = new File("").getAbsoluteFile();
    public File skinsDir;
    private static Config theConfig;
    private String webHostListUrl = "http://jalbum.net/web-hosts.xml";

    private Config() {
        this.newProgDir();
        if (!this.skinsDir.exists() || !this.pluginsDir.exists()) {
            URL url;
            File classPath = new File(System.getProperty("java.class.path"));
            this.progDir = classPath.exists() ? classPath.getParentFile().getAbsoluteFile() : ((url = (class$se$datadosen$jalbum$JAlbum == null ? (class$se$datadosen$jalbum$JAlbum = Config.class$("se.datadosen.jalbum.JAlbum")) : class$se$datadosen$jalbum$JAlbum).getResource("../../../")) != null ? new File(url.getFile()).getParentFile() : new File(""));
            this.newProgDir();
        }
        this.setNewLookAndFeel(System.getProperty("swing.defaultlaf") == null ? UIManager.getSystemLookAndFeelClassName() : System.getProperty("swing.defaultlaf"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static Config getConfig() {
        if (theConfig == null) {
            theConfig = new Config();
        }
        return theConfig;
    }

    public String getInterpretedLanguage() {
        return this.language.equals("default") ? System.getProperty("user.language") : this.language;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public String getNewLookAndFeel() {
        return this.lookAndFeel;
    }

    public String getWebHostListUrl() {
        return this.webHostListUrl;
    }

    private void newProgDir() {
        SmartResourceBundle.setDefaultDir(this.progDir);
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }

    public void setLanguage(String language) {
        this.language = language;
        if (!language.equals("default")) {
            Locale.setDefault(new Locale(language, System.getProperty("user.country")));
        } else {
            Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        Msg.reloadBundle();
    }

    public void setNewLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public void setProgramDirectory(String progDir) {
        this.setProgramDirectory(new File(progDir));
    }

    public void setProgramDirectory(File progDir) {
        this.progDir = progDir;
        this.newProgDir();
    }

    public void setSkinsDirectory(String skinsDir) {
        this.setSkinsDirectory(new File(skinsDir));
    }

    public void setSkinsDirectory(File skinsDir) {
        this.skinsDir = skinsDir;
    }

    public void setWebHostListUrl(String webHostListUrl) {
        this.webHostListUrl = webHostListUrl;
    }
}

