/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.FileDateComparator;
import se.datadosen.jalbum.FileNameComparator;
import se.datadosen.jalbum.SimpleFileNameComparator;
import se.datadosen.util.IO;

class FileCollection {
    File baseDir;
    File customOrderFile;
    boolean doSort = false;
    AlbumBean engine;
    Set excluded = new HashSet();
    Set included;

    public FileCollection(AlbumBean engine, File baseDir) {
        this.engine = engine;
        this.baseDir = baseDir;
        this.customOrderFile = new File(baseDir, "albumfiles.txt");
    }

    private File getFile(String fileName) {
        File f2 = new File(fileName);
        if (!f2.isAbsolute()) {
            f2 = new File(this.baseDir, fileName);
        }
        return f2;
    }

    public boolean isCustomOrder() {
        return this.customOrderFile.exists();
    }

    public boolean isExcluded(File f2) {
        return this.excluded.contains(f2);
    }

    public File[] listFiles(FileFilter ff, boolean includeExcluded) {
        if (!this.isCustomOrder()) {
            return this.sort(this.baseDir.listFiles(ff));
        }
        try {
            this.excluded = new HashSet();
            LinkedList<File> list = new LinkedList<File>();
            String text = IO.readTextFile(this.customOrderFile);
            StringTokenizer lines = new StringTokenizer(text, "\n");
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                File f2 = this.getFile(line);
                if (f2.exists() && ff.accept(f2)) {
                    list.addLast(f2);
                    continue;
                }
                if (!line.startsWith("-")) continue;
                f2 = this.getFile(line.substring(1));
                this.excluded.add(f2);
                if (!includeExcluded || !f2.exists() || !ff.accept(f2)) continue;
                list.add(f2);
            }
            this.included = new HashSet(list);
            File[] content = this.baseDir.listFiles(ff);
            int i2 = 0;
            while (i2 < content.length) {
                File f3 = content[i2];
                if (!this.included.contains(f3) && !this.excluded.contains(f3)) {
                    if (includeExcluded || !this.engine.isExcludeByDefault()) {
                        list.add(f3);
                    }
                    if (this.engine.isExcludeByDefault()) {
                        this.excluded.add(f3);
                    }
                }
                ++i2;
            }
            File[] files = list.toArray(new File[list.size()]);
            return this.sort(files);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            throw new RuntimeException(ex.toString());
        }
    }

    public File[] listFiles(FileFilter ff) {
        return this.listFiles(ff, false);
    }

    private File[] sort(File[] files) {
        if (this.doSort && !this.isCustomOrder()) {
            String imageOrdering = this.engine.getImageOrdering();
            boolean reverseOrder = this.engine.isReverseOrder();
            boolean directoriesFirst = this.engine.isDirectoriesFirst();
            Comparator customImageOrdering = this.engine.getCustomImageOrdering();
            Comparator fileComparator = customImageOrdering != null ? customImageOrdering : (imageOrdering.equals("OrderByDate") ? new FileDateComparator(reverseOrder, directoriesFirst) : (imageOrdering.equals("OrderByName") ? new FileNameComparator(reverseOrder, directoriesFirst) : new SimpleFileNameComparator(reverseOrder, directoriesFirst)));
            Arrays.sort(files, fileComparator);
        }
        return files;
    }

    public void useJAlbumOrdering(boolean doSort) {
        this.doSort = doSort;
    }
}

