/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JIconButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

public class JAccountProfilesDialog
extends JDialog {
    JList accountList;
    JLabel accountListLabel;
    JTextField accountName;
    JLabel accountNameLabel;
    Vector accounts;
    static final File accountsFile = new File(System.getProperty("user.home"), ".jalbum-ftp-accounts.xml");
    JButton addAccountButton;
    BorderLayout borderLayout3;
    JPanel buttonPanel;
    JButton cancelButton;
    JAlbumFrame parent;
    JButton removeAccountButton;
    RiverLayout riverLayout1 = new RiverLayout();
    JScrollPane scrollPane;
    JButton selectButton;

    public JAccountProfilesDialog(JAlbumFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.accountListLabel = new JLabel();
        this.accountList = new JList();
        this.scrollPane = new JScrollPane(this.accountList);
        this.borderLayout3 = new BorderLayout();
        this.accountName = new JTextField();
        this.buttonPanel = new JPanel();
        this.addAccountButton = new JIconButton();
        this.removeAccountButton = new JIconButton();
        this.selectButton = new JButton();
        this.cancelButton = new JButton();
        this.accountNameLabel = new JLabel();
        this.accounts = new Vector();
        this.parent = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    void accountList_keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 127) {
            this.removeAccountButton_actionPerformed(null);
        }
    }

    public void addAccount(String name) {
        Vector<String> names = new Vector<String>();
        Iterator it = this.accounts.iterator();
        while (it.hasNext()) {
            Account account = (Account)it.next();
            names.add(account.name);
        }
        name = JAccountProfilesDialog.uniqueName(name, names);
        try {
            this.parent.ui2Engine();
            Properties allProps = BeanBinder.getProperties(this.parent.engine);
            HashMap props = new HashMap();
            JAccountProfilesDialog.copyProperty("ftpServer", allProps, props);
            JAccountProfilesDialog.copyProperty("ftpPort", allProps, props);
            JAccountProfilesDialog.copyProperty("passiveMode", allProps, props);
            JAccountProfilesDialog.copyProperty("ftpUser", allProps, props);
            JAccountProfilesDialog.copyProperty("ftpPassword", allProps, props);
            JAccountProfilesDialog.copyProperty("remoteDirectory", allProps, props);
            JAccountProfilesDialog.copyProperty("ftpWebDirectory", allProps, props);
            JAccountProfilesDialog.copyProperty("webRoot", allProps, props);
            JAccountProfilesDialog.copyProperty("ftpForceUTF8", allProps, props);
            JAccountProfilesDialog.copyProperty("secureFtp", allProps, props);
            this.accounts.add(new Account(name, props));
            this.saveAccounts();
            if (this.isVisible()) {
                this.accountList.setListData(this.accounts);
            }
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    void addAccountButton_actionPerformed(ActionEvent e2) {
        this.addAccount(this.accountName.getText());
    }

    void cancelButton_actionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private static void copyProperty(String name, Map from, Map to) {
        to.put(name, from.get(name));
    }

    private void jbInit() throws Exception {
        Container content = this.getContentPane();
        content.setLayout(this.riverLayout1);
        this.accountListLabel.setText(Msg.getString("acc.profilesLabel"));
        this.accountListLabel.setIcon(this.parent.accountsIcon);
        this.accountList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    JAccountProfilesDialog.this.selectButton_actionPerformed(null);
                }
            }
        });
        this.addAccountButton.setText(Msg.getString("add"));
        this.addAccountButton.setIcon(this.parent.addAccountIcon);
        this.addAccountButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAccountProfilesDialog.this.addAccountButton_actionPerformed(e2);
            }
        });
        this.removeAccountButton.setText(Msg.getString("remove"));
        this.removeAccountButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAccountProfilesDialog.this.removeAccountButton_actionPerformed(e2);
            }
        });
        this.selectButton.setText(Msg.getString("select"));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAccountProfilesDialog.this.selectButton_actionPerformed(e2);
            }
        });
        this.cancelButton.setText(Msg.getString("cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAccountProfilesDialog.this.cancelButton_actionPerformed(e2);
            }
        });
        this.accountNameLabel.setText(Msg.getString("acc.profileName"));
        this.accountList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                JAccountProfilesDialog.this.accountList_keyPressed(e2);
            }
        });
        content.add(this.accountListLabel);
        content.add("br hfill vfill", this.scrollPane);
        ControlPanel newProfile = new ControlPanel(Msg.getString("acc.newProfileBorder"));
        newProfile.add("hfill", this.accountName);
        newProfile.add(this.addAccountButton);
        content.add("br hfill", newProfile);
        content.add("br right", this.selectButton);
        content.add(this.removeAccountButton);
        content.add(this.cancelButton);
        this.loadAccounts();
    }

    /*
     * WARNING - void declaration
     */
    void loadAccounts() {
        try {
            Element ae;
            String doc;
            if (!accountsFile.exists()) {
                return;
            }
            String rest = doc = IO.readTextFile(accountsFile);
            while ((ae = Elements.getElementByName("account", rest, false)) != null) {
                void var3_4;
                Account a2 = new Account(var3_4.getAttribute("name"), var3_4.getAttributes());
                this.accounts.add(a2);
                rest = var3_4.getPostElement();
            }
            this.accountList.setListData(this.accounts);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    public void removeAccount(String name) {
        this.accounts.remove(new Account(name, null));
        this.saveAccounts();
        this.accountList.setListData(this.accounts);
    }

    void removeAccountButton_actionPerformed(ActionEvent e2) {
        Account account = (Account)this.accountList.getSelectedValue();
        if (account == null) {
            return;
        }
        int answer = JOptionPane.showConfirmDialog(this, MessageFormat.format(Msg.getString("acc.removeAccountInfo"), account.name), Msg.getString("acc.removeAccountTitle"), 0);
        if (answer == 0) {
            this.removeAccount(account.name);
        }
    }

    void saveAccounts() {
        try {
            FileWriter out = new FileWriter(accountsFile);
            Element ftpAccounts = new Element("ftp-accounts");
            Iterator it = this.accounts.iterator();
            while (it.hasNext()) {
                Account account = (Account)it.next();
                Element el = new Element("account");
                el.setAttributes(account.properties);
                el.setAttribute("name", account.name);
                ftpAccounts.addContentElement(el);
            }
            XMLDocument doc = new XMLDocument(ftpAccounts);
            out.write(doc.toString());
            out.close();
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    void selectButton_actionPerformed(ActionEvent e2) {
        try {
            Account account = (Account)this.accountList.getSelectedValue();
            if (account == null) {
                return;
            }
            try {
                this.parent.ui2Engine();
            }
            catch (BeanBinderException ex) {
                Debug.showErrorDialog(this, ex);
            }
            BeanBinder.setProperties((Object)this.parent.engine, account.properties);
            this.parent.engine2UI(true);
            this.setVisible(false);
        }
        catch (BeanBinderException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    public void setVisible(boolean show) {
        if (show) {
            Dimension parentSize = this.getParent().getSize();
            Dimension mySize = this.getSize();
            Point loc = this.getParent().getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
        }
        super.setVisible(show);
    }

    static String uniqueName(String name, AbstractCollection names) {
        if (names.contains(name)) {
            int i2 = name.length() - 1;
            while (i2 >= 0 && Character.isDigit(name.charAt(i2))) {
                --i2;
            }
            String base = name.substring(0, i2 + 1);
            i2 = 1;
            while (names.contains(name = base + i2)) {
                ++i2;
            }
        }
        return name;
    }

    class Account {
        String name;
        Map properties;

        public Account(String name, Map properties) {
            this.name = name;
            this.properties = properties;
        }

        public boolean equals(Object o2) {
            return this.name.equals(o2.toString());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

