/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.incors.plaf.alloy.AlloyLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.UIManager;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumConsole;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.SplashScreen;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Timer;

public class JAlbum {
    public static Component comp = null;
    public static Object initializedOkMonitor = new Object();
    boolean packFrame = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAlbum(String[] args) throws Exception {
        SplashScreen splash = new SplashScreen();
        splash.show();
        File projectFile = null;
        if (args.length > 0) {
            projectFile = new File(args[0]);
        }
        Object object = initializedOkMonitor;
        synchronized (object) {
            JAlbumFrame frame = new JAlbumFrame(projectFile);
            frame.setResizable(true);
            if (this.packFrame) {
                frame.pack();
            } else {
                frame.validate();
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = frame.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            frame.setVisible(true);
            splash.setVisible(false);
        }
    }

    public static void main(String[] args) {
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        File defaultProjectFile = new File(System.getProperty("user.home"), ".jalbum-defaults.jap");
        try {
            boolean macintosh = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
            boolean explicitLookAndFeel = false;
            Config config = Config.getConfig();
            if (defaultProjectFile.exists()) {
                Properties props = IO.readPropertyFile(defaultProjectFile);
                BeanBinder.setProperties((Object)config, props);
                if (props.containsKey("newLookAndFeel")) {
                    explicitLookAndFeel = true;
                }
            }
            if (!macintosh && !explicitLookAndFeel) {
                config.setNewLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
            }
            Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
            BeanBinder.setProperties((Object)Config.getConfig(), commandLineProperties);
            SmartResourceBundle.getBundle("texts/texts");
            if (commandLineProperties.size() > 0 && !commandLineProperties.containsKey("ui")) {
                Timer timer = new Timer();
                timer.start();
                new JAlbumConsole(commandLineProperties);
                System.out.println("Elapsed time: " + timer);
                System.exit(0);
            } else {
                AlloyLookAndFeel.setProperty("alloy.licenseCode", "x#David_Ekholm#y9qpca#do9gyo");
                UIManager.setLookAndFeel(config.getNewLookAndFeel());
                new JAlbum(args);
            }
        }
        catch (MissingResourceException ex) {
            System.err.println("JAlbum: Cannot locate resources. Either set -programDirectory to JAlbum install directory or run JAlbum from its install directory.");
        }
        catch (Exception e2) {
            e2.printStackTrace(System.err);
        }
    }
}

