/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.FileListMenuListener;
import se.datadosen.component.JFileListMenu;
import se.datadosen.component.JIconButton;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumUtils;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.DirectoryFilter;
import se.datadosen.jalbum.JAccountProfilesDialog;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame_AboutBox;
import se.datadosen.jalbum.JConsoleFrame;
import se.datadosen.jalbum.JImageFrame;
import se.datadosen.jalbum.JPrefsPanel;
import se.datadosen.jalbum.JSharePanel;
import se.datadosen.jalbum.JSignupWizard;
import se.datadosen.jalbum.JToolsMenu;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NumericVerifier;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.ProgressDialog;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.UploadProgressDialog;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.Timer;
import visionaut.EasyJFrame;
import visionaut.component.dnd.FileDropEvent;
import visionaut.component.dnd.FileDropListener;
import visionaut.component.dnd.JFileDropPanel;

public class JAlbumFrame
extends EasyJFrame {
    public static final String PROJECT_EXTENSION = ".jap";
    public static final String PROJECT_FILE_NAME = "jalbum-settings.jap";
    ImageIcon accountWizardIcon;
    ImageIcon accountsIcon;
    private JAlbumAdapter adapter;
    ImageIcon addAccountIcon;
    JTabbedPane advancedPanel;
    ImageIcon advancedTabIcon;
    ControlPanel albumPreviewPanel;
    JCheckBox alwaysUploadPages;
    JPanel appearancePanel;
    ControlPanel appearanceSubPanel;
    BorderLayout borderLayout1;
    ButtonModel buttonModel1;
    Config cfg;
    static final String[] charsetNames;
    JButton chooseDirectoryButton;
    JButton chooseOutputDirectoryButton;
    static /* synthetic */ Class class$javax$swing$JFileChooser;
    static /* synthetic */ Class class$se$datadosen$component$JDirectoryChooser;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbumFrame;
    JCheckBox classicReaders;
    Properties cleanProjectSettings = null;
    JTextField closeupDirectory;
    JLabel closeupDirectoryLabel;
    JTextField closeupPrefix;
    JLabel closeupPrefixLabel;
    JTextField cols;
    JLabel colsLabel;
    ControlPanel commentSourcesPanel;
    ImageIcon connectIcon;
    ControlPanel connectionPanel;
    JConsoleFrame console = new JConsoleFrame(this);
    JPanel contentPane;
    JCheckBox copyOriginals;
    Component currentPanel;
    JTextField dateFormat;
    JLabel dateFormatLabel;
    JLabel dateFormatTemplateLabel;
    static final File defaultProjectFile;
    JCheckBox directoriesFirst;
    JTextField directory;
    DeferredChooser directoryChooser;
    JLabel directoryLabel;
    File editDirectory;
    ImageIcon editIcon;
    JAlbumExplorer editPanel;
    JButton editSkinButton;
    ImageIcon editTabIcon;
    JLabel encodingLabel;
    AlbumBean engine;
    ImageIcon engineIcon;
    ImageIcon enginesIcon;
    StringBuffer errorBuffer;
    JCheckBox excludeByDefault;
    JCheckBox exifImageDescription;
    JCheckBox exifUserComment;
    boolean exitOnClose;
    FlowLayout flowLayout1;
    JButton ftpAccountsButton;
    JCheckBox ftpForceUTF8;
    JPasswordField ftpPassword;
    JLabel ftpPasswordLabel;
    JTextField ftpPort;
    JLabel ftpPortLabel;
    JTextField ftpServer;
    JLabel ftpServerLabel;
    JTextField ftpUser;
    JLabel ftpUserNameLabel;
    JTextField ftpWebDirectory;
    JLabel ftpWebDirectoryLabel;
    ControlPanel generalPanel;
    JCheckBox highQualityScaling;
    JCheckBox highQualityThumbs;
    JTextField ignorePattern;
    JLabel ignorePatternLabel;
    ControlPanel imageBoundsPanel;
    ControlPanel imageGenerationPanel;
    ButtonGroup imageLinking;
    ControlPanel imageLinkingPanel;
    JComboBox imageOrdering;
    ControlPanel imageOrderingPanel;
    JComboBox imageSize;
    JLabel imageSizeLabel;
    TitledBorder imageTitle;
    JCheckBox includeDirectories;
    JTextField indexPageName;
    JLabel indexPageNameLabel;
    JCheckBox iptcCaption;
    JMenuItem jCDROMIndexMenuItem;
    JFileDropPanel jFileDropPanel1;
    JMenuItem jHQWebAlbumMenuItem;
    JMenuItem jHardDiskAlbumMenuItem;
    JMenuItem jLargeIndexMenuItem;
    JMenuItem jMediumIndexMenuItem;
    JMenuBar jMenuBar1;
    JMenu jMenuFile;
    JMenuItem jMenuFileExit;
    JMenuItem jMenuFileNew;
    JMenuItem jMenuFileOpen;
    JFileListMenu jMenuFileRecentProjects;
    JMenuItem jMenuFileSave;
    JMenuItem jMenuFileSaveAs;
    JMenuItem jMenuFileSaveAsDefault;
    JMenuItem jMenuFileSaveProjectInAlbum;
    JMenuItem jMenuFileSaveProjectInImageDirectory;
    JMenu jMenuHelp;
    JMenuItem jMenuHelpAbout;
    JMenuItem jMenuHelpCheckForUpdates;
    JMenuItem jMenuHelpConsole;
    JMenuItem jMenuHelpSupporting;
    JMenuItem jMenuHelpTopics;
    JMenuItem jMenuHelpWeb;
    JMenu jMenuPresets;
    JMenu jMenuTools;
    JMenuItem jSmallIndexMenuItem;
    JMenuItem jSmallSizeWebAlbumMenuItem;
    JMenuItem jWebAlbumMenuItem;
    private transient Vector jalbumListeners;
    JCheckBox jpegComment;
    JCheckBox keepMetaData;
    JRadioButton linkOriginals;
    JRadioButton linkOriginalsViaScaled;
    JRadioButton linkScaled;
    private boolean loadHints;
    JPanel mainPanel;
    ImageIcon mainTabIcon;
    JButton makeAlbumButton;
    JCheckBox metaData;
    ControlPanel namingPanel;
    ImageIcon openIcon;
    public PrintStream originalOut;
    JTextField outputDirectory;
    DeferredChooser outputDirectoryChooser;
    JLabel outputDirectoryLabel;
    JFileDropPanel outputDirectoryPanel;
    JTextField pageExtension;
    JLabel pageExtensionLabel;
    JCheckBox passiveMode;
    ImageIcon preferencesTabIcon;
    JPrefsPanel prefsPanel;
    ImageIcon previewIcon;
    JLinkLabel previewLink;
    JLabel previewLinkLabel;
    JButton previewSkinButton;
    JImageFrame previewSkinFrame;
    Thread processThread = null;
    ProgressDialog progressDialog;
    JCheckBox progressiveMode;
    DeferredChooser projectChooser;
    JPanel publishPanel;
    ImageIcon publishTabIcon;
    JSlider qualityPercent;
    JLabel qualityPercentLabel;
    JButton rebuildAllButton;
    BlinkerThread rememberDNDblinker;
    JLabel rememberLabel;
    JTextField remoteDirectory;
    JLabel remoteDirectoryLabel;
    RemoteFSBean remoteFSBean;
    JCheckBox reverseOrder;
    JTextField rows;
    JLabel rowsLabel;
    JCheckBox sameDirectory;
    JCheckBox savePassword;
    JCheckBox secureFtp;
    JSharePanel sharePanel;
    ImageIcon shareTabIcon;
    JLabel signupTipLabel;
    JButton signupWizardButton;
    public JComboBox skin;
    ActionListener skinActionListener;
    JLabel skinLabel;
    ImageIcon skinTabIcon;
    ControlPanel skinUI = null;
    JTextField slideDirectory;
    JLabel slideDirectoryLabel;
    JCheckBox slides;
    JButton smartUploadButton;
    ControlPanel smartUploadPanel;
    JLabel statusBar;
    JComboBox style;
    JLabel styleLabel;
    JCheckBox subdirs;
    JTabbedPane tabbedPanel;
    JButton testConnectionButton;
    JComboBox textEncoding;
    JCheckBox textFileComment;
    JComboBox thumbSize;
    JLabel thumbSizeLabel;
    JTextField thumbnailDirectory;
    JLabel thumbnailDirectoryLabel;
    ControlPanel thumbnailLayoutPanel;
    JTextField thumbnailPrefix;
    JLabel thumbnailPrefixLabel;
    ImageIcon tipIcon;
    Thread updateCheckerThread = null;
    JCheckBox updatedDirsOnly;
    JButton uploadAll;
    ImageIcon uploadIcon;
    JCheckBox urlEncode;
    public DummyCheckBox useLayoutHints;
    JCheckBox useThumbForFolderIcon;
    JScrollPane userVariablesScrollPanel;
    JMapTable userVariablesTable;
    ControlPanel varsPanel;
    JButton viewAlbumButton;
    ImageIcon viewIcon;
    JTextField webRoot;
    JLabel webRootLabel;
    ImageIcon windowIcon;
    JCheckBox writeUTF8;

    static {
        defaultProjectFile = new File(System.getProperty("user.home"), ".jalbum-defaults.jap");
        charsetNames = new String[]{"ISO-8859-1", "US-ASCII", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-8", "windows-1252", Msg.getString("ui.internationalJavaInfo"), "Big5", "Big5-HKSCS", "EUC-CN", "EUC-JP", "euc-jp-linux", "EUC-KR", "EUC-TW", "GB18030", "GBK", "ISCII91", "ISO-2022-CN-CNS", "ISO-2022-CN-GB", "ISO-2022-KR", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "JIS0201", "JIS0208", "JIS0212", "Johab", "KOI8-R", "Shift_JIS", "TIS-620", "windows-1250", "windows-1251", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258", "windows-936", "windows-949", "windows-950"};
    }

    public JAlbumFrame(File projectFile) {
        this.cfg = Config.getConfig();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuFileExit = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuHelpTopics = new JMenuItem();
        this.jMenuHelpWeb = new JMenuItem();
        this.jMenuHelpSupporting = new JMenuItem();
        this.jMenuHelpConsole = new JMenuItem();
        this.jMenuHelpAbout = new JMenuItem();
        this.previewSkinFrame = new JImageFrame();
        this.statusBar = new JLabel();
        this.borderLayout1 = new BorderLayout();
        this.editPanel = new JAlbumExplorer();
        this.errorBuffer = new StringBuffer();
        this.mainPanel = new JPanel();
        this.appearancePanel = new JPanel();
        this.directoryLabel = new JLabel();
        this.directory = new JSmartTextField();
        this.chooseDirectoryButton = new JIconButton();
        this.subdirs = new JCheckBox();
        this.thumbnailLayoutPanel = new ControlPanel();
        this.colsLabel = new JLabel();
        this.cols = new JSmartTextField(4);
        this.thumbSize = new JComboBox<Object>(new Object[]{"240x240", "180x180", "160x160", "120x120", "90x90"});
        this.thumbSizeLabel = new JLabel();
        this.imageSize = new JComboBox<Object>(new Object[]{"1024x1024", "800x800", "720x720", "640x640", "512x512", "400x400"});
        this.imageSizeLabel = new JLabel();
        this.makeAlbumButton = new JIconButton();
        this.directoryChooser = new DeferredChooser(class$se$datadosen$component$JDirectoryChooser == null ? (class$se$datadosen$component$JDirectoryChooser = JAlbumFrame.class$("se.datadosen.component.JDirectoryChooser")) : class$se$datadosen$component$JDirectoryChooser);
        this.outputDirectoryChooser = new DeferredChooser(class$se$datadosen$component$JDirectoryChooser == null ? (class$se$datadosen$component$JDirectoryChooser = JAlbumFrame.class$("se.datadosen.component.JDirectoryChooser")) : class$se$datadosen$component$JDirectoryChooser);
        this.projectChooser = new DeferredChooser(class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = JAlbumFrame.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser);
        this.jFileDropPanel1 = new JFileDropPanel();
        this.tabbedPanel = new JTabbedPane();
        this.advancedPanel = new JTabbedPane();
        this.generalPanel = new ControlPanel();
        this.namingPanel = new ControlPanel();
        this.varsPanel = new ControlPanel();
        this.slides = new JCheckBox();
        this.imageOrderingPanel = new ControlPanel();
        this.dateFormat = new JSmartTextField(16);
        this.dateFormatLabel = new JLabel();
        this.urlEncode = new JCheckBox();
        this.indexPageName = new JTextField(8);
        this.indexPageNameLabel = new JLabel();
        this.viewAlbumButton = new JIconButton();
        this.metaData = new JCheckBox();
        this.updatedDirsOnly = new JCheckBox();
        this.excludeByDefault = new JCheckBox();
        this.classicReaders = new JCheckBox();
        this.useThumbForFolderIcon = new JCheckBox();
        this.dateFormatTemplateLabel = new JLabel();
        this.rebuildAllButton = new JIconButton();
        this.rows = new JSmartTextField(4);
        this.rowsLabel = new JLabel();
        this.appearanceSubPanel = new ControlPanel();
        this.skinLabel = new JLabel();
        this.styleLabel = new JLabel();
        this.skin = new JComboBox();
        this.commentSourcesPanel = new ControlPanel();
        this.textFileComment = new JCheckBox();
        this.jpegComment = new JCheckBox();
        this.iptcCaption = new JCheckBox();
        this.exifUserComment = new JCheckBox();
        this.exifImageDescription = new JCheckBox();
        this.skinActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.skin_actionPerformed(e2);
            }
        };
        this.style = new JComboBox();
        this.outputDirectory = new JSmartTextField();
        this.outputDirectoryPanel = new JFileDropPanel();
        this.outputDirectoryLabel = new JLabel();
        this.chooseOutputDirectoryButton = new JIconButton();
        this.copyOriginals = new JCheckBox();
        this.sameDirectory = new JCheckBox();
        this.imageLinkingPanel = new ControlPanel();
        this.linkOriginals = new JRadioButton();
        this.linkOriginalsViaScaled = new JRadioButton();
        this.linkScaled = new JRadioButton();
        this.imageBoundsPanel = new ControlPanel();
        this.imageGenerationPanel = new ControlPanel();
        this.qualityPercentLabel = new JLabel();
        this.qualityPercent = new JSlider(0, 0, 100, 1);
        this.highQualityScaling = new JCheckBox();
        this.highQualityThumbs = new JCheckBox();
        this.progressiveMode = new JCheckBox();
        this.keepMetaData = new JCheckBox();
        this.imageLinking = new ButtonGroup();
        this.jMenuPresets = new JMenu();
        this.jMenuTools = new JToolsMenu(this);
        this.jSmallSizeWebAlbumMenuItem = new JMenuItem();
        this.jHQWebAlbumMenuItem = new JMenuItem();
        this.jWebAlbumMenuItem = new JMenuItem();
        this.jCDROMIndexMenuItem = new JMenuItem();
        this.jHardDiskAlbumMenuItem = new JMenuItem();
        this.pageExtension = new JTextField();
        this.pageExtensionLabel = new JLabel();
        this.thumbnailDirectory = new JTextField();
        this.thumbnailDirectoryLabel = new JLabel();
        this.closeupDirectory = new JTextField();
        this.closeupDirectoryLabel = new JLabel();
        this.slideDirectory = new JTextField();
        this.slideDirectoryLabel = new JLabel();
        this.thumbnailPrefix = new JTextField();
        this.thumbnailPrefixLabel = new JLabel();
        this.closeupPrefix = new JTextField();
        this.closeupPrefixLabel = new JLabel();
        this.jLargeIndexMenuItem = new JMenuItem();
        this.jMediumIndexMenuItem = new JMenuItem();
        this.jSmallIndexMenuItem = new JMenuItem();
        this.includeDirectories = new JCheckBox();
        this.jMenuFileNew = new JMenuItem();
        this.jMenuFileOpen = new JMenuItem();
        this.jMenuFileRecentProjects = new JFileListMenu(new File(System.getProperty("user.home"), ".jalbum-recent-projects.properties"));
        this.jMenuFileSave = new JMenuItem();
        this.jMenuFileSaveAs = new JMenuItem();
        this.jMenuFileSaveAsDefault = new JMenuItem();
        this.jMenuFileSaveProjectInImageDirectory = new JMenuItem();
        this.jMenuFileSaveProjectInAlbum = new JMenuItem();
        this.editSkinButton = new JIconButton();
        this.userVariablesScrollPanel = new JScrollPane();
        this.userVariablesTable = new JMapTable();
        this.sharePanel = new JSharePanel(this);
        this.publishPanel = new JPanel();
        this.prefsPanel = new JPrefsPanel(this);
        this.useLayoutHints = new DummyCheckBox(this.prefsPanel.useLayoutHints);
        this.connectionPanel = new ControlPanel();
        this.signupTipLabel = new JLabel();
        this.signupWizardButton = new JIconButton();
        this.ftpAccountsButton = new JIconButton();
        this.ftpServerLabel = new JLabel();
        this.ftpServer = new JSmartTextField(15);
        this.ftpUserNameLabel = new JLabel();
        this.ftpUser = new JSmartTextField(15);
        this.ftpPasswordLabel = new JLabel();
        this.ftpPassword = new JPasswordField(15);
        this.remoteDirectoryLabel = new JLabel();
        this.remoteDirectory = new JSmartTextField(15);
        this.ftpWebDirectoryLabel = new JLabel();
        this.ftpWebDirectory = new JSmartTextField(12);
        this.secureFtp = new JCheckBox();
        this.passiveMode = new JCheckBox();
        this.ftpForceUTF8 = new JCheckBox();
        this.testConnectionButton = new JIconButton();
        this.savePassword = new JCheckBox();
        this.webRoot = new JSmartTextField();
        this.previewLink = new JLinkLabel();
        this.smartUploadButton = new JIconButton();
        this.uploadAll = new JIconButton();
        this.remoteFSBean = new RemoteFSBean();
        this.smartUploadPanel = new ControlPanel();
        this.albumPreviewPanel = new ControlPanel();
        this.alwaysUploadPages = new JCheckBox();
        this.webRootLabel = new JLabel();
        this.previewLinkLabel = new JLabel();
        this.reverseOrder = new JCheckBox();
        this.directoriesFirst = new JCheckBox();
        this.imageTitle = new TitledBorder("");
        this.rememberLabel = new JLabel();
        this.ignorePatternLabel = new JLabel();
        this.ignorePattern = new JSmartTextField();
        this.exitOnClose = true;
        this.ftpPortLabel = new JLabel();
        this.ftpPort = new JSmartTextField(4);
        this.previewSkinButton = new JIconButton();
        this.imageOrdering = new JComboBox();
        this.flowLayout1 = new FlowLayout();
        this.encodingLabel = new JLabel();
        this.textEncoding = new JComboBox<String>(charsetNames);
        this.writeUTF8 = new JCheckBox();
        this.jMenuHelpCheckForUpdates = new JMenuItem();
        this.originalOut = System.out;
        this.loadHints = true;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.cols.setInputVerifier(new NumericVerifier());
            this.qualityPercent.setMajorTickSpacing(25);
            this.qualityPercent.setMinorTickSpacing(5);
            this.qualityPercent.setSnapToTicks(true);
            this.qualityPercent.setPaintTicks(true);
            this.qualityPercent.setPaintLabels(true);
            if (projectFile == null && defaultProjectFile.exists()) {
                projectFile = defaultProjectFile;
            }
            this.newProject(projectFile);
            if (this.prefsPanel.checkForUpdates.isSelected()) {
                this.checkForUpdates(true);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public JAlbumFrame() {
        this((File)null);
    }

    public synchronized void addJAlbumListener(JAlbumListener l2) {
        Vector v2;
        Vector vector = v2 = this.jalbumListeners == null ? new Vector(2) : (Vector)this.jalbumListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.jalbumListeners = v2;
        }
    }

    boolean askProjectSave(String title) {
        try {
            if (!this.prefsPanel.showWarnings.isSelected()) {
                return true;
            }
            this.ui2Engine();
            Properties currentProjectSettings = this.getProjectSettings();
            if (this.cleanProjectSettings != null && !currentProjectSettings.equals(this.cleanProjectSettings)) {
                int answer = JOptionPane.showConfirmDialog(this, Msg.getString("ui.saveChangesToProjectQuestion"), title, 1);
                switch (answer) {
                    case 0: {
                        return this.saveProject(false);
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception ex) {}
        return true;
    }

    boolean askStopSharing() {
        if (!this.sharePanel.shareBean.isRunning() || this.sharePanel.shareBean.getShares().size() == 0) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this, Msg.getString("ui.activeSharesWarning"), Msg.getString("ui.exitMenu"), 2, 2);
        return answer == 0;
    }

    void checkForUpdates(final boolean onStartup) {
        this.updateCheckerThread = new Thread("UpdateChecker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        JAlbumFrame.this.statusBar.setText(Msg.getString("ui.updateCheckInfo"));
                        String padVersion = JAlbumFrame.checkPadVersion("http://jalbum.net/pad.xml?java.version=" + IO.urlEncode(System.getProperty("java.version")) + "&jalbum.version=" + IO.urlEncode("6.5.4"));
                        if (padVersion.compareTo("6.5.4") <= 0) {
                            if (!onStartup) {
                                String msg = Msg.getString("ui.versionIsCurrentInfo");
                                JOptionPane.showMessageDialog(JAlbumFrame.this, msg, Msg.getString("ui.checkForUpdates"), 1);
                            }
                            Object var5_5 = null;
                            JAlbumFrame.this.statusBar.setText(Msg.getString("ui.introInfo"));
                            return;
                        }
                        String msg = MessageFormat.format(Msg.getString("ui.newUpdateAvailable"), padVersion);
                        int answer = JOptionPane.showConfirmDialog(JAlbumFrame.this, msg, Msg.getString("ui.checkForUpdatesTitle"), 0, 1);
                        if (answer == 0) {
                            BrowserLauncher.openURL("http://jalbum.net/history.jsp");
                        }
                    }
                    catch (IOException ex) {
                        if (!onStartup) {
                            JOptionPane.showMessageDialog(JAlbumFrame.this, ex.toString(), Msg.getString("ui.checkForUpdatesTitle"), 0);
                        }
                        Object var5_7 = null;
                        JAlbumFrame.this.statusBar.setText(Msg.getString("ui.introInfo"));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.introInfo"));
                    throw throwable;
                }
                Object var5_6 = null;
                JAlbumFrame.this.statusBar.setText(Msg.getString("ui.introInfo"));
            }
        };
        this.updateCheckerThread.start();
    }

    /*
     * WARNING - void declaration
     */
    private static String checkPadVersion(String padUrl) throws IOException {
        String line;
        URL versionUrl = new URL(padUrl);
        BufferedReader in = new BufferedReader(new InputStreamReader(versionUrl.openStream()));
        while ((line = in.readLine()) != null) {
            void var3_3;
            int versionIndex = var3_3.indexOf("<Program_Version>");
            if (versionIndex == -1) continue;
            int versionStartIndex = var3_3.indexOf(">", versionIndex);
            int versionEndIndex = var3_3.indexOf("<", versionStartIndex);
            return var3_3.substring(versionStartIndex + 1, versionEndIndex);
        }
        in.close();
        throw new IOException(Msg.getString("ui.cannotFindVersionInformationError") + " " + versionUrl);
    }

    void chooseDirectoryButton_actionPerformed(ActionEvent e2) {
        int returnVal;
        File d2;
        String dir2 = this.directory.getText();
        if (dir2.length() > 0 && (d2 = new File(dir2)).isDirectory()) {
            this.directoryChooser.setCurrentDirectory(d2);
        }
        if ((returnVal = this.directoryChooser.showOpenDialog(this)) == 0) {
            this.directory.setText(this.directoryChooser.getSelectedFile().getAbsolutePath());
            this.directorySelected();
            this.scanImageDirectory();
        }
    }

    void chooseDirectoryButton_mouseEntered(MouseEvent e2) {
        if (this.prefsPanel.allowBlinkingHints.isSelected() && (this.rememberDNDblinker == null || !this.rememberDNDblinker.isAlive())) {
            this.rememberDNDblinker = new BlinkerThread(this.rememberLabel);
            this.rememberDNDblinker.start();
        }
    }

    void chooseOutputDirectoryButton_actionPerformed(ActionEvent e2) {
        int returnVal;
        if (this.outputDirectory.getText().length() > 0) {
            File dir2 = new File(this.outputDirectory.getText());
            if (!dir2.isAbsolute()) {
                dir2 = new File(this.directory.getText(), this.outputDirectory.getText());
            }
            this.outputDirectoryChooser.setCurrentDirectory(dir2);
        }
        if ((returnVal = this.outputDirectoryChooser.showSaveDialog(this)) == 0) {
            this.outputDirectory.setText(this.outputDirectoryChooser.getSelectedFile().getAbsolutePath());
            this.directorySelected();
        }
    }

    void chooseOutputDirectoryButton_mouseEntered(MouseEvent e2) {
        this.chooseDirectoryButton_mouseEntered(e2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException ex) {
        }
    }

    private void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ex) {
        }
    }

    private void directorySelected() {
        if (this.directory.getText().length() > 0 && (this.sameDirectory.isSelected() || this.outputDirectory.getText().length() > 0)) {
            this.rebuildAllButton.setEnabled(true);
            this.makeAlbumButton.setEnabled(true);
            this.viewAlbumButton.setEnabled(true);
            this.jMenuFileSaveProjectInImageDirectory.setEnabled(true);
            this.jMenuFileSaveProjectInAlbum.setEnabled(true);
        } else {
            this.rebuildAllButton.setEnabled(false);
            this.makeAlbumButton.setEnabled(false);
            this.viewAlbumButton.setEnabled(false);
            this.jMenuFileSaveProjectInImageDirectory.setEnabled(false);
            this.jMenuFileSaveProjectInAlbum.setEnabled(false);
        }
    }

    void directory_keyReleased(KeyEvent e2) {
        this.directorySelected();
    }

    void doMakeAlbum() {
        int res;
        String dir2;
        if (this.engine.isAppendImages() && (this.engine.getLastImageSize() != null && !this.imageSize.getSelectedItem().equals(this.engine.getLastImageSize()) || this.engine.getLastThumbSize() != null && !this.thumbSize.getSelectedItem().equals(this.engine.getLastThumbSize()))) {
            String def = Msg.getString("ui.ignore");
            Object[] options = new String[]{def, Msg.getString("ui.rebuildAll"), Msg.getString("ui.useOldSizes"), Msg.getString("cancel")};
            int res2 = 0;
            if (this.prefsPanel.showWarnings.isSelected()) {
                res2 = JOptionPane.showOptionDialog(this, MessageFormat.format(Msg.getString("ui.newSizeWarning"), this.imageSize.getSelectedItem(), this.thumbSize.getSelectedItem(), this.engine.getLastImageSize(), this.engine.getLastThumbSize()), Msg.getString("ui.newSizeWarningLabel"), 0, 2, null, options, def);
            }
            if (res2 == -1 || res2 == 3) {
                return;
            }
            if (res2 == 1) {
                this.engine.setAppendImages(false);
            }
            if (res2 == 2) {
                this.imageSize.setSelectedItem(this.engine.getLastImageSize());
                this.thumbSize.setSelectedItem(this.engine.getLastThumbSize());
            }
        }
        boolean warn = false;
        if (this.sameDirectory.isSelected()) {
            dir2 = this.directory.getText();
            if (!dir2.equals(this.engine.getDirectory())) {
                warn = true;
            }
        } else {
            dir2 = this.outputDirectory.getText();
            if (!dir2.equals(this.engine.getOutputDirectory())) {
                warn = true;
            }
        }
        if (!(this.directory.getText().equals(dir2) || this.linkScaled.isSelected() || this.copyOriginals.isSelected())) {
            int res3 = 1;
            if (this.prefsPanel.showWarnings.isSelected()) {
                res3 = this.messageBox(Msg.getString("ui.externalLinksWarning"), 19, Msg.getString("ui.makeAlbum"));
            }
            if (res3 != 1) {
                return;
            }
        }
        if (warn && (res = this.messageBox(MessageFormat.format(Msg.getString("ui.makeAlbumInfo"), dir2), 3, Msg.getString("ui.makeAlbum"))) != 1) {
            return;
        }
        try {
            this.ui2Engine();
            if (Runtime.getRuntime().availableProcessors() > 1) {
                this.engine.setNThreads((Integer)this.prefsPanel.nThreads.getSelectedItem());
            }
            this.fireAlbumCreationStarted(new JAlbumEvent(this));
            if (this.processThread == null) {
                this.processThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        block13: {
                            try {
                                try {
                                    JAlbumFrame.this.errorBuffer = new StringBuffer();
                                    Timer timer = new Timer();
                                    timer.start();
                                    JAlbumFrame.this.engine.makeAlbum();
                                    System.out.println("Elapsed time: " + timer);
                                    JAlbumFrame.this.progressDialog.setVisible(false);
                                    JAlbumFrame.this.processThread = null;
                                }
                                catch (Throwable t2) {
                                    JAlbumFrame.this.progressDialog.setVisible(false);
                                    JAlbumFrame.this.processThread = null;
                                    try {
                                        throw t2;
                                    }
                                    catch (ParameterException ex) {
                                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                                        JAlbumFrame.this.statusBar.setText(ex.getMessage());
                                    }
                                    catch (UnsupportedEncodingException ex) {
                                        JAlbumFrame.this.messageBox(MessageFormat.format(Msg.getString("ui.unsupportedEncodingError"), JAlbumFrame.this.engine.getTextEncoding()), 32);
                                        JAlbumFrame.this.statusBar.setText(ex.toString());
                                    }
                                    catch (IOException ex) {
                                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                                        JAlbumFrame.this.statusBar.setText(ex.getMessage());
                                    }
                                    catch (OperationAbortedException ex) {
                                        JAlbumFrame.this.statusBar.setText(Msg.getString("ui.operationAborted"));
                                    }
                                    catch (ElementException ex) {
                                        Debug.showCopyableError(JAlbumFrame.this, ex, Msg.getString("ui.scriptingError"));
                                    }
                                    catch (Throwable t22) {
                                        Debug.showStackTraceDialog(JAlbumFrame.this, t22);
                                    }
                                    Object var9_4 = null;
                                    JAlbumFrame.this.fireAlbumCreationFinished(new JAlbumEvent(this));
                                    JAlbumFrame.this.engine2UI(true);
                                    break block13;
                                }
                                Object var9_3 = null;
                                JAlbumFrame.this.fireAlbumCreationFinished(new JAlbumEvent(this));
                                JAlbumFrame.this.engine2UI(true);
                            }
                            catch (Throwable throwable) {
                                Object var9_5 = null;
                                JAlbumFrame.this.fireAlbumCreationFinished(new JAlbumEvent(this));
                                JAlbumFrame.this.engine2UI(true);
                                throw throwable;
                            }
                        }
                        if (JAlbumFrame.this.errorBuffer.length() > 0) {
                            JScrollPane sp = new JScrollPane();
                            JSmartTextArea ta = new JSmartTextArea(JAlbumFrame.this.errorBuffer.toString());
                            ta.setEditable(false);
                            sp.getViewport().add((Component)ta, null);
                            JOptionPane.showMessageDialog(JAlbumFrame.this, sp, Msg.getString("ui.errorsDuringAlbumGeneration"), 2);
                        }
                    }
                };
                this.processThread.setPriority(1);
                this.progressDialog.abort = false;
                this.processThread.start();
                this.progressDialog.setVisible(true);
            } else {
                this.processThread = null;
            }
        }
        catch (BeanBinderException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    void doUploadAlbum(final boolean fullUpdate) {
        int res = this.messageBox(Msg.getString("ui.uploadConfirmation") + " " + (fullUpdate ? Msg.getString("ui.uploadConfirmation2") : Msg.getString("ui.uploadConfirmation3")) + " " + Msg.getString("ui.uploadConfirmation4") + " ", 3, Msg.getString("ui.uploadConfirmationTitle"));
        if (res != 1) {
            return;
        }
        Thread uploadThread = new Thread("FTP upload"){

            public void run() {
                try {
                    if (!JAlbumFrame.this.testRemoteDirectory()) {
                        return;
                    }
                    UploadBean uploader = new UploadBean();
                    UploadProgressDialog uploadProgress = new UploadProgressDialog(JAlbumFrame.this, Msg.getString("ui.uploadingAlbumTitle"), false);
                    uploader.addUploadListener(uploadProgress);
                    uploader.uploadAlbum(JAlbumFrame.this.engine, fullUpdate);
                    uploadProgress.setVisible(false);
                }
                catch (OperationAbortedException ex) {
                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.uploadAborted"));
                }
                catch (Throwable t2) {
                    Debug.showErrorDialog(JAlbumFrame.this, t2);
                    JAlbumFrame.this.statusBar.setText(t2.getMessage());
                }
            }
        };
        uploadThread.start();
    }

    void editSkinButton_actionPerformed(ActionEvent e2) {
        try {
            File skinLocation = new File(this.cfg.skinsDir, this.skin.getSelectedItem().toString());
            BrowserLauncher.openLocal(skinLocation);
        }
        catch (IOException ex) {
        }
    }

    private static void enableComponents(JComponent comp, boolean enable) {
        comp.setEnabled(enable);
        Component[] components = comp.getComponents();
        int i2 = 0;
        while (i2 < components.length) {
            if (components[i2] instanceof JComponent) {
                JAlbumFrame.enableComponents((JComponent)components[i2], enable);
            }
            ++i2;
        }
    }

    void engine2UI(boolean quick) {
        try {
            if (quick) {
                this.skin.removeActionListener(this.skinActionListener);
            }
            BeanBinder.getProperties((Object)this.engine, this);
            BeanBinder.getProperties((Object)Config.getConfig(), this.prefsPanel);
            if (quick) {
                this.skin.addActionListener(this.skinActionListener);
            }
            this.userVariablesTable.clear();
            TreeMap vars = new TreeMap(this.engine.getUserVariables());
            this.userVariablesTable.putAll(vars);
            this.userVariablesTable.updateUI();
            if (this.skinUI != null) {
                PropertyBinder.syncUI(vars, this.skinUI);
                PropertyBinder.syncUI(this.engine.getSkinVariables(), this.skinUI);
            }
            if (this.currentPanel == this.editPanel) {
                this.updateEditPanel();
            }
            this.fixUIdisabling();
            this.repaint();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    void engine2UI() {
        this.engine2UI(false);
    }

    void engine_imageProcessingFinished(AlbumBeanEvent e2) {
        this.statusBar.setText(MessageFormat.format(Msg.getString("ui.albumGenerationProgress"), new Integer(e2.imageNum), new Integer(e2.imageSum), e2.dir.getName()) + Msg.getString("ui.albumGenerationDone"));
        if (this.processThread == null) {
            e2.abortProcessing();
            this.statusBar.setText(Msg.getString("ui.processingAborted"));
        }
    }

    void engine_imageProcessingStarted(AlbumBeanEvent e2) {
        this.statusBar.setText(MessageFormat.format(Msg.getString("ui.albumGenerationProgress"), new Integer(e2.imageNum), new Integer(e2.imageSum), e2.dir.getName()));
        if (this.processThread == null) {
            e2.abortProcessing();
            this.statusBar.setText(Msg.getString("ui.processingAborted"));
        }
    }

    void executeStript(File f2) {
        if (f2.exists()) {
            try {
                this.engine.processBeanShellFile(f2);
            }
            catch (ElementException ex) {
                Debug.showCopyableError(this, ex, Msg.getString("ui.scriptingError"));
                ex.printStackTrace(System.out);
            }
            catch (OperationAbortedException ex) {
                this.statusBar.setText(Msg.getString("ui.operationAborted"));
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    private static void fillCombo(JComboBox combo, File dir2, FileFilter filter) {
        if (!dir2.isDirectory()) {
            return;
        }
        Object[] files = dir2.listFiles(filter);
        Arrays.sort(files);
        int i2 = 0;
        while (i2 < files.length) {
            combo.addItem(((File)files[i2]).getName());
            ++i2;
        }
    }

    protected void fireAlbumCreationFinished(JAlbumEvent e2) {
        if (this.jalbumListeners != null) {
            Vector listeners = this.jalbumListeners;
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((JAlbumListener)it.next()).albumCreationFinished(e2);
            }
        }
    }

    protected void fireAlbumCreationStarted(JAlbumEvent e2) {
        if (this.jalbumListeners != null) {
            Vector listeners = this.jalbumListeners;
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((JAlbumListener)it.next()).albumCreationStarted(e2);
            }
        }
    }

    protected void fireSkinChanged(JAlbumEvent e2) {
        if (this.jalbumListeners != null) {
            Vector listeners = this.jalbumListeners;
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((JAlbumListener)it.next()).skinChanged(e2);
                it.remove();
            }
        }
    }

    protected void fireSkinUIDisplayed(JAlbumEvent e2) {
        if (this.jalbumListeners != null) {
            Vector listeners = this.jalbumListeners;
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((JAlbumListener)it.next()).skinUIDisplayed(e2);
            }
        }
    }

    protected void fireSkinUIHidden(JAlbumEvent e2) {
        if (this.jalbumListeners != null) {
            Vector listeners = this.jalbumListeners;
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((JAlbumListener)it.next()).skinUIHidden(e2);
            }
        }
    }

    protected void fireStyleChanged(JAlbumEvent e2) {
        if (this.jalbumListeners != null) {
            Vector listeners = this.jalbumListeners;
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((JAlbumListener)it.next()).styleChanged(e2);
            }
        }
    }

    private void fixUIdisabling() {
        this.jMenuFileSave.setEnabled(this.projectChooser.getSelectedFile() != null);
        JAlbumFrame.enableComponents(this.outputDirectoryLabel, !this.sameDirectory.isSelected());
        JAlbumFrame.enableComponents(this.outputDirectory, !this.sameDirectory.isSelected());
        JAlbumFrame.enableComponents(this.copyOriginals, !this.sameDirectory.isSelected());
        this.imageSize.setEnabled(!this.linkOriginals.isSelected());
        this.copyOriginals.setEnabled(!this.linkScaled.isSelected() && !this.sameDirectory.isSelected());
        this.directorySelected();
    }

    void ftpAccountsButton_actionPerformed(ActionEvent e2) {
        JAccountProfilesDialog selector = null;
        selector = new JAccountProfilesDialog(this, Msg.getString("acc.title"), true);
        selector.validate();
        selector.setVisible(true);
    }

    public AlbumBean getEngine() {
        return this.engine;
    }

    private Properties getProjectSettings(boolean full) throws Exception {
        Map.Entry<Object, Object> item;
        Properties props = BeanBinder.getProperties(this.engine);
        props.remove("userVariables");
        props.remove("skinVariables");
        props.remove("appendImages");
        Iterator<Map.Entry<Object, Object>> it = this.userVariablesTable.getMap().entrySet().iterator();
        while (it.hasNext()) {
            item = it.next();
            props.setProperty("user." + item.getKey(), item.getValue().toString());
        }
        if (this.skinUI != null && full) {
            it = PropertyBinder.getProperties(this.skinUI).entrySet().iterator();
            while (it.hasNext()) {
                item = it.next();
                props.setProperty("skin." + item.getKey(), item.getValue().toString());
            }
        }
        return props;
    }

    private Properties getProjectSettings() throws Exception {
        return this.getProjectSettings(false);
    }

    public ControlPanel getSkinUI() {
        return this.skinUI;
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public boolean isSkinUISelected() {
        return this.tabbedPanel.getSelectedComponent() == this.appearancePanel;
    }

    void jCDROMIndexMenuItem_actionPerformed(ActionEvent e2) {
        this.urlEncode.setSelected(false);
        this.sameDirectory.setSelected(false);
        this.sameDirectory_actionPerformed(null);
        this.linkOriginals.setSelected(true);
        this.linkOriginals_actionPerformed(null);
    }

    void jFileDropPanel1_filesDropped(final FileDropEvent e2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                File droppedFile = e2.getFirstFile();
                if (droppedFile.isDirectory()) {
                    JAlbumFrame.this.directory.setText(e2.getFirstFile().getAbsolutePath());
                    JAlbumFrame.this.directorySelected();
                    JAlbumFrame.this.scanImageDirectory();
                } else if (droppedFile.getName().endsWith(JAlbumFrame.PROJECT_EXTENSION)) {
                    JAlbumFrame.this.loadProject(droppedFile);
                } else {
                    JAlbumFrame.this.messageBox(Msg.getString("ui.filesDroppedError"));
                }
            }
        });
    }

    void jHQWebAlbumMenuItem_actionPerformed(ActionEvent e2) {
        this.urlEncode.setSelected(true);
        this.linkOriginalsViaScaled.setSelected(true);
        this.linkOriginalsViaScaled_actionPerformed(null);
        this.sameDirectory.setSelected(true);
        this.sameDirectory_actionPerformed(null);
    }

    void jHardDiskAlbumMenuItem_actionPerformed(ActionEvent e2) {
        this.urlEncode.setSelected(false);
        this.sameDirectory.setSelected(true);
        this.sameDirectory_actionPerformed(null);
        this.linkOriginalsViaScaled.setSelected(true);
        this.linkOriginalsViaScaled_actionPerformed(null);
    }

    void jLargeIndexMenuItem_actionPerformed(ActionEvent e2) {
        this.cols.setText("6");
        this.rows.setText("30");
        this.thumbSize.setSelectedItem("120x120");
    }

    void jMediumIndexMenuItem_actionPerformed(ActionEvent e2) {
        this.cols.setText("4");
        this.rows.setText("3");
        this.thumbSize.setSelectedItem("180x180");
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e2) {
        if (this.exitOnClose) {
            if (this.sharePanel.trayIcon != null) {
                this.setVisible(false);
                return;
            }
            if (!this.askProjectSave(Msg.getString("ui.exitMenu"))) {
                return;
            }
            if (!this.askStopSharing()) {
                return;
            }
            System.exit(0);
        }
    }

    void jMenuFileNew_actionPerformed(ActionEvent e2) {
        this.newProject(defaultProjectFile.exists() ? defaultProjectFile : null);
    }

    void jMenuFileOpen_actionPerformed(ActionEvent e2) {
        int returnVal = this.projectChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.loadProject(this.projectChooser.getSelectedFile());
        }
    }

    void jMenuFileRecentProjects_fileSelected(ActionEvent e2) {
        this.loadProject(new File(e2.getActionCommand()));
    }

    void jMenuFileSaveAsDefault_actionPerformed(ActionEvent e2) {
        this.saveProject(defaultProjectFile);
    }

    void jMenuFileSaveAs_actionPerformed(ActionEvent e2) {
        int returnVal = this.projectChooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.saveProject(this.projectChooser.getSelectedFile());
        }
    }

    void jMenuFileSaveProjectInAlbum_actionPerformed(ActionEvent e2) {
        File projectFile;
        String dir2 = this.sameDirectory.isSelected() ? this.directory.getText() : this.outputDirectory.getText();
        File f2 = new File(dir2);
        if (!f2.isAbsolute()) {
            f2 = new File(this.directory.getText(), this.outputDirectory.getText());
        }
        if (this.saveProject(projectFile = new File(f2, PROJECT_FILE_NAME))) {
            this.messageBox(Msg.getString("ui.projectSavedInAlbumInfo"));
        }
    }

    void jMenuFileSaveProjectInImageDirectory_actionPerformed(ActionEvent e2) {
        File projectFile = new File(this.directory.getText(), PROJECT_FILE_NAME);
        if (this.saveProject(projectFile)) {
            this.messageBox(Msg.getString("ui.projectSavedInImageDirectoryInfo"));
        }
    }

    void jMenuFileSave_actionPerformed(ActionEvent e2) {
        if (this.projectChooser.getSelectedFile() != null) {
            this.saveProject(this.projectChooser.getSelectedFile());
        }
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e2) {
        JAlbumFrame_AboutBox dlg = new JAlbumFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    void jMenuHelpCheckForUpdates_actionPerformed(ActionEvent e2) {
        this.checkForUpdates(false);
    }

    public void jMenuHelpConsole_actionPerformed(ActionEvent e2) {
        this.console.setVisible(true);
    }

    void jMenuHelpSupporting_actionPerformed(ActionEvent e2) {
        try {
            BrowserLauncher.openURL("http://jalbum.net/supporting.jsp");
        }
        catch (IOException ex) {
            this.messageBox(ex.getMessage(), 32);
        }
    }

    void jMenuHelpTopics_actionPerformed(ActionEvent e2) {
        try {
            BrowserLauncher.openLocal(new File(this.cfg.progDir, "help/index.html"));
        }
        catch (IOException ex) {
            this.messageBox(ex.getMessage(), 32);
        }
    }

    void jMenuHelpWeb_actionPerformed(ActionEvent e2) {
        try {
            BrowserLauncher.openURL("http://jalbum.net");
        }
        catch (IOException ex) {
            this.messageBox(ex.getMessage(), 32);
        }
    }

    void jSmallIndexMenuItem_actionPerformed(ActionEvent e2) {
        this.cols.setText("2");
        this.rows.setText("2");
        this.thumbSize.setSelectedItem("360x360");
    }

    void jSmallSizeWebAlbumMenuItem_actionPerformed(ActionEvent e2) {
        this.urlEncode.setSelected(true);
        this.linkScaled.setSelected(true);
        this.linkScaled_actionPerformed(null);
    }

    void jWebAlbumMenuItem_actionPerformed(ActionEvent e2) {
        this.urlEncode.setSelected(true);
        this.linkOriginals.setSelected(true);
        this.linkOriginals_actionPerformed(null);
        this.sameDirectory.setSelected(true);
        this.sameDirectory_actionPerformed(null);
    }

    private void jbInit() throws Exception {
        System.setOut(this.console.getPrintStream());
        System.setErr(this.console.getPrintStream());
        System.out.println("JAlbum 6.5.4 system console. For skin development use");
        System.out.println("This section captures debug prints sent to System.out and System.err");
        System.out.println("The top section evaluates BeanShell expressions (interpreted Java)");
        System.out.println("Press CTRL+E to evaluate an expression. (Evaluates selected text if selection is active)");
        System.out.println("You have access to the basic JAlbum implicit objects such as engine and window");
        System.out.println("\nSample expressions:");
        System.out.println("4*(3+2); // Basic calculations");
        System.out.println("engine.getSkin(); // Use of implicit object");
        System.out.println("for (int i=1; i<10; i++) System.out.println(i); // Iterations");
        System.out.println("window.messageBox(\"You can interact with any Java object\");\n");
        this.progressDialog = new ProgressDialog(this, "", true);
        this.progressDialog.peekButton.setVisible(true);
        JAlbum.comp = this;
        this.windowIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("froghead16x16.png"));
        this.setIconImage(this.windowIcon.getImage());
        if (System.getProperty("java.version").compareTo("1.4") < 0) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Msg.getString("ui.javaVersionError"), "1.4"), "JAlbum", 0);
            System.exit(20);
        }
        this.openIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/folderOpen.png"));
        this.engineIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/gear.png"));
        this.enginesIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/gears.png"));
        this.uploadIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/server_from_client.png"));
        this.editIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/nut_and_bolt.png"));
        this.previewIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/document_view.png"));
        this.viewIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/earth_view.png"));
        this.tipIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/lightbulb_on.png"));
        this.accountWizardIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/magic-wand.png"));
        this.addAccountIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/user1_add.png"));
        this.accountsIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/users1.png"));
        this.connectIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/plug.png"));
        this.mainTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/control_panel.png"));
        this.skinTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/skin_leopard.png"));
        this.editTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/edit_images.png"));
        this.shareTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/earth_connection.png"));
        this.publishTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/publish.png"));
        this.advancedTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/wrench.png"));
        this.preferencesTabIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JAlbumFrame.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/preferences.png"));
        this.setTexts();
        this.projectChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(JAlbumFrame.PROJECT_EXTENSION);
            }

            public String getDescription() {
                return "JAlbum Project files (*.jap)";
            }
        });
        this.scanSkins();
        this.skin.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e2) {
                JAlbumFrame.this.skin_mouseEntered(e2);
            }
        });
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileExit_actionPerformed(e2);
            }
        });
        this.jMenuHelpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
        this.jMenuHelpTopics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuHelpTopics_actionPerformed(e2);
            }
        });
        this.jMenuHelpWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuHelpWeb_actionPerformed(e2);
            }
        });
        this.jMenuHelpSupporting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuHelpSupporting_actionPerformed(e2);
            }
        });
        this.jMenuHelpConsole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuHelpConsole_actionPerformed(e2);
            }
        });
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuHelpAbout_actionPerformed(e2);
            }
        });
        this.directoryLabel.setLabelFor(this.directory);
        this.chooseDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.chooseDirectoryButton_actionPerformed(e2);
            }
        });
        this.subdirs.setSelected(true);
        this.colsLabel.setLabelFor(this.cols);
        this.thumbSizeLabel.setLabelFor(this.thumbSize);
        this.imageSizeLabel.setLabelFor(this.imageSize);
        this.makeAlbumButton.setEnabled(false);
        this.makeAlbumButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.makeAlbumButton_actionPerformed(e2);
            }
        });
        this.directory.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e2) {
                JAlbumFrame.this.directory_keyReleased(e2);
            }
        });
        this.directoryChooser.setFileSelectionMode(1);
        this.outputDirectoryChooser.setFileSelectionMode(1);
        this.chooseDirectoryButton.setMargin(new Insets(1, 3, 1, 3));
        this.chooseDirectoryButton.setIcon(this.openIcon);
        this.chooseDirectoryButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e2) {
                JAlbumFrame.this.chooseDirectoryButton_mouseEntered(e2);
            }
        });
        this.jFileDropPanel1.setComponent(this.directory);
        this.jFileDropPanel1.setComponent(this.thumbnailLayoutPanel);
        this.jFileDropPanel1.setComponent(this.mainPanel);
        this.outputDirectoryPanel.setComponent(this.outputDirectory);
        this.outputDirectoryPanel.setComponent(this.outputDirectoryPanel);
        this.jFileDropPanel1.addFileDropListener(new FileDropListener(){

            public void filesDropped(FileDropEvent e2) {
                JAlbumFrame.this.jFileDropPanel1_filesDropped(e2);
            }
        });
        this.imageSize.setEditable(true);
        this.thumbSize.setEditable(true);
        this.style.setSelectedItem("Plain.css");
        this.style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.setPreviewImage();
                JAlbumFrame.this.fireStyleChanged(new JAlbumEvent(this));
            }
        });
        this.dateFormatLabel.setLabelFor(this.dateFormat);
        this.indexPageNameLabel.setLabelFor(this.indexPageName);
        this.viewAlbumButton.setEnabled(false);
        this.viewAlbumButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.viewAlbumButton_actionPerformed(e2);
            }
        });
        this.dateFormatTemplateLabel.setFont(new Font("Dialog", 0, 10));
        this.rebuildAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.rebuildAllButton_actionPerformed(e2);
            }
        });
        this.rebuildAllButton.setEnabled(false);
        this.rowsLabel.setLabelFor(this.rows);
        this.outputDirectoryPanel.addFileDropListener(new FileDropListener(){

            public void filesDropped(FileDropEvent e2) {
                JAlbumFrame.this.outputDirectoryPanel_filesDropped(e2);
            }
        });
        this.outputDirectoryPanel.setLayout(new RiverLayout());
        this.outputDirectoryLabel.setLabelFor(this.outputDirectory);
        this.chooseOutputDirectoryButton.setMargin(new Insets(1, 3, 1, 3));
        this.chooseOutputDirectoryButton.setIcon(this.openIcon);
        this.chooseOutputDirectoryButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e2) {
                JAlbumFrame.this.chooseOutputDirectoryButton_mouseEntered(e2);
            }
        });
        this.chooseOutputDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.chooseOutputDirectoryButton_actionPerformed(e2);
            }
        });
        this.sameDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.sameDirectory_actionPerformed(e2);
            }
        });
        this.linkOriginals.setActionCommand("LinkOriginals");
        this.linkOriginals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.linkOriginals_actionPerformed(e2);
            }
        });
        this.linkOriginalsViaScaled.setActionCommand("LinkOriginalsViaScaled");
        this.linkOriginalsViaScaled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.linkOriginalsViaScaled_actionPerformed(e2);
            }
        });
        this.linkScaled.setSelected(true);
        this.linkScaled.setActionCommand("LinkScaled");
        this.linkScaled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.linkScaled_actionPerformed(e2);
            }
        });
        this.qualityPercentLabel.setLabelFor(this.qualityPercent);
        this.outputDirectory.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e2) {
                JAlbumFrame.this.outputDirectory_keyReleased(e2);
            }
        });
        this.jSmallSizeWebAlbumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jSmallSizeWebAlbumMenuItem_actionPerformed(e2);
            }
        });
        this.jHQWebAlbumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jHQWebAlbumMenuItem_actionPerformed(e2);
            }
        });
        this.jWebAlbumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jWebAlbumMenuItem_actionPerformed(e2);
            }
        });
        this.jCDROMIndexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jCDROMIndexMenuItem_actionPerformed(e2);
            }
        });
        this.jHardDiskAlbumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jHardDiskAlbumMenuItem_actionPerformed(e2);
            }
        });
        this.pageExtensionLabel.setLabelFor(this.pageExtension);
        this.thumbnailDirectoryLabel.setLabelFor(this.thumbnailDirectory);
        this.thumbnailDirectoryLabel.setEnabled(false);
        this.thumbnailDirectory.setEnabled(false);
        this.closeupDirectoryLabel.setLabelFor(this.closeupDirectory);
        this.closeupDirectoryLabel.setEnabled(false);
        this.closeupDirectory.setEnabled(false);
        this.slideDirectoryLabel.setLabelFor(this.slideDirectory);
        this.slideDirectoryLabel.setEnabled(false);
        this.slideDirectory.setEnabled(false);
        this.thumbnailPrefixLabel.setLabelFor(this.thumbnailPrefix);
        this.thumbnailPrefixLabel.setEnabled(false);
        this.thumbnailPrefix.setEnabled(false);
        this.closeupPrefixLabel.setLabelFor(this.closeupPrefix);
        this.closeupPrefixLabel.setEnabled(false);
        this.closeupPrefix.setEnabled(false);
        this.jLargeIndexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jLargeIndexMenuItem_actionPerformed(e2);
            }
        });
        this.jMediumIndexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMediumIndexMenuItem_actionPerformed(e2);
            }
        });
        this.jSmallIndexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jSmallIndexMenuItem_actionPerformed(e2);
            }
        });
        this.jMenuFileNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.jMenuFileNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileNew_actionPerformed(e2);
            }
        });
        this.jMenuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.jMenuFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileOpen_actionPerformed(e2);
            }
        });
        this.jMenuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.jMenuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileSave_actionPerformed(e2);
            }
        });
        this.jMenuFileSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileSaveAs_actionPerformed(e2);
            }
        });
        this.jMenuFileSaveAsDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileSaveAsDefault_actionPerformed(e2);
            }
        });
        this.jMenuFileRecentProjects.addFileListMenuListener(new FileListMenuListener(){

            public void fileSelected(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileRecentProjects_fileSelected(e2);
            }
        });
        this.jMenuFileSaveProjectInImageDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileSaveProjectInImageDirectory_actionPerformed(e2);
            }
        });
        this.jMenuFileSaveProjectInAlbum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuFileSaveProjectInAlbum_actionPerformed(e2);
            }
        });
        this.editSkinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.editSkinButton_actionPerformed(e2);
            }
        });
        this.publishPanel.setLayout(new RiverLayout());
        this.signupWizardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.signupWizardButton_actionPerformed(e2);
            }
        });
        this.ftpAccountsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.ftpAccountsButton_actionPerformed(e2);
            }
        });
        this.secureFtp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (JAlbumFrame.this.secureFtp.isSelected()) {
                    JAlbumFrame.this.ftpPort.setText("22");
                    JAlbumFrame.this.passiveMode.setEnabled(false);
                    JAlbumFrame.this.ftpForceUTF8.setEnabled(false);
                } else {
                    JAlbumFrame.this.ftpPort.setText("21");
                    JAlbumFrame.this.passiveMode.setEnabled(true);
                    JAlbumFrame.this.ftpForceUTF8.setEnabled(true);
                }
            }
        });
        this.testConnectionButton.setMnemonic('T');
        this.testConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.testConnectionButton_actionPerformed(e2);
            }
        });
        this.savePassword.setEnabled(false);
        this.savePassword.setSelected(true);
        DocumentListener pathCombiner = new DocumentListener(){

            public void changedUpdate(DocumentEvent e2) {
            }

            void combinePaths() {
                String linkText = IO.combinePaths(JAlbumFrame.this.webRoot.getText(), JAlbumFrame.this.remoteDirectory.getText(), '/');
                JAlbumFrame.this.previewLink.setText(linkText);
                if (!JAlbumFrame.this.webRoot.getText().startsWith("http://")) {
                    linkText = "http://" + linkText;
                }
                JAlbumFrame.this.previewLink.setURL(linkText);
            }

            public void insertUpdate(DocumentEvent e2) {
                this.combinePaths();
            }

            public void removeUpdate(DocumentEvent e2) {
                this.combinePaths();
            }
        };
        this.remoteDirectory.getDocument().addDocumentListener(pathCombiner);
        this.webRoot.getDocument().addDocumentListener(pathCombiner);
        this.smartUploadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.smartUploadButton_actionPerformed(e2);
            }
        });
        this.uploadAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.uploadAll_actionPerformed(e2);
            }
        });
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                JAlbumFrame.this.tabbedPanel_stateChanged(e2);
            }
        });
        this.previewSkinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.previewSkinButton_actionPerformed(e2);
            }
        });
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.textEncoding.setEditable(true);
        this.jMenuHelpCheckForUpdates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.jMenuHelpCheckForUpdates_actionPerformed(e2);
            }
        });
        this.jMenuFile.add(this.jMenuFileNew);
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFile.add(this.jMenuFileRecentProjects);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileSave);
        this.jMenuFile.add(this.jMenuFileSaveAs);
        this.jMenuFile.add(this.jMenuFileSaveProjectInImageDirectory);
        this.jMenuFile.add(this.jMenuFileSaveProjectInAlbum);
        this.jMenuFile.add(this.jMenuFileSaveAsDefault);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpCheckForUpdates);
        this.jMenuHelp.add(this.jMenuHelpTopics);
        this.jMenuHelp.add(this.jMenuHelpWeb);
        this.jMenuHelp.add(this.jMenuHelpSupporting);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(this.jMenuHelpConsole);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuPresets);
        this.jMenuBar1.add(this.jMenuTools);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuPresets.add(this.jSmallSizeWebAlbumMenuItem);
        this.jMenuPresets.add(this.jHQWebAlbumMenuItem);
        this.jMenuPresets.add(this.jWebAlbumMenuItem);
        this.jMenuPresets.add(this.jCDROMIndexMenuItem);
        this.jMenuPresets.add(this.jHardDiskAlbumMenuItem);
        this.jMenuPresets.addSeparator();
        this.jMenuPresets.add(this.jLargeIndexMenuItem);
        this.jMenuPresets.add(this.jMediumIndexMenuItem);
        this.setJMenuBar(this.jMenuBar1);
        this.mainPanel.setLayout(new RiverLayout());
        this.mainPanel.add("br", this.directoryLabel);
        this.mainPanel.add("tab hfill", this.directory);
        this.mainPanel.add(this.chooseDirectoryButton);
        this.mainPanel.add("br", this.outputDirectoryLabel);
        this.mainPanel.add("tab hfill", this.outputDirectory);
        this.mainPanel.add(this.chooseOutputDirectoryButton);
        this.mainPanel.add("br", this.sameDirectory);
        this.mainPanel.add(this.copyOriginals);
        this.mainPanel.add(this.subdirs);
        this.mainPanel.add(this.slides);
        Box middleBox = Box.createHorizontalBox();
        this.imageLinkingPanel.add(this.linkOriginals);
        this.imageLinkingPanel.add("br", this.linkOriginalsViaScaled);
        this.imageLinkingPanel.add("br", this.linkScaled);
        middleBox.add(this.imageLinkingPanel);
        this.imageBoundsPanel.add(this.thumbSizeLabel);
        this.imageBoundsPanel.add("tab", this.thumbSize);
        this.imageBoundsPanel.add("br", this.imageSizeLabel);
        this.imageBoundsPanel.add("tab", this.imageSize);
        middleBox.add(Box.createHorizontalStrut(5));
        middleBox.add(this.imageBoundsPanel);
        this.thumbnailLayoutPanel.add("br", this.colsLabel);
        this.thumbnailLayoutPanel.add("tab", this.cols);
        this.thumbnailLayoutPanel.add("br", this.rowsLabel);
        this.thumbnailLayoutPanel.add("tab", this.rows);
        Box lowerBox = Box.createHorizontalBox();
        lowerBox.add(this.thumbnailLayoutPanel);
        lowerBox.add(Box.createHorizontalStrut(5));
        this.mainPanel.add("br hfill", middleBox);
        this.imageOrderingPanel.add(this.imageOrdering);
        this.imageOrderingPanel.add("br", this.reverseOrder);
        this.imageOrderingPanel.add("br", this.directoriesFirst);
        lowerBox.add(this.imageOrderingPanel);
        this.appearanceSubPanel.add(this.skinLabel);
        this.appearanceSubPanel.add("tab hfill", this.skin);
        this.appearanceSubPanel.add("br", this.styleLabel);
        this.appearanceSubPanel.add("tab hfill", this.style);
        this.appearanceSubPanel.add("p", this.previewSkinButton);
        this.appearanceSubPanel.add(this.editSkinButton);
        lowerBox.add(Box.createHorizontalStrut(5));
        lowerBox.add(this.appearanceSubPanel);
        this.mainPanel.add("br hfill", lowerBox);
        this.mainPanel.add("br hfill vfill", Box.createGlue());
        this.mainPanel.add("br hfill", this.rememberLabel);
        this.mainPanel.add(this.rebuildAllButton);
        this.mainPanel.add(this.makeAlbumButton);
        this.mainPanel.add(this.viewAlbumButton);
        this.userVariablesTable.setRowHeight(this.userVariablesTable.getRowHeight() * 4 / 3);
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPane.add((Component)this.tabbedPanel, "Center");
        this.contentPane.add((Component)this.statusBar, "South");
        this.imageLinking.add(this.linkOriginals);
        this.imageLinking.add(this.linkOriginalsViaScaled);
        this.imageLinking.add(this.linkScaled);
        this.mainPanel.setName(Msg.getString("ui.mainPanel"));
        this.tabbedPanel.addTab(Msg.getString("ui.mainPanel"), this.mainTabIcon, this.mainPanel);
        this.appearancePanel.setLayout(new BorderLayout());
        this.appearancePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.editPanel.setName(Msg.getString("ui.editPanel"));
        this.tabbedPanel.addTab(Msg.getString("ui.editPanel"), this.editTabIcon, this.editPanel);
        this.sharePanel.setName(Msg.getString("ui.sharePanel"));
        this.tabbedPanel.addTab(Msg.getString("ui.sharePanel"), this.shareTabIcon, this.sharePanel);
        this.publishPanel.setName(Msg.getString("ui.publishPanel"));
        this.tabbedPanel.addTab(Msg.getString("ui.publishPanel"), this.publishTabIcon, this.publishPanel);
        this.publishPanel.add("br", this.signupTipLabel);
        this.publishPanel.add("hfill", Box.createHorizontalGlue());
        this.publishPanel.add("", this.signupWizardButton);
        this.publishPanel.add("", this.ftpAccountsButton);
        this.publishPanel.add("p hfill", this.connectionPanel);
        this.connectionPanel.add(this.ftpServerLabel);
        this.connectionPanel.add("tab", this.ftpServer);
        this.connectionPanel.add("tab", this.ftpPortLabel);
        this.connectionPanel.add("tab", this.ftpPort);
        this.connectionPanel.add("br", this.ftpUserNameLabel);
        this.connectionPanel.add("tab", this.ftpUser);
        this.connectionPanel.add("tab", this.ftpPasswordLabel);
        this.connectionPanel.add("tab", this.ftpPassword);
        this.connectionPanel.add("br", this.ftpWebDirectoryLabel);
        this.connectionPanel.add("tab", this.ftpWebDirectory);
        this.connectionPanel.add("tab", this.remoteDirectoryLabel);
        this.connectionPanel.add("tab", this.remoteDirectory);
        this.connectionPanel.add("p", this.secureFtp);
        this.connectionPanel.add(this.passiveMode);
        this.connectionPanel.add(this.savePassword);
        this.connectionPanel.add(this.ftpForceUTF8);
        this.connectionPanel.add("hfill", Box.createHorizontalGlue());
        this.connectionPanel.add(this.testConnectionButton);
        this.publishPanel.add("br hfill", this.smartUploadPanel);
        this.smartUploadPanel.add(this.alwaysUploadPages);
        this.albumPreviewPanel.add(this.webRootLabel);
        this.albumPreviewPanel.add("tab hfill", this.webRoot);
        this.albumPreviewPanel.add("br", this.previewLinkLabel);
        this.albumPreviewPanel.add("tab hfill", this.previewLink);
        this.publishPanel.add("br hfill", this.albumPreviewPanel);
        this.publishPanel.add("br hfill vfill", Box.createGlue());
        this.publishPanel.add("br hfill", Box.createGlue());
        this.publishPanel.add(this.smartUploadButton);
        this.publishPanel.add(this.uploadAll);
        this.advancedPanel.setName(Msg.getString("ui.advancedPanel"));
        this.tabbedPanel.addTab(Msg.getString("ui.advancedPanel"), this.advancedTabIcon, this.advancedPanel);
        this.generalPanel.setName(Msg.getString("ui.generalPanel"));
        this.advancedPanel.add((Component)this.generalPanel, Msg.getString("ui.generalPanel"));
        this.namingPanel.setName(Msg.getString("ui.namingPanel"));
        this.advancedPanel.add((Component)this.namingPanel, Msg.getString("ui.namingPanel"));
        this.varsPanel.setName(Msg.getString("ui.varsPanel"));
        this.advancedPanel.add((Component)this.varsPanel, Msg.getString("ui.varsPanel"));
        this.prefsPanel.setName(Msg.getString("ui.prefsPanel"));
        this.advancedPanel.addTab(Msg.getString("ui.prefsPanel"), this.preferencesTabIcon, this.prefsPanel);
        this.namingPanel.add(this.urlEncode);
        this.namingPanel.add("br", this.indexPageNameLabel);
        this.namingPanel.add("tab hfill", this.indexPageName);
        this.namingPanel.add("br", this.pageExtensionLabel);
        this.namingPanel.add("tab hfill", this.pageExtension);
        this.namingPanel.add("br", this.thumbnailDirectoryLabel);
        this.namingPanel.add("tab hfill", this.thumbnailDirectory);
        this.namingPanel.add("br", this.closeupDirectoryLabel);
        this.namingPanel.add("tab hfill", this.closeupDirectory);
        this.namingPanel.add("br", this.slideDirectoryLabel);
        this.namingPanel.add("tab hfill", this.slideDirectory);
        this.namingPanel.add("br", this.thumbnailPrefixLabel);
        this.namingPanel.add("tab hfill", this.thumbnailPrefix);
        this.namingPanel.add("br", this.closeupPrefixLabel);
        this.namingPanel.add("tab hfill", this.closeupPrefix);
        this.generalPanel.add("br", this.encodingLabel);
        this.generalPanel.add("tab", this.textEncoding);
        this.generalPanel.add("", this.writeUTF8);
        this.generalPanel.add("br", this.dateFormatLabel);
        this.generalPanel.add("tab", this.dateFormat);
        this.generalPanel.add(this.dateFormatTemplateLabel);
        this.generalPanel.add("br", this.metaData);
        this.generalPanel.add("", this.classicReaders);
        this.generalPanel.add("br", this.includeDirectories);
        this.generalPanel.add("", this.updatedDirsOnly);
        this.generalPanel.add("br", this.useThumbForFolderIcon);
        this.generalPanel.add("", this.excludeByDefault);
        this.imageGenerationPanel.add("", this.qualityPercentLabel);
        this.imageGenerationPanel.add("", this.qualityPercent);
        this.imageGenerationPanel.add(new JLabel("%"));
        this.imageGenerationPanel.add("br", this.highQualityScaling);
        this.imageGenerationPanel.add(this.highQualityThumbs);
        this.imageGenerationPanel.add(this.progressiveMode);
        this.imageGenerationPanel.add(this.keepMetaData);
        this.generalPanel.add("br hfill", this.imageGenerationPanel);
        this.generalPanel.add("p", this.ignorePatternLabel);
        this.generalPanel.add("hfill", this.ignorePattern);
        this.commentSourcesPanel.add(this.textFileComment);
        this.commentSourcesPanel.add("", this.jpegComment);
        this.commentSourcesPanel.add("", this.iptcCaption);
        this.commentSourcesPanel.add("", this.exifUserComment);
        this.commentSourcesPanel.add("", this.exifImageDescription);
        this.generalPanel.add("br hfill", this.commentSourcesPanel);
        this.userVariablesScrollPanel.setPreferredSize(new Dimension(100, 100));
        this.userVariablesScrollPanel.getViewport().add((Component)this.userVariablesTable, null);
        this.varsPanel.add("br hfill vfill", this.userVariablesScrollPanel);
        if (this.sharePanel.shareBean.isAutoStart()) {
            Thread t2 = new Thread("Web server launcher thread"){

                public void run() {
                    JAlbumFrame.this.sharePanel.startAction.actionPerformed(null);
                }
            };
            t2.setDaemon(true);
            t2.start();
        }
    }

    void linkOriginalsViaScaled_actionPerformed(ActionEvent e2) {
        this.fixUIdisabling();
    }

    void linkOriginals_actionPerformed(ActionEvent e2) {
        this.fixUIdisabling();
    }

    void linkScaled_actionPerformed(ActionEvent e2) {
        this.fixUIdisabling();
    }

    private void loadHints() {
        if (!this.prefsPanel.useLayoutHints.isSelected()) {
            return;
        }
        File hintsFile = new File(this.cfg.skinsDir, (String)this.skin.getSelectedItem() + "/hints.jap");
        if (!hintsFile.exists()) {
            return;
        }
        try {
            Properties props = IO.readPropertyFile(hintsFile);
            this.ui2Engine();
            Iterator it = this.engine.getUserVariables().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e2 = it.next();
                if (!((String)e2.getKey()).startsWith("filter")) continue;
                it.remove();
            }
            BeanBinder.setProperties((Object)this.engine, props);
            Map userVariables = this.engine.getUserVariables();
            userVariables.putAll(AlbumUtils.getUserVariables(props));
            this.engine.setUserVariables(userVariables);
            this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
            this.statusBar.setText(Msg.getString("ui.layoutHintsLoaded") + " " + hintsFile.getAbsolutePath());
            this.engine2UI(true);
        }
        catch (IOException ex) {
            this.engine2UI();
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadProject(File projectFile) {
        try {
            try {
                if (!projectFile.equals(defaultProjectFile) && !this.askProjectSave(Msg.getString("ui.openProjectMenu"))) {
                    Object var5_2 = null;
                    this.loadHints = true;
                    return;
                }
                Properties props = IO.readPropertyFile(projectFile);
                BeanBinder.setProperties((Object)this.engine, props);
                this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
                this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
                if (projectFile.equals(defaultProjectFile)) {
                    BeanBinder.setProperties((Object)Config.getConfig(), props);
                    PropertyBinder.syncUI(props, this.prefsPanel);
                } else {
                    this.jMenuFileRecentProjects.addFileName(projectFile.getAbsolutePath());
                    this.projectChooser.setSelectedFile(projectFile);
                    this.setTitle();
                    this.statusBar.setText(Msg.getString("ui.projectLoaded") + " " + projectFile.getAbsolutePath());
                }
                this.loadHints = false;
                this.engine2UI();
                try {
                    this.cleanProjectSettings = this.getProjectSettings();
                }
                catch (Exception ex) {
                }
            }
            catch (IOException ex) {
                this.engine2UI();
                Object var5_4 = null;
                this.loadHints = true;
                return;
            }
            catch (Exception ex) {
                this.statusBar.setText(ex.getMessage());
                Debug.showErrorDialog(this, ex);
                Object var5_5 = null;
                this.loadHints = true;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.loadHints = true;
            throw throwable;
        }
        Object var5_3 = null;
        this.loadHints = true;
    }

    void makeAlbumButton_actionPerformed(ActionEvent e2) {
        this.engine.setAppendImages(true);
        this.doMakeAlbum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newProject(File projectFile) {
        if (!this.askProjectSave(defaultProjectFile.equals(projectFile) ? Msg.getString("ui.newProjectMenu") : Msg.getString("ui.openProjectMenu"))) {
            return;
        }
        this.engine = new AlbumBean();
        this.engine.addAlbumBeanListener(this.progressDialog);
        this.engine.addAlbumBeanListener(new AlbumBeanListener(){

            public void errorOccured(Throwable t2, File f2) {
                String msg;
                if (t2 instanceof RuntimeException && JAlbumFrame.this.prefsPanel.debugMode.isSelected()) {
                    throw (RuntimeException)t2;
                }
                if (JAlbumFrame.this.errorBuffer.length() == 0) {
                    JAlbumFrame.this.errorBuffer.append(Msg.getString("ui.fileProcessingError") + "\n");
                }
                if ((msg = t2.getMessage()) == null || t2 instanceof RuntimeException) {
                    msg = t2.toString();
                }
                JAlbumFrame.this.errorBuffer.append(f2.getName() + ": " + msg + "\n");
            }

            public void imageProcessingFinished(AlbumBeanEvent e2) {
                JAlbumFrame.this.engine_imageProcessingFinished(e2);
            }

            public void imageProcessingStarted(AlbumBeanEvent e2) {
                JAlbumFrame.this.engine_imageProcessingStarted(e2);
            }
        });
        JAlbumFrame.fillCombo(this.style, new File(this.cfg.skinsDir, this.engine.getSkin() + "/styles"), new StyleFileFilter());
        this.projectChooser.setSelectedFile(null);
        this.setTitle();
        if (projectFile != null) {
            this.loadProject(projectFile);
        } else {
            try {
                this.loadHints = false;
                try {
                    this.engine2UI();
                    Object var3_2 = null;
                    this.loadHints = true;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.loadHints = true;
                    throw throwable;
                }
                this.loadHints();
                this.ui2Engine();
                this.cleanProjectSettings = this.getProjectSettings();
            }
            catch (Exception ex) {
            }
        }
        if (this.updateCheckerThread == null || !this.updateCheckerThread.isAlive()) {
            this.statusBar.setText(Msg.getString("ui.introInfo"));
        }
    }

    void outputDirectoryPanel_filesDropped(FileDropEvent e2) {
        if (e2.getFirstFile().isDirectory()) {
            this.outputDirectory.setText(e2.getFirstFile().getAbsolutePath());
            this.directorySelected();
        } else {
            this.messageBox(Msg.getString("ui.filesDroppedError2"));
        }
    }

    void outputDirectory_keyReleased(KeyEvent e2) {
        this.directorySelected();
    }

    void previewSkinButton_actionPerformed(ActionEvent e2) {
        this.setPreviewImage();
        this.previewSkinFrame.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201 && this.sharePanel.trayIcon != null) {
            this.setVisible(false);
            return;
        }
        if (e2.getID() == 201 && !this.askProjectSave(Msg.getString("ui.exitMenu"))) {
            return;
        }
        if (e2.getID() == 201 && !this.askStopSharing()) {
            return;
        }
        super.processWindowEvent(e2);
        if (e2.getID() == 201) {
            System.exit(0);
        }
    }

    void rebuildAllButton_actionPerformed(ActionEvent e2) {
        this.engine.setAppendImages(false);
        this.doMakeAlbum();
    }

    public synchronized void removeJAlbumListener(JAlbumListener l2) {
        if (this.jalbumListeners != null && this.jalbumListeners.contains(l2)) {
            Vector v2 = (Vector)this.jalbumListeners.clone();
            v2.removeElement(l2);
            this.jalbumListeners = v2;
        }
    }

    private void renameTab(JTabbedPane tabs, JComponent comp, String newName) {
        int index = tabs.indexOfTab(comp.getName());
        if (index != -1) {
            tabs.setTitleAt(index, newName);
            comp.setName(newName);
        }
    }

    void sameDirectory_actionPerformed(ActionEvent e2) {
        this.fixUIdisabling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProject(File projectFile) {
        boolean bl2;
        String fileName = projectFile.getName();
        if (!fileName.endsWith(PROJECT_EXTENSION)) {
            fileName = fileName + PROJECT_EXTENSION;
        }
        projectFile = new File(projectFile.getParentFile(), fileName);
        FileOutputStream fos = null;
        try {
            this.ui2Engine();
            this.cleanProjectSettings = this.getProjectSettings();
            Properties props = this.getProjectSettings(true);
            if (projectFile.equals(defaultProjectFile)) {
                BeanBinder.getProperties((Object)Config.getConfig(), props);
                PropertyBinder.getProperties(this.prefsPanel, props);
            } else {
                this.jMenuFileRecentProjects.addFileName(projectFile.getAbsolutePath());
                this.jMenuFileSave.setEnabled(true);
                this.projectChooser.setSelectedFile(projectFile);
                this.setTitle();
            }
            fos = new FileOutputStream(projectFile);
            props.store(fos, "JAlbum Project");
            this.statusBar.setText(Msg.getString("ui.projectSaved") + " " + projectFile.getAbsolutePath());
            bl2 = true;
            Object var7_8 = null;
            this.close(fos);
        }
        catch (Exception ex) {
            boolean bl3;
            try {
                Debug.showErrorDialog(this, ex);
                this.statusBar.setText(ex.getMessage());
                bl3 = false;
                Object var7_9 = null;
                this.close(fos);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.close(fos);
                throw throwable;
            }
            return bl3;
        }
        return bl2;
    }

    boolean saveProject(boolean alwaysSaveAs) {
        if (alwaysSaveAs || this.projectChooser.getSelectedFile() == null) {
            int returnVal = this.projectChooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.saveProject(this.projectChooser.getSelectedFile());
                return true;
            }
            return false;
        }
        this.saveProject(this.projectChooser.getSelectedFile());
        return true;
    }

    private void scanImageDirectory() {
        int answer;
        File dir2 = new File(this.directory.getText());
        if (!dir2.isDirectory()) {
            return;
        }
        File projectFile = new File(dir2, PROJECT_FILE_NAME);
        if (projectFile.exists() && (answer = this.messageBox(Msg.getString("ui.loadProjectFile"), 12)) == 4) {
            this.loadProject(projectFile);
        }
    }

    void scanSkins() {
        this.skin.removeActionListener(this.skinActionListener);
        Object selected = this.skin.getSelectedItem();
        this.skin.removeAllItems();
        JAlbumFrame.fillCombo(this.skin, this.cfg.skinsDir, new DirectoryFilter());
        this.skin.setSelectedItem(selected);
        this.skin.addActionListener(this.skinActionListener);
        Object newSelected = this.skin.getSelectedItem();
        if (newSelected != null && !newSelected.equals(selected)) {
            this.skin.setSelectedItem(this.skin.getSelectedItem());
        }
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    private void setPreviewImage() {
        String skin = (String)this.skin.getSelectedItem();
        String style = (String)this.style.getSelectedItem();
        if (skin == null || style == null) {
            return;
        }
        File f2 = new File(this.cfg.skinsDir, skin + "/styles/" + IO.baseName(style) + ".jpg");
        if (!f2.exists()) {
            f2 = new File(this.cfg.skinsDir, skin + "/preview.jpg");
        }
        if (f2.exists()) {
            this.previewSkinFrame.setImage(f2);
        } else {
            this.previewSkinFrame.setText(Msg.getString("ui.noPreviewAvailable"));
        }
    }

    public void setSkinUI(ControlPanel ui) {
        if (this.skinUI != null) {
            this.appearancePanel.remove(this.skinUI);
        }
        this.skinUI = ui;
        if (ui != null) {
            this.appearancePanel.add(ui);
            PropertyBinder.syncUI(this.engine.getUserVariables(), ui);
            PropertyBinder.syncUI(this.engine.getSkinVariables(), ui);
        }
        this.tabbedPanel.remove(this.appearancePanel);
        if (ui != null) {
            this.tabbedPanel.insertTab(this.skin.getSelectedItem().toString(), this.skinTabIcon, this.appearancePanel, null, 5);
        }
    }

    public void setTexts() {
        this.renameTab(this.tabbedPanel, this.mainPanel, Msg.getString("ui.mainPanel"));
        this.renameTab(this.tabbedPanel, this.editPanel, Msg.getString("ui.editPanel"));
        this.renameTab(this.tabbedPanel, this.sharePanel, Msg.getString("ui.sharePanel"));
        this.renameTab(this.tabbedPanel, this.publishPanel, Msg.getString("ui.publishPanel"));
        this.renameTab(this.tabbedPanel, this.advancedPanel, Msg.getString("ui.advancedPanel"));
        this.renameTab(this.advancedPanel, this.generalPanel, Msg.getString("ui.generalPanel"));
        this.renameTab(this.advancedPanel, this.namingPanel, Msg.getString("ui.namingPanel"));
        this.renameTab(this.advancedPanel, this.varsPanel, Msg.getString("ui.varsPanel"));
        this.renameTab(this.advancedPanel, this.prefsPanel, Msg.getString("ui.prefsPanel"));
        this.console.setTitle(Msg.getString("ui.consoleMenu"));
        this.previewSkinFrame.setTitle(Msg.getString("ui.skinPreviewTitle"));
        this.jMenuFileRecentProjects.setText(Msg.getString("ui.recentProjectsMenu"));
        this.setTitle(Msg.getString("ui.windowTitle"));
        this.jMenuFileExit.setText(Msg.getString("ui.exitMenu"));
        this.jMenuFile.setText(Msg.getString("ui.fileMenu"));
        this.jMenuHelp.setText(Msg.getString("ui.helpMenu"));
        this.jMenuHelpTopics.setText(Msg.getString("ui.helpTopicsMenu"));
        this.jMenuHelpWeb.setText(Msg.getString("ui.jalbumOnTheWebMenu"));
        this.jMenuHelpSupporting.setText(Msg.getString("ui.supportingJAlbumMenu"));
        this.jMenuHelpConsole.setText(Msg.getString("ui.consoleMenu"));
        this.jMenuHelpAbout.setText(Msg.getString("ui.aboutMenu"));
        this.jMenuPresets.setText(Msg.getString("ui.presetsMenu"));
        this.jMenuTools.setText(Msg.getString("ui.toolsMenu"));
        this.jSmallSizeWebAlbumMenuItem.setText(Msg.getString("ui.smallSizeWebAlbumMenu"));
        this.jHQWebAlbumMenuItem.setText(Msg.getString("ui.hiqhQualityWebAlbumMenu"));
        this.jWebAlbumMenuItem.setText(Msg.getString("ui.smallOriginalsWebAlbumMenu"));
        this.jCDROMIndexMenuItem.setText(Msg.getString("ui.indexWithLinksToCD-ROMOriginalsMenu"));
        this.jHardDiskAlbumMenuItem.setText(Msg.getString("ui.localAlbumMenu"));
        this.jMediumIndexMenuItem.setText(Msg.getString("ui.12ImagesMenu"));
        this.jSmallIndexMenuItem.setText(Msg.getString("ui.4ImagesMenu"));
        this.jMenuFileOpen.setText(Msg.getString("ui.openProjectMenu"));
        this.jMenuFileNew.setText(Msg.getString("ui.newProjectMenu"));
        this.jMenuFileSave.setText(Msg.getString("ui.saveProjectMenu"));
        this.jMenuFileSaveAs.setText(Msg.getString("ui.saveProjectAsMenu"));
        this.jMenuFileSaveAsDefault.setText(Msg.getString("ui.saveAsDefaultMenu"));
        this.jLargeIndexMenuItem.setText(Msg.getString("ui.180ImagesIndexMenu"));
        this.jMenuFileSaveProjectInImageDirectory.setText(Msg.getString("ui.saveProjectInImageDirectoryMenu"));
        this.jMenuFileSaveProjectInAlbum.setText(Msg.getString("ui.saveProjectInAlbumMenu"));
        this.jMenuHelpCheckForUpdates.setText(Msg.getString("ui.checkForUpdatesMenu"));
        this.directoryLabel.setText(Msg.getString("ui.imageDirectoryLabel"));
        this.ignorePatternLabel.setText(Msg.getString("ui.ignorePattern"));
        this.imageGenerationPanel.setTitle(Msg.getString("ui.imageGenerationBorder"));
        this.commentSourcesPanel.setTitle(Msg.getString("ui.commentSourcesBorder"));
        this.commentSourcesPanel.setToolTipText(Msg.getString("ui.commentSourcesToolTip"));
        this.textFileComment.setText(Msg.getString("ui.textFileComment"));
        this.jpegComment.setText(Msg.getString("ui.jpegComment"));
        this.iptcCaption.setText(Msg.getString("ui.iptcCaption"));
        this.exifUserComment.setText(Msg.getString("ui.exifUserComment"));
        this.exifImageDescription.setText(Msg.getString("ui.exifImageDescription"));
        this.progressDialog.setTitle(Msg.getString("ui.generatingAlbumInfo"));
        this.smartUploadPanel.setTitle(Msg.getString("ui.smartUploadBorder"));
        this.imageTitle.setTitle(Msg.getString("ui.imageBorder"));
        this.connectionPanel.setTitle(Msg.getString("ui.ftpConnectionPropertiesBorder"));
        this.imageBoundsPanel.setTitle(Msg.getString("ui.imageBoundsBorder"));
        this.imageOrderingPanel.setTitle(Msg.getString("ui.imageOrderingBorder"));
        this.appearanceSubPanel.setTitle(Msg.getString("ui.appearanceBorder"));
        this.imageLinkingPanel.setTitle(Msg.getString("ui.imageLinkingBorder"));
        this.thumbnailLayoutPanel.setTitle(Msg.getString("ui.thumbnailLayoutBorder"));
        this.subdirs.setText(Msg.getString("ui.processSubdirectoriesCheckbox"));
        this.subdirs.setToolTipText(Msg.getString("ui.processSubdirectoriesToolTip"));
        this.imageSizeLabel.setText(Msg.getString("ui.imagesLabel"));
        this.colsLabel.setText(Msg.getString("ui.columnsLabel"));
        this.thumbSizeLabel.setText(Msg.getString("ui.thumbnailsLabel"));
        this.editSkinButton.setText(Msg.getString("ui.edit"));
        this.editSkinButton.setIcon(this.editIcon);
        this.editSkinButton.setToolTipText(Msg.getString("ui.editToolTip"));
        this.makeAlbumButton.setText(Msg.getString("ui.makeAlbum"));
        this.makeAlbumButton.setIcon(this.engineIcon);
        this.makeAlbumButton.setToolTipText(Msg.getString("ui.makeAlbumToolTip"));
        this.makeAlbumButton.setMnemonic('M');
        this.chooseDirectoryButton.setToolTipText(Msg.getString("ui.chooseDirectoryToolTip"));
        this.directory.setToolTipText(Msg.getString("ui.imageDirectoryToolTip"));
        this.imageSize.setToolTipText(Msg.getString("ui.imageSizeToolTip"));
        this.thumbSize.setToolTipText(Msg.getString("ui.thumbSizeToolTip"));
        this.style.setToolTipText(Msg.getString("ui.styleToolTip"));
        this.slides.setText(Msg.getString("ui.makeSlides"));
        this.slides.setToolTipText(Msg.getString("ui.makeSlidesToolTip"));
        this.dateFormatLabel.setText(Msg.getString("ui.dateFormat"));
        this.urlEncode.setText(Msg.getString("ui.urlEncode"));
        this.urlEncode.setToolTipText(Msg.getString("ui.urlEncodeToolTip"));
        this.indexPageNameLabel.setText(Msg.getString("ui.indexPageName"));
        this.viewAlbumButton.setText(Msg.getString("ui.viewAlbum"));
        this.viewAlbumButton.setIcon(this.viewIcon);
        this.viewAlbumButton.setMnemonic('V');
        this.viewAlbumButton.setToolTipText(Msg.getString("ui.viewAlbumToolTip"));
        this.metaData.setText(Msg.getString("ui.metaData"));
        this.updatedDirsOnly.setText(Msg.getString("ui.updatedDirsOnly"));
        this.updatedDirsOnly.setToolTipText(Msg.getString("ui.updatedDirsOnlyToolTip"));
        this.excludeByDefault.setText(Msg.getString("ui.excludeByDefault"));
        this.excludeByDefault.setToolTipText(Msg.getString("ui.excludeByDefaultToolTip"));
        this.classicReaders.setText(Msg.getString("ui.classicReaders"));
        this.classicReaders.setToolTipText(Msg.getString("ui.classicReadersToolTip"));
        this.useThumbForFolderIcon.setText(Msg.getString("ui.useThumbForFolderIcon"));
        this.useThumbForFolderIcon.setToolTipText(Msg.getString("ui.useThumbForFolderIconToolTip"));
        this.dateFormatTemplateLabel.setText(Msg.getString("ui.dateFormatTemplate"));
        this.dateFormat.setToolTipText(Msg.getString("ui.dateFormatTemplateToolTip"));
        this.ignorePattern.setToolTipText(Msg.getString("ui.ignorePatternToolTip"));
        this.rebuildAllButton.setText(Msg.getString("ui.rebuildAll"));
        this.rebuildAllButton.setIcon(this.enginesIcon);
        this.rebuildAllButton.setToolTipText(Msg.getString("ui.rebuildAllToolTip"));
        this.rebuildAllButton.setMnemonic('R');
        this.rowsLabel.setText(Msg.getString("ui.rows"));
        this.appearanceSubPanel.setToolTipText(Msg.getString("ui.appearancePanelToolTip"));
        this.skinLabel.setLabelFor(this.skin);
        this.skinLabel.setText(Msg.getString("ui.skin"));
        this.styleLabel.setLabelFor(this.style);
        this.styleLabel.setText(Msg.getString("ui.style"));
        this.outputDirectoryLabel.setText(Msg.getString("ui.outputDirectory"));
        this.chooseOutputDirectoryButton.setToolTipText(Msg.getString("ui.outputDirectoryToolTip"));
        this.copyOriginals.setText(Msg.getString("ui.copyOriginals"));
        this.copyOriginals.setToolTipText(Msg.getString("ui.copyOriginalsToolTip"));
        this.sameDirectory.setText(Msg.getString("ui.sameDirectory"));
        this.linkOriginals.setText(Msg.getString("ui.linkToOriginals"));
        this.linkOriginalsViaScaled.setText(Msg.getString("ui.linkToOriginalsViaScaledImages"));
        this.linkScaled.setText(Msg.getString("ui.linkToScaledImagesOnly"));
        this.imageOrdering.removeAllItems();
        this.imageOrdering.addItem(new Item("OrderByDate", Msg.getString("ui.dateOrdering")));
        this.imageOrdering.addItem(new Item("OrderByName", Msg.getString("ui.nameOrdering")));
        this.imageOrdering.addItem(new Item("OrderBySimpleName", Msg.getString("ui.simpleNameOrdering")));
        this.qualityPercentLabel.setText(Msg.getString("ui.jpegQuality"));
        this.highQualityScaling.setText(Msg.getString("ui.highQualityScaling"));
        this.highQualityScaling.setToolTipText(Msg.getString("ui.highQualityScalingToolTip"));
        this.highQualityThumbs.setText(Msg.getString("ui.highQualityThumbs"));
        this.highQualityThumbs.setToolTipText(Msg.getString("ui.highQualityThumbsToolTip"));
        this.progressiveMode.setText(Msg.getString("ui.progressiveMode"));
        this.progressiveMode.setToolTipText(Msg.getString("ui.progressiveModeToolTip"));
        this.keepMetaData.setText(Msg.getString("ui.keepMetaDataInfo"));
        this.keepMetaData.setToolTipText(Msg.getString("ui.keepMetaDataToolTip"));
        this.highQualityScaling.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                JAlbumFrame.this.highQualityThumbs.setEnabled(!JAlbumFrame.this.highQualityScaling.isSelected());
            }
        });
        this.rows.setToolTipText(Msg.getString("ui.rowsToolTip") + Msg.getString("ui.rowsToolTip2"));
        this.qualityPercent.setToolTipText(Msg.getString("ui.qualityPercentToolTip"));
        this.pageExtensionLabel.setText(Msg.getString("ui.pageExtension"));
        this.thumbnailDirectoryLabel.setText(Msg.getString("ui.thumbnailDirectory"));
        this.closeupDirectoryLabel.setText(Msg.getString("ui.closeupDirectory"));
        this.slideDirectoryLabel.setText(Msg.getString("ui.slideDirectory"));
        this.thumbnailPrefixLabel.setText(Msg.getString("ui.thumbnailPrefix"));
        this.closeupPrefixLabel.setText(Msg.getString("ui.closeupPrefix"));
        this.includeDirectories.setText(Msg.getString("ui.includeDirectories"));
        this.userVariablesTable.setToolTipText(Msg.getString("ui.userVariablesToolTip"));
        this.signupTipLabel.setText("<html>" + Msg.getString("ui.signupTipLabel") + "</html>");
        this.signupTipLabel.setIcon(this.tipIcon);
        this.signupWizardButton.setText(Msg.getString("ui.signupWizard"));
        this.signupWizardButton.setIcon(this.accountWizardIcon);
        this.signupWizardButton.setToolTipText(Msg.getString("ui.signupWizardToolTip"));
        this.ftpAccountsButton.setText(Msg.getString("ui.ftpAccounts"));
        this.ftpAccountsButton.setIcon(this.accountsIcon);
        this.ftpAccountsButton.setToolTipText(Msg.getString("ui.ftpAccountsToolTip"));
        this.ftpServerLabel.setText(Msg.getString("ui.ftpServer"));
        this.ftpServer.setToolTipText(Msg.getString("ui.ftpServerToolTip"));
        this.ftpUserNameLabel.setText(Msg.getString("ui.userName"));
        this.ftpUser.setToolTipText(Msg.getString("ui.userNameToolTip"));
        this.ftpPasswordLabel.setText(Msg.getString("ui.password"));
        this.remoteDirectoryLabel.setText(Msg.getString("ui.remoteDirectory"));
        this.remoteDirectory.setToolTipText(Msg.getString("ui.remoteDirectoryToolTip"));
        this.ftpWebDirectoryLabel.setText(Msg.getString("ui.ftpWebDirectory"));
        this.ftpWebDirectory.setToolTipText(Msg.getString("ui.ftpWebDirectoryToolTip"));
        this.secureFtp.setText(Msg.getString("ui.secureFtp"));
        this.secureFtp.setToolTipText(Msg.getString("ui.secureFtpToolTip"));
        this.passiveMode.setText(Msg.getString("ui.passiveMode"));
        this.passiveMode.setToolTipText(Msg.getString("ui.passiveModeToolTip"));
        this.ftpForceUTF8.setText(Msg.getString("ui.ftpForceUTF8"));
        this.ftpForceUTF8.setToolTipText(Msg.getString("ui.ftpForceUTF8ToolTip"));
        this.testConnectionButton.setText(Msg.getString("ui.testConnection"));
        this.testConnectionButton.setIcon(this.connectIcon);
        this.savePassword.setText(Msg.getString("ui.savePassword"));
        this.albumPreviewPanel.setTitle(Msg.getString("ui.albumPreviewBorder"));
        this.webRootLabel.setText(Msg.getString("ui.webRoot"));
        this.previewLinkLabel.setText(Msg.getString("ui.previewLink"));
        this.smartUploadButton.setText(Msg.getString("ui.smartUpload"));
        this.smartUploadButton.setMnemonic('M');
        this.smartUploadButton.setIcon(this.uploadIcon);
        this.smartUploadButton.setToolTipText(Msg.getString("ui.smartUploadToolTip"));
        this.uploadAll.setText(Msg.getString("ui.uploadAll"));
        this.uploadAll.setMnemonic('U');
        this.uploadAll.setIcon(this.uploadIcon);
        this.uploadAll.setToolTipText(Msg.getString("ui.uploadAllToolTip"));
        this.smartUploadPanel.setToolTipText(Msg.getString("ui.smartUploadPanelToolTip"));
        this.alwaysUploadPages.setText(Msg.getString("ui.alwaysUploadPages"));
        this.alwaysUploadPages.setToolTipText(Msg.getString("ui.alwaysUploadPagesToolTip"));
        this.reverseOrder.setText(Msg.getString("ui.reverseOrder"));
        this.directoriesFirst.setText(Msg.getString("ui.directoriesFirst"));
        this.directoriesFirst.setToolTipText(Msg.getString("ui.directoriesFirstToolTip"));
        this.rememberLabel.setText(Msg.getString("ui.tipLabel"));
        this.rememberLabel.setIcon(this.tipIcon);
        this.outputDirectory.setToolTipText(Msg.getString("ui.outputDirectoryToolTip"));
        this.ftpPortLabel.setText(Msg.getString("ui.portToolTip"));
        this.previewSkinButton.setText(Msg.getString("ui.preview"));
        this.previewSkinButton.setIcon(this.previewIcon);
        this.previewSkinButton.setActionCommand("previewSkin");
        this.encodingLabel.setText(Msg.getString("ui.encoding"));
        this.writeUTF8.setText(Msg.getString("ui.writeUTF8"));
        this.writeUTF8.setToolTipText(Msg.getString("ui.writeUTF8ToolTip"));
        this.textEncoding.setToolTipText(Msg.getString("ui.textEncodingToolTip"));
        this.userVariablesTable.setHeaderNames(Msg.getString("ui.userVariablesNameColumn"), Msg.getString("ui.userVariablesValueColumn"));
        this.statusBar.setText("");
        this.editPanel.setTexts();
        this.sharePanel.setTexts();
        this.prefsPanel.setTexts();
    }

    void setTitle() {
        String title = Msg.getString("ui.windowTitle");
        File f2 = this.projectChooser.getSelectedFile();
        if (f2 != null) {
            title = title + " [..." + f2.getParentFile().getName() + File.separatorChar + f2.getName() + "]";
        }
        this.setTitle(title);
    }

    void signupWizardButton_actionPerformed(ActionEvent e2) {
        JSignupWizard wiz = null;
        try {
            wiz = new JSignupWizard(this);
            wiz.pack();
            wiz.setVisible(true);
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
    }

    void skin_actionPerformed(ActionEvent e2) {
        this.fireSkinChanged(new JAlbumEvent(this));
        this.setSkinUI(null);
        Object selected = this.style.getSelectedItem();
        this.style.removeAllItems();
        JAlbumFrame.fillCombo(this.style, new File(this.cfg.skinsDir, (String)this.skin.getSelectedItem() + "/styles"), new StyleFileFilter());
        this.style.setSelectedItem(selected);
        if (this.style.getSelectedIndex() == -1 && this.style.getItemCount() > 0) {
            this.style.setSelectedIndex(0);
        }
        if (this.loadHints) {
            this.loadHints();
        }
        if (this.previewSkinFrame.isVisible()) {
            this.setPreviewImage();
        }
        this.engine.setSkin(this.skin.getSelectedItem().toString());
        this.engine.initInterpreter();
        final File onLoadScript = new File(this.cfg.skinsDir, this.engine.getSkin() + "/onload.bsh");
        if (onLoadScript.exists()) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = JAlbum.initializedOkMonitor;
                    synchronized (object) {
                        JAlbumFrame.this.executeStript(onLoadScript);
                    }
                }
            }.start();
        }
    }

    void skin_mouseEntered(MouseEvent e2) {
        this.scanSkins();
    }

    void smartUploadButton_actionPerformed(ActionEvent e2) {
        this.doUploadAlbum(false);
    }

    void tabbedPanel_stateChanged(ChangeEvent e2) {
        Component previousPanel = this.currentPanel;
        this.currentPanel = this.tabbedPanel.getSelectedComponent();
        if (this.currentPanel == this.editPanel) {
            try {
                this.ui2Engine();
            }
            catch (BeanBinderException ex) {
                // empty catch block
            }
            this.updateEditPanel();
        }
        if (previousPanel == this.appearancePanel) {
            this.fireSkinUIHidden(new JAlbumEvent(this));
        } else if (this.currentPanel == this.appearancePanel) {
            this.fireSkinUIDisplayed(new JAlbumEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void testConnectionButton_actionPerformed(ActionEvent e2) {
        block12: {
            this.statusBar.setText(Msg.getString("ui.connectingToServer") + this.ftpServer.getText() + "...");
            this.statusBar.repaint();
            this.testRemoteDirectory();
            this.statusBar.setText(Msg.getString("ui.connectedOk"));
            this.messageBox(Msg.getString("ui.connectedOk"));
            Object var6_2 = null;
            try {
                this.remoteFSBean.disconnect();
            }
            catch (Exception ex2) {
            }
            break block12;
            {
                catch (RemoteFSException ex) {
                    this.statusBar.setText(ex.getMessage());
                    Debug.showErrorDialog(this, ex);
                    Object var6_3 = null;
                    try {
                        this.remoteFSBean.disconnect();
                    }
                    catch (Exception ex2) {
                    }
                    break block12;
                }
                catch (IOException ex) {
                    this.statusBar.setText(ex.getMessage());
                    Debug.showErrorDialog(this, ex);
                    Object var6_4 = null;
                    try {
                        this.remoteFSBean.disconnect();
                    }
                    catch (Exception ex2) {
                    }
                    break block12;
                }
                catch (Exception ex) {
                    Debug.showStackTraceDialog(this, ex);
                    Object var6_5 = null;
                    try {
                        this.remoteFSBean.disconnect();
                    }
                    catch (Exception ex2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    this.remoteFSBean.disconnect();
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    boolean testRemoteDirectory() throws RemoteFSException, IOException {
        boolean bl2;
        try {
            this.ui2Engine();
            this.remoteFSBean.setSecure(this.engine.isSecureFtp());
            this.remoteFSBean.setForceUTF8(this.engine.isFtpForceUTF8());
            this.remoteFSBean.setPort(this.engine.getFtpPort());
            this.remoteFSBean.connect(this.engine.getFtpServer(), this.engine.getFtpUser(), new String(this.engine.getFtpPassword()));
            String remoteDir = IO.combinePaths(this.engine.getFtpWebDirectory(), this.engine.getRemoteDirectory(), '/');
            if (remoteDir.length() > 0) {
                try {
                    this.remoteFSBean.setDirectory(remoteDir);
                }
                catch (RemoteFSException ex) {
                    int answer = this.messageBox(MessageFormat.format(Msg.getString("ui.remoteDirectoryWarning"), remoteDir), 12);
                    if (answer == 4) {
                        this.remoteFSBean.createDirectory(remoteDir);
                        boolean bl3 = true;
                        Object var6_7 = null;
                        try {
                            this.remoteFSBean.disconnect();
                        }
                        catch (Exception ex2) {
                        }
                        return bl3;
                    }
                    boolean bl4 = false;
                    Object var6_8 = null;
                    try {
                        this.remoteFSBean.disconnect();
                    }
                    catch (Exception ex2) {
                    }
                    return bl4;
                }
            }
            bl2 = true;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                this.remoteFSBean.disconnect();
            }
            catch (Exception ex2) {
            }
            throw throwable;
        }
        try {
            this.remoteFSBean.disconnect();
        }
        catch (Exception ex2) {
        }
        return bl2;
    }

    public void ui2Engine() throws BeanBinderException {
        BeanBinder.setProperties((Object)this.engine, this);
        if (this.skinUI != null) {
            this.engine.setSkinVariables(PropertyBinder.getProperties(this.skinUI));
        }
        this.engine.setUserVariables(this.userVariablesTable.getMap());
    }

    private void updateEditPanel() {
        File f2 = new File(this.directory.getText());
        if (this.editDirectory == null || !this.editDirectory.equals(f2)) {
            this.editDirectory = f2;
            AlbumObjectFactory factory = new AlbumObjectFactory(this.engine);
            AlbumObject root = factory.createInstance(f2);
            this.editPanel.setRootFolder(root);
            this.editPanel.viewFolder(root);
        }
    }

    void uploadAll_actionPerformed(ActionEvent e2) {
        this.doUploadAlbum(true);
    }

    void viewAlbumButton_actionPerformed(ActionEvent e2) {
        try {
            File dir2 = new File(this.sameDirectory.isSelected() ? this.directory.getText() : this.outputDirectory.getText());
            if (!dir2.isAbsolute()) {
                dir2 = new File(this.directory.getText(), this.outputDirectory.getText());
            }
            File indexFile = new File(dir2, this.indexPageName.getText() + this.pageExtension.getText());
            BrowserLauncher.openLocal(indexFile);
        }
        catch (IOException ex) {
            this.statusBar.setText(ex.getMessage());
        }
    }

    class BlinkerThread
    extends Thread {
        Component comp;
        int nblinks;

        public BlinkerThread(Component comp) {
            this(comp, 3);
        }

        public BlinkerThread(Component comp, int nblinks) {
            super("ReminderAnimatorThread");
            this.comp = comp;
            this.nblinks = nblinks;
        }

        public void run() {
            boolean visible = this.comp.isVisible();
            try {
                int i2 = 0;
                while (i2 < this.nblinks) {
                    this.comp.setVisible(!visible);
                    Thread.sleep(250L);
                    this.comp.setVisible(visible);
                    Thread.sleep(250L);
                    ++i2;
                }
            }
            catch (InterruptedException ex) {
                this.comp.setVisible(visible);
            }
        }
    }

    public class DummyCheckBox {
        JCheckBox cb;

        public DummyCheckBox(JCheckBox cb2) {
            this.cb = cb2;
        }

        public boolean isSelected() {
            return this.cb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.cb.setSelected(selected);
        }
    }
}

