/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.io.ConsoleStream;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Debug;
import se.datadosen.util.PrintSafeHashMap;

public class JConsoleFrame
extends JFrame {
    BorderLayout borderLayout1 = new BorderLayout();
    JTextArea console;
    Interpreter interpreter;
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2;
    JSplitPane jSplitPane1;
    ClassLoader loader;
    JTextArea output;
    PrintStream stream;
    JAlbumFrame ui;

    public JConsoleFrame(JAlbumFrame ui) {
        this.console = new JSmartTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.output = new JSmartTextArea();
        this.stream = new PrintStream(new ConsoleStream(this.output), true);
        this.interpreter = new Interpreter();
        this.ui = ui;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JConsoleFrame() {
        this.console = new JSmartTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.output = new JSmartTextArea();
        this.stream = new PrintStream(new ConsoleStream(this.output), true);
        this.interpreter = new Interpreter();
        try {
            this.jbInit();
            this.loader = new URLClassLoader(new URL[]{Config.getConfig().pluginsDir.toURL()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public String getText() {
        return this.console.getText();
    }

    void jbInit() throws Exception {
        this.interpreter.setClassLoader(this.loader);
        this.getContentPane().setLayout(this.borderLayout1);
        this.console.setText("");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.output.setColumns(100);
        this.output.setRows(20);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jScrollPane1, "top");
        this.jSplitPane1.add((Component)this.jScrollPane2, "bottom");
        this.jScrollPane2.getViewport().add((Component)this.output, null);
        this.jScrollPane1.getViewport().add((Component)this.console, null);
        AbstractAction evalExpression = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    String expr = JConsoleFrame.this.console.getSelectedText();
                    if (expr == null) {
                        expr = JConsoleFrame.this.console.getText();
                    }
                    JConsoleFrame.this.ui.ui2Engine();
                    System.out.println("==> " + JConsoleFrame.this.processExpression(expr));
                }
                catch (ElementException ex) {
                    Debug.showCopyableError(JConsoleFrame.this, ex, Msg.getString("ui.scriptingError"));
                }
                catch (OperationAbortedException ex) {
                    JConsoleFrame.this.ui.statusBar.setText(Msg.getString("ui.operationAborted"));
                }
                catch (Exception ex) {
                    Debug.showErrorDialog(JConsoleFrame.this, ex);
                }
            }
        };
        KeyStroke ctrlE = KeyStroke.getKeyStroke(69, 2);
        this.console.registerKeyboardAction(evalExpression, "evalExpression", ctrlE, 0);
        this.pack();
        this.jSplitPane1.setDividerLocation(100);
    }

    Object processExpression(String expr) throws ElementException {
        PrintSafeHashMap vars = new PrintSafeHashMap();
        this.ui.engine.addGlobals(vars);
        Map userVariables = this.ui.engine.getUserVariables();
        if (userVariables != null) {
            vars.putAll(userVariables);
        }
        AlbumBean cfr_ignored_0 = this.ui.engine;
        AlbumBean.setVars(vars, this.interpreter);
        try {
            return this.interpreter.eval(expr);
        }
        catch (ParseException e2) {
            throw new ElementException(e2.getMessage() + "\n\nDetails:\n" + e2.getErrorSourceFile());
        }
        catch (TargetError e3) {
            Throwable t2 = e3.getTarget();
            if (t2 instanceof OperationAbortedException) {
                throw (OperationAbortedException)t2;
            }
            throw new ElementException("Exception caused by line " + e3.getErrorLineNumber() + ": " + e3.getTarget() + "\n\nDetails:\n" + e3.getMessage());
        }
        catch (EvalError e4) {
            throw new ElementException("Evaluation error on line " + e4.getErrorLineNumber() + ":\n\nDetails:\n" + e4.getMessage());
        }
    }

    public void setText(String text) {
        this.console.setText(text);
    }
}

