/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.incors.plaf.alloy.AlloyLookAndFeel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import se.datadosen.component.ControlPanel;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JPrefsPanel_language_actionAdapter;
import se.datadosen.jalbum.JPrefsPanel_lookAndFeel_actionAdapter;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Item;
import se.datadosen.util.LanguageMapper;

public class JPrefsPanel
extends ControlPanel {
    JCheckBox allowBlinkingHints;
    JCheckBox autoWriteCommentsToFile;
    JCheckBox checkForUpdates;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbumFrame;
    JCheckBox debugMode = new JCheckBox();
    ControlPanel editing;
    ControlPanel guides;
    JComboBox language;
    JLabel languageLabel;
    JComboBox lookAndFeel;
    JLabel lookAndFeelLabel;
    ControlPanel multipleProcessors;
    JComboBox nThreads;
    JLabel nThreadsLabel;
    JAlbumFrame parent;
    JLabel rememberLabel;
    JCheckBox showWarnings;
    ControlPanel skins;
    ImageIcon tipIcon;
    JCheckBox useLayoutHints;

    public JPrefsPanel(JAlbumFrame parent) {
        this.checkForUpdates = new JCheckBox();
        this.useLayoutHints = new JCheckBox();
        this.autoWriteCommentsToFile = new JCheckBox();
        this.language = new JComboBox<Object>(JPrefsPanel.fillLanguages());
        this.lookAndFeel = new JComboBox<Object>(JPrefsPanel.fillLookAndFeels());
        this.rememberLabel = new JLabel();
        this.tipIcon = new ImageIcon();
        this.skins = new ControlPanel();
        this.editing = new ControlPanel();
        this.guides = new ControlPanel();
        this.showWarnings = new JCheckBox();
        this.allowBlinkingHints = new JCheckBox();
        this.multipleProcessors = new ControlPanel();
        this.nThreadsLabel = new JLabel();
        this.nThreads = new JComboBox<Object>(JPrefsPanel.fillNThreads());
        this.languageLabel = new JLabel();
        this.lookAndFeelLabel = new JLabel();
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static Object[] fillLanguages() {
        File dir2 = new File(Config.getConfig().progDir, "texts");
        File[] files = dir2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".properties");
            }
        });
        Object[] result = new Object[files.length + 1];
        int i2 = 0;
        while (i2 < files.length) {
            String name = files[i2].getName();
            int underscoreIndex = name.indexOf(95);
            String iso2 = underscoreIndex == -1 ? "en" : name.substring(underscoreIndex + 1, name.lastIndexOf(46));
            result[i2 + 1] = new Item(iso2, LanguageMapper.getFullName(iso2));
            ++i2;
        }
        Arrays.sort(result, 1, result.length - 1);
        result[0] = new Item("default", Msg.getString("prefs.systemDefault"));
        return result;
    }

    private static Object[] fillLookAndFeels() {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Object[] result = new Object[lafInfo.length + 2];
        result[0] = new Item(UIManager.getSystemLookAndFeelClassName(), Msg.getString("prefs.systemDefault"));
        result[1] = new Item("com.incors.plaf.alloy.AlloyLookAndFeel", "Alloy");
        int i2 = 0;
        while (i2 < lafInfo.length) {
            result[i2 + 2] = new Item(lafInfo[i2].getClassName(), lafInfo[i2].getName());
            ++i2;
        }
        return result;
    }

    static Object[] fillNThreads() {
        Object[] result = new Object[Runtime.getRuntime().availableProcessors()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = new Integer(i2 + 1);
            ++i2;
        }
        return result;
    }

    private void jbInit() throws Exception {
        this.useLayoutHints.setSelected(true);
        this.showWarnings.setSelected(true);
        this.allowBlinkingHints.setSelected(true);
        this.checkForUpdates.setSelected(true);
        this.tipIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JPrefsPanel.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/lightbulb_on.png"));
        this.setTexts();
        this.useLayoutHints.setSelected(true);
        this.debugMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                System.setProperty("log.level", JPrefsPanel.this.debugMode.isSelected() ? "DEBUG" : "OFF");
                String logLevel = System.getProperty("log.level");
                if (logLevel == null || logLevel.equals("OFF")) {
                    Logger.setLevel(Level.OFF);
                } else {
                    Logger.setLevel(Level.getLevel(logLevel));
                }
            }
        });
        this.language.addActionListener(new JPrefsPanel_language_actionAdapter(this));
        this.lookAndFeel.addActionListener(new JPrefsPanel_lookAndFeel_actionAdapter(this));
        this.add("br", this.rememberLabel);
        this.add("p", this.languageLabel);
        this.add(this.language);
        this.add("tab", this.lookAndFeelLabel);
        this.add(this.lookAndFeel);
        this.add("p", this.debugMode);
        this.add(this.checkForUpdates);
        this.skins.add(this.useLayoutHints);
        this.add("br hfill", this.skins);
        this.editing.add(this.autoWriteCommentsToFile);
        this.add("br hfill", this.editing);
        this.guides.add(this.showWarnings);
        this.guides.add(this.allowBlinkingHints);
        this.add("br hfill", this.guides);
        this.multipleProcessors.add(this.nThreadsLabel);
        this.multipleProcessors.add(this.nThreads);
        this.add("br hfill", this.multipleProcessors);
        if (Runtime.getRuntime().availableProcessors() < 2) {
            this.multipleProcessors.setEnabled(false);
        }
    }

    void language_actionPerformed(ActionEvent e2) {
        Item lang = (Item)this.language.getSelectedItem();
        String newLang = (String)lang.value;
        Config config = Config.getConfig();
        if (!config.getLanguage().equals(newLang)) {
            config.setLanguage(newLang);
            this.parent.setTexts();
            this.parent.pack();
        }
    }

    void lookAndFeel_actionPerformed(ActionEvent e2) {
        String laf = (String)((Item)this.lookAndFeel.getSelectedItem()).value;
        Config config = Config.getConfig();
        if (!config.getNewLookAndFeel().equals(laf)) {
            config.setNewLookAndFeel(laf);
            try {
                UIManager.setLookAndFeel(laf);
                AlloyLookAndFeel.updateAllUIs();
                this.parent.validate();
            }
            catch (Exception ex) {
                this.parent.statusBar.setText(ex.toString());
            }
        }
    }

    public void setTexts() {
        this.languageLabel.setText(Msg.getString("prefs.language"));
        this.lookAndFeelLabel.setText(Msg.getString("prefs.lookAndFeel"));
        this.debugMode.setText(Msg.getString("ui.debugMode"));
        this.debugMode.setToolTipText(Msg.getString("ui.debugModeToolTip"));
        this.checkForUpdates.setText(Msg.getString("ui.checkForUpdates"));
        this.checkForUpdates.setToolTipText(Msg.getString("ui.checkForUpdatesToolTip"));
        this.useLayoutHints.setText(Msg.getString("ui.useLayoutHints"));
        this.useLayoutHints.setToolTipText(Msg.getString("ui.useLayoutHintsToolTip"));
        this.rememberLabel.setIcon(this.tipIcon);
        this.rememberLabel.setText(Msg.getString("prefs.tipLabel"));
        this.autoWriteCommentsToFile.setText(Msg.getString("prefs.autoWriteCommentsToFile"));
        this.skins.setTitle(Msg.getString("prefs.skinsBorder"));
        this.editing.setTitle(Msg.getString("prefs.imageEditingBorder"));
        this.guides.setTitle(Msg.getString("prefs.guidesBorder"));
        this.showWarnings.setText(Msg.getString("prefs.showWarnings"));
        this.allowBlinkingHints.setText(Msg.getString("prefs.allowBlinkingHints"));
        this.multipleProcessors.setTitle(Msg.getString("prefs.multipleProcessorsBorder"));
        this.nThreadsLabel.setText(Msg.getString("prefs.nThreadsLabel"));
    }
}

