/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.jdesktop.jdic.tray.SystemTray;
import org.mortbay.util.MultiException;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumTrayIcon;
import se.datadosen.jalbum.JShareSecuritySettingsDialog;
import se.datadosen.jalbum.JWebServerSettingsDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ShareBean;
import se.datadosen.jalbum.event.StatusListener;
import se.datadosen.net.Share;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;

public class JSharePanel
extends ControlPanel
implements StatusListener {
    JCheckBox active;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbumFrame;
    ControlPanel currentShare;
    Action gotoURLAction;
    JButton gotoURLButton;
    ImageIcon infoIcon;
    JLabel infoLabel;
    JTextField localPath;
    JLabel localPathLabel;
    JAlbumFrame parent;
    Action removeShareAction;
    JButton removeShareButton;
    JShareSecuritySettingsDialog securityDialog;
    Action securitySettingsAction;
    JButton securitySettingsButton;
    ControlPanel serverControl;
    ButtonGroup serverControlButtons;
    Action settingsAction;
    JButton settingsButton;
    JWebServerSettingsDialog settingsDialog;
    ImageIcon settingsIcon;
    ShareBean shareBean = new ShareBean();
    Action shareCurrentAlbumAction;
    JButton shareCurrentAlbumButton;
    JLabel sharesLabel;
    JList sharesList;
    JScrollPane sharesScrollPane;
    Action startAction;
    JToggleButton startButton;
    ImageIcon startIcon;
    Action stopAction;
    JToggleButton stopButton;
    ImageIcon stopIcon;
    JAlbumTrayIcon trayIcon;
    Action updateShareAction;
    JButton updateShareButton;
    JTextField uri;
    JLabel uriLabel;
    JTextField url;
    JLabel urlLabel;

    public JSharePanel(JAlbumFrame parent) {
        this.infoLabel = new JLabel();
        this.currentShare = new ControlPanel();
        this.active = new JCheckBox();
        this.localPathLabel = new JLabel();
        this.localPath = new JSmartTextField();
        this.uriLabel = new JLabel();
        this.uri = new JSmartTextField();
        this.urlLabel = new JLabel();
        this.url = new JSmartTextField();
        this.sharesLabel = new JLabel();
        this.sharesList = new JList();
        this.sharesScrollPane = new JScrollPane(this.sharesList);
        this.serverControl = new ControlPanel();
        this.serverControlButtons = new ButtonGroup();
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void addTrayIcon(boolean showMsg) {
        if (this.trayIcon != null) {
            return;
        }
        try {
            SystemTray tray = SystemTray.getDefaultSystemTray();
            this.trayIcon = new JAlbumTrayIcon(this.parent);
            tray.addTrayIcon(this.trayIcon);
            this.trayIcon.displayMessage(Msg.getString("trayIcon.title"), Msg.getString("trayIcon.message"), 0);
        }
        catch (Throwable t2) {
            System.err.println("Couldn't install tray icon: " + t2.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private Share getCurrentShare() {
        List shares = this.shareBean.getShares();
        int index = this.sharesList.getSelectedIndex();
        if (index >= 0) {
            return (Share)shares.get(index);
        }
        return null;
    }

    private String getFinalURL(String uri) throws IOException, UPNPResponseException {
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        String portStr = this.shareBean.getPort() == 80 ? "" : ":" + this.shareBean.getPort();
        return "http://" + (this.shareBean.getHostName().length() > 0 ? this.shareBean.getHostName() : this.shareBean.getExternalAddress()) + portStr + uri.replaceAll(" ", "%20");
    }

    private void jbInit() throws Exception {
        this.shareBean.addStatusListener(this);
        this.infoIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JSharePanel.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/information.png"));
        this.startIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JSharePanel.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_play_green.png"));
        this.stopIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JSharePanel.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_stop_red.png"));
        this.settingsIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JSharePanel.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/preferences.png"));
        this.startAction = new AbstractAction("startAction", this.startIcon){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e2) {
                BeanBinder.setProperties((Object)JSharePanel.this.shareBean, JSharePanel.this);
                JSharePanel.this.setCursor(new Cursor(3));
                try {
                    JSharePanel.this.shareBean.start();
                    JSharePanel.this.startButton.setSelected(true);
                    JSharePanel.this.updateURL();
                    JSharePanel.this.addTrayIcon(e2 != null);
                }
                catch (MultiException ex) {
                    JSharePanel.this.setCursor(new Cursor(0));
                    JSharePanel.this.stopButton.setSelected(true);
                    if (!(ex.getException(0) instanceof BindException)) return;
                    JOptionPane.showMessageDialog(JSharePanel.this, MessageFormat.format(Msg.getString("share.bindErrorInfo"), new Integer(JSharePanel.this.shareBean.getPort())), Msg.getString("share.shareAlbum"), 0);
                    return;
                }
                catch (Exception ex) {
                    JSharePanel.this.setCursor(new Cursor(0));
                    JSharePanel.this.stopButton.setSelected(true);
                    Debug.showErrorDialog(JSharePanel.this.parent, ex);
                    return;
                }
                try {
                    block11: {
                        try {
                            if (JSharePanel.this.shareBean.isDoPortMapping()) {
                                JSharePanel.this.shareBean.ensurePortMapping();
                            }
                            if (JSharePanel.this.shareBean.albumAccessTest()) break block11;
                            JOptionPane.showMessageDialog(JSharePanel.this, Msg.getString("share.softwareFirewallInfo"), Msg.getString("share.shareAlbum"), 2);
                        }
                        catch (Exception ex) {
                            if (!JSharePanel.this.shareBean.albumAccessTest()) {
                                try {
                                    JOptionPane.showMessageDialog(JSharePanel.this, MessageFormat.format(Msg.getString("share.portForwardingInfo"), new Integer(JSharePanel.this.shareBean.getPort()), InetAddress.getLocalHost().getHostAddress()), Msg.getString("share.shareAlbum"), 2);
                                }
                                catch (IOException ex1) {
                                }
                            }
                            Object var5_7 = null;
                            JSharePanel.this.setCursor(new Cursor(0));
                            return;
                        }
                    }
                    Object var5_6 = null;
                    JSharePanel.this.setCursor(new Cursor(0));
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    JSharePanel.this.setCursor(new Cursor(0));
                    throw throwable;
                }
            }
        };
        this.stopAction = new AbstractAction("stopAction", this.stopIcon){

            public void actionPerformed(ActionEvent e2) {
                try {
                    JSharePanel.this.setCursor(new Cursor(3));
                    JSharePanel.this.shareBean.stop();
                    JSharePanel.this.updateURL();
                    JSharePanel.this.removeTrayIcon();
                }
                catch (Exception ex) {
                    JSharePanel.this.setCursor(new Cursor(0));
                    Debug.showErrorDialog(JSharePanel.this.parent, ex);
                }
                JSharePanel.this.setCursor(new Cursor(0));
            }
        };
        this.settingsAction = new AbstractAction("settingsAction", this.settingsIcon){

            public void actionPerformed(ActionEvent e2) {
                try {
                    BeanBinder.getProperties((Object)JSharePanel.this.shareBean, JSharePanel.this.settingsDialog);
                    JSharePanel.this.settingsDialog.setVisible(true);
                    if (JSharePanel.this.settingsDialog.isOkPressed()) {
                        boolean running = JSharePanel.this.shareBean.isRunning();
                        if (running) {
                            JSharePanel.this.stopAction.actionPerformed(null);
                        }
                        BeanBinder.setProperties((Object)JSharePanel.this.shareBean, JSharePanel.this.settingsDialog);
                        JSharePanel.this.shareBean.setLogger();
                        if (running) {
                            JSharePanel.this.startAction.actionPerformed(null);
                        }
                        JSharePanel.this.shareBean.saveSettings();
                    }
                }
                catch (Exception ex) {
                    Debug.showErrorDialog(JSharePanel.this, ex);
                }
            }
        };
        this.shareCurrentAlbumAction = new AbstractAction("shareCurrentAlbumAction"){

            public void actionPerformed(ActionEvent e2) {
                JSharePanel.this.parent.ui2Engine();
                JSharePanel.this.uri.setText("/" + new File(JSharePanel.this.parent.engine.getDirectory()).getName());
                File dir2 = JSharePanel.this.parent.engine.getInterpretedOutputDirectory();
                JSharePanel.this.localPath.setText(dir2.getAbsolutePath());
                JSharePanel.this.active.setSelected(true);
                JSharePanel.this.updateShareAction.actionPerformed(null);
                JSharePanel.this.startAction.actionPerformed(null);
                JOptionPane.showMessageDialog(JSharePanel.this.parent, Msg.getString("share.shareCurrentAlbumInfo"), Msg.getString("share.shareAlbum"), 1);
            }
        };
        this.gotoURLAction = new AbstractAction("openURLAction"){

            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL(JSharePanel.this.url.getText());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JSharePanel.this.parent, ex);
                }
            }
        };
        this.updateShareAction = new AbstractAction("updateShareAction"){

            public void actionPerformed(ActionEvent e2) {
                List shares = JSharePanel.this.shareBean.getShares();
                Share share = new Share(JSharePanel.this.localPath.getText(), JSharePanel.this.uri.getText(), JSharePanel.this.active.isSelected());
                share.passwordProtect = JSharePanel.this.securityDialog.passwordProtect.isSelected();
                share.userName = JSharePanel.this.securityDialog.userName.getText();
                share.password = JSharePanel.this.securityDialog.password.getText();
                shares.remove(share);
                shares.add(share);
                JSharePanel.this.shareBean.setShares(shares);
                JSharePanel.this.sharesList.setListData(shares.toArray());
                JSharePanel.this.updateURL();
                try {
                    JSharePanel.this.shareBean.saveSettings();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JSharePanel.this.parent, ex);
                }
            }
        };
        this.removeShareAction = new AbstractAction("removeShareAction"){

            public void actionPerformed(ActionEvent e2) {
                List shares = JSharePanel.this.shareBean.getShares();
                Share share = new Share(JSharePanel.this.localPath.getText(), JSharePanel.this.uri.getText(), JSharePanel.this.active.isSelected());
                shares.remove(share);
                JSharePanel.this.shareBean.setShares(shares);
                JSharePanel.this.sharesList.setListData(shares.toArray());
                try {
                    JSharePanel.this.shareBean.saveSettings();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JSharePanel.this.parent, ex);
                }
            }
        };
        this.securitySettingsAction = new AbstractAction("securitySettingsAction", this.settingsIcon){

            public void actionPerformed(ActionEvent e2) {
                JSharePanel.this.securityDialog.setVisible(true);
                Share share = JSharePanel.this.getCurrentShare();
                if (share != null) {
                    share.passwordProtect = JSharePanel.this.securityDialog.passwordProtect.isSelected();
                }
            }
        };
        this.shareCurrentAlbumButton = new JButton(this.shareCurrentAlbumAction);
        this.gotoURLButton = new JButton(this.gotoURLAction);
        this.updateShareButton = new JButton(this.updateShareAction);
        this.removeShareButton = new JButton(this.removeShareAction);
        this.securitySettingsButton = new JButton(this.securitySettingsAction);
        this.startButton = new JToggleButton(this.startAction);
        this.stopButton = new JToggleButton(this.stopAction);
        this.serverControlButtons.add(this.startButton);
        this.serverControlButtons.add(this.stopButton);
        this.settingsButton = new JButton(this.settingsAction);
        this.settingsDialog = new JWebServerSettingsDialog((Frame)this.parent, true);
        this.securityDialog = this.securityDialog = new JShareSecuritySettingsDialog((Frame)this.parent, true);
        this.url.setEditable(false);
        this.stopButton.setSelected(true);
        this.sharesList.setSelectionMode(0);
        this.sharesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                JSharePanel.this.updateCurrentShare();
            }
        });
        this.sharesList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 127) {
                    JSharePanel.this.removeShareAction.actionPerformed(null);
                }
            }
        });
        this.setTexts();
        this.add("br", this.infoLabel);
        this.add("p", this.sharesLabel);
        this.sharesScrollPane.setPreferredSize(new Dimension(220, 120));
        this.add("br vfill", this.sharesScrollPane);
        JPanel rp = new JPanel();
        rp.setLayout(new RiverLayout());
        rp.add(this.shareCurrentAlbumButton);
        this.serverControl.add(this.startButton);
        this.serverControl.add(this.stopButton);
        this.serverControl.add(this.settingsButton);
        rp.add("p", this.serverControl);
        this.add(rp);
        this.currentShare.add(this.uriLabel);
        this.currentShare.add("tab hfill", this.uri);
        this.currentShare.add(this.securitySettingsButton);
        this.currentShare.add(this.active);
        this.currentShare.add("br", this.localPathLabel);
        this.currentShare.add("tab hfill", this.localPath);
        this.currentShare.add("br", this.urlLabel);
        this.currentShare.add("tab hfill", this.url);
        this.currentShare.add(this.gotoURLButton);
        this.currentShare.add("p right", this.updateShareButton);
        this.currentShare.add(this.removeShareButton);
        this.add("p hfill", this.currentShare);
        this.shareBean.loadSettings();
        List shares = this.shareBean.getShares();
        this.sharesList.setListData(shares.toArray());
        int index = this.sharesList.getModel().getSize() - 1;
        if (index > 0) {
            this.sharesList.setSelectedIndex(index);
        }
    }

    private void removeTrayIcon() {
        if (this.trayIcon != null) {
            SystemTray tray = SystemTray.getDefaultSystemTray();
            tray.removeTrayIcon(this.trayIcon);
            this.trayIcon = null;
        }
    }

    public void setTexts() {
        JOptionPane.setRootFrame(null);
        this.infoLabel.setIcon(this.infoIcon);
        this.infoLabel.setText("<html>" + Msg.getString("share.infoLabel") + "</html>");
        this.sharesLabel.setText(Msg.getString("share.sharesList"));
        this.shareCurrentAlbumAction.putValue("Name", Msg.getString("share.shareCurrentAlbum"));
        this.updateShareAction.putValue("Name", Msg.getString("share.update"));
        this.removeShareAction.putValue("Name", Msg.getString("remove"));
        this.securitySettingsAction.putValue("Name", Msg.getString("share.securitySettings"));
        this.serverControl.setTitle(Msg.getString("share.serverControlBorder"));
        this.startAction.putValue("Name", Msg.getString("share.start"));
        this.stopAction.putValue("Name", Msg.getString("share.stop"));
        this.settingsAction.putValue("Name", Msg.getString("share.settings"));
        this.currentShare.setTitle(Msg.getString("share.currentShareBorder"));
        this.active.setText(Msg.getString("share.active"));
        this.uriLabel.setText(Msg.getString("share.name"));
        this.localPathLabel.setText(Msg.getString("share.localPath"));
        this.urlLabel.setText(Msg.getString("share.url"));
        this.gotoURLAction.putValue("Name", Msg.getString("share.gotoURL"));
        this.url.setToolTipText(Msg.getString("share.urlToolTip"));
    }

    public void statusChanged(String msg) {
        System.out.println(msg);
        this.parent.statusBar.setText(msg);
    }

    private void updateCurrentShare() {
        Share share = this.getCurrentShare();
        if (share != null) {
            this.uri.setText(share.uri);
            this.localPath.setText(share.localPath);
            this.active.setSelected(share.active);
            this.securityDialog.passwordProtect.setSelected(share.passwordProtect);
            this.securityDialog.userName.setText(share.userName);
            this.securityDialog.password.setText(share.password);
            this.securityDialog.passwordProtectAction.actionPerformed(null);
            this.updateURL();
        }
    }

    private void updateURL() {
        if (this.shareBean.isRunning()) {
            try {
                this.url.setText(this.getFinalURL(this.uri.getText()));
            }
            catch (UPNPResponseException ex) {
            }
            catch (IOException ex) {
            }
        } else {
            this.url.setText("Web server not running");
        }
    }
}

