/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ToolFileFilter;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;

class JToolsMenu
extends JMenu
implements ActionListener {
    private Vector names;
    File toolsDir;
    private JAlbumFrame ui;

    public JToolsMenu(JAlbumFrame ui) {
        this.ui = ui;
        this.init();
    }

    public void actionPerformed(final ActionEvent e2) {
        try {
            this.ui.ui2Engine();
        }
        catch (BeanBinderException ex) {
            Debug.showErrorDialog(this, ex);
        }
        new Thread("ScriptingThread"){

            public void run() {
                try {
                    ((JToolsMenu)JToolsMenu.this).ui.engine.init();
                    File cmdFile = new File(JToolsMenu.this.toolsDir, e2.getActionCommand() + ".bsh");
                    if (cmdFile.exists()) {
                        ((JToolsMenu)JToolsMenu.this).ui.engine.processBeanShellFile(cmdFile);
                    }
                }
                catch (ElementException ex) {
                    Debug.showCopyableError(JToolsMenu.this.ui, ex, Msg.getString("ui.scriptingError"));
                }
                catch (OperationAbortedException ex) {
                    ((JToolsMenu)JToolsMenu.this).ui.statusBar.setText(Msg.getString("ui.operationAborted"));
                }
                catch (Exception ex) {
                    Debug.showErrorDialog(JToolsMenu.this.ui, ex);
                }
            }
        }.start();
    }

    private void init() {
        this.names = new Vector();
        this.toolsDir = new File(Config.getConfig().progDir, "tools");
        File[] tools = this.toolsDir.listFiles(new ToolFileFilter());
        if (tools == null) {
            System.err.println("Cannot install tools. Full path to tools directory is: " + this.toolsDir.getAbsolutePath());
            return;
        }
        int i2 = 0;
        while (i2 < tools.length) {
            String name = tools[i2].getName().substring(0, tools[i2].getName().indexOf(46));
            this.names.add(name);
            ++i2;
        }
        this.rebuildMenu();
    }

    protected void rebuildMenu() {
        this.removeAll();
        int i2 = 0;
        while (i2 < this.names.size()) {
            JMenuItem item = new JMenuItem((String)this.names.get(i2));
            item.addActionListener(this);
            this.add(item);
            ++i2;
        }
    }
}

