/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import se.datadosen.component.JIconButton;
import se.datadosen.component.JIconToggleButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Timer;

public class ProgressDialog
extends JDialog
implements AlbumBeanListener {
    boolean abort = false;
    JButton abortButton;
    BorderLayout borderLayout1;
    JPanel buttonPanel;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbumFrame;
    JLabel count;
    JLabel directory;
    JLabel file;
    JPanel mainPanel;
    JPanel panel1 = new JPanel();
    JAlbumFrame parent;
    JToggleButton pauseButton;
    JButton peekButton;
    JProgressBar progressBar;
    JLabel timeLeft;
    Timer timer;

    public ProgressDialog(JAlbumFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.borderLayout1 = new BorderLayout();
        this.mainPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.abortButton = new JIconButton();
        this.peekButton = new JIconButton();
        this.pauseButton = new JIconToggleButton();
        this.directory = new JLabel();
        this.progressBar = new JProgressBar();
        this.file = new JLabel();
        this.timeLeft = new JLabel();
        this.timer = new Timer();
        this.count = new JLabel();
        this.parent = parent;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    synchronized void abortButton_actionPerformed(ActionEvent e2) {
        this.abort = true;
        this.setVisible(false);
        this.pauseButton.setSelected(false);
        this.notifyAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void errorOccured(Throwable t2, File f2) {
    }

    public void imageProcessingFinished(AlbumBeanEvent e2) {
        if (this.abort) {
            e2.abortProcessing();
        }
        long elapsed = this.timer.getMillis();
        long totalMillis = (long)e2.totalFiles * elapsed / (long)e2.processedFiles;
        int secsLeft = (int)(totalMillis - elapsed) / 1000;
        this.timeLeft.setText(Msg.getString("progress.estimatedTimeLeftInfo") + " " + ProgressDialog.timerFormat(secsLeft));
    }

    public synchronized void imageProcessingStarted(AlbumBeanEvent e2) {
        if (this.pauseButton.isSelected()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
            }
        }
        if (!this.isVisible() && !this.abort) {
            new Thread(){

                public void run() {
                    ProgressDialog.this.setVisible(true);
                }
            }.start();
        }
        if (this.abort) {
            e2.abortProcessing();
        }
        if (e2.processedFiles == 1) {
            this.timer.start();
        }
        this.directory.setText(Msg.getString("progress.processingInfo") + " " + e2.dir.getName());
        this.progressBar.setValue(e2.processedFiles);
        this.progressBar.setMaximum(e2.totalFiles);
        this.file.setText(e2.msg);
        this.count.setText(MessageFormat.format(Msg.getString("progress.processingInfo2"), new Integer(e2.processedFiles), new Integer(e2.totalFiles)));
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.abortButton.setText(Msg.getString("abort"));
        this.abortButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = ProgressDialog.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_stop.png")));
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ProgressDialog.this.abortButton_actionPerformed(e2);
            }
        });
        this.peekButton.setText(Msg.getString("progress.peek"));
        this.peekButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = ProgressDialog.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/earth_view.png")));
        this.peekButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ProgressDialog.this.peekButton_actionPerformed(e2);
            }
        });
        this.peekButton.setVisible(false);
        this.pauseButton.setText(Msg.getString("progress.pause"));
        this.pauseButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = ProgressDialog.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_pause.png")));
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ProgressDialog.this.pauseButton_actionPerformed(e2);
            }
        });
        this.buttonPanel.setLayout(new RiverLayout());
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.getString("progress.processingInfo"));
        this.file.setText(Msg.getString("progress.fileInfo"));
        this.timeLeft.setText(Msg.getString("progress.estimatedTimeLeftInfo"));
        this.count.setText(Msg.getString("progress.countInfo"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                ProgressDialog.this.this_windowClosing(e2);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.directory, null);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br hfill", this.progressBar);
        this.mainPanel.add("br", this.count);
        this.mainPanel.add("br", this.timeLeft);
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add("center", this.peekButton);
        this.buttonPanel.add(this.pauseButton);
        this.buttonPanel.add(this.abortButton);
    }

    synchronized void pauseButton_actionPerformed(ActionEvent e2) {
        if (this.pauseButton.isSelected()) {
            this.timer.stop();
        } else {
            this.timer.start();
            this.notifyAll();
        }
    }

    void peekButton_actionPerformed(ActionEvent e2) {
        this.parent.viewAlbumButton_actionPerformed(e2);
    }

    public void setVisible(boolean show) {
        if (show) {
            this.pauseButton.setSelected(false);
            Dimension parentSize = this.parent.getSize();
            Dimension mySize = this.getSize();
            Point loc = this.parent.getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
            this.directory.setText(" ");
            this.file.setText(" ");
            this.count.setText(" ");
            this.timeLeft.setText(" ");
            this.progressBar.setValue(0);
            this.timer.reset();
            this.abort = false;
        }
        super.setVisible(show);
    }

    void this_windowClosing(WindowEvent e2) {
        this.abort = true;
    }

    public static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return "" + hours + ":" + ProgressDialog.twoDigits(minutes) + ":" + ProgressDialog.twoDigits(seconds);
    }

    private static String twoDigits(int x2) {
        if (x2 < 10) {
            return "0" + x2;
        }
        return "" + x2;
    }
}

