/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.mortbay.http.NCSARequestLog;
import org.mortbay.http.RequestLog;
import se.datadosen.jalbum.event.StatusListener;
import se.datadosen.net.JettyHttpServer;
import se.datadosen.net.NetUtil;
import se.datadosen.net.PortMapping;
import se.datadosen.net.PortMappingListener;
import se.datadosen.net.Share;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;

public class ShareBean
extends JettyHttpServer
implements PortMappingListener {
    public static final String CONSOLE_LOGGING = "console";
    public static final String FILE_LOGGING = "file";
    public static final String NO_LOGGING = "no";
    private boolean autoStart;
    private boolean doPortMapping = true;
    private String externalAddress;
    private String hostName = "";
    private String logDateFormat;
    private String logFileName = "albumsharing.log";
    private String logType = "no";
    private NCSARequestLog logger = new NCSARequestLog();
    private PortMapping portMapping = null;
    static final File settingsFile = new File(System.getProperty("user.home"), ".jalbum-sharing.xml");
    private transient Vector statusListeners;

    public ShareBean() {
        this.setPort(NetUtil.getFreeServerPort());
    }

    public synchronized void addStatusListener(StatusListener l2) {
        Vector v2;
        Vector vector = v2 = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.statusListeners = v2;
        }
    }

    public boolean albumAccessTest() {
        try {
            URL url = new URL("http://" + this.getExternalAddress() + ":" + this.getPort() + "/PingServlet");
            Socket sock = new Socket();
            sock.connect(new InetSocketAddress(url.getHost(), url.getPort()), 700);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Object o2 = conn.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o2));
            String s2 = reader.readLine();
            return s2.equals("JAlbum album sharing");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void ensurePortMapping() throws UPNPResponseException, IOException {
        if (this.portMapping != null) {
            if (this.portMapping.getPort() != this.getPort()) {
                this.portMapping.setMapping(this.getPort());
            }
        } else if (InetAddress.getLocalHost().isSiteLocalAddress()) {
            this.portMapping = new PortMapping("JAlbum album sharing", this.getPort(), this);
        }
    }

    protected void fireStatusChanged(String msg) {
        if (this.statusListeners != null) {
            Vector listeners = this.statusListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((StatusListener)listeners.elementAt(i2)).statusChanged(msg);
                ++i2;
            }
        }
    }

    public String getExternalAddress() throws UPNPResponseException, IOException {
        if (this.externalAddress == null) {
            this.externalAddress = this.portMapping != null ? this.portMapping.getExternalAddress() : (InetAddress.getLocalHost().isSiteLocalAddress() ? this.getExternalAddressFromWeb() : InetAddress.getLocalHost().getHostAddress());
        }
        return this.externalAddress;
    }

    private String getExternalAddressFromWeb() throws IOException {
        URL url = new URL("http://checkip.dyndns.org");
        Object o2 = url.getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o2));
        String s2 = reader.readLine();
        return s2.substring(s2.indexOf(":") + 1, s2.indexOf("</body>")).trim();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getLogDateFormat() {
        return this.logger.getLogDateFormat();
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogType() {
        return this.logType;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isDoPortMapping() {
        return this.doPortMapping;
    }

    /*
     * WARNING - void declaration
     */
    public void loadSettings() throws IOException, ElementException {
        LinkedList<Share> shares = new LinkedList<Share>();
        if (!settingsFile.exists()) {
            return;
        }
        String doc = IO.readTextFile(settingsFile);
        Element sharingElement = Elements.getElementByName("sharing", doc, false);
        if (sharingElement != null) {
            Element el;
            Map attrs = sharingElement.getAttributes();
            if (attrs != null) {
                BeanBinder.setProperties((Object)this, attrs);
            }
            String rest = sharingElement.getContent();
            while ((el = Elements.getElementByName("share", rest, false)) != null) {
                void var6_6;
                Share share = new Share(var6_6.getAttribute("localPath"), var6_6.getAttribute("uri"), var6_6.getBooleanAttribute("active"));
                share.passwordProtect = var6_6.getBooleanAttribute("passwordProtect");
                share.userName = var6_6.getAttribute("userName", "");
                share.password = var6_6.getAttribute("password", "");
                shares.add(share);
                rest = var6_6.getPostElement();
            }
            this.setShares(shares);
        }
    }

    public synchronized void removeStatusListener(StatusListener l2) {
        if (this.statusListeners != null && this.statusListeners.contains(l2)) {
            Vector v2 = (Vector)this.statusListeners.clone();
            v2.removeElement(l2);
            this.statusListeners = v2;
        }
    }

    public void saveSettings() throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(settingsFile)));
        Element sharing = new Element("sharing");
        sharing.setAttribute("port", this.getPort());
        sharing.setAttribute("hostName", this.hostName);
        sharing.setAttribute("autoStart", this.autoStart);
        sharing.setAttribute("doPortMapping", this.doPortMapping);
        sharing.setAttribute("logType", this.logType);
        sharing.setAttribute("logDateFormat", this.logDateFormat);
        sharing.setAttribute("logFileName", this.logFileName);
        Iterator it = this.getShares().iterator();
        while (it.hasNext()) {
            Share share = (Share)it.next();
            Element el = new Element("share");
            el.setAttribute("uri", share.uri);
            el.setAttribute("localPath", share.localPath);
            el.setAttribute("active", share.active);
            el.setAttribute("passwordProtect", share.passwordProtect);
            el.setAttribute("userName", share.userName);
            el.setAttribute("password", share.password);
            sharing.addContentElement(el);
        }
        XMLDocument doc = new XMLDocument(sharing);
        out.print(doc);
        out.close();
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setDoPortMapping(boolean doPortMapping) {
        this.doPortMapping = doPortMapping;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setLogDateFormat(String logDateFormat) {
        this.logger.setLogDateFormat(logDateFormat);
        this.logDateFormat = logDateFormat;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public void setLogger() {
        if (this.logType.equals(NO_LOGGING)) {
            this.server.setRequestLog(null);
            return;
        }
        if (this.logDateFormat != null && this.logDateFormat.length() > 0) {
            this.logger.setLogDateFormat(this.logDateFormat);
        }
        if (this.logType.equals(CONSOLE_LOGGING)) {
            this.logger.setFilename(null);
        } else {
            this.logger.setFilename(this.logFileName);
        }
        this.server.setRequestLog(this.logger);
    }

    public void setRequestLog(RequestLog logger) {
        this.server.setRequestLog(logger);
    }

    public void start() throws Exception {
        this.setLogger();
        super.start();
        this.fireStatusChanged("Web server started");
    }

    public void statusChanged(String msg) {
        this.fireStatusChanged(msg);
    }

    public void stop() throws InterruptedException {
        super.stop();
        this.fireStatusChanged("Web server stopped");
    }
}

