/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.UploadFileFilter;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.IO;

public class UploadBean
implements RemoteFSProgressMonitor {
    boolean connected = false;
    private AlbumBean engine;
    private int processedFiles;
    private RemoteFSBean remoteFSBean = new RemoteFSBean();
    private int totalFiles;
    private transient Vector uploadListeners;

    public synchronized void addUploadListener(UploadListener l2) {
        Vector v2;
        Vector vector = v2 = this.uploadListeners == null ? new Vector(2) : (Vector)this.uploadListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.uploadListeners = v2;
        }
    }

    public void bytesTransferred(long bytes) {
        this.fireBytesTransferred(bytes);
    }

    private int countFiles(File dir2, Map remoteFiles) {
        int counter = 0;
        File[] filesDirs = dir2.listFiles(new UploadFileFilter(this.engine.getIgnorePattern()));
        if (filesDirs == null) {
            return 0;
        }
        int i2 = 0;
        while (i2 < filesDirs.length) {
            RemoteFile rf;
            Object o2;
            if (filesDirs[i2].isDirectory()) {
                Map remoteDir = null;
                if (remoteFiles != null && (o2 = remoteFiles.get(filesDirs[i2].getName())) != null && o2 instanceof Map) {
                    remoteDir = (Map)o2;
                }
                counter += this.countFiles(filesDirs[i2], remoteDir);
            } else if (remoteFiles == null || (o2 = remoteFiles.get(filesDirs[i2].getName())) == null || !(o2 instanceof RemoteFile) || !this.identical(filesDirs[i2], rf = (RemoteFile)o2)) {
                ++counter;
            }
            ++i2;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyRemoteAlbum(AlbumBean engine) throws ParameterException, RemoteFSException, IOException {
        try {
            this.remoteFSBean.setPassiveMode(engine.isPassiveMode());
            this.remoteFSBean.setPort(engine.getFtpPort());
            this.remoteFSBean.connect(engine.getFtpServer(), engine.getFtpUser(), engine.getFtpPassword());
            String remoteDir = IO.combinePaths(engine.getFtpWebDirectory(), engine.getRemoteDirectory(), '/');
            if (remoteDir.length() <= 0) {
                throw new ParameterException("Cannot delete ftp root (security)");
            }
            this.remoteFSBean.setDirectory(remoteDir);
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, null, Msg.getString("upload.cleaningFilesInfo"), 1, 1, 1, 1);
            this.fireImageProcessingStarted(eventObject);
            this.emptyRemoteAlbum(eventObject);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.remoteFSBean.disconnect();
            throw throwable;
        }
        this.remoteFSBean.disconnect();
    }

    private void emptyRemoteAlbum(AlbumBeanEvent eventObject) throws RemoteFSException, IOException {
        RemoteFile[] files = this.remoteFSBean.getFiles();
        int i2 = 0;
        while (i2 < files.length) {
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            if (files[i2].isDirectory()) {
                this.remoteFSBean.setDirectory(files[i2].getName());
                this.emptyRemoteAlbum(eventObject);
                this.remoteFSBean.toParentDirectory();
                this.remoteFSBean.removeDirectory(files[i2].getName());
            } else {
                this.remoteFSBean.removeFile(files[i2].getName());
            }
            ++i2;
        }
    }

    protected void fireBytesTransferred(long bytes) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((UploadListener)listeners.elementAt(i2)).bytesTransferred(bytes);
                ++i2;
            }
        }
    }

    protected void fireErrorOccured(Exception param1, File param2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((UploadListener)listeners.elementAt(i2)).errorOccured(param1, param2);
                ++i2;
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((UploadListener)listeners.elementAt(i2)).imageProcessingFinished(e2);
                ++i2;
            }
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            int i2 = 0;
            while (i2 < count) {
                ((UploadListener)listeners.elementAt(i2)).imageProcessingStarted(e2);
                ++i2;
            }
        }
    }

    private boolean identical(File local, RemoteFile remote) {
        return local.length() == remote.size() && (!this.engine.isAlwaysUploadPages() || !local.getName().endsWith(this.engine.getPageExtension()));
    }

    public boolean isSecure() {
        return this.remoteFSBean.isSecure();
    }

    private void myAssert(boolean test, String msg) throws ParameterException {
        if (!test) {
            throw new ParameterException(msg);
        }
    }

    public synchronized void removeUploadListener(UploadListener l2) {
        if (this.uploadListeners != null && this.uploadListeners.contains(l2)) {
            Vector v2 = (Vector)this.uploadListeners.clone();
            v2.removeElement(l2);
            this.uploadListeners = v2;
        }
    }

    private Map scanRemoteFiles(File dir2) throws RemoteFSException, IOException {
        File[] filesDirs = dir2.listFiles(new UploadFileFilter(this.engine.getIgnorePattern()));
        HashMap<String, File> localFiles = new HashMap<String, File>();
        int i2 = 0;
        while (i2 < filesDirs.length) {
            localFiles.put(filesDirs[i2].getName(), filesDirs[i2]);
            ++i2;
        }
        HashMap<String, Object> remoteFiles = new HashMap<String, Object>();
        RemoteFile[] res2 = this.remoteFSBean.getFiles();
        int i3 = 0;
        while (i3 < res2.length) {
            RemoteFile remoteFile = res2[i3];
            if (remoteFile.isFile()) {
                remoteFiles.put(remoteFile.getName(), remoteFile);
            } else {
                File localFile = (File)localFiles.get(remoteFile.getName());
                if (localFile != null && localFile.isDirectory()) {
                    this.remoteFSBean.setDirectory(remoteFile.getName());
                    remoteFiles.put(remoteFile.getName(), this.scanRemoteFiles(localFile));
                    this.remoteFSBean.toParentDirectory();
                }
            }
            ++i3;
        }
        return remoteFiles;
    }

    public void setSecure(boolean secure) {
        this.remoteFSBean.setSecure(secure);
    }

    public void testConnection(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.setSecure(engine.isSecureFtp());
        this.remoteFSBean.testConnection(engine.getFtpServer(), engine.getFtpUser(), engine.getFtpPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uploadAlbum(AlbumBean engine, boolean fullUpdate) throws ParameterException, RemoteFSException, IOException, OperationAbortedException {
        this.engine = engine;
        File dir2 = engine.getInterpretedOutputDirectory();
        if (!dir2.isDirectory()) {
            throw new IOException(Msg.getString("upload.outputDirectoryNotADirectoryError"));
        }
        this.processedFiles = 0;
        try {
            this.remoteFSBean.setProgressMonitor(this);
            this.remoteFSBean.setSecure(engine.isSecureFtp());
            this.remoteFSBean.setForceUTF8(engine.isFtpForceUTF8());
            this.remoteFSBean.setPassiveMode(engine.isPassiveMode());
            this.remoteFSBean.setPort(engine.getFtpPort());
            this.remoteFSBean.connect(engine.getFtpServer(), engine.getFtpUser(), engine.getFtpPassword());
            this.connected = true;
            String remoteDir = IO.combinePaths(engine.getFtpWebDirectory(), engine.getRemoteDirectory(), '/');
            if (remoteDir.length() > 0) {
                this.remoteFSBean.setDirectory(remoteDir);
            }
            Map remoteFiles = null;
            if (!fullUpdate) {
                AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir2, Msg.getString("upload.comparingFilesInfo"), 1, 1, 1, 1);
                this.fireImageProcessingStarted(eventObject);
                remoteFiles = this.scanRemoteFiles(dir2);
            }
            this.totalFiles = this.countFiles(dir2, remoteFiles);
            this.uploadAlbumDirectory(dir2, remoteFiles);
            Object var8_7 = null;
            if (!this.connected) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!this.connected) throw throwable;
            this.remoteFSBean.disconnect();
            throw throwable;
        }
        this.remoteFSBean.disconnect();
    }

    private void uploadAlbumDirectory(File dir2, Map remoteFiles) throws RemoteFSException, IOException, OperationAbortedException {
        File[] filesDirs = dir2.listFiles(new UploadFileFilter(this.engine.getIgnorePattern()));
        int i2 = 0;
        while (i2 < filesDirs.length) {
            RemoteFile rf;
            Object o2;
            if (filesDirs[i2].isDirectory()) {
                try {
                    this.remoteFSBean.createDirectory(filesDirs[i2].getName());
                }
                catch (RemoteFSException ex) {
                    // empty catch block
                }
                this.remoteFSBean.setDirectory(filesDirs[i2].getName());
                Map remoteDir = null;
                if (remoteFiles != null && (o2 = remoteFiles.get(filesDirs[i2].getName())) != null && o2 instanceof Map) {
                    remoteDir = (Map)o2;
                }
                this.uploadAlbumDirectory(filesDirs[i2], remoteDir);
                this.remoteFSBean.toParentDirectory();
            } else if (remoteFiles == null || (o2 = remoteFiles.get(filesDirs[i2].getName())) == null || !(o2 instanceof RemoteFile) || !this.identical(filesDirs[i2], rf = (RemoteFile)o2)) {
                AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir2, filesDirs[i2].getName(), i2 + 1, filesDirs.length, this.processedFiles + 1, this.totalFiles);
                this.fireImageProcessingStarted(eventObject);
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                this.remoteFSBean.putFile(filesDirs[i2]);
                this.fireImageProcessingFinished(eventObject);
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                ++this.processedFiles;
            }
            ++i2;
        }
    }
}

