/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.Timer;

public class UploadProgressDialog
extends JDialog
implements UploadListener {
    JPanel ButtonPanel;
    boolean abort = false;
    JButton abortButton;
    BorderLayout borderLayout1;
    JLabel count;
    JLabel directory;
    JLabel file;
    FlowLayout flowLayout1;
    String lastMsg = "";
    JPanel mainPanel;
    JPanel panel1 = new JPanel();
    JAlbumFrame parent;
    JProgressBar progressBar;
    JLabel timeLeft;
    Timer timer;

    public UploadProgressDialog(JAlbumFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.borderLayout1 = new BorderLayout();
        this.mainPanel = new JPanel();
        this.ButtonPanel = new JPanel();
        this.abortButton = new JButton();
        this.flowLayout1 = new FlowLayout();
        this.directory = new JLabel();
        this.progressBar = new JProgressBar();
        this.file = new JLabel();
        this.timeLeft = new JLabel();
        this.timer = new Timer();
        this.count = new JLabel();
        this.parent = parent;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void abortButton_actionPerformed(ActionEvent e2) {
        this.abort = true;
        this.setVisible(false);
    }

    public void byteRead(int bytes) {
    }

    public void bytesTransferred(long count) {
        this.file.setText(this.lastMsg + " " + count + " " + Msg.getString("upload.bytesInfo"));
    }

    public void errorOccured(Throwable t2, File f2) {
    }

    public void imageProcessingFinished(AlbumBeanEvent e2) {
        if (this.abort) {
            e2.abortProcessing();
        }
        long elapsed = this.timer.getMillis();
        long totalMillis = (long)e2.totalFiles * elapsed / (long)e2.processedFiles;
        int secsLeft = (int)(totalMillis - elapsed) / 1000;
        this.timeLeft.setText(Msg.getString("upload.estimatedTimeLeftInfo") + " " + UploadProgressDialog.timerFormat(secsLeft));
    }

    public void imageProcessingStarted(AlbumBeanEvent e2) {
        if (!this.isVisible() && !this.abort) {
            new Thread(){

                public void run() {
                    UploadProgressDialog.this.setVisible(true);
                }
            }.start();
        }
        if (this.abort) {
            e2.abortProcessing();
        }
        this.directory.setText(Msg.getString("upload.processingInfo") + " " + e2.dir.getName());
        this.progressBar.setValue(e2.processedFiles);
        this.progressBar.setMaximum(e2.totalFiles);
        this.file.setText(e2.msg);
        this.lastMsg = e2.msg;
        this.count.setText(MessageFormat.format(Msg.getString("upload.processingInfo2"), new Integer(e2.processedFiles), new Integer(e2.totalFiles)));
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.abortButton.setText(Msg.getString("abort"));
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                UploadProgressDialog.this.abortButton_actionPerformed(e2);
            }
        });
        this.ButtonPanel.setLayout(this.flowLayout1);
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.getString("upload.processingInfo"));
        this.file.setText(Msg.getString("upload.fileLabel"));
        this.timeLeft.setText(Msg.getString("upload.estimatedTimeLeftInfo"));
        this.count.setText(Msg.getString("upload.countLabel"));
        this.panel1.setPreferredSize(new Dimension(300, 151));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                UploadProgressDialog.this.this_windowClosing(e2);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.mainPanel, "Center");
        this.mainPanel.add("br", this.directory);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br hfill", this.progressBar);
        this.mainPanel.add("br", this.count);
        this.mainPanel.add("br", this.timeLeft);
        this.panel1.add((Component)this.ButtonPanel, "South");
        this.ButtonPanel.add((Component)this.abortButton, null);
    }

    void peekButton_actionPerformed(ActionEvent e2) {
        this.parent.viewAlbumButton_actionPerformed(e2);
    }

    public void setVisible(boolean show) {
        if (show) {
            Dimension parentSize = this.parent.getSize();
            Dimension mySize = this.getSize();
            Point loc = this.parent.getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
            this.directory.setText(Msg.getString("upload.comparingFilesInfo"));
            this.file.setText(" ");
            this.count.setText(" ");
            this.timeLeft.setText(" ");
            this.progressBar.setValue(0);
            this.timer.reset();
            this.timer.start();
            this.abort = false;
        }
        super.setVisible(show);
    }

    void this_windowClosing(WindowEvent e2) {
        this.abort = true;
    }

    public static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return "" + hours + ":" + UploadProgressDialog.twoDigits(minutes) + ":" + UploadProgressDialog.twoDigits(seconds);
    }

    private static String twoDigits(int x2) {
        if (x2 < 10) {
            return "0" + x2;
        }
        return "" + x2;
    }
}

