/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.net;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import se.datadosen.net.Share;

public class JettyHttpServer {
    public static final String PING_SERVLET_URI = "/PingServlet";
    protected SocketListener listener;
    protected HttpServer server = new HttpServer();
    private List shares;
    private Thread stopServerHook;

    public JettyHttpServer() {
        this.listener = new SocketListener();
        this.shares = new LinkedList();
        this.server.addListener(this.listener);
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public List getShares() {
        return this.shares;
    }

    public boolean isRunning() {
        return this.server.isStarted();
    }

    public void setPort(int port) {
        this.listener.setPort(port);
    }

    public void setShares(List shares) {
        this.shares = shares;
        int nShares = 0;
        Iterator it = shares.iterator();
        while (it.hasNext()) {
            Share share = (Share)it.next();
            if (!share.active) continue;
            ++nShares;
        }
        HttpContext[] contexts = new HttpContext[nShares + 1];
        it = shares.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            Share share = (Share)it.next();
            if (!share.active) continue;
            HttpContext context = new HttpContext();
            context.setContextPath(share.uri);
            context.setResourceBase(share.localPath);
            if (share.passwordProtect && share.userName != null && share.password != null) {
                HashUserRealm hr = new HashUserRealm();
                hr.setName(share.uri);
                hr.put(share.userName, share.password);
                this.server.addRealm(hr);
                context.addHandler(new SecurityHandler());
                context.setAuthenticator(new BasicAuthenticator());
                context.setRealmName(share.uri);
                SecurityConstraint sc = new SecurityConstraint();
                sc.setAuthenticate(true);
                sc.addRole("*");
                context.addSecurityConstraint("/", sc);
            }
            ResourceHandler rh = new ResourceHandler();
            rh.setDirAllowed(false);
            context.addHandler(rh);
            contexts[i2] = context;
            ++i2;
        }
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        ServletHandler servlets = new ServletHandler();
        servlets.addServlet(PING_SERVLET_URI, "se.datadosen.net.PingServlet");
        context.addHandler(servlets);
        contexts[contexts.length - 1] = context;
        this.server.setContexts(contexts);
        if (this.server.isStarted()) {
            try {
                this.server.stop();
                this.server.start();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void start() throws Exception {
        this.server.start();
        this.stopServerHook = new Thread(){

            public void run() {
                try {
                    JettyHttpServer.this.server.stop();
                }
                catch (InterruptedException ex) {
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.stopServerHook);
    }

    public void stop() throws InterruptedException {
        this.server.stop();
        if (this.stopServerHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.stopServerHook);
        }
        this.stopServerHook = null;
    }
}

