/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.net;

import java.io.IOException;
import java.net.InetAddress;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.UPNPResponseException;
import se.datadosen.net.PortMappingListener;

public class PortMapping {
    private Thread deletePortMappingHook;
    private String description;
    private String externalAddress;
    private InternetGatewayDevice gateway;
    private PortMappingListener listener;
    private boolean mapped = false;
    private int port;

    public PortMapping(String description, int port, PortMappingListener listener) throws IOException, UPNPResponseException {
        this.description = description;
        this.listener = listener;
        int discoveryTimeout = 5000;
        listener.statusChanged("Searching for gateway...");
        InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices(discoveryTimeout);
        if (IGDs == null) {
            throw new IOException("No UPnP enabled gateway found");
        }
        this.gateway = IGDs[0];
        listener.statusChanged("Found device " + this.gateway.getIGDRootDevice().getModelName() + " out of " + IGDs.length + " devices");
        System.out.println("Gateway def loc: " + this.gateway.getIGDRootDevice().getDeviceDefLoc());
        this.setMapping(port);
    }

    public PortMapping(String description, int port) throws IOException, UPNPResponseException {
        this(description, port, null);
    }

    private boolean deletePortMapping(boolean removeHook) {
        if (removeHook && this.deletePortMappingHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.deletePortMappingHook);
            this.deletePortMappingHook = null;
        }
        try {
            boolean success = this.gateway.deletePortMapping(null, this.port, "TCP");
            boolean bl2 = this.mapped = !success;
            if (success) {
                this.listener.statusChanged("Deleted port mapping for port " + this.port);
            }
            return success;
        }
        catch (UPNPResponseException ex) {
        }
        catch (IOException ex) {
        }
        return false;
    }

    public boolean deletePortMapping() {
        return this.deletePortMapping(true);
    }

    public String getExternalAddress() throws IOException, UPNPResponseException {
        if (this.externalAddress == null) {
            this.externalAddress = this.gateway.getExternalIPAddress();
        }
        return this.externalAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setMapping(int port) throws UPNPResponseException, IOException {
        if (this.mapped) {
            this.deletePortMapping();
        }
        this.port = port;
        String localHostIP = InetAddress.getLocalHost().getHostAddress();
        this.mapped = this.gateway.addPortMapping(this.description, null, port, port, localHostIP, 0, "TCP");
        if (this.mapped) {
            this.deletePortMappingHook = new Thread(){

                public void run() {
                    PortMapping.this.deletePortMapping(false);
                }
            };
            Runtime.getRuntime().addShutdownHook(this.deletePortMappingHook);
            this.listener.statusChanged("Port " + port + " mapped to " + localHostIP);
        }
    }
}

