/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

public class FileFilters {
    private static final String FOLDER_KEY = "folder";
    private static Set classicTypes = new HashSet();
    private static Set imageIOTypes = new HashSet();
    private static Map otherTypes;

    static {
        classicTypes.add("jpg");
        classicTypes.add("jpeg");
        classicTypes.add("jpe");
        classicTypes.add("gif");
        classicTypes.add("png");
        String[] types = ImageIO.getReaderFormatNames();
        int i2 = 0;
        while (i2 < types.length) {
            imageIOTypes.add(types[i2]);
            ++i2;
        }
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi2 = new BufferedImage(iw, ih, 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage(img, 0, 0, null);
        return bi2;
    }

    public static String getExtensionOf(File f2) {
        String name = f2.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1).toLowerCase();
    }

    public static File getIconFor(File f2, AlbumBean engine) {
        File iconFile;
        Config c2 = Config.getConfig();
        String ext = f2.isDirectory() ? FOLDER_KEY : FileFilters.getExtensionOf(f2);
        FileType ft = (FileType)FileFilters.getOtherTypes().get(ext);
        if (ft == null) {
            return null;
        }
        if (engine != null && (iconFile = new File(engine.srcResDir, ft.icon)).exists()) {
            return iconFile;
        }
        return new File(c2.progDir, "res/" + ft.icon);
    }

    public static File getIconFor(File f2) {
        return FileFilters.getIconFor(f2, null);
    }

    /*
     * WARNING - void declaration
     */
    static Map getOtherTypes() {
        if (otherTypes != null) {
            return otherTypes;
        }
        otherTypes = new HashMap();
        try {
            Element type;
            Config c2 = Config.getConfig();
            String content = IO.readTextFile(new File(c2.progDir, "filetypes.xml"));
            String docrest = content = Elements.stripComments(content);
            Element root = Elements.getElementByName("filetypes", docrest, false);
            if (root != null) {
                otherTypes.put(FOLDER_KEY, new FileType("Folder", root.getAttribute("foldericon", "folder.gif")));
            }
            while ((type = Elements.getElementByName("type", docrest, false)) != null) {
                Element ext;
                void var4_5;
                FileType ft = new FileType(var4_5.getAttribute("name"), var4_5.getAttribute("icon"));
                String extrest = var4_5.getContent();
                while ((ext = Elements.getElementByName("ext", extrest, false)) != null) {
                    void var6_7;
                    otherTypes.put(var6_7.getContent(), ft);
                    extrest = var6_7.getPostElement();
                }
                docrest = var4_5.getPostElement();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return otherTypes;
    }

    public static boolean hasIcon(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (FileFilters.isFileSupported(file)) {
            return false;
        }
        String ext = FileFilters.getExtensionOf(file);
        return FileFilters.getOtherTypes().containsKey(ext);
    }

    public static boolean isFileSupported(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileFilters.getExtensionOf(file);
        return classicTypes.contains(extension) || imageIOTypes.contains(extension);
    }

    public static boolean isMediaFile(File file) {
        boolean mediaFile = FileFilters.hasIcon(file);
        if (file.isDirectory()) {
            return false;
        }
        return mediaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadImage(File file, AlbumBean engine) throws IOException, ImageFormatException {
        if (!FileFilters.getExtensionOf(file).equals("thm") && !FileFilters.isFileSupported(file)) {
            file = FileFilters.getIconFor(file, engine);
        }
        if (engine.isClassicReaders() && classicTypes.contains(FileFilters.getExtensionOf(file))) {
            BufferedImage bufferedImage;
            block8: {
                JPEGDecodeParam p2 = null;
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(file));
                    JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                    BufferedImage img = decoder.decodeAsBufferedImage();
                    p2 = decoder.getJPEGDecodeParam();
                    in.close();
                    in = null;
                    if (p2.getEncodedColorID() != 3 && p2.getEncodedColorID() != 2) {
                        throw new ImageFormatException("Image must be stored in RGB color model");
                    }
                    bufferedImage = img;
                    Object var8_11 = null;
                    if (in == null) break block8;
                }
                catch (Exception ex) {
                    BufferedImage bufferedImage2;
                    block9: {
                        try {
                            ImageIcon tmp = new ImageIcon(file.getAbsolutePath());
                            bufferedImage2 = FileFilters.ensureBuffered(tmp.getImage(), tmp.getIconWidth(), tmp.getIconHeight());
                            Object var8_12 = null;
                            if (in == null) break block9;
                        }
                        catch (Throwable throwable) {
                            Object var8_13 = null;
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                        in.close();
                    }
                    return bufferedImage2;
                }
                in.close();
            }
            return bufferedImage;
        }
        BufferedImage bi2 = ImageIO.read(file);
        return bi2;
    }

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData) throws IOException, ImageFormatException {
        if (file.exists()) {
            file.delete();
        }
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("jpeg");
        while (it.hasNext()) {
            ImageWriter iw = it.next();
            ImageWriteParam param = iw.getDefaultWriteParam();
            if (engine.isProgressiveMode() && !param.canWriteProgressive() && it.hasNext()) continue;
            param.setCompressionMode(2);
            param.setCompressionQuality((float)engine.getQualityPercent() / 100.0f);
            if (engine.isProgressiveMode() && param.canWriteProgressive()) {
                param.setProgressiveMode(1);
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            iw.setOutput(ios);
            iw.write(null, new IIOImage(img, null, metaData), param);
            iw.dispose();
            ios.close();
            break;
        }
    }

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine) throws IOException, ImageFormatException {
        FileFilters.saveJPEG(img, file, engine, null);
    }

    public static class FileType {
        String icon;
        String name;

        public FileType(String name, String icon) {
            this.name = name;
            this.icon = icon;
        }

        public String toString() {
            return "{Name=" + this.name + " icon=" + this.icon + "}";
        }
    }
}

