/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import se.datadosen.util.Replacer;
import se.datadosen.util.StringCodec;

public class IO {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String baseName(File file) {
        return IO.baseName(file.getName());
    }

    public static String baseName(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex != -1 ? fullName.substring(0, dotIndex) : fullName;
    }

    public static String combinePaths(String part1, String part2, char separator) {
        if (part1.length() == 0) {
            return part2;
        }
        if (part2.length() == 0) {
            return part1;
        }
        int end = part1.length();
        while (end > 0 && part1.charAt(end - 1) == separator) {
            --end;
        }
        if (part1.endsWith("" + separator + separator)) {
            ++end;
        }
        int start = 0;
        while (start < part2.length() && part2.charAt(start) == separator) {
            ++start;
        }
        return part1.substring(0, end) + separator + part2.substring(start, part2.length());
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy) throws IOException {
        dest.mkdir();
        if (!srcDir.isDirectory()) {
            throw new IOException("Missing directory " + srcDir.getAbsolutePath());
        }
        File[] files = srcDir.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].isDirectory()) {
                IO.copyDirectoryContent(files[i2], new File(dest, files[i2].getName()), forceCopy);
            } else if (files[i2].isFile()) {
                IO.copyFile(files[i2].getAbsolutePath(), dest, forceCopy);
            }
            ++i2;
        }
    }

    public static void copyDirectoryContent(String srcPath, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(new File(srcPath), dest, forceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest, boolean forceCopy) throws IOException {
        if (src.isDirectory()) {
            if (!dest.isDirectory()) {
                throw new IOException("copyFile: Cannot copy directory onto single file");
            }
            File[] files = src.listFiles();
            int i2 = 0;
            while (i2 < files.length) {
                IO.copyFile(files[i2], dest, forceCopy);
                ++i2;
            }
        } else {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (src.getName().equalsIgnoreCase("Thumbs.db")) {
                return;
            }
            if (!forceCopy && dest.exists()) {
                return;
            }
            if (dest.exists() && !dest.canWrite()) {
                return;
            }
            long lastModified = src.lastModified();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                int bytesRead;
                byte[] buffer = new byte[65536];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                in.close();
                out.close();
                dest.setLastModified(lastModified);
                throw throwable;
            }
            in.close();
            out.close();
            dest.setLastModified(lastModified);
            {
            }
        }
    }

    public static void copyFile(String name, File dest, boolean forceCopy) throws IOException {
        IO.copyFile(new File(name), dest, forceCopy);
    }

    public static void copyFile(String name, File dest) throws IOException {
        IO.copyFile(name, dest, true);
    }

    public static void copyFile(File src, File dest) throws IOException {
        IO.copyFile(src, dest, true);
    }

    public static long deepLastModified(File dir2) throws IOException {
        long lastModified = dir2.lastModified();
        File[] files = dir2.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            long lm = files[i2].lastModified();
            if (files[i2].isDirectory()) {
                lm = IO.deepLastModified(files[i2]);
            }
            if (lm > lastModified) {
                lastModified = lm;
            }
            ++i2;
        }
        return lastModified;
    }

    public static String extensionOf(File file) {
        return IO.extensionOf(file.getName());
    }

    public static String extensionOf(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = fullName.length() - 1;
        }
        return fullName.substring(dotIndex + 1);
    }

    public static void main(String[] args) throws IOException {
    }

    public static byte[] readBytes(File f2) throws IOException {
        byte[] buf = new byte[(int)f2.length()];
        FileInputStream in = new FileInputStream(f2);
        in.read(buf);
        in.close();
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Map readMapFile(File file) throws IOException {
        HashMap<String, String> hashMap;
        block4: {
            Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);
            String s2 = IO.readTextFile(file);
            BufferedReader in = new BufferedReader(new StringReader(s2));
            try {
                String line;
                HashMap<String, String> theMap = new HashMap<String, String>();
                while ((line = in.readLine()) != null) {
                    int equalsIndex;
                    void var5_5;
                    line = var5_5.trim();
                    if (line.startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                    String key = line.substring(0, equalsIndex).trim();
                    String value = line.substring(equalsIndex + 1).trim();
                    while (IO.continueLine(line)) {
                        value = value.substring(0, value.length() - 1);
                        line = in.readLine();
                        if (line == null) break;
                        value = value + "\n" + line;
                    }
                    value = backslashPattern.matcher(value).replaceAll("\\\\");
                    theMap.put(key, value);
                }
                hashMap = theMap;
                Object var10_10 = null;
                if (in == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_11 = null;
                    if (in == null) break block5;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(File file) throws IOException {
        Properties properties;
        block2: {
            FileInputStream fis = null;
            try {
                Properties props = new Properties();
                fis = new FileInputStream(file);
                props.load(fis);
                properties = props;
                Object var5_4 = null;
                if (fis == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (fis == null) break block3;
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        return properties;
    }

    public static String readTextFile(String fileName) throws IOException {
        return IO.readTextFile(new File(fileName));
    }

    public static String readTextFile(File file) throws IOException {
        return IO.readTextFile(file, System.getProperty("file.encoding"));
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        byte[] buf = IO.readBytes(file);
        StringCodec codec = new StringCodec();
        return codec.decode(buf, encoding);
    }

    public static String readTextUrl(URL textUrl) throws IOException {
        URLConnection conn = textUrl.openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            throw new IOException("Couldn't connect to " + textUrl);
        }
        byte[] bytes = new byte[length];
        InputStream is = conn.getInputStream();
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read from " + textUrl);
        }
        is.close();
        StringCodec codec = new StringCodec();
        return codec.decode(bytes, System.getProperty("file.encoding"));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static String relativePath(File file, File rel) {
        StringTokenizer tokens;
        int i2;
        StringBuffer result;
        String relString;
        String fileString;
        block10: {
            boolean absolute = false;
            fileString = file.getAbsolutePath();
            relString = rel.getAbsolutePath();
            char[] filePath = fileString.toCharArray();
            char[] relPath = relString.toCharArray();
            result = new StringBuffer();
            i2 = 0;
            while (i2 < filePath.length && i2 < relPath.length) {
                if (filePath[i2] != relPath[i2]) break;
                ++i2;
            }
            boolean bl2 = true;
            do {
                block12: {
                    block11: {
                        if (!bl2 || (bl2 = false)) break block11;
                        if (i2 < relPath.length && i2 < filePath.length) break block12;
                        if (relPath.length >= filePath.length) break block10;
                        if (filePath[i2] == File.separatorChar) break block10;
                        if (true) break block12;
                    }
                    --i2;
                }
                if (i2 <= 0) break;
            } while (relPath[i2 - 1] != File.separatorChar);
        }
        if (i2 != 0) {
            tokens = new StringTokenizer(relString.substring(i2), File.separator);
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                result.append("../");
            }
        }
        if ((tokens = new StringTokenizer(fileString.substring(i2), File.separator)).hasMoreTokens()) {
            result.append(tokens.nextToken());
        } else if (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        while (tokens.hasMoreTokens()) {
            result.append("/" + tokens.nextToken());
        }
        String res = result.toString();
        if (res.equals("")) {
            return ".";
        }
        String string = res;
        return string;
    }

    public static int sizeof(Object o2) {
        try {
            ByteArrayOutputStream ba2 = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ba2);
            oos.writeObject(o2);
            return ba2.toByteArray().length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static String urlEncode(String s2) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bytes = StringCodec.isEncodable(s2, System.getProperty("file.encoding")) ? s2.getBytes(System.getProperty("file.encoding")) : s2.getBytes("UTF-8");
            s2 = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s2.toCharArray();
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] > '\u007f' || chars[i2] == ' ' || chars[i2] == '#' || chars[i2] == '%') {
                sb.append('%');
                sb.append(hexDigits[(chars[i2] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i2] & 0xF]);
            } else {
                sb.append(chars[i2]);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static void writeBytes(byte[] buf, File f2) throws IOException {
        FileOutputStream out = new FileOutputStream(f2);
        out.write(buf);
        out.close();
    }

    public static boolean writeChangedTextFile(String content, File file, String encoding) throws IOException {
        if (!file.exists()) {
            IO.writeTextFile(content, file, encoding);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
        writer.write(content);
        writer.close();
        byte[] outBytes = out.toByteArray();
        byte[] inBytes = IO.readBytes(file);
        if (!Arrays.equals(outBytes, inBytes)) {
            IO.writeBytes(outBytes, file);
            return true;
        }
        return false;
    }

    public static void writeMapFile(Map map, File f2) throws IOException {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            out.println(e2.getKey().toString() + "=" + backslashEncoder.replace(e2.getValue().toString()));
        }
        out.close();
        String s2 = writer.getBuffer().toString();
        StringCodec codec = new StringCodec();
        byte[] bytes = codec.encode(s2);
        if (!s2.equals(codec.decode(bytes))) {
            bytes = codec.encode(s2, "UTF-8");
        }
        IO.writeBytes(bytes, f2);
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        writer.write(content);
        writer.close();
    }

    public static void writeTextFile(String content, File file) throws IOException {
        IO.writeTextFile(content, file, System.getProperty("file.encoding"));
    }
}

