/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;
import se.datadosen.util.Attributizer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;

public class PropertyBinder {
    public static Properties getProperties(JComponentHolder jComponentHolder, Properties existing) {
        Properties props = existing;
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            int i2 = 0;
            while (i2 < fields.length) {
                String name = fields[i2].getName();
                fields[i2].setAccessible(true);
                int mods = fields[i2].getModifiers();
                if (!Modifier.isPrivate(mods) && !Modifier.isProtected(mods)) {
                    Object comp = fields[i2].get(jComponentHolder);
                    if (comp instanceof JComponentHolder) {
                        Properties subProps = PropertyBinder.getProperties((JComponentHolder)comp);
                        props.putAll((Map<?, ?>)subProps);
                    } else if (comp instanceof JComponent) {
                        if (comp instanceof JTextComponent) {
                            JTextComponent tc = (JTextComponent)comp;
                            props.setProperty(name, tc.getText());
                        } else if (comp instanceof JComboBox) {
                            JComboBox jc = (JComboBox)comp;
                            Object sel = jc.getSelectedItem();
                            if (sel != null) {
                                if (sel instanceof Item) {
                                    sel = ((Item)sel).value.toString();
                                }
                                props.setProperty(name, sel.toString());
                            }
                        } else if (comp instanceof JCheckBox) {
                            JCheckBox cb2 = (JCheckBox)comp;
                            props.setProperty(name, cb2.isSelected() ? "true" : "false");
                        } else if (comp instanceof JColorSelector) {
                            JColorSelector cs2 = (JColorSelector)comp;
                            props.setProperty(name, cs2.getHTMLColor());
                        } else if (comp instanceof JSlider) {
                            JSlider js = (JSlider)comp;
                            props.setProperty(name, "" + js.getValue());
                        }
                    } else if (comp instanceof ButtonGroup) {
                        ButtonGroup bg2 = (ButtonGroup)comp;
                        Enumeration<AbstractButton> buttons = bg2.getElements();
                        while (buttons.hasMoreElements()) {
                            AbstractButton button = buttons.nextElement();
                            if (!button.isSelected()) continue;
                            props.setProperty(name, button.getActionCommand());
                        }
                    } else if (comp instanceof Attributizer) {
                        Attributizer attr = (Attributizer)comp;
                        props.setProperty(name, attr.getAttributes());
                    }
                }
                ++i2;
            }
            return props;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static Properties getProperties(JComponentHolder jComponentHolder) {
        return PropertyBinder.getProperties(jComponentHolder, new Properties());
    }

    public static void syncUI(Map props, JComponentHolder jComponentHolder) {
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            int i2 = 0;
            while (i2 < fields.length) {
                block8: {
                    String value;
                    Object comp;
                    block10: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        String name;
                                        block9: {
                                            name = fields[i2].getName();
                                            fields[i2].setAccessible(true);
                                            int mods = fields[i2].getModifiers();
                                            if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) break block8;
                                            comp = fields[i2].get(jComponentHolder);
                                            if (!props.containsKey(name) && !(comp instanceof JComponentHolder)) break block8;
                                            if (!(comp instanceof JComponentHolder)) break block9;
                                            PropertyBinder.syncUI(props, (JComponentHolder)comp);
                                            break block8;
                                        }
                                        value = props.get(name).toString();
                                        if (!(comp instanceof JComponent)) break block10;
                                        if (!(comp instanceof JTextComponent)) break block11;
                                        JTextComponent tc = (JTextComponent)comp;
                                        tc.setText(value);
                                        break block8;
                                    }
                                    if (!(comp instanceof JComboBox)) break block12;
                                    JComboBox jc = (JComboBox)comp;
                                    boolean setOk = false;
                                    int k2 = 0;
                                    while (k2 < jc.getItemCount()) {
                                        Object item = jc.getItemAt(k2);
                                        if (item instanceof Integer) {
                                            item = ((Integer)item).toString();
                                        }
                                        if (item.equals(value)) {
                                            jc.setSelectedIndex(k2);
                                            setOk = true;
                                            break;
                                        }
                                        ++k2;
                                    }
                                    if (setOk) break block8;
                                    jc.setSelectedItem(value);
                                    break block8;
                                }
                                if (!(comp instanceof JCheckBox)) break block13;
                                JCheckBox cb2 = (JCheckBox)comp;
                                cb2.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                                break block8;
                            }
                            if (!(comp instanceof JColorSelector)) break block14;
                            JColorSelector cs2 = (JColorSelector)comp;
                            cs2.setColor(value);
                            break block8;
                        }
                        if (!(comp instanceof JSlider)) break block8;
                        JSlider js = (JSlider)comp;
                        js.setValue(Integer.parseInt(value));
                        break block8;
                    }
                    if (comp instanceof ButtonGroup) {
                        ButtonGroup bg2 = (ButtonGroup)comp;
                        Enumeration<AbstractButton> buttons = bg2.getElements();
                        while (buttons.hasMoreElements()) {
                            AbstractButton button = buttons.nextElement();
                            String ac = button.getActionCommand();
                            if (ac == null || !ac.equals(value)) continue;
                            bg2.setSelected(button.getModel(), true);
                            break;
                        }
                    }
                }
                ++i2;
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }
}

