/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import se.datadosen.util.APP1Segment;
import se.datadosen.util.JpegFile;
import se.datadosen.util.Segment;

public class RotationSupport {
    public static final int LEFT_ROTATED = 6;
    public static final int NOT_ROTATED = 1;
    public static final int RIGHT_ROTATED = 8;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;

    public static BufferedImage adjustOrientation(BufferedImage bi2, int existingOrientation) {
        if (existingOrientation == 6) {
            return RotationSupport.rotateRight(bi2);
        }
        if (existingOrientation == 8) {
            return RotationSupport.rotateLeft(bi2);
        }
        return bi2;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, String existingOrientation) {
        return RotationSupport.adjustOrientation(bi2, RotationSupport.asCode(existingOrientation));
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, File file) {
        try {
            return RotationSupport.adjustOrientation(bi2, RotationSupport.getOrientation(file));
        }
        catch (IOException ex) {
            return bi2;
        }
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, Metadata meta) {
        if (meta == null) {
            return bi2;
        }
        try {
            if (meta.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
                Directory exif = meta.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                int existingOrientation = exif.getInt(274);
                return RotationSupport.adjustOrientation(bi2, existingOrientation);
            }
        }
        catch (MetadataException ex) {}
        return bi2;
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, File file) {
        try {
            BufferedImage bi2 = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
            bi2 = RotationSupport.adjustOrientation(bi2, RotationSupport.getOrientation(file));
            return new ImageIcon(bi2);
        }
        catch (IOException ex) {
            return ii;
        }
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, Metadata meta) {
        if (meta == null) {
            return ii;
        }
        BufferedImage bi2 = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
        bi2 = RotationSupport.adjustOrientation(bi2, meta);
        return new ImageIcon(bi2);
    }

    private static int asCode(String orientation) {
        if ("left".equals(orientation)) {
            return 6;
        }
        if ("right".equals(orientation)) {
            return 8;
        }
        return 1;
    }

    private static String asString(int orientation) {
        switch (orientation) {
            case 6: {
                return "left";
            }
            case 8: {
                return "right";
            }
        }
        return "normal";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static BufferedImage createBufferedImage(Image img, int iw, int ih) {
        BufferedImage bi2 = new BufferedImage(iw, ih, 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage(img, 0, 0, null);
        return bi2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getOrientation(File file) throws IOException {
        JpegFile f2;
        block7: {
            APP1Segment app1;
            f2 = null;
            try {
                f2 = new JpegFile(file);
                Segment s2 = f2.getFirstSegment();
                while (true) {
                    if (s2 == null || s2.getId() == -31) {
                        if (s2 == null) break block7;
                        app1 = new APP1Segment(s2);
                        boolean ifdNum = false;
                        break;
                    }
                    s2 = s2.getNextSegment();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (f2 == null) throw throwable;
                f2.close();
                throw throwable;
            }
            do {
                int i2 = 0;
                while (i2 < app1.getEntryCount()) {
                    APP1Segment.Entry ifd = app1.getEntry(i2);
                    if (ifd.getTagNr() == 274) {
                        int n2 = ifd.getValue();
                        Object var9_9 = null;
                        if (f2 == null) return n2;
                        f2.close();
                        return n2;
                    }
                    ++i2;
                }
            } while (app1.nextIFD());
        }
        int n3 = 1;
        Object var9_10 = null;
        if (f2 == null) return n3;
        f2.close();
        return n3;
    }

    public static int getOrientation(Metadata meta) {
        try {
            if (meta.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
                Directory exif = meta.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                return exif.getInt(274);
            }
        }
        catch (MetadataException ex) {}
        return 1;
    }

    public static String getOrientationAsString(File file) throws IOException {
        return RotationSupport.asString(RotationSupport.getOrientation(file));
    }

    public static String getOrientationAsString(Metadata meta) {
        return RotationSupport.asString(RotationSupport.getOrientation(meta));
    }

    public static void main(String[] args) throws Exception {
        File file = new File("C:/Documents and Settings/David Ekholm/Skrivbord/Rotationstest/DSC08646.JPG");
        RotationSupport.setOrientation(4, file);
        Metadata imageInfo = JpegMetadataReader.readMetadata(file);
        System.out.println(RotationSupport.getOrientation(imageInfo));
    }

    public static BufferedImage rotateLeft(BufferedImage bi2) {
        AffineTransform rot270Transform = AffineTransform.getRotateInstance(4.71238898038469);
        rot270Transform.translate(-bi2.getWidth(), 0.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot270Transform, hints);
        return op.filter(bi2, null);
    }

    public static BufferedImage rotateRight(BufferedImage bi2) {
        AffineTransform rot90Transform = AffineTransform.getRotateInstance(1.5707963267948966);
        rot90Transform.translate(0.0, -bi2.getHeight());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot90Transform, hints);
        return op.filter(bi2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setOrientation(int orientation, File file) throws IOException {
        boolean bl2;
        block7: {
            JpegFile f2 = null;
            try {
                f2 = new JpegFile(file, "rw");
                Segment s2 = f2.getFirstSegment();
                while (s2 != null && s2.getId() != -31) {
                    s2 = s2.getNextSegment();
                }
                if (s2 != null) {
                    APP1Segment app1 = new APP1Segment(s2);
                    boolean ifdNum = false;
                    block3: do {
                        int i2 = 0;
                        while (i2 < app1.getEntryCount()) {
                            APP1Segment.Entry ifd = app1.getEntry(i2);
                            if (ifd.getTagNr() == 274) {
                                ifd.setValue(orientation);
                                continue block3;
                            }
                            ++i2;
                        }
                    } while (app1.nextIFD());
                }
                bl2 = false;
                Object var9_9 = null;
                if (f2 == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var9_10 = null;
                    if (f2 == null) break block8;
                    f2.close();
                }
                throw throwable;
            }
            f2.close();
        }
        return bl2;
    }
}

