/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.IOException;
import java.io.RandomAccessFile;

class Segment {
    private static final byte MARKER_EOI = -39;
    private static final byte SEGMENT_SOS = -38;
    RandomAccessFile file;
    byte[] head = new byte[4];
    int length;
    long offset;

    public Segment(RandomAccessFile file) throws IOException {
        this.file = file;
        this.offset = file.getFilePointer();
        file.read(this.head);
        if (this.head[0] != -1) {
            throw new IOException("Not a segment: " + this.head[0]);
        }
        this.length = 0xFFFF & (this.head[2] << 8 & 0xFF00 | this.head[3] & 0xFF) - 2;
    }

    public byte[] getData() throws IOException {
        this.file.seek(this.offset + 4L);
        byte[] data = new byte[this.length];
        this.file.read(data);
        return data;
    }

    public long getDataOffset() {
        return this.offset + 4L;
    }

    public byte getId() {
        return this.head[1];
    }

    public Segment getNextSegment() throws IOException {
        if (this.getId() == -39 || this.getId() == -38) {
            return null;
        }
        this.file.seek(this.offset + 4L + (long)this.length);
        return new Segment(this.file);
    }
}

