/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import se.datadosen.util.IO;

public class SmartResourceBundle {
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static File defaultDir = new File("");
    private Locale locale = null;
    protected SmartResourceBundle parent = null;
    protected Map resources = new HashMap();

    protected SmartResourceBundle() {
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        result.addElement(temp.toString());
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.addElement(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.addElement(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public static final SmartResourceBundle getBundle(File dir2, String baseName, Locale locale) {
        Vector names = SmartResourceBundle.calculateBundleNames(baseName, locale);
        SmartResourceBundle bundle = null;
        SmartResourceBundle last = null;
        try {
            int i2 = 0;
            while (i2 < names.size()) {
                File bundleFile = new File(dir2, names.get(i2) + ".properties");
                if (bundleFile.exists()) {
                    bundle = new SmartResourceBundle();
                    bundle.resources = IO.readMapFile(bundleFile);
                    if (i2 > 0) {
                        bundle.locale = locale;
                    }
                    bundle.setParent(last);
                    last = bundle;
                }
                ++i2;
            }
            if (bundle == null) {
                throw new MissingResourceException("Resource file: " + new File(dir2, names.get(0) + ".properties").getAbsolutePath(), null, null);
            }
            return bundle;
        }
        catch (IOException ex) {
            throw new MissingResourceException("Cannot read bundle file: " + ex, baseName, null);
        }
    }

    public static final SmartResourceBundle getBundle(String baseName) {
        return SmartResourceBundle.getBundle(defaultDir, baseName, Locale.getDefault());
    }

    public static final SmartResourceBundle getBundle(File dir2, String baseName) {
        File f2 = new File(dir2, baseName);
        return SmartResourceBundle.getBundle(dir2, baseName, Locale.getDefault());
    }

    public Set getKeys() {
        if (this.parent != null) {
            HashSet allKeys = new HashSet(this.parent.getKeys());
            allKeys.addAll(this.resources.keySet());
            return allKeys;
        }
        return this.resources.keySet();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final Object getObject(String key) {
        Object obj = this.resources.get(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public static void main(String[] args) {
        SmartResourceBundle b2 = SmartResourceBundle.getBundle("texts");
        System.out.println("image=" + b2.getString("image"));
        System.out.println("button=" + b2.getString("button"));
    }

    public static void setDefaultDir(File defaultDir) {
        SmartResourceBundle.defaultDir = defaultDir;
    }

    protected void setParent(SmartResourceBundle parent) {
        this.parent = parent;
    }
}

